/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pools;

public class Region
implements Parcelable {
    private static final int MAX_POOL_SIZE = 10;
    private static final Pools.SynchronizedPool<Region> sPool = new Pools.SynchronizedPool(10);
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long mNativeRegion;
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        @Override
        public Region createFromParcel(Parcel p) {
            long ni = Region.nativeCreateFromParcel(p);
            if (ni == 0L) {
                throw new RuntimeException();
            }
            return new Region(ni);
        }

        public Region[] newArray(int size) {
            return new Region[size];
        }
    };

    public Region() {
        this(Region.nativeConstructor());
    }

    public Region(Region region) {
        this(Region.nativeConstructor());
        Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
    }

    public Region(Rect r) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public Region(int left, int top, int right, int bottom) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public void setEmpty() {
        Region.nativeSetRect(this.mNativeRegion, 0, 0, 0, 0);
    }

    public boolean set(Region region) {
        Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
        return true;
    }

    public boolean set(Rect r) {
        return Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public boolean set(int left, int top, int right, int bottom) {
        return Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public boolean setPath(Path path, Region clip) {
        return Region.nativeSetPath(this.mNativeRegion, path.readOnlyNI(), clip.mNativeRegion);
    }

    public native boolean isEmpty();

    public native boolean isRect();

    public native boolean isComplex();

    public Rect getBounds() {
        Rect r = new Rect();
        Region.nativeGetBounds(this.mNativeRegion, r);
        return r;
    }

    public boolean getBounds(Rect r) {
        if (r == null) {
            throw new NullPointerException();
        }
        return Region.nativeGetBounds(this.mNativeRegion, r);
    }

    public Path getBoundaryPath() {
        Path path = new Path();
        Region.nativeGetBoundaryPath(this.mNativeRegion, path.mutateNI());
        return path;
    }

    public boolean getBoundaryPath(Path path) {
        return Region.nativeGetBoundaryPath(this.mNativeRegion, path.mutateNI());
    }

    public native boolean contains(int var1, int var2);

    public boolean quickContains(Rect r) {
        return this.quickContains(r.left, r.top, r.right, r.bottom);
    }

    public native boolean quickContains(int var1, int var2, int var3, int var4);

    public boolean quickReject(Rect r) {
        return this.quickReject(r.left, r.top, r.right, r.bottom);
    }

    public native boolean quickReject(int var1, int var2, int var3, int var4);

    public native boolean quickReject(Region var1);

    public void translate(int dx, int dy) {
        this.translate(dx, dy, null);
    }

    public native void translate(int var1, int var2, Region var3);

    @UnsupportedAppUsage
    public void scale(float scale) {
        this.scale(scale, null);
    }

    public native void scale(float var1, Region var2);

    public final boolean union(Rect r) {
        return this.op(r, Op.UNION);
    }

    public boolean op(Rect r, Op op) {
        return Region.nativeOp(this.mNativeRegion, r.left, r.top, r.right, r.bottom, op.nativeInt);
    }

    public boolean op(int left, int top, int right, int bottom, Op op) {
        return Region.nativeOp(this.mNativeRegion, left, top, right, bottom, op.nativeInt);
    }

    public boolean op(Region region, Op op) {
        return this.op(this, region, op);
    }

    public boolean op(Rect rect, Region region, Op op) {
        return Region.nativeOp(this.mNativeRegion, rect, region.mNativeRegion, op.nativeInt);
    }

    public boolean op(Region region1, Region region2, Op op) {
        return Region.nativeOp(this.mNativeRegion, region1.mNativeRegion, region2.mNativeRegion, op.nativeInt);
    }

    public String toString() {
        return Region.nativeToString(this.mNativeRegion);
    }

    public static Region obtain() {
        Region region = sPool.acquire();
        return region != null ? region : new Region();
    }

    public static Region obtain(Region other) {
        Region region = Region.obtain();
        region.set(other);
        return region;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void recycle() {
        this.setEmpty();
        sPool.release(this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel p, int flags) {
        if (!Region.nativeWriteToParcel(this.mNativeRegion, p)) {
            throw new RuntimeException();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Region)) {
            return false;
        }
        Region peer = (Region)obj;
        return Region.nativeEquals(this.mNativeRegion, peer.mNativeRegion);
    }

    protected void finalize() throws Throwable {
        try {
            Region.nativeDestructor(this.mNativeRegion);
            this.mNativeRegion = 0L;
        }
        finally {
            super.finalize();
        }
    }

    Region(long ni) {
        if (ni == 0L) {
            throw new RuntimeException();
        }
        this.mNativeRegion = ni;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Region(long ni, int unused) {
        this(ni);
    }

    final long ni() {
        return this.mNativeRegion;
    }

    private static native boolean nativeEquals(long var0, long var2);

    private static native long nativeConstructor();

    private static native void nativeDestructor(long var0);

    private static native void nativeSetRegion(long var0, long var2);

    private static native boolean nativeSetRect(long var0, int var2, int var3, int var4, int var5);

    private static native boolean nativeSetPath(long var0, long var2, long var4);

    private static native boolean nativeGetBounds(long var0, Rect var2);

    private static native boolean nativeGetBoundaryPath(long var0, long var2);

    private static native boolean nativeOp(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native boolean nativeOp(long var0, Rect var2, long var3, int var5);

    private static native boolean nativeOp(long var0, long var2, long var4, int var6);

    private static native long nativeCreateFromParcel(Parcel var0);

    private static native boolean nativeWriteToParcel(long var0, Parcel var2);

    private static native String nativeToString(long var0);

    public static enum Op {
        DIFFERENCE(0),
        INTERSECT(1),
        UNION(2),
        XOR(3),
        REVERSE_DIFFERENCE(4),
        REPLACE(5);

        @UnsupportedAppUsage
        public final int nativeInt;

        private Op(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

