/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Shader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BitmapShader
extends Shader {
    Bitmap mBitmap;
    private int mTileX;
    private int mTileY;
    public static final int FILTER_MODE_DEFAULT = 0;
    public static final int FILTER_MODE_NEAREST = 1;
    public static final int FILTER_MODE_LINEAR = 2;
    private int mFilterMode;
    private boolean mFilterFromPaint;
    private boolean mIsDirectSampled;
    private boolean mRequestDirectSampling;

    public BitmapShader(Bitmap bitmap, Shader.TileMode tileX, Shader.TileMode tileY) {
        this(bitmap, tileX.nativeInt, tileY.nativeInt);
    }

    private BitmapShader(Bitmap bitmap, int tileX, int tileY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must be non-null");
        }
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
        this.mFilterMode = 0;
        this.mFilterFromPaint = false;
        this.mIsDirectSampled = false;
        this.mRequestDirectSampling = false;
    }

    public int getFilterMode() {
        return this.mFilterMode;
    }

    public void setFilterMode(int mode) {
        if (mode != this.mFilterMode) {
            this.mFilterMode = mode;
            this.discardNativeInstance();
        }
    }

    synchronized long getNativeInstanceWithDirectSampling() {
        this.mRequestDirectSampling = true;
        return this.getNativeInstance();
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        boolean enableLinearFilter;
        boolean bl = enableLinearFilter = this.mFilterMode == 2;
        if (this.mFilterMode == 0) {
            enableLinearFilter = this.mFilterFromPaint = filterFromPaint;
        }
        this.mIsDirectSampled = this.mRequestDirectSampling;
        this.mRequestDirectSampling = false;
        return BitmapShader.nativeCreate(nativeMatrix, this.mBitmap.getNativeInstance(), this.mTileX, this.mTileY, enableLinearFilter, this.mIsDirectSampled);
    }

    @Override
    protected boolean shouldDiscardNativeInstance(boolean filterFromPaint) {
        return this.mIsDirectSampled != this.mRequestDirectSampling || this.mFilterMode == 0 && this.mFilterFromPaint != filterFromPaint;
    }

    private static native long nativeCreate(long var0, long var2, int var4, int var5, boolean var6, boolean var7);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilterMode {
    }
}

