/*
 * Decompiled with CFR 0.152.
 */
package android.content.rollback;

import android.annotation.SystemApi;
import android.content.pm.VersionedPackage;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class PackageRollbackInfo
implements Parcelable {
    private final VersionedPackage mVersionRolledBackFrom;
    private final VersionedPackage mVersionRolledBackTo;
    private final List<Integer> mPendingBackups;
    private final ArrayList<RestoreInfo> mPendingRestores;
    private final boolean mIsApex;
    private final boolean mIsApkInApex;
    private final List<Integer> mSnapshottedUsers;
    private final int mRollbackDataPolicy;
    public static final Parcelable.Creator<PackageRollbackInfo> CREATOR = new Parcelable.Creator<PackageRollbackInfo>(){

        @Override
        public PackageRollbackInfo createFromParcel(Parcel in) {
            return new PackageRollbackInfo(in);
        }

        public PackageRollbackInfo[] newArray(int size) {
            return new PackageRollbackInfo[size];
        }
    };

    public String getPackageName() {
        return this.mVersionRolledBackFrom.getPackageName();
    }

    public VersionedPackage getVersionRolledBackFrom() {
        return this.mVersionRolledBackFrom;
    }

    public VersionedPackage getVersionRolledBackTo() {
        return this.mVersionRolledBackTo;
    }

    public void addPendingBackup(int userId) {
        this.mPendingBackups.add(userId);
    }

    public List<Integer> getPendingBackups() {
        return this.mPendingBackups;
    }

    public ArrayList<RestoreInfo> getPendingRestores() {
        return this.mPendingRestores;
    }

    public RestoreInfo getRestoreInfo(int userId) {
        for (RestoreInfo ri : this.mPendingRestores) {
            if (ri.userId != userId) continue;
            return ri;
        }
        return null;
    }

    public void removeRestoreInfo(RestoreInfo ri) {
        this.mPendingRestores.remove(ri);
    }

    public boolean isApex() {
        return this.mIsApex;
    }

    public int getRollbackDataPolicy() {
        return this.mRollbackDataPolicy;
    }

    public boolean isApkInApex() {
        return this.mIsApkInApex;
    }

    public List<Integer> getSnapshottedUsers() {
        return this.mSnapshottedUsers;
    }

    public void removePendingBackup(int userId) {
        this.mPendingBackups.remove((Object)userId);
    }

    public void removePendingRestoreInfo(int userId) {
        this.removeRestoreInfo(this.getRestoreInfo(userId));
    }

    public PackageRollbackInfo(VersionedPackage packageRolledBackFrom, VersionedPackage packageRolledBackTo, List<Integer> pendingBackups, ArrayList<RestoreInfo> pendingRestores, boolean isApex, boolean isApkInApex, List<Integer> snapshottedUsers) {
        this(packageRolledBackFrom, packageRolledBackTo, pendingBackups, pendingRestores, isApex, isApkInApex, snapshottedUsers, 0);
    }

    public PackageRollbackInfo(VersionedPackage packageRolledBackFrom, VersionedPackage packageRolledBackTo, List<Integer> pendingBackups, ArrayList<RestoreInfo> pendingRestores, boolean isApex, boolean isApkInApex, List<Integer> snapshottedUsers, int rollbackDataPolicy) {
        this.mVersionRolledBackFrom = packageRolledBackFrom;
        this.mVersionRolledBackTo = packageRolledBackTo;
        this.mPendingBackups = pendingBackups;
        this.mPendingRestores = pendingRestores;
        this.mIsApex = isApex;
        this.mRollbackDataPolicy = rollbackDataPolicy;
        this.mIsApkInApex = isApkInApex;
        this.mSnapshottedUsers = snapshottedUsers;
    }

    private PackageRollbackInfo(Parcel in) {
        this.mVersionRolledBackFrom = VersionedPackage.CREATOR.createFromParcel(in);
        this.mVersionRolledBackTo = VersionedPackage.CREATOR.createFromParcel(in);
        this.mIsApex = in.readBoolean();
        this.mIsApkInApex = in.readBoolean();
        this.mPendingRestores = null;
        this.mPendingBackups = null;
        this.mSnapshottedUsers = null;
        this.mRollbackDataPolicy = 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mVersionRolledBackFrom.writeToParcel(out, flags);
        this.mVersionRolledBackTo.writeToParcel(out, flags);
        out.writeBoolean(this.mIsApex);
        out.writeBoolean(this.mIsApkInApex);
    }

    public static class RestoreInfo {
        public final int userId;
        public final int appId;
        public final String seInfo;

        public RestoreInfo(int userId, int appId, String seInfo) {
            this.userId = userId;
            this.appId = appId;
            this.seInfo = seInfo;
        }
    }
}

