/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.content.pm.verify.domain.DomainOwner;
import android.content.pm.verify.domain.DomainSet;
import android.content.pm.verify.domain.DomainVerificationInfo;
import android.content.pm.verify.domain.DomainVerificationUserState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IDomainVerificationManager
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.verify.domain.IDomainVerificationManager";

    public List<String> queryValidVerificationPackageNames() throws RemoteException;

    public DomainVerificationInfo getDomainVerificationInfo(String var1) throws RemoteException;

    public DomainVerificationUserState getDomainVerificationUserState(String var1, int var2) throws RemoteException;

    public List<DomainOwner> getOwnersForDomain(String var1, int var2) throws RemoteException;

    public int setDomainVerificationStatus(String var1, DomainSet var2, int var3) throws RemoteException;

    public void setDomainVerificationLinkHandlingAllowed(String var1, boolean var2, int var3) throws RemoteException;

    public int setDomainVerificationUserSelection(String var1, DomainSet var2, boolean var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDomainVerificationManager {
        static final int TRANSACTION_queryValidVerificationPackageNames = 1;
        static final int TRANSACTION_getDomainVerificationInfo = 2;
        static final int TRANSACTION_getDomainVerificationUserState = 3;
        static final int TRANSACTION_getOwnersForDomain = 4;
        static final int TRANSACTION_setDomainVerificationStatus = 5;
        static final int TRANSACTION_setDomainVerificationLinkHandlingAllowed = 6;
        static final int TRANSACTION_setDomainVerificationUserSelection = 7;

        public Stub() {
            this.attachInterface(this, IDomainVerificationManager.DESCRIPTOR);
        }

        public static IDomainVerificationManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDomainVerificationManager.DESCRIPTOR);
            if (iin != null && iin instanceof IDomainVerificationManager) {
                return (IDomainVerificationManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "queryValidVerificationPackageNames";
                }
                case 2: {
                    return "getDomainVerificationInfo";
                }
                case 3: {
                    return "getDomainVerificationUserState";
                }
                case 4: {
                    return "getOwnersForDomain";
                }
                case 5: {
                    return "setDomainVerificationStatus";
                }
                case 6: {
                    return "setDomainVerificationLinkHandlingAllowed";
                }
                case 7: {
                    return "setDomainVerificationUserSelection";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDomainVerificationManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    List<String> _result = this.queryValidVerificationPackageNames();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    DomainVerificationInfo _result = this.getDomainVerificationInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    DomainVerificationUserState _result = this.getDomainVerificationUserState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<DomainOwner> _result = this.getOwnersForDomain(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    DomainSet _arg1 = data.readTypedObject(DomainSet.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDomainVerificationStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDomainVerificationLinkHandlingAllowed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    DomainSet _arg1 = data.readTypedObject(DomainSet.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDomainVerificationUserSelection(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IDomainVerificationManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDomainVerificationManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> queryValidVerificationPackageNames() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DomainVerificationInfo getDomainVerificationInfo(String packageName) throws RemoteException {
                DomainVerificationInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DomainVerificationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DomainVerificationUserState getDomainVerificationUserState(String packageName, int userId) throws RemoteException {
                DomainVerificationUserState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DomainVerificationUserState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<DomainOwner> getOwnersForDomain(String domain, int userId) throws RemoteException {
                ArrayList<DomainOwner> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(domain);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(DomainOwner.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDomainVerificationStatus(String domainSetId, DomainSet domains, int state) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(domainSetId);
                    _data.writeTypedObject(domains, 0);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDomainVerificationLinkHandlingAllowed(String packageName, boolean allowed, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(allowed);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDomainVerificationUserSelection(String domainSetId, DomainSet domains, boolean enabled, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDomainVerificationManager.DESCRIPTOR);
                    _data.writeString(domainSetId);
                    _data.writeTypedObject(domains, 0);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDomainVerificationManager {
        @Override
        public List<String> queryValidVerificationPackageNames() throws RemoteException {
            return null;
        }

        @Override
        public DomainVerificationInfo getDomainVerificationInfo(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public DomainVerificationUserState getDomainVerificationUserState(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<DomainOwner> getOwnersForDomain(String domain, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int setDomainVerificationStatus(String domainSetId, DomainSet domains, int state) throws RemoteException {
            return 0;
        }

        @Override
        public void setDomainVerificationLinkHandlingAllowed(String packageName, boolean allowed, int userId) throws RemoteException {
        }

        @Override
        public int setDomainVerificationUserSelection(String domainSetId, DomainSet domains, boolean enabled, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

