/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@SystemApi
public class DomainOwner
implements Parcelable {
    private final String mPackageName;
    private final boolean mOverrideable;
    public static final Parcelable.Creator<DomainOwner> CREATOR = new Parcelable.Creator<DomainOwner>(){

        public DomainOwner[] newArray(int size) {
            return new DomainOwner[size];
        }

        @Override
        public DomainOwner createFromParcel(Parcel in) {
            return new DomainOwner(in);
        }
    };

    public DomainOwner(String packageName, boolean overrideable) {
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mOverrideable = overrideable;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public boolean isOverrideable() {
        return this.mOverrideable;
    }

    public String toString() {
        return "DomainOwner { packageName = " + this.mPackageName + ", overrideable = " + this.mOverrideable + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainOwner that = (DomainOwner)o;
        return Objects.equals(this.mPackageName, that.mPackageName) && this.mOverrideable == that.mOverrideable;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Boolean.hashCode(this.mOverrideable);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mOverrideable) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        dest.writeString(this.mPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    DomainOwner(Parcel in) {
        String packageName;
        byte flg = in.readByte();
        boolean overrideable = (flg & 2) != 0;
        this.mPackageName = packageName = in.readString();
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mOverrideable = overrideable;
    }

    @Deprecated
    private void __metadata() {
    }
}

