/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.permission;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SplitPermissionInfoParcelable
implements Parcelable {
    private final String mSplitPermission;
    private final List<String> mNewPermissions;
    private final int mTargetSdk;
    public static final Parcelable.Creator<SplitPermissionInfoParcelable> CREATOR = new Parcelable.Creator<SplitPermissionInfoParcelable>(){

        public SplitPermissionInfoParcelable[] newArray(int size) {
            return new SplitPermissionInfoParcelable[size];
        }

        @Override
        public SplitPermissionInfoParcelable createFromParcel(Parcel in) {
            return new SplitPermissionInfoParcelable(in);
        }
    };

    private void onConstructed() {
        Preconditions.checkCollectionElementsNotNull(this.mNewPermissions, "newPermissions");
    }

    public SplitPermissionInfoParcelable(String splitPermission, List<String> newPermissions, int targetSdk) {
        this.mSplitPermission = splitPermission;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSplitPermission);
        this.mNewPermissions = newPermissions;
        AnnotationValidations.validate(NonNull.class, null, this.mNewPermissions);
        this.mTargetSdk = targetSdk;
        AnnotationValidations.validate(IntRange.class, null, this.mTargetSdk, "from", 0L);
        this.onConstructed();
    }

    public String getSplitPermission() {
        return this.mSplitPermission;
    }

    public List<String> getNewPermissions() {
        return this.mNewPermissions;
    }

    public int getTargetSdk() {
        return this.mTargetSdk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitPermissionInfoParcelable that = (SplitPermissionInfoParcelable)o;
        return Objects.equals(this.mSplitPermission, that.mSplitPermission) && Objects.equals(this.mNewPermissions, that.mNewPermissions) && this.mTargetSdk == that.mTargetSdk;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mSplitPermission);
        _hash = 31 * _hash + Objects.hashCode(this.mNewPermissions);
        _hash = 31 * _hash + this.mTargetSdk;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSplitPermission);
        dest.writeStringList(this.mNewPermissions);
        dest.writeInt(this.mTargetSdk);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected SplitPermissionInfoParcelable(Parcel in) {
        String splitPermission = in.readString();
        ArrayList<String> newPermissions = new ArrayList<String>();
        in.readStringList(newPermissions);
        int targetSdk = in.readInt();
        this.mSplitPermission = splitPermission;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSplitPermission);
        this.mNewPermissions = newPermissions;
        AnnotationValidations.validate(NonNull.class, null, this.mNewPermissions);
        this.mTargetSdk = targetSdk;
        AnnotationValidations.validate(IntRange.class, null, this.mTargetSdk, "from", 0L);
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }
}

