/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.pm.Signature;
import android.content.pm.SigningDetails;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.internal.modules.utils.build.UnboundedSdkLevel;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Slog;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.util.ArrayUtils;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class FrameworkParsingPackageUtils {
    private static final String TAG = "FrameworkParsingPackageUtils";
    private static final int MAX_FILE_NAME_SIZE = 223;
    public static final int PARSE_IGNORE_OVERLAY_REQUIRED_SYSTEM_PROPERTY = 128;
    public static final int PARSE_APK_IN_APEX = 512;

    public static String validateName(String name, boolean requireSeparator, boolean requireFilename) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        if (requireFilename) {
            if (!FileUtils.isValidExtFilename(name)) {
                return "Invalid filename";
            }
            if (N > 223) {
                return "the length of the name is greater than 223";
            }
        }
        return hasSep || !requireSeparator ? null : "must have at least one '.' separator";
    }

    public static ParseResult validateName(ParseInput input, String name, boolean requireSeparator, boolean requireFilename) {
        String errorMessage = FrameworkParsingPackageUtils.validateName(name, requireSeparator, requireFilename);
        if (errorMessage != null) {
            return input.error(errorMessage);
        }
        return input.success(null);
    }

    public static PublicKey parsePublicKey(String encodedPublicKey) {
        if (encodedPublicKey == null) {
            Slog.w(TAG, "Could not parse null public key");
            return null;
        }
        try {
            return FrameworkParsingPackageUtils.parsePublicKey(Base64.decode(encodedPublicKey, 0));
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Could not parse verifier public key; invalid Base64");
            return null;
        }
    }

    public static PublicKey parsePublicKey(byte[] publicKey) {
        X509EncodedKeySpec keySpec;
        if (publicKey == null) {
            Slog.w(TAG, "Could not parse null public key");
            return null;
        }
        try {
            keySpec = new X509EncodedKeySpec(publicKey);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: RSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: EC KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: DSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    public static boolean checkRequiredSystemProperties(String rawPropNames, String rawPropValues) {
        String[] propValues;
        if (TextUtils.isEmpty(rawPropNames) || TextUtils.isEmpty(rawPropValues)) {
            if (!TextUtils.isEmpty(rawPropNames) || !TextUtils.isEmpty(rawPropValues)) {
                Slog.w(TAG, "Disabling overlay - incomplete property :'" + rawPropNames + "=" + rawPropValues + "' - require both requiredSystemPropertyName AND requiredSystemPropertyValue to be specified.");
                return false;
            }
            return true;
        }
        String[] propNames = rawPropNames.split(",");
        if (propNames.length != (propValues = rawPropValues.split(",")).length) {
            Slog.w(TAG, "Disabling overlay - property :'" + rawPropNames + "=" + rawPropValues + "' - require both requiredSystemPropertyName AND requiredSystemPropertyValue lists to have the same size.");
            return false;
        }
        for (int i = 0; i < propNames.length; ++i) {
            String currValue = SystemProperties.get(propNames[i]);
            if (TextUtils.equals(currValue, propValues[i])) continue;
            return false;
        }
        return true;
    }

    public static ParseResult<SigningDetails> getSigningDetails(ParseInput input, String baseCodePath, boolean skipVerify, boolean isStaticSharedLibrary, SigningDetails existingSigningDetails, int targetSdk) {
        ParseResult<SigningDetails> verified;
        int minSignatureScheme = ApkSignatureVerifier.getMinimumSignatureSchemeVersionForTargetSdk(targetSdk);
        if (isStaticSharedLibrary) {
            minSignatureScheme = 2;
        }
        if ((verified = skipVerify ? ApkSignatureVerifier.unsafeGetCertsWithoutVerification(input, baseCodePath, 1) : ApkSignatureVerifier.verify(input, baseCodePath, minSignatureScheme)).isError()) {
            return input.error(verified);
        }
        if (existingSigningDetails == SigningDetails.UNKNOWN) {
            return verified;
        }
        if (!Signature.areExactMatch(existingSigningDetails.getSignatures(), verified.getResult().getSignatures())) {
            return input.error(-104, baseCodePath + " has mismatched certificates");
        }
        return input.success(existingSigningDetails);
    }

    public static ParseResult<Integer> computeMinSdkVersion(int minVers, String minCode, int platformSdkVersion, String[] platformSdkCodenames, ParseInput input) {
        if (minCode == null) {
            if (minVers <= platformSdkVersion) {
                return input.success(minVers);
            }
            return input.error(-12, "Requires newer sdk version #" + minVers + " (current version is #" + platformSdkVersion + ")");
        }
        if (FrameworkParsingPackageUtils.matchTargetCode(platformSdkCodenames, minCode)) {
            return input.success(10000);
        }
        if (platformSdkCodenames.length > 0) {
            return input.error(-12, "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")");
        }
        return input.error(-12, "Requires development platform " + minCode + " but this is a release platform.");
    }

    public static ParseResult<Integer> computeTargetSdkVersion(int targetVers, String targetCode, String[] platformSdkCodenames, ParseInput input, boolean allowUnknownCodenames) {
        if (targetCode == null) {
            return input.success(targetVers);
        }
        try {
            if (allowUnknownCodenames && UnboundedSdkLevel.isAtMost(targetCode)) {
                return input.success(10000);
            }
        }
        catch (IllegalArgumentException e) {
            return input.error(-12, e.getMessage());
        }
        if (FrameworkParsingPackageUtils.matchTargetCode(platformSdkCodenames, targetCode)) {
            return input.success(10000);
        }
        if (platformSdkCodenames.length > 0) {
            return input.error(-12, "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")");
        }
        return input.error(-12, "Requires development platform " + targetCode + " but this is a release platform.");
    }

    public static ParseResult<Integer> computeMaxSdkVersion(int maxVers, int platformSdkVersion, ParseInput input) {
        if (platformSdkVersion > maxVers) {
            return input.error(-14, "Requires max SDK version " + maxVers + " but is " + platformSdkVersion);
        }
        return input.success(maxVers);
    }

    private static boolean matchTargetCode(String[] codeNames, String targetCode) {
        int targetCodeIdx = targetCode.indexOf(46);
        String targetCodeName = targetCodeIdx == -1 ? targetCode : targetCode.substring(0, targetCodeIdx);
        return ArrayUtils.contains(codeNames, targetCodeName);
    }
}

