/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.AppDetailsActivity;
import android.app.PackageDeleteObserver;
import android.app.PropertyInvalidatedCache;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApkChecksum;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstallSourceInfo;
import android.content.pm.InstantAppInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.SuspendDialogInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.ArtManager;
import android.content.pm.pkg.FrameworkPackageUserState;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import dalvik.system.VMRuntime;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public abstract class PackageManager {
    private static final String TAG = "PackageManager";
    public static final boolean APPLY_DEFAULT_TO_DEVICE_PROTECTED_STORAGE = true;
    public static final boolean ENABLE_SHARED_UID_MIGRATION = true;
    public static final String PROPERTY_MEDIA_CAPABILITIES = "android.media.PROPERTY_MEDIA_CAPABILITIES";
    public static final String PROPERTY_NO_APP_DATA_STORAGE = "android.internal.PROPERTY_NO_APP_DATA_STORAGE";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ACTIVITY = 1;
    public static final int TYPE_RECEIVER = 2;
    public static final int TYPE_SERVICE = 3;
    public static final int TYPE_PROVIDER = 4;
    public static final int TYPE_APPLICATION = 5;
    public static final int GET_ACTIVITIES = 1;
    public static final int GET_RECEIVERS = 2;
    public static final int GET_SERVICES = 4;
    public static final int GET_PROVIDERS = 8;
    public static final int GET_INSTRUMENTATION = 16;
    @Deprecated
    public static final int GET_INTENT_FILTERS = 32;
    @Deprecated
    public static final int GET_SIGNATURES = 64;
    public static final int GET_RESOLVED_FILTER = 64;
    public static final int GET_META_DATA = 128;
    public static final int GET_GIDS = 256;
    @Deprecated
    public static final int GET_DISABLED_COMPONENTS = 512;
    public static final int MATCH_DISABLED_COMPONENTS = 512;
    public static final int GET_SHARED_LIBRARY_FILES = 1024;
    public static final int GET_URI_PERMISSION_PATTERNS = 2048;
    public static final int GET_PERMISSIONS = 4096;
    @Deprecated
    public static final int GET_UNINSTALLED_PACKAGES = 8192;
    public static final int MATCH_UNINSTALLED_PACKAGES = 8192;
    public static final int GET_CONFIGURATIONS = 16384;
    @Deprecated
    public static final int GET_DISABLED_UNTIL_USED_COMPONENTS = 32768;
    public static final int MATCH_DISABLED_UNTIL_USED_COMPONENTS = 32768;
    public static final int MATCH_DEFAULT_ONLY = 65536;
    public static final int MATCH_ALL = 131072;
    public static final int MATCH_DIRECT_BOOT_UNAWARE = 262144;
    public static final int MATCH_DIRECT_BOOT_AWARE = 524288;
    public static final int MATCH_SYSTEM_ONLY = 0x100000;
    @SystemApi
    public static final int MATCH_FACTORY_ONLY = 0x200000;
    @SystemApi
    public static final int MATCH_ANY_USER = 0x400000;
    public static final int MATCH_KNOWN_PACKAGES = 0x402000;
    @SystemApi
    public static final int MATCH_INSTANT = 0x800000;
    public static final int MATCH_VISIBLE_TO_INSTANT_APP_ONLY = 0x1000000;
    public static final int MATCH_EXPLICITLY_VISIBLE_ONLY = 0x2000000;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int MATCH_STATIC_SHARED_AND_SDK_LIBRARIES = 0x4000000;
    public static final int GET_SIGNING_CERTIFICATES = 0x8000000;
    public static final int MATCH_DIRECT_BOOT_AUTO = 0x10000000;
    public static final int GET_ATTRIBUTIONS = Integer.MIN_VALUE;
    @Deprecated
    public static final int MATCH_DEBUG_TRIAGED_MISSING = 0x10000000;
    @SystemApi
    public static final int MATCH_HIDDEN_UNTIL_INSTALLED_COMPONENTS = 0x20000000;
    public static final int MATCH_APEX = 0x40000000;
    public static final int SKIP_CURRENT_PROFILE = 2;
    public static final int ONLY_IF_NO_MATCH_FOUND = 4;
    @SystemApi
    public static final int MODULE_APEX_NAME = 1;
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_DENIED = -1;
    public static final int SIGNATURE_MATCH = 0;
    public static final int SIGNATURE_NEITHER_SIGNED = 1;
    public static final int SIGNATURE_FIRST_NOT_SIGNED = -1;
    public static final int SIGNATURE_SECOND_NOT_SIGNED = -2;
    public static final int SIGNATURE_NO_MATCH = -3;
    public static final int SIGNATURE_UNKNOWN_PACKAGE = -4;
    public static final int COMPONENT_ENABLED_STATE_DEFAULT = 0;
    public static final int COMPONENT_ENABLED_STATE_ENABLED = 1;
    public static final int COMPONENT_ENABLED_STATE_DISABLED = 2;
    public static final int COMPONENT_ENABLED_STATE_DISABLED_USER = 3;
    public static final int COMPONENT_ENABLED_STATE_DISABLED_UNTIL_USED = 4;
    @SystemApi
    public static final int ROLLBACK_DATA_POLICY_RESTORE = 0;
    @SystemApi
    public static final int ROLLBACK_DATA_POLICY_WIPE = 1;
    @SystemApi
    public static final int ROLLBACK_DATA_POLICY_RETAIN = 2;
    @UnsupportedAppUsage
    public static final int INSTALL_REPLACE_EXISTING = 2;
    public static final int INSTALL_ALLOW_TEST = 4;
    public static final int INSTALL_INTERNAL = 16;
    public static final int INSTALL_FROM_ADB = 32;
    public static final int INSTALL_ALL_USERS = 64;
    public static final int INSTALL_REQUEST_DOWNGRADE = 128;
    public static final int INSTALL_GRANT_RUNTIME_PERMISSIONS = 256;
    public static final int INSTALL_ALL_WHITELIST_RESTRICTED_PERMISSIONS = 0x400000;
    public static final int INSTALL_FORCE_VOLUME_UUID = 512;
    public static final int INSTALL_FORCE_PERMISSION_PROMPT = 1024;
    public static final int INSTALL_INSTANT_APP = 2048;
    public static final int INSTALL_DONT_KILL_APP = 4096;
    public static final int INSTALL_FULL_APP = 16384;
    public static final int INSTALL_ALLOCATE_AGGRESSIVE = 32768;
    public static final int INSTALL_VIRTUAL_PRELOAD = 65536;
    public static final int INSTALL_APEX = 131072;
    public static final int INSTALL_ENABLE_ROLLBACK = 262144;
    public static final int INSTALL_DISABLE_VERIFICATION = 524288;
    public static final int INSTALL_ALLOW_DOWNGRADE = 0x100000;
    public static final int INSTALL_STAGED = 0x200000;
    public static final int INSTALL_DISABLE_ALLOWED_APEX_UPDATE_CHECK = 0x400000;
    public static final int DONT_KILL_APP = 1;
    public static final int SYNCHRONOUS = 2;
    public static final int INSTALL_REASON_UNKNOWN = 0;
    public static final int INSTALL_REASON_POLICY = 1;
    public static final int INSTALL_REASON_DEVICE_RESTORE = 2;
    public static final int INSTALL_REASON_DEVICE_SETUP = 3;
    public static final int INSTALL_REASON_USER = 4;
    public static final int INSTALL_REASON_ROLLBACK = 5;
    public static final int INSTALL_SCENARIO_DEFAULT = 0;
    public static final int INSTALL_SCENARIO_FAST = 1;
    public static final int INSTALL_SCENARIO_BULK = 2;
    public static final int INSTALL_SCENARIO_BULK_SECONDARY = 3;
    public static final int UNINSTALL_REASON_UNKNOWN = 0;
    public static final int UNINSTALL_REASON_USER_TYPE = 1;
    public static final int INSTALL_UNKNOWN = 0;
    @SystemApi
    public static final int INSTALL_SUCCEEDED = 1;
    @SystemApi
    public static final int INSTALL_FAILED_ALREADY_EXISTS = -1;
    @SystemApi
    public static final int INSTALL_FAILED_INVALID_APK = -2;
    @SystemApi
    public static final int INSTALL_FAILED_INVALID_URI = -3;
    @SystemApi
    public static final int INSTALL_FAILED_INSUFFICIENT_STORAGE = -4;
    @SystemApi
    public static final int INSTALL_FAILED_DUPLICATE_PACKAGE = -5;
    @SystemApi
    public static final int INSTALL_FAILED_NO_SHARED_USER = -6;
    @SystemApi
    public static final int INSTALL_FAILED_UPDATE_INCOMPATIBLE = -7;
    @SystemApi
    public static final int INSTALL_FAILED_SHARED_USER_INCOMPATIBLE = -8;
    @SystemApi
    public static final int INSTALL_FAILED_MISSING_SHARED_LIBRARY = -9;
    @SystemApi
    public static final int INSTALL_FAILED_REPLACE_COULDNT_DELETE = -10;
    @SystemApi
    public static final int INSTALL_FAILED_DEXOPT = -11;
    @SystemApi
    public static final int INSTALL_FAILED_OLDER_SDK = -12;
    @SystemApi
    public static final int INSTALL_FAILED_CONFLICTING_PROVIDER = -13;
    @SystemApi
    public static final int INSTALL_FAILED_NEWER_SDK = -14;
    @SystemApi
    public static final int INSTALL_FAILED_TEST_ONLY = -15;
    @SystemApi
    public static final int INSTALL_FAILED_CPU_ABI_INCOMPATIBLE = -16;
    @SystemApi
    public static final int INSTALL_FAILED_MISSING_FEATURE = -17;
    @SystemApi
    public static final int INSTALL_FAILED_CONTAINER_ERROR = -18;
    @SystemApi
    public static final int INSTALL_FAILED_INVALID_INSTALL_LOCATION = -19;
    @SystemApi
    public static final int INSTALL_FAILED_MEDIA_UNAVAILABLE = -20;
    @SystemApi
    public static final int INSTALL_FAILED_VERIFICATION_TIMEOUT = -21;
    @SystemApi
    public static final int INSTALL_FAILED_VERIFICATION_FAILURE = -22;
    @SystemApi
    public static final int INSTALL_FAILED_PACKAGE_CHANGED = -23;
    public static final int INSTALL_FAILED_UID_CHANGED = -24;
    public static final int INSTALL_FAILED_VERSION_DOWNGRADE = -25;
    @SystemApi
    public static final int INSTALL_FAILED_PERMISSION_MODEL_DOWNGRADE = -26;
    @SystemApi
    public static final int INSTALL_FAILED_SANDBOX_VERSION_DOWNGRADE = -27;
    public static final int INSTALL_FAILED_MISSING_SPLIT = -28;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_NOT_APK = -100;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_BAD_MANIFEST = -101;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_UNEXPECTED_EXCEPTION = -102;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_NO_CERTIFICATES = -103;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES = -104;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_CERTIFICATE_ENCODING = -105;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_BAD_PACKAGE_NAME = -106;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_BAD_SHARED_USER_ID = -107;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_MANIFEST_MALFORMED = -108;
    @SystemApi
    public static final int INSTALL_PARSE_FAILED_MANIFEST_EMPTY = -109;
    @SystemApi
    public static final int INSTALL_FAILED_INTERNAL_ERROR = -110;
    public static final int INSTALL_FAILED_USER_RESTRICTED = -111;
    public static final int INSTALL_FAILED_DUPLICATE_PERMISSION = -112;
    public static final int INSTALL_FAILED_NO_MATCHING_ABIS = -113;
    @UnsupportedAppUsage
    public static final int NO_NATIVE_LIBRARIES = -114;
    public static final int INSTALL_FAILED_ABORTED = -115;
    public static final int INSTALL_FAILED_SESSION_INVALID = -116;
    public static final int INSTALL_FAILED_BAD_DEX_METADATA = -117;
    public static final int INSTALL_FAILED_BAD_SIGNATURE = -118;
    public static final int INSTALL_FAILED_OTHER_STAGED_SESSION_IN_PROGRESS = -119;
    public static final int INSTALL_FAILED_MULTIPACKAGE_INCONSISTENCY = -120;
    public static final int INSTALL_FAILED_WRONG_INSTALLED_VERSION = -121;
    public static final int INSTALL_FAILED_PROCESS_NOT_DEFINED = -122;
    public static final int INSTALL_PARSE_FAILED_ONLY_COREAPP_ALLOWED = -123;
    public static final int INSTALL_PARSE_FAILED_RESOURCES_ARSC_COMPRESSED = -124;
    public static final int INSTALL_PARSE_FAILED_SKIPPED = -125;
    public static final int INSTALL_FAILED_DUPLICATE_PERMISSION_GROUP = -126;
    public static final int INSTALL_FAILED_BAD_PERMISSION_GROUP = -127;
    public static final int INSTALL_ACTIVATION_FAILED = -128;
    public static final int DELETE_KEEP_DATA = 1;
    public static final int DELETE_ALL_USERS = 2;
    public static final int DELETE_SYSTEM_APP = 4;
    public static final int DELETE_DONT_KILL_APP = 8;
    public static final int DELETE_CHATTY = Integer.MIN_VALUE;
    public static final int DELETE_SUCCEEDED = 1;
    public static final int DELETE_FAILED_INTERNAL_ERROR = -1;
    public static final int DELETE_FAILED_DEVICE_POLICY_MANAGER = -2;
    public static final int DELETE_FAILED_USER_RESTRICTED = -3;
    public static final int DELETE_FAILED_OWNER_BLOCKED = -4;
    public static final int DELETE_FAILED_ABORTED = -5;
    public static final int DELETE_FAILED_USED_SHARED_LIBRARY = -6;
    public static final int DELETE_FAILED_APP_PINNED = -7;
    public static final int MOVE_SUCCEEDED = -100;
    public static final int MOVE_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int MOVE_FAILED_DOESNT_EXIST = -2;
    public static final int MOVE_FAILED_SYSTEM_PACKAGE = -3;
    public static final int MOVE_FAILED_INVALID_LOCATION = -5;
    public static final int MOVE_FAILED_INTERNAL_ERROR = -6;
    public static final int MOVE_FAILED_OPERATION_PENDING = -7;
    public static final int MOVE_FAILED_DEVICE_ADMIN = -8;
    public static final int MOVE_FAILED_3RD_PARTY_NOT_ALLOWED_ON_INTERNAL = -9;
    public static final int MOVE_FAILED_LOCKED_USER = -10;
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int MOVE_INTERNAL = 1;
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int MOVE_EXTERNAL_MEDIA = 2;
    public static final String EXTRA_MOVE_ID = "android.content.pm.extra.MOVE_ID";
    public static final int VERIFICATION_ALLOW_WITHOUT_SUFFICIENT = 2;
    public static final int VERIFICATION_ALLOW = 1;
    public static final int VERIFICATION_REJECT = -1;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_VERIFICATION_SUCCESS = 1;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_VERIFICATION_FAILURE = -1;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_DOMAIN_VERIFICATION_STATUS_UNDEFINED = 0;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_DOMAIN_VERIFICATION_STATUS_ASK = 1;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_DOMAIN_VERIFICATION_STATUS_ALWAYS = 2;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_DOMAIN_VERIFICATION_STATUS_NEVER = 3;
    @Deprecated
    @SystemApi
    public static final int INTENT_FILTER_DOMAIN_VERIFICATION_STATUS_ALWAYS_ASK = 4;
    public static final long MAXIMUM_VERIFICATION_TIMEOUT = 3600000L;
    public static final String FEATURE_AUDIO_LOW_LATENCY = "android.hardware.audio.low_latency";
    public static final String FEATURE_AUDIO_OUTPUT = "android.hardware.audio.output";
    public static final String FEATURE_AUDIO_PRO = "android.hardware.audio.pro";
    public static final String FEATURE_BLUETOOTH = "android.hardware.bluetooth";
    public static final String FEATURE_BLUETOOTH_LE = "android.hardware.bluetooth_le";
    public static final String FEATURE_CAMERA = "android.hardware.camera";
    public static final String FEATURE_CAMERA_AUTOFOCUS = "android.hardware.camera.autofocus";
    public static final String FEATURE_CAMERA_ANY = "android.hardware.camera.any";
    public static final String FEATURE_CAMERA_EXTERNAL = "android.hardware.camera.external";
    public static final String FEATURE_CAMERA_FLASH = "android.hardware.camera.flash";
    public static final String FEATURE_CAMERA_FRONT = "android.hardware.camera.front";
    public static final String FEATURE_CAMERA_LEVEL_FULL = "android.hardware.camera.level.full";
    public static final String FEATURE_CAMERA_CAPABILITY_MANUAL_SENSOR = "android.hardware.camera.capability.manual_sensor";
    public static final String FEATURE_CAMERA_CAPABILITY_MANUAL_POST_PROCESSING = "android.hardware.camera.capability.manual_post_processing";
    public static final String FEATURE_CAMERA_CAPABILITY_RAW = "android.hardware.camera.capability.raw";
    public static final String FEATURE_CAMERA_AR = "android.hardware.camera.ar";
    public static final String FEATURE_CAMERA_CONCURRENT = "android.hardware.camera.concurrent";
    public static final String FEATURE_CONSUMER_IR = "android.hardware.consumerir";
    @SystemApi
    public static final String FEATURE_CONTEXT_HUB = "android.hardware.context_hub";
    public static final String FEATURE_CTS = "android.software.cts";
    public static final String FEATURE_CAR_TEMPLATES_HOST = "android.software.car.templates_host";
    public static final String FEATURE_IDENTITY_CREDENTIAL_HARDWARE = "android.hardware.identity_credential";
    public static final String FEATURE_IDENTITY_CREDENTIAL_HARDWARE_DIRECT_ACCESS = "android.hardware.identity_credential_direct_access";
    public static final String FEATURE_LOCATION = "android.hardware.location";
    public static final String FEATURE_LOCATION_GPS = "android.hardware.location.gps";
    public static final String FEATURE_LOCATION_NETWORK = "android.hardware.location.network";
    public static final String FEATURE_FELICA = "android.hardware.felica";
    public static final String FEATURE_RAM_LOW = "android.hardware.ram.low";
    public static final String FEATURE_RAM_NORMAL = "android.hardware.ram.normal";
    public static final String FEATURE_MICROPHONE = "android.hardware.microphone";
    public static final String FEATURE_NFC = "android.hardware.nfc";
    @Deprecated
    public static final String FEATURE_NFC_HCE = "android.hardware.nfc.hce";
    public static final String FEATURE_NFC_HOST_CARD_EMULATION = "android.hardware.nfc.hce";
    public static final String FEATURE_NFC_HOST_CARD_EMULATION_NFCF = "android.hardware.nfc.hcef";
    public static final String FEATURE_NFC_OFF_HOST_CARD_EMULATION_UICC = "android.hardware.nfc.uicc";
    public static final String FEATURE_NFC_OFF_HOST_CARD_EMULATION_ESE = "android.hardware.nfc.ese";
    public static final String FEATURE_NFC_BEAM = "android.sofware.nfc.beam";
    public static final String FEATURE_NFC_ANY = "android.hardware.nfc.any";
    public static final String FEATURE_SE_OMAPI_UICC = "android.hardware.se.omapi.uicc";
    public static final String FEATURE_SE_OMAPI_ESE = "android.hardware.se.omapi.ese";
    public static final String FEATURE_SE_OMAPI_SD = "android.hardware.se.omapi.sd";
    public static final String FEATURE_SECURITY_MODEL_COMPATIBLE = "android.hardware.security.model.compatible";
    public static final String FEATURE_OPENGLES_EXTENSION_PACK = "android.hardware.opengles.aep";
    public static final String FEATURE_VULKAN_HARDWARE_LEVEL = "android.hardware.vulkan.level";
    public static final String FEATURE_VULKAN_HARDWARE_COMPUTE = "android.hardware.vulkan.compute";
    public static final String FEATURE_VULKAN_HARDWARE_VERSION = "android.hardware.vulkan.version";
    public static final String FEATURE_VULKAN_DEQP_LEVEL = "android.software.vulkan.deqp.level";
    public static final String FEATURE_OPENGLES_DEQP_LEVEL = "android.software.opengles.deqp.level";
    @SystemApi
    public static final String FEATURE_BROADCAST_RADIO = "android.hardware.broadcastradio";
    public static final String FEATURE_SECURE_LOCK_SCREEN = "android.software.secure_lock_screen";
    public static final String FEATURE_SENSOR_ACCELEROMETER = "android.hardware.sensor.accelerometer";
    public static final String FEATURE_SENSOR_BAROMETER = "android.hardware.sensor.barometer";
    public static final String FEATURE_SENSOR_COMPASS = "android.hardware.sensor.compass";
    public static final String FEATURE_SENSOR_GYROSCOPE = "android.hardware.sensor.gyroscope";
    public static final String FEATURE_SENSOR_ACCELEROMETER_LIMITED_AXES = "android.hardware.sensor.accelerometer_limited_axes";
    public static final String FEATURE_SENSOR_GYROSCOPE_LIMITED_AXES = "android.hardware.sensor.gyroscope_limited_axes";
    public static final String FEATURE_SENSOR_ACCELEROMETER_LIMITED_AXES_UNCALIBRATED = "android.hardware.sensor.accelerometer_limited_axes_uncalibrated";
    public static final String FEATURE_SENSOR_GYROSCOPE_LIMITED_AXES_UNCALIBRATED = "android.hardware.sensor.gyroscope_limited_axes_uncalibrated";
    public static final String FEATURE_SENSOR_LIGHT = "android.hardware.sensor.light";
    public static final String FEATURE_SENSOR_PROXIMITY = "android.hardware.sensor.proximity";
    public static final String FEATURE_SENSOR_STEP_COUNTER = "android.hardware.sensor.stepcounter";
    public static final String FEATURE_SENSOR_STEP_DETECTOR = "android.hardware.sensor.stepdetector";
    public static final String FEATURE_SENSOR_HEART_RATE = "android.hardware.sensor.heartrate";
    public static final String FEATURE_SENSOR_HEART_RATE_ECG = "android.hardware.sensor.heartrate.ecg";
    public static final String FEATURE_SENSOR_RELATIVE_HUMIDITY = "android.hardware.sensor.relative_humidity";
    public static final String FEATURE_SENSOR_AMBIENT_TEMPERATURE = "android.hardware.sensor.ambient_temperature";
    public static final String FEATURE_SENSOR_HINGE_ANGLE = "android.hardware.sensor.hinge_angle";
    public static final String FEATURE_SENSOR_HEADING = "android.hardware.sensor.heading";
    public static final String FEATURE_SENSOR_DYNAMIC_HEAD_TRACKER = "android.hardware.sensor.dynamic.head_tracker";
    public static final String FEATURE_HIFI_SENSORS = "android.hardware.sensor.hifi_sensors";
    public static final String FEATURE_ASSIST_GESTURE = "android.hardware.sensor.assist";
    public static final String FEATURE_TELEPHONY = "android.hardware.telephony";
    public static final String FEATURE_TELEPHONY_CDMA = "android.hardware.telephony.cdma";
    public static final String FEATURE_TELEPHONY_GSM = "android.hardware.telephony.gsm";
    @SystemApi
    public static final String FEATURE_TELEPHONY_CARRIERLOCK = "android.hardware.telephony.carrierlock";
    public static final String FEATURE_TELEPHONY_EUICC = "android.hardware.telephony.euicc";
    public static final String FEATURE_TELEPHONY_EUICC_MEP = "android.hardware.telephony.euicc.mep";
    public static final String FEATURE_TELEPHONY_MBMS = "android.hardware.telephony.mbms";
    public static final String FEATURE_TELEPHONY_IMS = "android.hardware.telephony.ims";
    @SystemApi
    public static final String FEATURE_TELEPHONY_IMS_SINGLE_REGISTRATION = "android.hardware.telephony.ims.singlereg";
    public static final String FEATURE_TELECOM = "android.software.telecom";
    public static final String FEATURE_TELEPHONY_CALLING = "android.hardware.telephony.calling";
    public static final String FEATURE_TELEPHONY_DATA = "android.hardware.telephony.data";
    public static final String FEATURE_TELEPHONY_MESSAGING = "android.hardware.telephony.messaging";
    public static final String FEATURE_TELEPHONY_RADIO_ACCESS = "android.hardware.telephony.radio.access";
    public static final String FEATURE_TELEPHONY_SUBSCRIPTION = "android.hardware.telephony.subscription";
    public static final String FEATURE_UWB = "android.hardware.uwb";
    public static final String FEATURE_USB_HOST = "android.hardware.usb.host";
    public static final String FEATURE_USB_ACCESSORY = "android.hardware.usb.accessory";
    public static final String FEATURE_SIP = "android.software.sip";
    public static final String FEATURE_SIP_VOIP = "android.software.sip.voip";
    @Deprecated
    public static final String FEATURE_CONNECTION_SERVICE = "android.software.connectionservice";
    public static final String FEATURE_TOUCHSCREEN = "android.hardware.touchscreen";
    public static final String FEATURE_TOUCHSCREEN_MULTITOUCH = "android.hardware.touchscreen.multitouch";
    public static final String FEATURE_TOUCHSCREEN_MULTITOUCH_DISTINCT = "android.hardware.touchscreen.multitouch.distinct";
    public static final String FEATURE_TOUCHSCREEN_MULTITOUCH_JAZZHAND = "android.hardware.touchscreen.multitouch.jazzhand";
    public static final String FEATURE_FAKETOUCH = "android.hardware.faketouch";
    public static final String FEATURE_FAKETOUCH_MULTITOUCH_DISTINCT = "android.hardware.faketouch.multitouch.distinct";
    public static final String FEATURE_FAKETOUCH_MULTITOUCH_JAZZHAND = "android.hardware.faketouch.multitouch.jazzhand";
    public static final String FEATURE_FINGERPRINT = "android.hardware.fingerprint";
    public static final String FEATURE_FACE = "android.hardware.biometrics.face";
    public static final String FEATURE_IRIS = "android.hardware.biometrics.iris";
    public static final String FEATURE_SCREEN_PORTRAIT = "android.hardware.screen.portrait";
    public static final String FEATURE_SCREEN_LANDSCAPE = "android.hardware.screen.landscape";
    public static final String FEATURE_LIVE_WALLPAPER = "android.software.live_wallpaper";
    public static final String FEATURE_APP_WIDGETS = "android.software.app_widgets";
    public static final String FEATURE_CANT_SAVE_STATE = "android.software.cant_save_state";
    @SystemApi
    public static final String FEATURE_GAME_SERVICE = "android.software.game_service";
    public static final String FEATURE_VOICE_RECOGNIZERS = "android.software.voice_recognizers";
    public static final String FEATURE_HOME_SCREEN = "android.software.home_screen";
    public static final String FEATURE_INPUT_METHODS = "android.software.input_methods";
    public static final String FEATURE_DEVICE_ADMIN = "android.software.device_admin";
    public static final String FEATURE_LEANBACK = "android.software.leanback";
    public static final String FEATURE_LEANBACK_ONLY = "android.software.leanback_only";
    public static final String FEATURE_LIVE_TV = "android.software.live_tv";
    public static final String FEATURE_WIFI = "android.hardware.wifi";
    public static final String FEATURE_WIFI_DIRECT = "android.hardware.wifi.direct";
    public static final String FEATURE_WIFI_AWARE = "android.hardware.wifi.aware";
    public static final String FEATURE_WIFI_PASSPOINT = "android.hardware.wifi.passpoint";
    public static final String FEATURE_WIFI_RTT = "android.hardware.wifi.rtt";
    public static final String FEATURE_LOWPAN = "android.hardware.lowpan";
    public static final String FEATURE_AUTOMOTIVE = "android.hardware.type.automotive";
    @Deprecated
    public static final String FEATURE_TELEVISION = "android.hardware.type.television";
    public static final String FEATURE_WATCH = "android.hardware.type.watch";
    public static final String FEATURE_EMBEDDED = "android.hardware.type.embedded";
    public static final String FEATURE_PC = "android.hardware.type.pc";
    public static final String FEATURE_PRINTING = "android.software.print";
    public static final String FEATURE_COMPANION_DEVICE_SETUP = "android.software.companion_device_setup";
    public static final String FEATURE_BACKUP = "android.software.backup";
    public static final String FEATURE_FREEFORM_WINDOW_MANAGEMENT = "android.software.freeform_window_management";
    public static final String FEATURE_PICTURE_IN_PICTURE = "android.software.picture_in_picture";
    public static final String FEATURE_EXPANDED_PICTURE_IN_PICTURE = "android.software.expanded_picture_in_picture";
    public static final String FEATURE_ACTIVITIES_ON_SECONDARY_DISPLAYS = "android.software.activities_on_secondary_displays";
    public static final String FEATURE_MANAGED_USERS = "android.software.managed_users";
    public static final String FEATURE_MANAGED_PROFILES = "android.software.managed_users";
    public static final String FEATURE_VERIFIED_BOOT = "android.software.verified_boot";
    public static final String FEATURE_SECURELY_REMOVES_USERS = "android.software.securely_removes_users";
    public static final String FEATURE_FILE_BASED_ENCRYPTION = "android.software.file_based_encryption";
    public static final String FEATURE_ADOPTABLE_STORAGE = "android.software.adoptable_storage";
    public static final String FEATURE_WEBVIEW = "android.software.webview";
    public static final String FEATURE_ETHERNET = "android.hardware.ethernet";
    public static final String FEATURE_HDMI_CEC = "android.hardware.hdmi.cec";
    public static final String FEATURE_GAMEPAD = "android.hardware.gamepad";
    public static final String FEATURE_MIDI = "android.software.midi";
    @Deprecated
    public static final String FEATURE_VR_MODE = "android.software.vr.mode";
    public static final String FEATURE_VR_MODE_HIGH_PERFORMANCE = "android.hardware.vr.high_performance";
    public static final String FEATURE_AUTOFILL = "android.software.autofill";
    public static final String FEATURE_VR_HEADTRACKING = "android.hardware.vr.headtracking";
    public static final String FEATURE_HARDWARE_KEYSTORE = "android.hardware.hardware_keystore";
    public static final String FEATURE_STRONGBOX_KEYSTORE = "android.hardware.strongbox_keystore";
    public static final String FEATURE_SLICES_DISABLED = "android.software.slices_disabled";
    public static final String FEATURE_DEVICE_UNIQUE_ATTESTATION = "android.hardware.device_unique_attestation";
    public static final String FEATURE_DEVICE_ID_ATTESTATION = "android.software.device_id_attestation";
    public static final String FEATURE_IPSEC_TUNNELS = "android.software.ipsec_tunnels";
    public static final String FEATURE_CONTROLS = "android.software.controls";
    @SystemApi
    public static final String FEATURE_REBOOT_ESCROW = "android.hardware.reboot_escrow";
    @SystemApi
    public static final String FEATURE_INCREMENTAL_DELIVERY = "android.software.incremental_delivery";
    @SystemApi
    public static final String FEATURE_EROFS_LEGACY = "android.software.erofs_legacy";
    @SystemApi
    public static final String FEATURE_EROFS = "android.software.erofs";
    public static final String FEATURE_TUNER = "android.hardware.tv.tuner";
    public static final String FEATURE_APP_ENUMERATION = "android.software.app_enumeration";
    public static final String FEATURE_KEYSTORE_SINGLE_USE_KEY = "android.hardware.keystore.single_use_key";
    public static final String FEATURE_KEYSTORE_LIMITED_USE_KEY = "android.hardware.keystore.limited_use_key";
    public static final String FEATURE_KEYSTORE_APP_ATTEST_KEY = "android.hardware.keystore.app_attest_key";
    public static final String FEATURE_APP_COMPAT_OVERRIDES = "android.software.app_compat_overrides";
    public static final String FEATURE_COMMUNAL_MODE = "android.software.communal_mode";
    public static final String FEATURE_DREAM_OVERLAY = "android.software.dream_overlay";
    public static final String FEATURE_WINDOW_MAGNIFICATION = "android.software.window_magnification";
    public static final boolean APP_ENUMERATION_ENABLED_BY_DEFAULT = true;
    public static final String EXTRA_VERIFICATION_URI = "android.content.pm.extra.VERIFICATION_URI";
    public static final String EXTRA_VERIFICATION_ID = "android.content.pm.extra.VERIFICATION_ID";
    public static final String EXTRA_VERIFICATION_INSTALLER_PACKAGE = "android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE";
    public static final String EXTRA_VERIFICATION_INSTALL_FLAGS = "android.content.pm.extra.VERIFICATION_INSTALL_FLAGS";
    public static final String EXTRA_VERIFICATION_INSTALLER_UID = "android.content.pm.extra.VERIFICATION_INSTALLER_UID";
    public static final String EXTRA_VERIFICATION_PACKAGE_NAME = "android.content.pm.extra.VERIFICATION_PACKAGE_NAME";
    public static final String EXTRA_VERIFICATION_RESULT = "android.content.pm.extra.VERIFICATION_RESULT";
    @Deprecated
    public static final String EXTRA_VERIFICATION_VERSION_CODE = "android.content.pm.extra.VERIFICATION_VERSION_CODE";
    public static final String EXTRA_VERIFICATION_LONG_VERSION_CODE = "android.content.pm.extra.VERIFICATION_LONG_VERSION_CODE";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String EXTRA_VERIFICATION_ROOT_HASH = "android.content.pm.extra.VERIFICATION_ROOT_HASH";
    @Deprecated
    public static final String EXTRA_INTENT_FILTER_VERIFICATION_ID = "android.content.pm.extra.INTENT_FILTER_VERIFICATION_ID";
    @Deprecated
    public static final String EXTRA_INTENT_FILTER_VERIFICATION_URI_SCHEME = "android.content.pm.extra.INTENT_FILTER_VERIFICATION_URI_SCHEME";
    @Deprecated
    public static final String EXTRA_INTENT_FILTER_VERIFICATION_HOSTS = "android.content.pm.extra.INTENT_FILTER_VERIFICATION_HOSTS";
    @Deprecated
    public static final String EXTRA_INTENT_FILTER_VERIFICATION_PACKAGE_NAME = "android.content.pm.extra.INTENT_FILTER_VERIFICATION_PACKAGE_NAME";
    @SystemApi
    public static final String ACTION_REQUEST_PERMISSIONS = "android.content.pm.action.REQUEST_PERMISSIONS";
    @SystemApi
    public static final String ACTION_REQUEST_PERMISSIONS_FOR_OTHER = "android.content.pm.action.REQUEST_PERMISSIONS_FOR_OTHER";
    @SystemApi
    public static final String EXTRA_REQUEST_PERMISSIONS_NAMES = "android.content.pm.extra.REQUEST_PERMISSIONS_NAMES";
    @SystemApi
    public static final String EXTRA_REQUEST_PERMISSIONS_RESULTS = "android.content.pm.extra.REQUEST_PERMISSIONS_RESULTS";
    @SystemApi
    public static final String EXTRA_REQUEST_PERMISSIONS_LEGACY_ACCESS_PERMISSION_NAMES = "android.content.pm.extra.REQUEST_PERMISSIONS_LEGACY_ACCESS_PERMISSION_NAMES";
    public static final String EXTRA_FAILURE_EXISTING_PACKAGE = "android.content.pm.extra.FAILURE_EXISTING_PACKAGE";
    public static final String EXTRA_FAILURE_EXISTING_PERMISSION = "android.content.pm.extra.FAILURE_EXISTING_PERMISSION";
    @SystemApi
    public static final int FLAG_PERMISSION_USER_SET = 1;
    @SystemApi
    public static final int FLAG_PERMISSION_USER_FIXED = 2;
    @SystemApi
    public static final int FLAG_PERMISSION_POLICY_FIXED = 4;
    @Deprecated
    @SystemApi
    public static final int FLAG_PERMISSION_REVOKE_ON_UPGRADE = 8;
    @SystemApi
    public static final int FLAG_PERMISSION_SYSTEM_FIXED = 16;
    @SystemApi
    public static final int FLAG_PERMISSION_GRANTED_BY_DEFAULT = 32;
    @SystemApi
    public static final int FLAG_PERMISSION_REVIEW_REQUIRED = 64;
    @SystemApi
    public static final int FLAG_PERMISSION_REVOKE_WHEN_REQUESTED = 128;
    @SystemApi
    public static final int FLAG_PERMISSION_USER_SENSITIVE_WHEN_GRANTED = 256;
    @SystemApi
    public static final int FLAG_PERMISSION_USER_SENSITIVE_WHEN_DENIED = 512;
    @SystemApi
    public static final int FLAG_PERMISSION_RESTRICTION_INSTALLER_EXEMPT = 2048;
    @SystemApi
    public static final int FLAG_PERMISSION_RESTRICTION_SYSTEM_EXEMPT = 4096;
    @SystemApi
    public static final int FLAG_PERMISSION_RESTRICTION_UPGRADE_EXEMPT = 8192;
    @SystemApi
    public static final int FLAG_PERMISSION_APPLY_RESTRICTION = 16384;
    @SystemApi
    public static final int FLAG_PERMISSION_GRANTED_BY_ROLE = 32768;
    @SystemApi
    public static final int FLAG_PERMISSION_REVOKED_COMPAT = 8;
    @SystemApi
    public static final int FLAG_PERMISSION_ONE_TIME = 65536;
    @SystemApi
    public static final int FLAG_PERMISSION_AUTO_REVOKED = 131072;
    @SystemApi
    public static final int FLAG_PERMISSION_SELECTED_LOCATION_ACCURACY = 524288;
    @SystemApi
    public static final int FLAGS_PERMISSION_RESERVED_PERMISSION_CONTROLLER = -268435456;
    public static final int FLAGS_PERMISSION_RESTRICTION_ANY_EXEMPT = 14336;
    @Deprecated
    @SystemApi
    public static final int MASK_PERMISSION_FLAGS = 255;
    public static final int MASK_PERMISSION_FLAGS_ALL = 261119;
    public static final String APP_DETAILS_ACTIVITY_CLASS_NAME = AppDetailsActivity.class.getName();
    public static final int FLAG_PERMISSION_WHITELIST_SYSTEM = 1;
    public static final int FLAG_PERMISSION_WHITELIST_INSTALLER = 2;
    public static final int FLAG_PERMISSION_WHITELIST_UPGRADE = 4;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String SYSTEM_SHARED_LIBRARY_SERVICES = "android.ext.services";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String SYSTEM_SHARED_LIBRARY_SHARED = "android.ext.shared";
    public static final int NOTIFY_PACKAGE_USE_ACTIVITY = 0;
    public static final int NOTIFY_PACKAGE_USE_SERVICE = 1;
    public static final int NOTIFY_PACKAGE_USE_FOREGROUND_SERVICE = 2;
    public static final int NOTIFY_PACKAGE_USE_BROADCAST_RECEIVER = 3;
    public static final int NOTIFY_PACKAGE_USE_CONTENT_PROVIDER = 4;
    public static final int NOTIFY_PACKAGE_USE_BACKUP = 5;
    public static final int NOTIFY_PACKAGE_USE_CROSS_PACKAGE = 6;
    public static final int NOTIFY_PACKAGE_USE_INSTRUMENTATION = 7;
    public static final int NOTIFY_PACKAGE_USE_REASONS_COUNT = 8;
    public static final int VERSION_CODE_HIGHEST = -1;
    public static final long FILTER_APPLICATION_QUERY = 135549675L;
    @SystemApi
    public static final int SYSTEM_APP_STATE_HIDDEN_UNTIL_INSTALLED_HIDDEN = 0;
    @SystemApi
    public static final int SYSTEM_APP_STATE_HIDDEN_UNTIL_INSTALLED_VISIBLE = 1;
    @SystemApi
    public static final int SYSTEM_APP_STATE_INSTALLED = 2;
    @SystemApi
    public static final int SYSTEM_APP_STATE_UNINSTALLED = 3;
    public static final String PROPERTY_ALLOW_ADB_BACKUP = "android.backup.ALLOW_ADB_BACKUP";
    @SystemApi
    public static final int RESTRICTION_NONE = 0;
    @SystemApi
    public static final int RESTRICTION_HIDE_FROM_SUGGESTIONS = 1;
    @SystemApi
    public static final int RESTRICTION_HIDE_NOTIFICATIONS = 2;
    public static final int CERT_INPUT_RAW_X509 = 0;
    public static final int CERT_INPUT_SHA256 = 1;
    public static final List<Certificate> TRUST_ALL = Collections.singletonList(null);
    public static final List<Certificate> TRUST_NONE = Collections.singletonList(null);
    private static final PropertyInvalidatedCache<ApplicationInfoQuery, ApplicationInfo> sApplicationInfoCache = new PropertyInvalidatedCache<ApplicationInfoQuery, ApplicationInfo>(16, "cache_key.package_info", "getApplicationInfo"){

        @Override
        public ApplicationInfo recompute(ApplicationInfoQuery query) {
            return PackageManager.getApplicationInfoAsUserUncached(query.packageName, query.flags, query.userId);
        }

        @Override
        public boolean resultEquals(ApplicationInfo cached, ApplicationInfo fetched) {
            return true;
        }
    };
    private static final PropertyInvalidatedCache.AutoCorker sCacheAutoCorker = new PropertyInvalidatedCache.AutoCorker("cache_key.package_info");
    private static final PropertyInvalidatedCache<PackageInfoQuery, PackageInfo> sPackageInfoCache = new PropertyInvalidatedCache<PackageInfoQuery, PackageInfo>(32, "cache_key.package_info", "getPackageInfo"){

        @Override
        public PackageInfo recompute(PackageInfoQuery query) {
            return PackageManager.getPackageInfoAsUserUncached(query.packageName, query.flags, query.userId);
        }

        @Override
        public boolean resultEquals(PackageInfo cached, PackageInfo fetched) {
            return true;
        }
    };

    public int getUserId() {
        return UserHandle.myUserId();
    }

    @Deprecated
    public PackageManager() {
    }

    @Deprecated
    public abstract PackageInfo getPackageInfo(String var1, int var2) throws NameNotFoundException;

    public PackageInfo getPackageInfo(String packageName, PackageInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageInfo not implemented in subclass");
    }

    @Deprecated
    public abstract PackageInfo getPackageInfo(VersionedPackage var1, int var2) throws NameNotFoundException;

    public PackageInfo getPackageInfo(VersionedPackage versionedPackage, PackageInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageInfo not implemented in subclass");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @UnsupportedAppUsage
    public abstract PackageInfo getPackageInfoAsUser(String var1, int var2, int var3) throws NameNotFoundException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public PackageInfo getPackageInfoAsUser(String packageName, PackageInfoFlags flags, int userId) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageInfoAsUser not implemented in subclass");
    }

    public abstract String[] currentToCanonicalPackageNames(String[] var1);

    public abstract String[] canonicalToCurrentPackageNames(String[] var1);

    public abstract Intent getLaunchIntentForPackage(String var1);

    public abstract Intent getLeanbackLaunchIntentForPackage(String var1);

    public abstract Intent getCarLaunchIntentForPackage(String var1);

    public IntentSender getLaunchIntentSenderForPackage(String packageName) {
        throw new UnsupportedOperationException("getLaunchIntentSenderForPackage not implementedin subclass");
    }

    public abstract int[] getPackageGids(String var1) throws NameNotFoundException;

    @Deprecated
    public abstract int[] getPackageGids(String var1, int var2) throws NameNotFoundException;

    public int[] getPackageGids(String packageName, PackageInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageGids not implemented in subclass");
    }

    @Deprecated
    public abstract int getPackageUid(String var1, int var2) throws NameNotFoundException;

    public int getPackageUid(String packageName, PackageInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageUid not implemented in subclass");
    }

    @UnsupportedAppUsage
    public abstract int getPackageUidAsUser(String var1, int var2) throws NameNotFoundException;

    @Deprecated
    @UnsupportedAppUsage
    public abstract int getPackageUidAsUser(String var1, int var2, int var3) throws NameNotFoundException;

    public int getPackageUidAsUser(String packageName, PackageInfoFlags flags, int userId) throws NameNotFoundException {
        throw new UnsupportedOperationException("getPackageUidAsUser not implemented in subclass");
    }

    public abstract PermissionInfo getPermissionInfo(String var1, int var2) throws NameNotFoundException;

    public abstract List<PermissionInfo> queryPermissionsByGroup(String var1, int var2) throws NameNotFoundException;

    @SystemApi
    public abstract boolean arePermissionsIndividuallyControlled();

    public abstract boolean isWirelessConsentModeEnabled();

    public abstract PermissionGroupInfo getPermissionGroupInfo(String var1, int var2) throws NameNotFoundException;

    public abstract List<PermissionGroupInfo> getAllPermissionGroups(int var1);

    public void getPlatformPermissionsForGroup(String permissionGroupName, Executor executor, Consumer<List<String>> callback) {
    }

    public void getGroupOfPlatformPermission(String permissionName, Executor executor, Consumer<String> callback) {
    }

    @Deprecated
    public abstract ApplicationInfo getApplicationInfo(String var1, int var2) throws NameNotFoundException;

    public ApplicationInfo getApplicationInfo(String packageName, ApplicationInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getApplicationInfo not implemented in subclass");
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract ApplicationInfo getApplicationInfoAsUser(String var1, int var2, int var3) throws NameNotFoundException;

    public ApplicationInfo getApplicationInfoAsUser(String packageName, ApplicationInfoFlags flags, int userId) throws NameNotFoundException {
        throw new UnsupportedOperationException("getApplicationInfoAsUser not implemented in subclass");
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public ApplicationInfo getApplicationInfoAsUser(String packageName, int flags, UserHandle user) throws NameNotFoundException {
        return this.getApplicationInfoAsUser(packageName, flags, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public ApplicationInfo getApplicationInfoAsUser(String packageName, ApplicationInfoFlags flags, UserHandle user) throws NameNotFoundException {
        return this.getApplicationInfoAsUser(packageName, flags, user.getIdentifier());
    }

    public int getTargetSdkVersion(String packageName) throws NameNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public abstract ActivityInfo getActivityInfo(ComponentName var1, int var2) throws NameNotFoundException;

    public ActivityInfo getActivityInfo(ComponentName component, ComponentInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getActivityInfo not implemented in subclass");
    }

    @Deprecated
    public abstract ActivityInfo getReceiverInfo(ComponentName var1, int var2) throws NameNotFoundException;

    public ActivityInfo getReceiverInfo(ComponentName component, ComponentInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getReceiverInfo not implemented in subclass");
    }

    @Deprecated
    public abstract ServiceInfo getServiceInfo(ComponentName var1, int var2) throws NameNotFoundException;

    public ServiceInfo getServiceInfo(ComponentName component, ComponentInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getServiceInfo not implemented in subclass");
    }

    @Deprecated
    public abstract ProviderInfo getProviderInfo(ComponentName var1, int var2) throws NameNotFoundException;

    public ProviderInfo getProviderInfo(ComponentName component, ComponentInfoFlags flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getProviderInfo not implemented in subclass");
    }

    public ModuleInfo getModuleInfo(String packageName, int flags) throws NameNotFoundException {
        throw new UnsupportedOperationException("getModuleInfo not implemented in subclass");
    }

    public List<ModuleInfo> getInstalledModules(int flags) {
        throw new UnsupportedOperationException("getInstalledModules not implemented in subclass");
    }

    @Deprecated
    public abstract List<PackageInfo> getInstalledPackages(int var1);

    public List<PackageInfo> getInstalledPackages(PackageInfoFlags flags) {
        throw new UnsupportedOperationException("getInstalledPackages not implemented in subclass");
    }

    @Deprecated
    public abstract List<PackageInfo> getPackagesHoldingPermissions(String[] var1, int var2);

    public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, PackageInfoFlags flags) {
        throw new UnsupportedOperationException("getPackagesHoldingPermissions not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public abstract List<PackageInfo> getInstalledPackagesAsUser(int var1, int var2);

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public List<PackageInfo> getInstalledPackagesAsUser(PackageInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("getApplicationInfoAsUser not implemented in subclass");
    }

    public abstract int checkPermission(String var1, String var2);

    public abstract boolean isPermissionRevokedByPolicy(String var1, String var2);

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public String getPermissionControllerPackageName() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String getSdkSandboxPackageName() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract boolean addPermission(PermissionInfo var1);

    public abstract boolean addPermissionAsync(PermissionInfo var1);

    public abstract void removePermission(String var1);

    @SystemApi
    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS")
    public abstract void grantRuntimePermission(String var1, String var2, UserHandle var3);

    @SystemApi
    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public abstract void revokeRuntimePermission(String var1, String var2, UserHandle var3);

    @SystemApi
    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermission(String packageName, String permName, UserHandle user, String reason) {
        this.revokeRuntimePermission(packageName, permName, user);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.GET_RUNTIME_PERMISSIONS"})
    public abstract int getPermissionFlags(String var1, String var2, UserHandle var3);

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS"})
    public abstract void updatePermissionFlags(String var1, String var2, int var3, int var4, UserHandle var5);

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public Set<String> getWhitelistedRestrictedPermissions(String packageName, int whitelistFlag) {
        return Collections.emptySet();
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean addWhitelistedRestrictedPermission(String packageName, String permName, int whitelistFlags) {
        return false;
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean removeWhitelistedRestrictedPermission(String packageName, String permName, int whitelistFlags) {
        return false;
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean setAutoRevokeWhitelisted(String packageName, boolean whitelisted) {
        return false;
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean isAutoRevokeWhitelisted(String packageName) {
        return false;
    }

    @UnsupportedAppUsage
    public abstract boolean shouldShowRequestPermissionRationale(String var1);

    public CharSequence getBackgroundPermissionOptionLabel() {
        return "";
    }

    @UnsupportedAppUsage
    public Intent buildRequestPermissionsIntent(String[] permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            throw new IllegalArgumentException("permission cannot be null or empty");
        }
        Intent intent = new Intent(ACTION_REQUEST_PERMISSIONS);
        intent.putExtra(EXTRA_REQUEST_PERMISSIONS_NAMES, permissions);
        intent.setPackage(this.getPermissionControllerPackageName());
        return intent;
    }

    public abstract int checkSignatures(String var1, String var2);

    public abstract int checkSignatures(int var1, int var2);

    public abstract String[] getPackagesForUid(int var1);

    public abstract String getNameForUid(int var1);

    public abstract String[] getNamesForUids(int[] var1);

    @UnsupportedAppUsage
    public abstract int getUidForSharedUser(String var1) throws NameNotFoundException;

    @Deprecated
    public abstract List<ApplicationInfo> getInstalledApplications(int var1);

    public List<ApplicationInfo> getInstalledApplications(ApplicationInfoFlags flags) {
        throw new UnsupportedOperationException("getInstalledApplications not implemented in subclass");
    }

    @Deprecated
    public abstract List<ApplicationInfo> getInstalledApplicationsAsUser(int var1, int var2);

    public List<ApplicationInfo> getInstalledApplicationsAsUser(ApplicationInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("getInstalledApplicationsAsUser not implemented in subclass");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_INSTANT_APPS")
    public abstract List<InstantAppInfo> getInstantApps();

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_INSTANT_APPS")
    public abstract Drawable getInstantAppIcon(String var1);

    public abstract boolean isInstantApp();

    public abstract boolean isInstantApp(String var1);

    public abstract int getInstantAppCookieMaxBytes();

    public abstract int getInstantAppCookieMaxSize();

    public abstract byte[] getInstantAppCookie();

    public abstract void clearInstantAppCookie();

    public abstract void updateInstantAppCookie(byte[] var1);

    public abstract boolean setInstantAppCookie(byte[] var1);

    public abstract String[] getSystemSharedLibraryNames();

    @Deprecated
    public abstract List<SharedLibraryInfo> getSharedLibraries(int var1);

    public List<SharedLibraryInfo> getSharedLibraries(PackageInfoFlags flags) {
        throw new UnsupportedOperationException("getSharedLibraries() not implemented in subclass");
    }

    @Deprecated
    public abstract List<SharedLibraryInfo> getSharedLibrariesAsUser(int var1, int var2);

    public List<SharedLibraryInfo> getSharedLibrariesAsUser(PackageInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("getSharedLibrariesAsUser() not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_SHARED_LIBRARIES")
    public List<SharedLibraryInfo> getDeclaredSharedLibraries(String packageName, int flags) {
        throw new UnsupportedOperationException("getDeclaredSharedLibraries() not implemented in subclass");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_SHARED_LIBRARIES")
    public List<SharedLibraryInfo> getDeclaredSharedLibraries(String packageName, PackageInfoFlags flags) {
        throw new UnsupportedOperationException("getDeclaredSharedLibraries() not implemented in subclass");
    }

    @UnsupportedAppUsage
    public abstract String getServicesSystemSharedLibraryPackageName();

    @UnsupportedAppUsage
    public abstract String getSharedSystemSharedLibraryPackageName();

    public abstract ChangedPackages getChangedPackages(int var1);

    public abstract FeatureInfo[] getSystemAvailableFeatures();

    public abstract boolean hasSystemFeature(String var1);

    public abstract boolean hasSystemFeature(String var1, int var2);

    @Deprecated
    public abstract ResolveInfo resolveActivity(Intent var1, int var2);

    public ResolveInfo resolveActivity(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("resolveActivity not implemented in subclass");
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract ResolveInfo resolveActivityAsUser(Intent var1, int var2, int var3);

    public ResolveInfo resolveActivityAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("resolveActivityAsUser not implemented in subclass");
    }

    @Deprecated
    public abstract List<ResolveInfo> queryIntentActivities(Intent var1, int var2);

    public List<ResolveInfo> queryIntentActivities(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("queryIntentActivities not implemented in subclass");
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract List<ResolveInfo> queryIntentActivitiesAsUser(Intent var1, int var2, int var3);

    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("queryIntentActivitiesAsUser not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, UserHandle user) {
        return this.queryIntentActivitiesAsUser(intent, flags, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, ResolveInfoFlags flags, UserHandle user) {
        return this.queryIntentActivitiesAsUser(intent, flags, user.getIdentifier());
    }

    @Deprecated
    public abstract List<ResolveInfo> queryIntentActivityOptions(ComponentName var1, Intent[] var2, Intent var3, int var4);

    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, List<Intent> specifics, Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("queryIntentActivityOptions not implemented in subclass");
    }

    @Deprecated
    public abstract List<ResolveInfo> queryBroadcastReceivers(Intent var1, int var2);

    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("queryBroadcastReceivers not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, UserHandle userHandle) {
        return this.queryBroadcastReceiversAsUser(intent, flags, userHandle.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, ResolveInfoFlags flags, UserHandle userHandle) {
        return this.queryBroadcastReceiversAsUser(intent, flags, userHandle.getIdentifier());
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract List<ResolveInfo> queryBroadcastReceiversAsUser(Intent var1, int var2, int var3);

    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("queryBroadcastReceiversAsUser not implemented in subclass");
    }

    @Deprecated
    @UnsupportedAppUsage
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags, int userId) {
        String msg = "Shame on you for calling the hidden API queryBroadcastReceivers(). Shame!";
        if (VMRuntime.getRuntime().getTargetSdkVersion() >= 26) {
            throw new UnsupportedOperationException("Shame on you for calling the hidden API queryBroadcastReceivers(). Shame!");
        }
        Log.d(TAG, "Shame on you for calling the hidden API queryBroadcastReceivers(). Shame!");
        return this.queryBroadcastReceiversAsUser(intent, flags, userId);
    }

    @Deprecated
    public abstract ResolveInfo resolveService(Intent var1, int var2);

    public ResolveInfo resolveService(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("resolveService not implemented in subclass");
    }

    @Deprecated
    public abstract ResolveInfo resolveServiceAsUser(Intent var1, int var2, int var3);

    public ResolveInfo resolveServiceAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("resolveServiceAsUser not implemented in subclass");
    }

    @Deprecated
    public abstract List<ResolveInfo> queryIntentServices(Intent var1, int var2);

    public List<ResolveInfo> queryIntentServices(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("queryIntentServices not implemented in subclass");
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract List<ResolveInfo> queryIntentServicesAsUser(Intent var1, int var2, int var3);

    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("queryIntentServicesAsUser not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, UserHandle user) {
        return this.queryIntentServicesAsUser(intent, flags, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, ResolveInfoFlags flags, UserHandle user) {
        return this.queryIntentServicesAsUser(intent, flags, user.getIdentifier());
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract List<ResolveInfo> queryIntentContentProvidersAsUser(Intent var1, int var2, int var3);

    protected List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, ResolveInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("queryIntentContentProvidersAsUser not implemented in subclass");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, UserHandle user) {
        return this.queryIntentContentProvidersAsUser(intent, flags, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, ResolveInfoFlags flags, UserHandle user) {
        return this.queryIntentContentProvidersAsUser(intent, flags, user.getIdentifier());
    }

    @Deprecated
    public abstract List<ResolveInfo> queryIntentContentProviders(Intent var1, int var2);

    public List<ResolveInfo> queryIntentContentProviders(Intent intent, ResolveInfoFlags flags) {
        throw new UnsupportedOperationException("queryIntentContentProviders not implemented in subclass");
    }

    @Deprecated
    public abstract ProviderInfo resolveContentProvider(String var1, int var2);

    public ProviderInfo resolveContentProvider(String authority, ComponentInfoFlags flags) {
        throw new UnsupportedOperationException("resolveContentProvider not implemented in subclass");
    }

    @UnsupportedAppUsage
    public abstract ProviderInfo resolveContentProviderAsUser(String var1, int var2, int var3);

    public ProviderInfo resolveContentProviderAsUser(String providerName, ComponentInfoFlags flags, int userId) {
        throw new UnsupportedOperationException("resolveContentProviderAsUser not implemented in subclass");
    }

    @Deprecated
    public abstract List<ProviderInfo> queryContentProviders(String var1, int var2, int var3);

    public List<ProviderInfo> queryContentProviders(String processName, int uid, ComponentInfoFlags flags) {
        throw new UnsupportedOperationException("queryContentProviders not implemented in subclass");
    }

    @Deprecated
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags, String metaDataKey) {
        return this.queryContentProviders(processName, uid, flags);
    }

    public List<ProviderInfo> queryContentProviders(String processName, int uid, ComponentInfoFlags flags, String metaDataKey) {
        return this.queryContentProviders(processName, uid, flags);
    }

    public abstract InstrumentationInfo getInstrumentationInfo(ComponentName var1, int var2) throws NameNotFoundException;

    public abstract List<InstrumentationInfo> queryInstrumentation(String var1, int var2);

    public abstract Drawable getDrawable(String var1, int var2, ApplicationInfo var3);

    public abstract Drawable getActivityIcon(ComponentName var1) throws NameNotFoundException;

    public abstract Drawable getActivityIcon(Intent var1) throws NameNotFoundException;

    public abstract Drawable getActivityBanner(ComponentName var1) throws NameNotFoundException;

    public abstract Drawable getActivityBanner(Intent var1) throws NameNotFoundException;

    public abstract Drawable getDefaultActivityIcon();

    public abstract Drawable getApplicationIcon(ApplicationInfo var1);

    public abstract Drawable getApplicationIcon(String var1) throws NameNotFoundException;

    public abstract Drawable getApplicationBanner(ApplicationInfo var1);

    public abstract Drawable getApplicationBanner(String var1) throws NameNotFoundException;

    public abstract Drawable getActivityLogo(ComponentName var1) throws NameNotFoundException;

    public abstract Drawable getActivityLogo(Intent var1) throws NameNotFoundException;

    public abstract Drawable getApplicationLogo(ApplicationInfo var1);

    public abstract Drawable getApplicationLogo(String var1) throws NameNotFoundException;

    public abstract Drawable getUserBadgedIcon(Drawable var1, UserHandle var2);

    public abstract Drawable getUserBadgedDrawableForDensity(Drawable var1, UserHandle var2, Rect var3, int var4);

    @UnsupportedAppUsage
    public abstract Drawable getUserBadgeForDensity(UserHandle var1, int var2);

    @UnsupportedAppUsage
    public abstract Drawable getUserBadgeForDensityNoBackground(UserHandle var1, int var2);

    public abstract CharSequence getUserBadgedLabel(CharSequence var1, UserHandle var2);

    public abstract CharSequence getText(String var1, int var2, ApplicationInfo var3);

    public abstract XmlResourceParser getXml(String var1, int var2, ApplicationInfo var3);

    public abstract CharSequence getApplicationLabel(ApplicationInfo var1);

    public abstract Resources getResourcesForActivity(ComponentName var1) throws NameNotFoundException;

    public abstract Resources getResourcesForApplication(ApplicationInfo var1) throws NameNotFoundException;

    public Resources getResourcesForApplication(ApplicationInfo app, Configuration configuration) throws NameNotFoundException {
        return this.getResourcesForApplication(app);
    }

    public abstract Resources getResourcesForApplication(String var1) throws NameNotFoundException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170928809L, publicAlternatives="Use {@code Context#createContextAsUser(UserHandle, int)} to create the relevant user context, {@link android.content.Context#getPackageManager()} and {@link android.content.pm.PackageManager#getResourcesForApplication(java.lang.String)} instead.")
    public abstract Resources getResourcesForApplicationAsUser(String var1, int var2) throws NameNotFoundException;

    @Deprecated
    public PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        return this.getPackageArchiveInfo(archiveFilePath, PackageInfoFlags.of(flags));
    }

    public PackageInfo getPackageArchiveInfo(String archiveFilePath, PackageInfoFlags flags) {
        long flagsBits = flags.getValue();
        PackageParser parser = new PackageParser();
        parser.setCallback(new PackageParser.CallbackImpl(this));
        File apkFile = new File(archiveFilePath);
        try {
            if ((flagsBits & 0xC0000L) == 0L) {
                flagsBits |= 0xC0000L;
            }
            PackageParser.Package pkg = parser.parsePackage(apkFile, 0, false);
            if ((flagsBits & 0x40L) != 0L) {
                PackageParser.collectCertificates(pkg, false);
            }
            return PackageParser.generatePackageInfo(pkg, null, (int)flagsBits, 0L, 0L, null, FrameworkPackageUserState.DEFAULT);
        }
        catch (PackageParser.PackageParserException e) {
            Log.w(TAG, "Failure to parse package archive", e);
            return null;
        }
    }

    @Deprecated
    @SystemApi
    public abstract int installExistingPackage(String var1) throws NameNotFoundException;

    @Deprecated
    @SystemApi
    public abstract int installExistingPackage(String var1, int var2) throws NameNotFoundException;

    @Deprecated
    @RequiresPermission(anyOf={"com.android.permission.INSTALL_EXISTING_PACKAGES", "android.permission.INSTALL_PACKAGES", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @UnsupportedAppUsage
    public abstract int installExistingPackageAsUser(String var1, int var2) throws NameNotFoundException;

    public abstract void verifyPendingInstall(int var1, int var2);

    public abstract void extendVerificationTimeout(int var1, int var2, long var3);

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTENT_FILTER_VERIFICATION_AGENT")
    public abstract void verifyIntentFilter(int var1, int var2, List<String> var3);

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public abstract int getIntentVerificationStatusAsUser(String var1, int var2);

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.SET_PREFERRED_APPLICATIONS")
    public abstract boolean updateIntentVerificationStatusAsUser(String var1, int var2, int var3);

    @Deprecated
    @SystemApi
    public abstract List<IntentFilterVerificationInfo> getIntentFilterVerifications(String var1);

    @SystemApi
    public abstract List<IntentFilter> getAllIntentFilters(String var1);

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public abstract String getDefaultBrowserPackageNameAsUser(int var1);

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SET_PREFERRED_APPLICATIONS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public abstract boolean setDefaultBrowserPackageNameAsUser(String var1, int var2);

    public abstract void setInstallerPackageName(String var1, String var2);

    @SystemApi
    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    public abstract void setUpdateAvailable(String var1, boolean var2);

    @RequiresPermission(value="android.permission.DELETE_PACKAGES")
    @UnsupportedAppUsage
    public abstract void deletePackage(String var1, IPackageDeleteObserver var2, int var3);

    @RequiresPermission(anyOf={"android.permission.DELETE_PACKAGES", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @UnsupportedAppUsage
    public abstract void deletePackageAsUser(String var1, IPackageDeleteObserver var2, int var3, int var4);

    @Deprecated
    public abstract String getInstallerPackageName(String var1);

    public InstallSourceInfo getInstallSourceInfo(String packageName) throws NameNotFoundException {
        throw new UnsupportedOperationException("getInstallSourceInfo not implemented");
    }

    @UnsupportedAppUsage
    public abstract void clearApplicationUserData(String var1, IPackageDataObserver var2);

    @UnsupportedAppUsage
    public abstract void deleteApplicationCacheFiles(String var1, IPackageDataObserver var2);

    @UnsupportedAppUsage
    public abstract void deleteApplicationCacheFilesAsUser(String var1, int var2, IPackageDataObserver var3);

    @UnsupportedAppUsage
    public void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
        this.freeStorageAndNotify(null, freeStorageSize, observer);
    }

    @UnsupportedAppUsage
    public abstract void freeStorageAndNotify(String var1, long var2, IPackageDataObserver var4);

    @UnsupportedAppUsage
    public void freeStorage(long freeStorageSize, IntentSender pi) {
        this.freeStorage(null, freeStorageSize, pi);
    }

    @UnsupportedAppUsage
    public abstract void freeStorage(String var1, long var2, IntentSender var4);

    @Deprecated
    @UnsupportedAppUsage
    public abstract void getPackageSizeInfoAsUser(String var1, int var2, IPackageStatsObserver var3);

    @Deprecated
    @UnsupportedAppUsage
    public void getPackageSizeInfo(String packageName, IPackageStatsObserver observer) {
        this.getPackageSizeInfoAsUser(packageName, this.getUserId(), observer);
    }

    @Deprecated
    public abstract void addPackageToPreferred(String var1);

    @Deprecated
    public abstract void removePackageFromPreferred(String var1);

    @Deprecated
    public abstract List<PackageInfo> getPreferredPackages(int var1);

    @Deprecated
    public abstract void addPreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4);

    @Deprecated
    @UnsupportedAppUsage
    public void addPreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Deprecated
    @UnsupportedAppUsage
    public abstract void replacePreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4);

    @SystemApi
    public void replacePreferredActivity(IntentFilter filter, int match, List<ComponentName> set, ComponentName activity) {
        this.replacePreferredActivity(filter, match, set.toArray(new ComponentName[0]), activity);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void replacePreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Deprecated
    public abstract void clearPackagePreferredActivities(String var1);

    public void addUniquePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        throw new UnsupportedOperationException("addUniquePreferredActivity not implemented in subclass");
    }

    @Deprecated
    public abstract int getPreferredActivities(List<IntentFilter> var1, List<ComponentName> var2, String var3);

    @UnsupportedAppUsage
    public abstract ComponentName getHomeActivities(List<ResolveInfo> var1);

    @RequiresPermission(value="android.permission.CHANGE_COMPONENT_ENABLED_STATE", conditional=true)
    public abstract void setComponentEnabledSetting(ComponentName var1, int var2, int var3);

    @RequiresPermission(value="android.permission.CHANGE_COMPONENT_ENABLED_STATE", conditional=true)
    public void setComponentEnabledSettings(List<ComponentEnabledSetting> settings) {
        throw new UnsupportedOperationException("setComponentEnabledSettings not implementedin subclass");
    }

    public abstract int getComponentEnabledSetting(ComponentName var1);

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_COMPONENT_ENABLED_STATE", conditional=true)
    public void setSyntheticAppDetailsActivityEnabled(String packageName, boolean enabled) {
        throw new UnsupportedOperationException("setSyntheticAppDetailsActivityEnabled not implemented");
    }

    public boolean getSyntheticAppDetailsActivityEnabled(String packageName) {
        throw new UnsupportedOperationException("getSyntheticAppDetailsActivityEnabled not implemented");
    }

    @RequiresPermission(value="android.permission.CHANGE_COMPONENT_ENABLED_STATE", conditional=true)
    public abstract void setApplicationEnabledSetting(String var1, int var2, int var3);

    public abstract int getApplicationEnabledSetting(String var1);

    @UnsupportedAppUsage
    public abstract void flushPackageRestrictionsAsUser(int var1);

    @UnsupportedAppUsage
    public abstract boolean setApplicationHiddenSettingAsUser(String var1, boolean var2, UserHandle var3);

    @UnsupportedAppUsage
    public abstract boolean getApplicationHiddenSettingAsUser(String var1, UserHandle var2);

    @SystemApi
    public void setSystemAppState(String packageName, int state) {
        throw new RuntimeException("Not implemented. Must override in a subclass");
    }

    public abstract boolean isSafeMode();

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public abstract void addOnPermissionsChangeListener(OnPermissionsChangedListener var1);

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public abstract void removeOnPermissionsChangeListener(OnPermissionsChangedListener var1);

    @UnsupportedAppUsage
    public abstract KeySet getKeySetByAlias(String var1, String var2);

    @UnsupportedAppUsage
    public abstract KeySet getSigningKeySet(String var1);

    @UnsupportedAppUsage
    public abstract boolean isSignedBy(String var1, KeySet var2);

    @UnsupportedAppUsage
    public abstract boolean isSignedByExactly(String var1, KeySet var2);

    @SystemApi
    @RequiresPermission(value="android.permission.SUSPEND_APPS")
    public String[] setDistractingPackageRestrictions(String[] packages, int restrictionFlags) {
        throw new UnsupportedOperationException("setDistractingPackageRestrictions not implemented");
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.SUSPEND_APPS")
    public String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        throw new UnsupportedOperationException("setPackagesSuspended not implemented");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SUSPEND_APPS")
    public String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo) {
        throw new UnsupportedOperationException("setPackagesSuspended not implemented");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SUSPEND_APPS")
    public String[] getUnsuspendablePackages(String[] packageNames) {
        throw new UnsupportedOperationException("getUnsuspendablePackages not implemented");
    }

    @UnsupportedAppUsage
    public abstract boolean isPackageSuspendedForUser(String var1, int var2);

    public boolean isPackageSuspended(String packageName) throws NameNotFoundException {
        throw new UnsupportedOperationException("isPackageSuspended not implemented");
    }

    public boolean isPackageSuspended() {
        throw new UnsupportedOperationException("isPackageSuspended not implemented");
    }

    public Bundle getSuspendedPackageAppExtras() {
        throw new UnsupportedOperationException("getSuspendedPackageAppExtras not implemented");
    }

    public abstract void setApplicationCategoryHint(String var1, int var2);

    public static boolean isMoveStatusFinished(int status) {
        return status < 0 || status > 100;
    }

    @UnsupportedAppUsage
    public abstract int getMoveStatus(int var1);

    @UnsupportedAppUsage
    public abstract void registerMoveCallback(MoveCallback var1, Handler var2);

    @UnsupportedAppUsage
    public abstract void unregisterMoveCallback(MoveCallback var1);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract int movePackage(String var1, VolumeInfo var2);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract VolumeInfo getPackageCurrentVolume(ApplicationInfo var1);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo var1);

    public abstract int movePrimaryStorage(VolumeInfo var1);

    public abstract VolumeInfo getPrimaryStorageCurrentVolume();

    public abstract List<VolumeInfo> getPrimaryStorageCandidateVolumes();

    public abstract VerifierDeviceIdentity getVerifierDeviceIdentity();

    @UnsupportedAppUsage
    public abstract boolean isUpgrade();

    public boolean isDeviceUpgrading() {
        return false;
    }

    public abstract PackageInstaller getPackageInstaller();

    @UnsupportedAppUsage
    public abstract void addCrossProfileIntentFilter(IntentFilter var1, int var2, int var3, int var4);

    @UnsupportedAppUsage
    public abstract void clearCrossProfileIntentFilters(int var1);

    @UnsupportedAppUsage
    public abstract Drawable loadItemIcon(PackageItemInfo var1, ApplicationInfo var2);

    @UnsupportedAppUsage
    public abstract Drawable loadUnbadgedItemIcon(PackageItemInfo var1, ApplicationInfo var2);

    @UnsupportedAppUsage
    public abstract boolean isPackageAvailable(String var1);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String installStatusToString(int status, String msg) {
        String str = PackageManager.installStatusToString(status);
        if (msg != null) {
            return str + ": " + msg;
        }
        return str;
    }

    @UnsupportedAppUsage
    public static String installStatusToString(int status) {
        switch (status) {
            case 1: {
                return "INSTALL_SUCCEEDED";
            }
            case -1: {
                return "INSTALL_FAILED_ALREADY_EXISTS";
            }
            case -2: {
                return "INSTALL_FAILED_INVALID_APK";
            }
            case -3: {
                return "INSTALL_FAILED_INVALID_URI";
            }
            case -4: {
                return "INSTALL_FAILED_INSUFFICIENT_STORAGE";
            }
            case -5: {
                return "INSTALL_FAILED_DUPLICATE_PACKAGE";
            }
            case -6: {
                return "INSTALL_FAILED_NO_SHARED_USER";
            }
            case -7: {
                return "INSTALL_FAILED_UPDATE_INCOMPATIBLE";
            }
            case -8: {
                return "INSTALL_FAILED_SHARED_USER_INCOMPATIBLE";
            }
            case -9: {
                return "INSTALL_FAILED_MISSING_SHARED_LIBRARY";
            }
            case -10: {
                return "INSTALL_FAILED_REPLACE_COULDNT_DELETE";
            }
            case -11: {
                return "INSTALL_FAILED_DEXOPT";
            }
            case -12: {
                return "INSTALL_FAILED_OLDER_SDK";
            }
            case -13: {
                return "INSTALL_FAILED_CONFLICTING_PROVIDER";
            }
            case -14: {
                return "INSTALL_FAILED_NEWER_SDK";
            }
            case -15: {
                return "INSTALL_FAILED_TEST_ONLY";
            }
            case -16: {
                return "INSTALL_FAILED_CPU_ABI_INCOMPATIBLE";
            }
            case -17: {
                return "INSTALL_FAILED_MISSING_FEATURE";
            }
            case -18: {
                return "INSTALL_FAILED_CONTAINER_ERROR";
            }
            case -19: {
                return "INSTALL_FAILED_INVALID_INSTALL_LOCATION";
            }
            case -20: {
                return "INSTALL_FAILED_MEDIA_UNAVAILABLE";
            }
            case -21: {
                return "INSTALL_FAILED_VERIFICATION_TIMEOUT";
            }
            case -22: {
                return "INSTALL_FAILED_VERIFICATION_FAILURE";
            }
            case -23: {
                return "INSTALL_FAILED_PACKAGE_CHANGED";
            }
            case -24: {
                return "INSTALL_FAILED_UID_CHANGED";
            }
            case -25: {
                return "INSTALL_FAILED_VERSION_DOWNGRADE";
            }
            case -100: {
                return "INSTALL_PARSE_FAILED_NOT_APK";
            }
            case -101: {
                return "INSTALL_PARSE_FAILED_BAD_MANIFEST";
            }
            case -102: {
                return "INSTALL_PARSE_FAILED_UNEXPECTED_EXCEPTION";
            }
            case -103: {
                return "INSTALL_PARSE_FAILED_NO_CERTIFICATES";
            }
            case -104: {
                return "INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES";
            }
            case -105: {
                return "INSTALL_PARSE_FAILED_CERTIFICATE_ENCODING";
            }
            case -106: {
                return "INSTALL_PARSE_FAILED_BAD_PACKAGE_NAME";
            }
            case -107: {
                return "INSTALL_PARSE_FAILED_BAD_SHARED_USER_ID";
            }
            case -108: {
                return "INSTALL_PARSE_FAILED_MANIFEST_MALFORMED";
            }
            case -109: {
                return "INSTALL_PARSE_FAILED_MANIFEST_EMPTY";
            }
            case -110: {
                return "INSTALL_FAILED_INTERNAL_ERROR";
            }
            case -111: {
                return "INSTALL_FAILED_USER_RESTRICTED";
            }
            case -112: {
                return "INSTALL_FAILED_DUPLICATE_PERMISSION";
            }
            case -113: {
                return "INSTALL_FAILED_NO_MATCHING_ABIS";
            }
            case -115: {
                return "INSTALL_FAILED_ABORTED";
            }
            case -117: {
                return "INSTALL_FAILED_BAD_DEX_METADATA";
            }
            case -28: {
                return "INSTALL_FAILED_MISSING_SPLIT";
            }
            case -118: {
                return "INSTALL_FAILED_BAD_SIGNATURE";
            }
            case -121: {
                return "INSTALL_FAILED_WRONG_INSTALLED_VERSION";
            }
            case -122: {
                return "INSTALL_FAILED_PROCESS_NOT_DEFINED";
            }
            case -116: {
                return "INSTALL_FAILED_SESSION_INVALID";
            }
        }
        return Integer.toString(status);
    }

    public static int installStatusToPublicStatus(int status) {
        switch (status) {
            case 1: {
                return 0;
            }
            case -1: {
                return 5;
            }
            case -2: {
                return 4;
            }
            case -3: {
                return 4;
            }
            case -4: {
                return 6;
            }
            case -5: {
                return 5;
            }
            case -6: {
                return 5;
            }
            case -7: {
                return 5;
            }
            case -8: {
                return 5;
            }
            case -9: {
                return 7;
            }
            case -10: {
                return 5;
            }
            case -11: {
                return 4;
            }
            case -12: {
                return 7;
            }
            case -13: {
                return 5;
            }
            case -14: {
                return 7;
            }
            case -15: {
                return 4;
            }
            case -16: {
                return 7;
            }
            case -17: {
                return 7;
            }
            case -18: {
                return 6;
            }
            case -19: {
                return 6;
            }
            case -20: {
                return 6;
            }
            case -21: {
                return 3;
            }
            case -22: {
                return 3;
            }
            case -23: {
                return 4;
            }
            case -24: {
                return 4;
            }
            case -25: {
                return 4;
            }
            case -26: {
                return 4;
            }
            case -100: {
                return 4;
            }
            case -101: {
                return 4;
            }
            case -102: {
                return 4;
            }
            case -103: {
                return 4;
            }
            case -104: {
                return 4;
            }
            case -105: {
                return 4;
            }
            case -106: {
                return 4;
            }
            case -107: {
                return 4;
            }
            case -108: {
                return 4;
            }
            case -109: {
                return 4;
            }
            case -117: {
                return 4;
            }
            case -118: {
                return 4;
            }
            case -110: {
                return 1;
            }
            case -111: {
                return 7;
            }
            case -112: {
                return 5;
            }
            case -113: {
                return 7;
            }
            case -115: {
                return 3;
            }
            case -28: {
                return 7;
            }
        }
        return 1;
    }

    public static String deleteStatusToString(int status, String msg) {
        String str = PackageManager.deleteStatusToString(status);
        if (msg != null) {
            return str + ": " + msg;
        }
        return str;
    }

    @UnsupportedAppUsage
    public static String deleteStatusToString(int status) {
        switch (status) {
            case 1: {
                return "DELETE_SUCCEEDED";
            }
            case -1: {
                return "DELETE_FAILED_INTERNAL_ERROR";
            }
            case -2: {
                return "DELETE_FAILED_DEVICE_POLICY_MANAGER";
            }
            case -3: {
                return "DELETE_FAILED_USER_RESTRICTED";
            }
            case -4: {
                return "DELETE_FAILED_OWNER_BLOCKED";
            }
            case -5: {
                return "DELETE_FAILED_ABORTED";
            }
            case -6: {
                return "DELETE_FAILED_USED_SHARED_LIBRARY";
            }
            case -7: {
                return "DELETE_FAILED_APP_PINNED";
            }
        }
        return Integer.toString(status);
    }

    public static int deleteStatusToPublicStatus(int status) {
        switch (status) {
            case 1: {
                return 0;
            }
            case -1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case -3: {
                return 2;
            }
            case -4: {
                return 2;
            }
            case -5: {
                return 3;
            }
            case -6: {
                return 5;
            }
            case -7: {
                return 2;
            }
        }
        return 1;
    }

    public static String permissionFlagToString(int flag) {
        switch (flag) {
            case 32: {
                return "GRANTED_BY_DEFAULT";
            }
            case 4: {
                return "POLICY_FIXED";
            }
            case 16: {
                return "SYSTEM_FIXED";
            }
            case 1: {
                return "USER_SET";
            }
            case 2: {
                return "USER_FIXED";
            }
            case 64: {
                return "REVIEW_REQUIRED";
            }
            case 128: {
                return "REVOKE_WHEN_REQUESTED";
            }
            case 256: {
                return "USER_SENSITIVE_WHEN_GRANTED";
            }
            case 512: {
                return "USER_SENSITIVE_WHEN_DENIED";
            }
            case 2048: {
                return "RESTRICTION_INSTALLER_EXEMPT";
            }
            case 4096: {
                return "RESTRICTION_SYSTEM_EXEMPT";
            }
            case 8192: {
                return "RESTRICTION_UPGRADE_EXEMPT";
            }
            case 16384: {
                return "APPLY_RESTRICTION";
            }
            case 32768: {
                return "GRANTED_BY_ROLE";
            }
            case 8: {
                return "REVOKED_COMPAT";
            }
            case 65536: {
                return "ONE_TIME";
            }
            case 131072: {
                return "AUTO_REVOKED";
            }
        }
        return Integer.toString(flag);
    }

    public abstract int getInstallReason(String var1, UserHandle var2);

    public abstract boolean canRequestPackageInstalls();

    @SystemApi
    public abstract ComponentName getInstantAppResolverSettingsComponent();

    @SystemApi
    public abstract ComponentName getInstantAppInstallerComponent();

    public abstract String getInstantAppAndroidId(String var1, UserHandle var2);

    @SystemApi
    public abstract void registerDexModule(String var1, DexModuleRegisterCallback var2);

    @SystemApi
    public ArtManager getArtManager() {
        throw new UnsupportedOperationException("getArtManager not implemented in subclass");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_HARMFUL_APP_WARNINGS")
    public void setHarmfulAppWarning(String packageName, CharSequence warning) {
        throw new UnsupportedOperationException("setHarmfulAppWarning not implemented in subclass");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_HARMFUL_APP_WARNINGS")
    public CharSequence getHarmfulAppWarning(String packageName) {
        throw new UnsupportedOperationException("getHarmfulAppWarning not implemented in subclass");
    }

    public boolean hasSigningCertificate(String packageName, byte[] certificate, int type) {
        throw new UnsupportedOperationException("hasSigningCertificate not implemented in subclass");
    }

    public boolean hasSigningCertificate(int uid, byte[] certificate, int type) {
        throw new UnsupportedOperationException("hasSigningCertificate not implemented in subclass");
    }

    public void requestChecksums(String packageName, boolean includeSplits, int required, List<Certificate> trustedInstallers, OnChecksumsReadyListener onChecksumsReadyListener) throws CertificateEncodingException, NameNotFoundException {
        throw new UnsupportedOperationException("requestChecksums not implemented in subclass");
    }

    public String getDefaultTextClassifierPackageName() {
        throw new UnsupportedOperationException("getDefaultTextClassifierPackageName not implemented in subclass");
    }

    public String getSystemTextClassifierPackageName() {
        throw new UnsupportedOperationException("getSystemTextClassifierPackageName not implemented in subclass");
    }

    public String getAttentionServicePackageName() {
        throw new UnsupportedOperationException("getAttentionServicePackageName not implemented in subclass");
    }

    public String getRotationResolverPackageName() {
        throw new UnsupportedOperationException("getRotationResolverPackageName not implemented in subclass");
    }

    public String getWellbeingPackageName() {
        throw new UnsupportedOperationException("getWellbeingPackageName not implemented in subclass");
    }

    public String getAppPredictionServicePackageName() {
        throw new UnsupportedOperationException("getAppPredictionServicePackageName not implemented in subclass");
    }

    public String getSystemCaptionsServicePackageName() {
        throw new UnsupportedOperationException("getSystemCaptionsServicePackageName not implemented in subclass");
    }

    public String getSetupWizardPackageName() {
        throw new UnsupportedOperationException("getSetupWizardPackageName not implemented in subclass");
    }

    public String getContentCaptureServicePackageName() {
        throw new UnsupportedOperationException("getContentCaptureServicePackageName not implemented in subclass");
    }

    @SystemApi
    public String getIncidentReportApproverPackageName() {
        throw new UnsupportedOperationException("getIncidentReportApproverPackageName not implemented in subclass");
    }

    public boolean isPackageStateProtected(String packageName, int userId) {
        throw new UnsupportedOperationException("isPackageStateProtected not implemented in subclass");
    }

    @SystemApi
    public void sendDeviceCustomizationReadyBroadcast() {
        throw new UnsupportedOperationException("sendDeviceCustomizationReadyBroadcast not implemented in subclass");
    }

    public boolean isAutoRevokeWhitelisted() {
        throw new UnsupportedOperationException("isAutoRevokeWhitelisted not implemented in subclass");
    }

    public boolean isDefaultApplicationIcon(Drawable drawable2) {
        int resId = drawable2 instanceof AdaptiveIconDrawable ? ((AdaptiveIconDrawable)drawable2).getSourceDrawableResId() : 0;
        return resId == 17301651 || resId == 17303687;
    }

    public void setMimeGroup(String mimeGroup, Set<String> mimeTypes) {
        throw new UnsupportedOperationException("setMimeGroup not implemented in subclass");
    }

    public Set<String> getMimeGroup(String mimeGroup) {
        throw new UnsupportedOperationException("getMimeGroup not implemented in subclass");
    }

    public Property getProperty(String propertyName, String packageName) throws NameNotFoundException {
        throw new UnsupportedOperationException("getProperty not implemented in subclass");
    }

    public Property getProperty(String propertyName, ComponentName component) throws NameNotFoundException {
        throw new UnsupportedOperationException("getProperty not implemented in subclass");
    }

    public List<Property> queryApplicationProperty(String propertyName) {
        throw new UnsupportedOperationException("qeuryApplicationProperty not implemented in subclass");
    }

    public List<Property> queryActivityProperty(String propertyName) {
        throw new UnsupportedOperationException("qeuryActivityProperty not implemented in subclass");
    }

    public List<Property> queryProviderProperty(String propertyName) {
        throw new UnsupportedOperationException("qeuryProviderProperty not implemented in subclass");
    }

    public List<Property> queryReceiverProperty(String propertyName) {
        throw new UnsupportedOperationException("qeuryReceiverProperty not implemented in subclass");
    }

    public List<Property> queryServiceProperty(String propertyName) {
        throw new UnsupportedOperationException("qeuryServiceProperty not implemented in subclass");
    }

    public boolean canPackageQuery(String sourcePackageName, String targetPackageName) throws NameNotFoundException {
        throw new UnsupportedOperationException("canPackageQuery not implemented in subclass");
    }

    public void makeProviderVisible(int recipientUid, String visibleAuthority) {
        try {
            ActivityThread.getPackageManager().makeProviderVisible(recipientUid, visibleAuthority);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MAKE_UID_VISIBLE")
    public void makeUidVisible(int recipientUid, int visibleUid) {
        throw new UnsupportedOperationException("makeUidVisible not implemented in subclass");
    }

    private static ApplicationInfo getApplicationInfoAsUserUncached(String packageName, long flags, int userId) {
        try {
            return ActivityThread.getPackageManager().getApplicationInfo(packageName, flags, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static ApplicationInfo getApplicationInfoAsUserCached(String packageName, long flags, int userId) {
        return sApplicationInfoCache.query(new ApplicationInfoQuery(packageName, flags, userId));
    }

    public static void disableApplicationInfoCache() {
        sApplicationInfoCache.disableLocal();
    }

    public static void invalidatePackageInfoCache() {
        sCacheAutoCorker.autoCork();
    }

    private static PackageInfo getPackageInfoAsUserUncached(String packageName, long flags, int userId) {
        try {
            return ActivityThread.getPackageManager().getPackageInfo(packageName, flags, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static PackageInfo getPackageInfoAsUserCached(String packageName, long flags, int userId) {
        return sPackageInfoCache.query(new PackageInfoQuery(packageName, flags, userId));
    }

    public static void disablePackageInfoCache() {
        sPackageInfoCache.disableLocal();
    }

    public static void corkPackageInfoCache() {
        PropertyInvalidatedCache.corkInvalidations("cache_key.package_info");
    }

    public static void uncorkPackageInfoCache() {
        PropertyInvalidatedCache.uncorkInvalidations("cache_key.package_info");
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    public IBinder getHoldLockToken() {
        try {
            return ActivityThread.getPackageManager().getHoldLockToken();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void holdLock(IBinder token, int durationMs) {
        try {
            ActivityThread.getPackageManager().holdLock(token, durationMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.KEEP_UNINSTALLED_PACKAGES")
    public void setKeepUninstalledPackages(List<String> packageList) {
        try {
            ActivityThread.getPackageManager().setKeepUninstalledPackages(packageList);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class PackageInfoQuery {
        final String packageName;
        final long flags;
        final int userId;

        PackageInfoQuery(String packageName, long flags, int userId) {
            this.packageName = packageName;
            this.flags = flags;
            this.userId = userId;
        }

        public String toString() {
            return String.format("PackageInfoQuery(packageName=\"%s\", flags=%s, userId=%s)", this.packageName, this.flags, this.userId);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.packageName);
            hash = hash * 13 + Objects.hashCode(this.flags);
            hash = hash * 13 + Objects.hashCode(this.userId);
            return hash;
        }

        public boolean equals(Object rval) {
            PackageInfoQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PackageInfoQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return Objects.equals(this.packageName, other.packageName) && this.flags == other.flags && this.userId == other.userId;
        }
    }

    private static class ApplicationInfoQuery {
        final String packageName;
        final long flags;
        final int userId;

        ApplicationInfoQuery(String packageName, long flags, int userId) {
            this.packageName = packageName;
            this.flags = flags;
            this.userId = userId;
        }

        public String toString() {
            return String.format("ApplicationInfoQuery(packageName=\"%s\", flags=%s, userId=%s)", this.packageName, this.flags, this.userId);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.packageName);
            hash = hash * 13 + Objects.hashCode(this.flags);
            hash = hash * 13 + Objects.hashCode(this.userId);
            return hash;
        }

        public boolean equals(Object rval) {
            ApplicationInfoQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (ApplicationInfoQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return Objects.equals(this.packageName, other.packageName) && this.flags == other.flags && this.userId == other.userId;
        }
    }

    @FunctionalInterface
    public static interface OnChecksumsReadyListener {
        public void onChecksumsReady(List<ApkChecksum> var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CertificateInputType {
    }

    @SystemApi
    public static abstract class DexModuleRegisterCallback {
        public abstract void onDexModuleRegistered(String var1, boolean var2, String var3);
    }

    public static class LegacyPackageDeleteObserver
    extends PackageDeleteObserver {
        private final IPackageDeleteObserver mLegacy;

        public LegacyPackageDeleteObserver(IPackageDeleteObserver legacy) {
            this.mLegacy = legacy;
        }

        @Override
        public void onPackageDeleted(String basePackageName, int returnCode, String msg) {
            if (this.mLegacy == null) {
                return;
            }
            try {
                this.mLegacy.packageDeleted(basePackageName, returnCode);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public static abstract class MoveCallback {
        public void onCreated(int moveId, Bundle extras) {
        }

        public abstract void onStatusChanged(int var1, int var2, long var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DistractionRestriction {
    }

    @SystemApi
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionFlags {
    }

    public static class ResolveInfoFlags
    extends Flags {
        private ResolveInfoFlags(long value) {
            super(value);
        }

        public static ResolveInfoFlags of(long value) {
            return new ResolveInfoFlags(value);
        }
    }

    public static class ComponentInfoFlags
    extends Flags {
        private ComponentInfoFlags(long value) {
            super(value);
        }

        public static ComponentInfoFlags of(long value) {
            return new ComponentInfoFlags(value);
        }
    }

    public static class ApplicationInfoFlags
    extends Flags {
        private ApplicationInfoFlags(long value) {
            super(value);
        }

        public static ApplicationInfoFlags of(long value) {
            return new ApplicationInfoFlags(value);
        }
    }

    public static class PackageInfoFlags
    extends Flags {
        private PackageInfoFlags(long value) {
            super(value);
        }

        public static PackageInfoFlags of(long value) {
            return new PackageInfoFlags(value);
        }
    }

    public static class Flags {
        final long mValue;

        protected Flags(long value) {
            this.mValue = value;
        }

        public long getValue() {
            return this.mValue;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemAppState {
    }

    public static @interface NotifyReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionWhitelistFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeleteFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UninstallReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstallScenario {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstallReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnabledFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstallFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RollbackDataPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnabledState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SignatureResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModuleInfoFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstrumentationInfoFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionGroupInfoFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionInfoFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstalledModulesFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolveInfoFlagsBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ComponentInfoFlagsBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplicationInfoFlagsBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PackageInfoFlagsBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PropertyLocation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ComponentType {
    }

    @SystemApi
    public static interface OnPermissionsChangedListener {
        public void onPermissionsChanged(int var1);
    }

    public static class ComponentEnabledSetting
    implements Parcelable {
        private final String mPackageName;
        private final ComponentName mComponentName;
        private final int mEnabledState;
        private final int mEnabledFlags;
        public static final Parcelable.Creator<ComponentEnabledSetting> CREATOR = new Parcelable.Creator<ComponentEnabledSetting>(){

            public ComponentEnabledSetting[] newArray(int size) {
                return new ComponentEnabledSetting[size];
            }

            @Override
            public ComponentEnabledSetting createFromParcel(Parcel in) {
                return new ComponentEnabledSetting(in);
            }
        };

        public ComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
            Objects.nonNull(componentName);
            this.mPackageName = null;
            this.mComponentName = componentName;
            this.mEnabledState = newState;
            this.mEnabledFlags = flags;
        }

        public ComponentEnabledSetting(String packageName, int newState, int flags) {
            Objects.nonNull(packageName);
            this.mPackageName = packageName;
            this.mComponentName = null;
            this.mEnabledState = newState;
            this.mEnabledFlags = flags;
        }

        public String getPackageName() {
            if (this.isComponent()) {
                return this.mComponentName.getPackageName();
            }
            return this.mPackageName;
        }

        public String getClassName() {
            if (this.isComponent()) {
                return this.mComponentName.getClassName();
            }
            return null;
        }

        public boolean isComponent() {
            return this.mComponentName != null;
        }

        public ComponentName getComponentName() {
            return this.mComponentName;
        }

        public int getEnabledState() {
            return this.mEnabledState;
        }

        public int getEnabledFlags() {
            return this.mEnabledFlags;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mPackageName != null) {
                flg = (byte)(flg | 1);
            }
            if (this.mComponentName != null) {
                flg = (byte)(flg | 2);
            }
            dest.writeByte(flg);
            if (this.mPackageName != null) {
                dest.writeString(this.mPackageName);
            }
            if (this.mComponentName != null) {
                dest.writeTypedObject(this.mComponentName, flags);
            }
            dest.writeInt(this.mEnabledState);
            dest.writeInt(this.mEnabledFlags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        ComponentEnabledSetting(Parcel in) {
            byte flg = in.readByte();
            String packageName = (flg & 1) == 0 ? null : in.readString();
            ComponentName componentName = (flg & 2) == 0 ? null : in.readTypedObject(ComponentName.CREATOR);
            int enabledState = in.readInt();
            int enabledFlags = in.readInt();
            this.mPackageName = packageName;
            this.mComponentName = componentName;
            this.mEnabledState = enabledState;
            AnnotationValidations.validate(EnabledState.class, null, this.mEnabledState);
            this.mEnabledFlags = enabledFlags;
            AnnotationValidations.validate(EnabledFlags.class, null, this.mEnabledFlags);
        }

        @Deprecated
        private void __metadata() {
        }
    }

    public static class Property
    implements Parcelable {
        private static final int TYPE_BOOLEAN = 1;
        private static final int TYPE_FLOAT = 2;
        private static final int TYPE_INTEGER = 3;
        private static final int TYPE_RESOURCE = 4;
        private static final int TYPE_STRING = 5;
        private final String mName;
        private final int mType;
        private final String mClassName;
        private final String mPackageName;
        private boolean mBooleanValue;
        private float mFloatValue;
        private int mIntegerValue;
        private String mStringValue;
        public static final Parcelable.Creator<Property> CREATOR = new Parcelable.Creator<Property>(){

            @Override
            public Property createFromParcel(Parcel source) {
                String name = source.readString();
                int type = source.readInt();
                String packageName = source.readString();
                String className = source.readString();
                if (type == 1) {
                    return new Property(name, source.readBoolean(), packageName, className);
                }
                if (type == 2) {
                    return new Property(name, source.readFloat(), packageName, className);
                }
                if (type == 3) {
                    return new Property(name, source.readInt(), false, packageName, className);
                }
                if (type == 4) {
                    return new Property(name, source.readInt(), true, packageName, className);
                }
                if (type == 5) {
                    return new Property(name, source.readString(), packageName, className);
                }
                return null;
            }

            public Property[] newArray(int size) {
                return new Property[size];
            }
        };

        @VisibleForTesting
        public Property(String name, int type, String packageName, String className) {
            assert (name != null);
            assert (type >= 1 && type <= 5);
            assert (packageName != null);
            this.mName = name;
            this.mType = type;
            this.mPackageName = packageName;
            this.mClassName = className;
        }

        public Property(String name, boolean value, String packageName, String className) {
            this(name, 1, packageName, className);
            this.mBooleanValue = value;
        }

        public Property(String name, float value, String packageName, String className) {
            this(name, 2, packageName, className);
            this.mFloatValue = value;
        }

        public Property(String name, int value, boolean isResource, String packageName, String className) {
            this(name, isResource ? 4 : 3, packageName, className);
            this.mIntegerValue = value;
        }

        public Property(String name, String value, String packageName, String className) {
            this(name, 5, packageName, className);
            this.mStringValue = value;
        }

        @VisibleForTesting
        public int getType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String getClassName() {
            return this.mClassName;
        }

        public boolean getBoolean() {
            return this.mBooleanValue;
        }

        public boolean isBoolean() {
            return this.mType == 1;
        }

        public float getFloat() {
            return this.mFloatValue;
        }

        public boolean isFloat() {
            return this.mType == 2;
        }

        public int getInteger() {
            return this.mType == 3 ? this.mIntegerValue : 0;
        }

        public boolean isInteger() {
            return this.mType == 3;
        }

        public int getResourceId() {
            return this.mType == 4 ? this.mIntegerValue : 0;
        }

        public boolean isResourceId() {
            return this.mType == 4;
        }

        public String getString() {
            return this.mStringValue;
        }

        public boolean isString() {
            return this.mType == 5;
        }

        public Bundle toBundle(Bundle outBundle) {
            Bundle b;
            Bundle bundle = b = outBundle == null || outBundle == Bundle.EMPTY ? new Bundle() : outBundle;
            if (this.mType == 1) {
                b.putBoolean(this.mName, this.mBooleanValue);
            } else if (this.mType == 2) {
                b.putFloat(this.mName, this.mFloatValue);
            } else if (this.mType == 3) {
                b.putInt(this.mName, this.mIntegerValue);
            } else if (this.mType == 4) {
                b.putInt(this.mName, this.mIntegerValue);
            } else if (this.mType == 5) {
                b.putString(this.mName, this.mStringValue);
            }
            return b;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mName);
            dest.writeInt(this.mType);
            dest.writeString(this.mPackageName);
            dest.writeString(this.mClassName);
            if (this.mType == 1) {
                dest.writeBoolean(this.mBooleanValue);
            } else if (this.mType == 2) {
                dest.writeFloat(this.mFloatValue);
            } else if (this.mType == 3) {
                dest.writeInt(this.mIntegerValue);
            } else if (this.mType == 4) {
                dest.writeInt(this.mIntegerValue);
            } else if (this.mType == 5) {
                dest.writeString(this.mStringValue);
            }
        }
    }

    public static class NameNotFoundException
    extends AndroidException {
        public NameNotFoundException() {
        }

        public NameNotFoundException(String name) {
            super(name);
        }
    }
}

