/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.content.Context;
import android.content.om.IOverlayManager;
import android.content.om.OverlayIdentifier;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManagerTransaction;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import java.util.List;

@SystemApi
public class OverlayManager {
    private final IOverlayManager mService;
    private final Context mContext;
    private static final long THROW_SECURITY_EXCEPTIONS = 147340954L;

    public OverlayManager(Context context, IOverlayManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public OverlayManager(Context context) {
        this(context, IOverlayManager.Stub.asInterface(ServiceManager.getService("overlay")));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void setEnabledExclusiveInCategory(String packageName, UserHandle user) throws SecurityException, IllegalStateException {
        try {
            if (!this.mService.setEnabledExclusiveInCategory(packageName, user.getIdentifier())) {
                throw new IllegalStateException("setEnabledExclusiveInCategory failed");
            }
        }
        catch (SecurityException e) {
            this.rethrowSecurityException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void setEnabled(String packageName, boolean enable, UserHandle user) throws SecurityException, IllegalStateException {
        try {
            if (!this.mService.setEnabled(packageName, enable, user.getIdentifier())) {
                throw new IllegalStateException("setEnabled failed");
            }
        }
        catch (SecurityException e) {
            this.rethrowSecurityException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public OverlayInfo getOverlayInfo(String packageName, UserHandle userHandle) {
        try {
            return this.mService.getOverlayInfo(packageName, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public OverlayInfo getOverlayInfo(OverlayIdentifier overlay, UserHandle userHandle) {
        try {
            return this.mService.getOverlayInfoByIdentifier(overlay, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, UserHandle user) {
        try {
            return this.mService.getOverlayInfosForTarget(targetPackageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS"})
    public void invalidateCachesForOverlay(String targetPackageName, UserHandle user) {
        try {
            this.mService.invalidateCachesForOverlay(targetPackageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void commit(OverlayManagerTransaction transaction) {
        try {
            this.mService.commit(transaction);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void rethrowSecurityException(SecurityException e) {
        if (!Compatibility.isChangeEnabled(147340954L)) {
            throw new IllegalStateException(e);
        }
        throw e;
    }
}

