/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.AttributionSource;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ContextParams {
    private final String mAttributionTag;
    private final AttributionSource mNext;
    private final Set<String> mRenouncedPermissions;
    public static final ContextParams EMPTY = new Builder().build();

    private ContextParams(String attributionTag, AttributionSource next, Set<String> renouncedPermissions) {
        this.mAttributionTag = attributionTag;
        this.mNext = next;
        this.mRenouncedPermissions = renouncedPermissions != null ? renouncedPermissions : Collections.emptySet();
    }

    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
    public Set<String> getRenouncedPermissions() {
        return this.mRenouncedPermissions;
    }

    public boolean isRenouncedPermission(String permission2) {
        return this.mRenouncedPermissions.contains(permission2);
    }

    public AttributionSource getNextAttributionSource() {
        return this.mNext;
    }

    public static class Builder {
        private String mAttributionTag;
        private Set<String> mRenouncedPermissions = Collections.emptySet();
        private AttributionSource mNext;

        public Builder() {
        }

        public Builder(ContextParams params) {
            Objects.requireNonNull(params);
            this.mAttributionTag = params.mAttributionTag;
            this.mRenouncedPermissions = params.mRenouncedPermissions;
            this.mNext = params.mNext;
        }

        public Builder setAttributionTag(String attributionTag) {
            this.mAttributionTag = attributionTag;
            return this;
        }

        public Builder setNextAttributionSource(AttributionSource next) {
            this.mNext = next;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
        public Builder setRenouncedPermissions(Set<String> renouncedPermissions) {
            if (renouncedPermissions != null && !renouncedPermissions.isEmpty() && ActivityThread.currentApplication().checkSelfPermission("android.permission.RENOUNCE_PERMISSIONS") != 0) {
                throw new SecurityException("Renouncing permissions requires: android.permission.RENOUNCE_PERMISSIONS");
            }
            this.mRenouncedPermissions = renouncedPermissions;
            return this;
        }

        public ContextParams build() {
            return new ContextParams(this.mAttributionTag, this.mNext, this.mRenouncedPermissions);
        }
    }
}

