/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.view.autofill.AutofillManager;
import java.io.PrintWriter;

public class AutofillOptions
implements Parcelable {
    private static final String TAG = AutofillOptions.class.getSimpleName();
    public final int loggingLevel;
    public final boolean compatModeEnabled;
    public boolean augmentedAutofillEnabled;
    @SuppressLint(value={"NullableCollection"})
    public ArraySet<ComponentName> whitelistedActivitiesForAugmentedAutofill;
    public long appDisabledExpiration;
    @SuppressLint(value={"NullableCollection"})
    public ArrayMap<String, Long> disabledActivities;
    public static final Parcelable.Creator<AutofillOptions> CREATOR = new Parcelable.Creator<AutofillOptions>(){

        @Override
        public AutofillOptions createFromParcel(Parcel parcel) {
            int loggingLevel = parcel.readInt();
            boolean compatMode = parcel.readBoolean();
            AutofillOptions options = new AutofillOptions(loggingLevel, compatMode);
            options.augmentedAutofillEnabled = parcel.readBoolean();
            options.whitelistedActivitiesForAugmentedAutofill = parcel.readArraySet(null);
            options.appDisabledExpiration = parcel.readLong();
            int size = parcel.readInt();
            if (size > 0) {
                options.disabledActivities = new ArrayMap();
                for (int i = 0; i < size; ++i) {
                    options.disabledActivities.put(parcel.readString(), parcel.readLong());
                }
            }
            return options;
        }

        public AutofillOptions[] newArray(int size) {
            return new AutofillOptions[size];
        }
    };

    public AutofillOptions(int loggingLevel, boolean compatModeEnabled) {
        this.loggingLevel = loggingLevel;
        this.compatModeEnabled = compatModeEnabled;
    }

    public boolean isAugmentedAutofillEnabled(Context context) {
        if (!this.augmentedAutofillEnabled) {
            return false;
        }
        AutofillManager.AutofillClient autofillClient = context.getAutofillClient();
        if (autofillClient == null) {
            return false;
        }
        ComponentName component = autofillClient.autofillClientGetComponentName();
        return this.whitelistedActivitiesForAugmentedAutofill == null || this.whitelistedActivitiesForAugmentedAutofill.contains(component);
    }

    public boolean isAutofillDisabledLocked(ComponentName componentName) {
        Long expiration;
        long elapsedTime = SystemClock.elapsedRealtime();
        String component = componentName.flattenToString();
        if (this.appDisabledExpiration >= elapsedTime) {
            return true;
        }
        if (this.disabledActivities != null && (expiration = this.disabledActivities.get(component)) != null) {
            if (expiration >= elapsedTime) {
                return true;
            }
            this.disabledActivities.remove(component);
        }
        this.appDisabledExpiration = 0L;
        return false;
    }

    public static AutofillOptions forWhitelistingItself() {
        ActivityThread at = ActivityThread.currentActivityThread();
        if (at == null) {
            throw new IllegalStateException("No ActivityThread");
        }
        String packageName = at.getApplication().getPackageName();
        if (!"android.autofillservice.cts".equals(packageName)) {
            Log.e(TAG, "forWhitelistingItself(): called by " + packageName);
            throw new SecurityException("Thou shall not pass!");
        }
        AutofillOptions options = new AutofillOptions(4, true);
        options.augmentedAutofillEnabled = true;
        Log.i(TAG, "forWhitelistingItself(" + packageName + "): " + options);
        return options;
    }

    public String toString() {
        return "AutofillOptions [loggingLevel=" + this.loggingLevel + ", compatMode=" + this.compatModeEnabled + ", augmentedAutofillEnabled=" + this.augmentedAutofillEnabled + ", appDisabledExpiration=" + this.appDisabledExpiration + "]";
    }

    public void dumpShort(PrintWriter pw) {
        pw.print("logLvl=");
        pw.print(this.loggingLevel);
        pw.print(", compatMode=");
        pw.print(this.compatModeEnabled);
        pw.print(", augmented=");
        pw.print(this.augmentedAutofillEnabled);
        if (this.whitelistedActivitiesForAugmentedAutofill != null) {
            pw.print(", whitelistedActivitiesForAugmentedAutofill=");
            pw.print(this.whitelistedActivitiesForAugmentedAutofill);
        }
        pw.print(", appDisabledExpiration=");
        pw.print(this.appDisabledExpiration);
        if (this.disabledActivities != null) {
            pw.print(", disabledActivities=");
            pw.print(this.disabledActivities);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.loggingLevel);
        parcel.writeBoolean(this.compatModeEnabled);
        parcel.writeBoolean(this.augmentedAutofillEnabled);
        parcel.writeArraySet(this.whitelistedActivitiesForAugmentedAutofill);
        parcel.writeLong(this.appDisabledExpiration);
        int size = this.disabledActivities != null ? this.disabledActivities.size() : 0;
        parcel.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String key = this.disabledActivities.keyAt(i);
                parcel.writeString(key);
                parcel.writeLong(this.disabledActivities.get(key));
            }
        }
    }
}

