/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.nio.ByteBuffer;

@SystemApi
@SuppressLint(value={"NotCloseable"})
public class AudioInjection {
    private static final String TAG = "AudioInjection";
    private final AudioFormat mAudioFormat;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private AudioTrack mAudioTrack;
    @GuardedBy(value={"mLock"})
    private int mPlayState = 1;
    @GuardedBy(value={"mLock"})
    private boolean mIsSilent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSilent(boolean isSilent) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSilent = isSilent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAudioTrack(AudioTrack audioTrack) {
        Log.d(TAG, "set AudioTrack with " + audioTrack);
        Object object = this.mLock;
        synchronized (object) {
            if (audioTrack != null) {
                if (audioTrack.getState() != 1) {
                    throw new IllegalStateException("set an uninitialized AudioTrack.");
                }
                if (this.mPlayState == 3 && audioTrack.getPlayState() != 3) {
                    audioTrack.play();
                }
                if (this.mPlayState == 1 && audioTrack.getPlayState() != 1) {
                    audioTrack.stop();
                }
            }
            if (this.mAudioTrack != null) {
                this.mAudioTrack.release();
            }
            this.mAudioTrack = audioTrack;
        }
    }

    AudioInjection(AudioFormat audioFormat) {
        this.mAudioFormat = audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.release();
                this.mAudioTrack = null;
            }
        }
    }

    public AudioFormat getFormat() {
        return this.mAudioFormat;
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.write(audioData, offsetInBytes, sizeInBytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        int sizeWrite;
        Object object = this.mLock;
        synchronized (object) {
            sizeWrite = this.mAudioTrack != null && !this.mIsSilent ? this.mAudioTrack.write(audioData, offsetInBytes, sizeInBytes, writeMode) : 0;
        }
        return sizeWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer audioBuffer, int sizeInBytes, int writeMode) {
        int sizeWrite;
        Object object = this.mLock;
        synchronized (object) {
            sizeWrite = this.mAudioTrack != null && !this.mIsSilent ? this.mAudioTrack.write(audioBuffer, sizeInBytes, writeMode) : 0;
        }
        return sizeWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer audioBuffer, int sizeInBytes, int writeMode, long timestamp) {
        int sizeWrite;
        Object object = this.mLock;
        synchronized (object) {
            sizeWrite = this.mAudioTrack != null && !this.mIsSilent ? this.mAudioTrack.write(audioBuffer, sizeInBytes, writeMode, timestamp) : 0;
        }
        return sizeWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        int sizeWrite;
        Object object = this.mLock;
        synchronized (object) {
            sizeWrite = this.mAudioTrack != null && !this.mIsSilent ? this.mAudioTrack.write(audioData, offsetInFloats, sizeInFloats, writeMode) : 0;
        }
        return sizeWrite;
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.write(audioData, offsetInShorts, sizeInShorts, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        int sizeWrite;
        Object object = this.mLock;
        synchronized (object) {
            sizeWrite = this.mAudioTrack != null && !this.mIsSilent ? this.mAudioTrack.write(audioData, offsetInShorts, sizeInShorts, writeMode) : 0;
        }
        return sizeWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayState = 3;
            if (this.mAudioTrack != null && this.mAudioTrack.getPlayState() != 3) {
                this.mAudioTrack.play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayState = 1;
            if (this.mAudioTrack != null && this.mAudioTrack.getPlayState() != 1) {
                this.mAudioTrack.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }
}

