/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.app.PendingIntent;
import android.companion.virtual.audio.IAudioConfigChangedCallback;
import android.companion.virtual.audio.IAudioRoutingCallback;
import android.graphics.Point;
import android.graphics.PointF;
import android.hardware.input.VirtualKeyEvent;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.hardware.input.VirtualTouchEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface IVirtualDevice
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDevice";

    public int getAssociationId() throws RemoteException;

    public void close() throws RemoteException;

    public void onAudioSessionStarting(int var1, IAudioRoutingCallback var2, IAudioConfigChangedCallback var3) throws RemoteException;

    public void onAudioSessionEnded() throws RemoteException;

    public void createVirtualKeyboard(int var1, String var2, int var3, int var4, IBinder var5) throws RemoteException;

    public void createVirtualMouse(int var1, String var2, int var3, int var4, IBinder var5) throws RemoteException;

    public void createVirtualTouchscreen(int var1, String var2, int var3, int var4, IBinder var5, Point var6) throws RemoteException;

    public void unregisterInputDevice(IBinder var1) throws RemoteException;

    public boolean sendKeyEvent(IBinder var1, VirtualKeyEvent var2) throws RemoteException;

    public boolean sendButtonEvent(IBinder var1, VirtualMouseButtonEvent var2) throws RemoteException;

    public boolean sendRelativeEvent(IBinder var1, VirtualMouseRelativeEvent var2) throws RemoteException;

    public boolean sendScrollEvent(IBinder var1, VirtualMouseScrollEvent var2) throws RemoteException;

    public boolean sendTouchEvent(IBinder var1, VirtualTouchEvent var2) throws RemoteException;

    public void launchPendingIntent(int var1, PendingIntent var2, ResultReceiver var3) throws RemoteException;

    public PointF getCursorPosition(IBinder var1) throws RemoteException;

    public void setShowPointerIcon(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDevice {
        static final int TRANSACTION_getAssociationId = 1;
        static final int TRANSACTION_close = 2;
        static final int TRANSACTION_onAudioSessionStarting = 3;
        static final int TRANSACTION_onAudioSessionEnded = 4;
        static final int TRANSACTION_createVirtualKeyboard = 5;
        static final int TRANSACTION_createVirtualMouse = 6;
        static final int TRANSACTION_createVirtualTouchscreen = 7;
        static final int TRANSACTION_unregisterInputDevice = 8;
        static final int TRANSACTION_sendKeyEvent = 9;
        static final int TRANSACTION_sendButtonEvent = 10;
        static final int TRANSACTION_sendRelativeEvent = 11;
        static final int TRANSACTION_sendScrollEvent = 12;
        static final int TRANSACTION_sendTouchEvent = 13;
        static final int TRANSACTION_launchPendingIntent = 14;
        static final int TRANSACTION_getCursorPosition = 15;
        static final int TRANSACTION_setShowPointerIcon = 16;

        public Stub() {
            this.attachInterface(this, IVirtualDevice.DESCRIPTOR);
        }

        public static IVirtualDevice asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDevice.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDevice) {
                return (IVirtualDevice)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAssociationId";
                }
                case 2: {
                    return "close";
                }
                case 3: {
                    return "onAudioSessionStarting";
                }
                case 4: {
                    return "onAudioSessionEnded";
                }
                case 5: {
                    return "createVirtualKeyboard";
                }
                case 6: {
                    return "createVirtualMouse";
                }
                case 7: {
                    return "createVirtualTouchscreen";
                }
                case 8: {
                    return "unregisterInputDevice";
                }
                case 9: {
                    return "sendKeyEvent";
                }
                case 10: {
                    return "sendButtonEvent";
                }
                case 11: {
                    return "sendRelativeEvent";
                }
                case 12: {
                    return "sendScrollEvent";
                }
                case 13: {
                    return "sendTouchEvent";
                }
                case 14: {
                    return "launchPendingIntent";
                }
                case 15: {
                    return "getCursorPosition";
                }
                case 16: {
                    return "setShowPointerIcon";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDevice.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _result = this.getAssociationId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IAudioRoutingCallback _arg1 = IAudioRoutingCallback.Stub.asInterface(data.readStrongBinder());
                    IAudioConfigChangedCallback _arg2 = IAudioConfigChangedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onAudioSessionStarting(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.onAudioSessionEnded();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IBinder _arg4 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualKeyboard(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IBinder _arg4 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualMouse(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IBinder _arg4 = data.readStrongBinder();
                    Point _arg5 = data.readTypedObject(Point.CREATOR);
                    data.enforceNoDataAvail();
                    this.createVirtualTouchscreen(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.unregisterInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualKeyEvent _arg1 = data.readTypedObject(VirtualKeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendKeyEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseButtonEvent _arg1 = data.readTypedObject(VirtualMouseButtonEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendButtonEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseRelativeEvent _arg1 = data.readTypedObject(VirtualMouseRelativeEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendRelativeEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseScrollEvent _arg1 = data.readTypedObject(VirtualMouseScrollEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendScrollEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualTouchEvent _arg1 = data.readTypedObject(VirtualTouchEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendTouchEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.launchPendingIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    PointF _result = this.getCursorPosition(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShowPointerIcon(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IVirtualDevice {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDevice.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAssociationId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(routingCallback);
                    _data.writeStrongInterface(configChangedCallback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionEnded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualKeyboard(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(inputDeviceName);
                    _data.writeInt(vendorId);
                    _data.writeInt(productId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualMouse(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(inputDeviceName);
                    _data.writeInt(vendorId);
                    _data.writeInt(productId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualTouchscreen(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token, Point screenSize) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(inputDeviceName);
                    _data.writeInt(vendorId);
                    _data.writeInt(productId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(screenSize, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterInputDevice(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendButtonEvent(IBinder token, VirtualMouseButtonEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendRelativeEvent(IBinder token, VirtualMouseRelativeEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendScrollEvent(IBinder token, VirtualMouseScrollEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendTouchEvent(IBinder token, VirtualTouchEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PointF getCursorPosition(IBinder token) throws RemoteException {
                PointF _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PointF.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeBoolean(showPointerIcon);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDevice {
        @Override
        public int getAssociationId() throws RemoteException {
            return 0;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
        }

        @Override
        public void onAudioSessionEnded() throws RemoteException {
        }

        @Override
        public void createVirtualKeyboard(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualMouse(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualTouchscreen(int displayId, String inputDeviceName, int vendorId, int productId, IBinder token, Point screenSize) throws RemoteException {
        }

        @Override
        public void unregisterInputDevice(IBinder token) throws RemoteException {
        }

        @Override
        public boolean sendKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendButtonEvent(IBinder token, VirtualMouseButtonEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendRelativeEvent(IBinder token, VirtualMouseRelativeEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendScrollEvent(IBinder token, VirtualMouseScrollEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendTouchEvent(IBinder token, VirtualTouchEvent event) throws RemoteException {
            return false;
        }

        @Override
        public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public PointF getCursorPosition(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

