/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface IAssociationRequestCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.IAssociationRequestCallback";

    public void onAssociationPending(PendingIntent var1) throws RemoteException;

    public void onAssociationCreated(AssociationInfo var1) throws RemoteException;

    public void onFailure(CharSequence var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAssociationRequestCallback {
        static final int TRANSACTION_onAssociationPending = 1;
        static final int TRANSACTION_onAssociationCreated = 2;
        static final int TRANSACTION_onFailure = 3;

        public Stub() {
            this.attachInterface(this, IAssociationRequestCallback.DESCRIPTOR);
        }

        public static IAssociationRequestCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAssociationRequestCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IAssociationRequestCallback) {
                return (IAssociationRequestCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAssociationPending";
                }
                case 2: {
                    return "onAssociationCreated";
                }
                case 3: {
                    return "onFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAssociationRequestCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAssociationPending(_arg0);
                    break;
                }
                case 2: {
                    AssociationInfo _arg0 = data.readTypedObject(AssociationInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAssociationCreated(_arg0);
                    break;
                }
                case 3: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.onFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IAssociationRequestCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAssociationRequestCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAssociationPending(PendingIntent pendingIntent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAssociationRequestCallback.DESCRIPTOR);
                    _data.writeTypedObject(pendingIntent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAssociationCreated(AssociationInfo associationInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAssociationRequestCallback.DESCRIPTOR);
                    _data.writeTypedObject(associationInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(CharSequence error) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAssociationRequestCallback.DESCRIPTOR);
                    if (error != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(error, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAssociationRequestCallback {
        @Override
        public void onAssociationPending(PendingIntent pendingIntent) throws RemoteException {
        }

        @Override
        public void onAssociationCreated(AssociationInfo associationInfo) throws RemoteException {
        }

        @Override
        public void onFailure(CharSequence error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

