/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeAudioCodecStatus;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothLeAudioCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothLeAudioCallback";

    public void onCodecConfigChanged(int var1, BluetoothLeAudioCodecStatus var2) throws RemoteException;

    public void onGroupNodeAdded(BluetoothDevice var1, int var2) throws RemoteException;

    public void onGroupNodeRemoved(BluetoothDevice var1, int var2) throws RemoteException;

    public void onGroupStatusChanged(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothLeAudioCallback {
        static final int TRANSACTION_onCodecConfigChanged = 1;
        static final int TRANSACTION_onGroupNodeAdded = 2;
        static final int TRANSACTION_onGroupNodeRemoved = 3;
        static final int TRANSACTION_onGroupStatusChanged = 4;

        public Stub() {
            this.attachInterface(this, IBluetoothLeAudioCallback.DESCRIPTOR);
        }

        public static IBluetoothLeAudioCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothLeAudioCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothLeAudioCallback) {
                return (IBluetoothLeAudioCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothLeAudioCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    BluetoothLeAudioCodecStatus _arg1 = data.readTypedObject(BluetoothLeAudioCodecStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCodecConfigChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onGroupNodeAdded(_arg0, _arg1);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onGroupNodeRemoved(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onGroupStatusChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothLeAudioCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothLeAudioCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCodecConfigChanged(int groupId, BluetoothLeAudioCodecStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeAudioCallback.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeTypedObject(status, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupNodeAdded(BluetoothDevice device, int groupId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeAudioCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(groupId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupNodeRemoved(BluetoothDevice device, int groupId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeAudioCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(groupId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupStatusChanged(int groupId, int groupStatus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothLeAudioCallback.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(groupStatus);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothLeAudioCallback {
        @Override
        public void onCodecConfigChanged(int groupId, BluetoothLeAudioCodecStatus status) throws RemoteException {
        }

        @Override
        public void onGroupNodeAdded(BluetoothDevice device, int groupId) throws RemoteException {
        }

        @Override
        public void onGroupNodeRemoved(BluetoothDevice device, int groupId) throws RemoteException {
        }

        @Override
        public void onGroupStatusChanged(int groupId, int groupStatus) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

