/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHapPresetInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothHapClientCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothHapClientCallback";

    public void onPresetSelected(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onPresetSelectionFailed(BluetoothDevice var1, int var2) throws RemoteException;

    public void onPresetSelectionForGroupFailed(int var1, int var2) throws RemoteException;

    public void onPresetInfoChanged(BluetoothDevice var1, List<BluetoothHapPresetInfo> var2, int var3) throws RemoteException;

    public void onSetPresetNameFailed(BluetoothDevice var1, int var2) throws RemoteException;

    public void onSetPresetNameForGroupFailed(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHapClientCallback {
        static final int TRANSACTION_onPresetSelected = 1;
        static final int TRANSACTION_onPresetSelectionFailed = 2;
        static final int TRANSACTION_onPresetSelectionForGroupFailed = 3;
        static final int TRANSACTION_onPresetInfoChanged = 4;
        static final int TRANSACTION_onSetPresetNameFailed = 5;
        static final int TRANSACTION_onSetPresetNameForGroupFailed = 6;

        public Stub() {
            this.attachInterface(this, IBluetoothHapClientCallback.DESCRIPTOR);
        }

        public static IBluetoothHapClientCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothHapClientCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHapClientCallback) {
                return (IBluetoothHapClientCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothHapClientCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPresetSelected(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPresetSelectionFailed(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPresetSelectionForGroupFailed(_arg0, _arg1);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    ArrayList<BluetoothHapPresetInfo> _arg1 = data.createTypedArrayList(BluetoothHapPresetInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPresetInfoChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSetPresetNameFailed(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSetPresetNameForGroupFailed(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothHapClientCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothHapClientCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPresetSelected(BluetoothDevice device, int presetIndex, int reasonCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(presetIndex);
                    _data.writeInt(reasonCode);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPresetSelectionFailed(BluetoothDevice device, int statusCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(statusCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPresetSelectionForGroupFailed(int hapGroupId, int statusCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeInt(hapGroupId);
                    _data.writeInt(statusCode);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPresetInfoChanged(BluetoothDevice device, List<BluetoothHapPresetInfo> presetInfoList, int statusCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedList(presetInfoList);
                    _data.writeInt(statusCode);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetPresetNameFailed(BluetoothDevice device, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetPresetNameForGroupFailed(int hapGroupId, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothHapClientCallback.DESCRIPTOR);
                    _data.writeInt(hapGroupId);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothHapClientCallback {
        @Override
        public void onPresetSelected(BluetoothDevice device, int presetIndex, int reasonCode) throws RemoteException {
        }

        @Override
        public void onPresetSelectionFailed(BluetoothDevice device, int statusCode) throws RemoteException {
        }

        @Override
        public void onPresetSelectionForGroupFailed(int hapGroupId, int statusCode) throws RemoteException {
        }

        @Override
        public void onPresetInfoChanged(BluetoothDevice device, List<BluetoothHapPresetInfo> presetInfoList, int statusCode) throws RemoteException {
        }

        @Override
        public void onSetPresetNameFailed(BluetoothDevice device, int status) throws RemoteException {
        }

        @Override
        public void onSetPresetNameForGroupFailed(int hapGroupId, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

