/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.CloseGuard;
import android.util.Log;
import java.util.List;

@SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
public abstract class BluetoothProfileConnector<T> {
    private final CloseGuard mCloseGuard = new CloseGuard();
    private final int mProfileId;
    private BluetoothProfile.ServiceListener mServiceListener;
    private final BluetoothProfile mProfileProxy;
    private Context mContext;
    private final String mProfileName;
    private final String mServiceName;
    private volatile T mService;
    private static final UserHandle USER_HANDLE_CURRENT_OR_SELF = UserHandle.of(-3);
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        @Override
        public void onBluetoothStateChange(boolean up) {
            if (up) {
                BluetoothProfileConnector.this.doBind();
            } else {
                BluetoothProfileConnector.this.doUnbind();
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothProfileConnector.this.logDebug("Proxy object connected");
            BluetoothProfileConnector.this.mService = BluetoothProfileConnector.this.getServiceInterface(service);
            if (BluetoothProfileConnector.this.mServiceListener != null) {
                BluetoothProfileConnector.this.mServiceListener.onServiceConnected(BluetoothProfileConnector.this.mProfileId, BluetoothProfileConnector.this.mProfileProxy);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            BluetoothProfileConnector.this.logDebug("Proxy object disconnected");
            BluetoothProfileConnector.this.doUnbind();
            if (BluetoothProfileConnector.this.mServiceListener != null) {
                BluetoothProfileConnector.this.mServiceListener.onServiceDisconnected(BluetoothProfileConnector.this.mProfileId);
            }
        }
    };

    private ComponentName resolveSystemService(Intent intent, PackageManager pm) {
        List<ResolveInfo> results = pm.queryIntentServices(intent, PackageManager.ResolveInfoFlags.of(0L));
        if (results == null) {
            return null;
        }
        ComponentName comp = null;
        for (int i = 0; i < results.size(); ++i) {
            ResolveInfo ri = results.get(i);
            if ((ri.serviceInfo.applicationInfo.flags & 1) == 0) continue;
            ComponentName foundComp = new ComponentName(ri.serviceInfo.applicationInfo.packageName, ri.serviceInfo.name);
            if (comp != null) {
                throw new IllegalStateException("Multiple system services handle " + intent + ": " + comp + ", " + foundComp);
            }
            comp = foundComp;
        }
        return comp;
    }

    BluetoothProfileConnector(BluetoothProfile profile, int profileId, String profileName, String serviceName) {
        this.mProfileId = profileId;
        this.mProfileProxy = profile;
        this.mProfileName = profileName;
        this.mServiceName = serviceName;
    }

    public void finalize() {
        this.mCloseGuard.warnIfOpen();
        this.doUnbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    private boolean doBind() {
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService == null) {
                this.logDebug("Binding service...");
                this.mCloseGuard.open("doUnbind");
                try {
                    Intent intent = new Intent(this.mServiceName);
                    ComponentName comp = this.resolveSystemService(intent, this.mContext.getPackageManager());
                    intent.setComponent(comp);
                    if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, USER_HANDLE_CURRENT_OR_SELF)) {
                        this.logError("Could not bind to Bluetooth Service with " + intent);
                        return false;
                    }
                }
                catch (SecurityException se) {
                    this.logError("Failed to bind service. " + se);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnbind() {
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                this.logDebug("Unbinding service...");
                this.mCloseGuard.close();
                try {
                    this.mContext.unbindService(this.mConnection);
                }
                catch (IllegalArgumentException ie) {
                    this.logError("Unable to unbind service: " + ie);
                }
                finally {
                    this.mService = null;
                }
            }
        }
    }

    void connect(Context context, BluetoothProfile.ServiceListener listener) {
        this.mContext = context;
        this.mServiceListener = listener;
        IBluetoothManager mgr = BluetoothAdapter.getDefaultAdapter().getBluetoothManager();
        if (context.getApplicationInfo().targetSdkVersion <= 30 && context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
            throw new SecurityException("Need BLUETOOTH permission");
        }
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException re) {
                this.logError("Failed to register state change callback. " + re);
            }
        }
        this.doBind();
    }

    void disconnect() {
        this.mServiceListener = null;
        IBluetoothManager mgr = BluetoothAdapter.getDefaultAdapter().getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException re) {
                this.logError("Failed to unregister state change callback" + re);
            }
        }
        this.doUnbind();
    }

    T getService() {
        return this.mService;
    }

    public abstract T getServiceInterface(IBinder var1);

    private void logDebug(String log) {
        Log.d(this.mProfileName, log);
    }

    private void logError(String log) {
        Log.e(this.mProfileName, log);
    }
}

