/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothMap;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.IpcDataCache;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import android.util.Pair;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

@SystemApi
public class BluetoothMap
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothMap";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private CloseGuard mCloseGuard;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.map.profile.action.CONNECTION_STATE_CHANGED";
    public static final int STATE_ERROR = -1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothMap> mProfileConnector = new BluetoothProfileConnector(this, 9, "BluetoothMap", IBluetoothMap.class.getName()){

        public IBluetoothMap getServiceInterface(IBinder service) {
            return IBluetoothMap.Stub.asInterface(service);
        }
    };
    private final IpcDataCache.QueryHandler<Pair<IBluetoothMap, BluetoothDevice>, Integer> mBluetoothConnectionQuery = new IpcDataCache.QueryHandler<Pair<IBluetoothMap, BluetoothDevice>, Integer>(){

        @Override
        @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
        public Integer apply(Pair<IBluetoothMap, BluetoothDevice> pairQuery) {
            BluetoothMap.log("getConnectionState(" + ((BluetoothDevice)pairQuery.second).getAnonymizedAddress() + ") uncached");
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            try {
                ((IBluetoothMap)pairQuery.first).getConnectionState((BluetoothDevice)pairQuery.second, BluetoothMap.this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final String GET_CONNECTION_STATE_API = "BluetoothMap_getConnectionState";
    private final BluetoothCache<Pair<IBluetoothMap, BluetoothDevice>, Integer> mBluetoothConnectionCache = new BluetoothCache("BluetoothMap_getConnectionState", this.mBluetoothConnectionQuery);

    BluetoothMap(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        Log.d(TAG, "Create BluetoothMap proxy object");
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    @SystemApi
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothMap getService() {
        return this.mProfileConnector.getService();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getState() {
        IBluetoothMap service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getState(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice getClient() {
        IBluetoothMap service = this.getService();
        BluetoothDevice defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getClient(this.mAttributionSource, recv);
                return Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected(BluetoothDevice device) {
        IBluetoothMap service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isConnected(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresNoPermission
    public boolean connect(BluetoothDevice device) {
        BluetoothMap.log("connect(" + device + ")not supported for MAPS");
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disconnect(BluetoothDevice device) {
        BluetoothMap.log("disconnect(" + device + ")");
        IBluetoothMap service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnect(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    public static boolean doesClassMatchSink(BluetoothClass btClass) {
        switch (btClass.getDeviceClass()) {
            case 256: 
            case 260: 
            case 264: 
            case 268: {
                return true;
            }
        }
        return false;
    }

    @Override
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothMap.log("getConnectedDevices()");
        IBluetoothMap service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothMap.log("getDevicesMatchingStates()");
        IBluetoothMap service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    public void disableBluetoothGetConnectionStateCache() {
        this.mBluetoothConnectionCache.disableForCurrentProcess();
    }

    public static void invalidateBluetoothGetConnectionStateCache() {
        BluetoothMap.invalidateCache(GET_CONNECTION_STATE_API);
    }

    private static void invalidateCache(String api) {
        IpcDataCache.invalidateCache("bluetooth", api);
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        BluetoothMap.log("getConnectionState(" + device + ")");
        IBluetoothMap service = this.getService();
        if (service == null) {
            Log.w(TAG, "BT not enabled. Cannot get connection state");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return (Integer)this.mBluetoothConnectionCache.query(new Pair<IBluetoothMap, BluetoothDevice>(service, device));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                    throw e;
                }
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothMap.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothMap.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothMap service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothMap.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothMap service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private boolean isEnabled() {
        return this.mAdapter.isEnabled();
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static class BluetoothCache<Q, R>
    extends IpcDataCache<Q, R> {
        BluetoothCache(String api, IpcDataCache.QueryHandler query) {
            super(8, "bluetooth", api, api, query);
        }
    }
}

