/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothLeAudioCodecConfig;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class BluetoothLeAudioCodecStatus
implements Parcelable {
    public static final String EXTRA_LE_AUDIO_CODEC_STATUS = "android.bluetooth.extra.LE_AUDIO_CODEC_STATUS";
    private final BluetoothLeAudioCodecConfig mInputCodecConfig;
    private final BluetoothLeAudioCodecConfig mOutputCodecConfig;
    private final List<BluetoothLeAudioCodecConfig> mInputCodecsLocalCapabilities;
    private final List<BluetoothLeAudioCodecConfig> mOutputCodecsLocalCapabilities;
    private final List<BluetoothLeAudioCodecConfig> mInputCodecsSelectableCapabilities;
    private final List<BluetoothLeAudioCodecConfig> mOutputCodecsSelectableCapabilities;
    public static final Parcelable.Creator<BluetoothLeAudioCodecStatus> CREATOR = new Parcelable.Creator<BluetoothLeAudioCodecStatus>(){

        @Override
        public BluetoothLeAudioCodecStatus createFromParcel(Parcel in) {
            return new BluetoothLeAudioCodecStatus(in);
        }

        public BluetoothLeAudioCodecStatus[] newArray(int size) {
            return new BluetoothLeAudioCodecStatus[size];
        }
    };

    public BluetoothLeAudioCodecStatus(BluetoothLeAudioCodecConfig inputCodecConfig, BluetoothLeAudioCodecConfig outputCodecConfig, List<BluetoothLeAudioCodecConfig> inputCodecsLocalCapabilities, List<BluetoothLeAudioCodecConfig> outputCodecsLocalCapabilities, List<BluetoothLeAudioCodecConfig> inputCodecsSelectableCapabilities, List<BluetoothLeAudioCodecConfig> outputCodecsSelectableCapabilities) {
        this.mInputCodecConfig = inputCodecConfig;
        this.mOutputCodecConfig = outputCodecConfig;
        this.mInputCodecsLocalCapabilities = inputCodecsLocalCapabilities;
        this.mOutputCodecsLocalCapabilities = outputCodecsLocalCapabilities;
        this.mInputCodecsSelectableCapabilities = inputCodecsSelectableCapabilities;
        this.mOutputCodecsSelectableCapabilities = outputCodecsSelectableCapabilities;
    }

    private BluetoothLeAudioCodecStatus(Parcel in) {
        this.mInputCodecConfig = in.readTypedObject(BluetoothLeAudioCodecConfig.CREATOR);
        this.mOutputCodecConfig = in.readTypedObject(BluetoothLeAudioCodecConfig.CREATOR);
        this.mInputCodecsLocalCapabilities = in.createTypedArrayList(BluetoothLeAudioCodecConfig.CREATOR);
        this.mOutputCodecsLocalCapabilities = in.createTypedArrayList(BluetoothLeAudioCodecConfig.CREATOR);
        this.mInputCodecsSelectableCapabilities = in.createTypedArrayList(BluetoothLeAudioCodecConfig.CREATOR);
        this.mOutputCodecsSelectableCapabilities = in.createTypedArrayList(BluetoothLeAudioCodecConfig.CREATOR);
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothLeAudioCodecStatus) {
            BluetoothLeAudioCodecStatus other = (BluetoothLeAudioCodecStatus)o;
            return Objects.equals(other.mInputCodecConfig, this.mInputCodecConfig) && Objects.equals(other.mOutputCodecConfig, this.mOutputCodecConfig) && BluetoothLeAudioCodecStatus.sameCapabilities(other.mInputCodecsLocalCapabilities, this.mInputCodecsLocalCapabilities) && BluetoothLeAudioCodecStatus.sameCapabilities(other.mOutputCodecsLocalCapabilities, this.mOutputCodecsLocalCapabilities) && BluetoothLeAudioCodecStatus.sameCapabilities(other.mInputCodecsSelectableCapabilities, this.mInputCodecsSelectableCapabilities) && BluetoothLeAudioCodecStatus.sameCapabilities(other.mOutputCodecsSelectableCapabilities, this.mOutputCodecsSelectableCapabilities);
        }
        return false;
    }

    private static boolean sameCapabilities(List<BluetoothLeAudioCodecConfig> c1, List<BluetoothLeAudioCodecConfig> c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        return c1.containsAll(c2);
    }

    private boolean isCodecConfigSelectable(BluetoothLeAudioCodecConfig codecConfig, BluetoothLeAudioCodecConfig selectableConfig) {
        if (codecConfig.getCodecType() != selectableConfig.getCodecType()) {
            return false;
        }
        if (codecConfig.getFrameDuration() != 0 && (codecConfig.getFrameDuration() & selectableConfig.getFrameDuration()) == 0) {
            return false;
        }
        if (codecConfig.getChannelCount() != 0 && (codecConfig.getChannelCount() & selectableConfig.getChannelCount()) == 0) {
            return false;
        }
        if (codecConfig.getSampleRate() != 0 && (codecConfig.getSampleRate() & selectableConfig.getSampleRate()) == 0) {
            return false;
        }
        if (codecConfig.getBitsPerSample() != 0 && (codecConfig.getBitsPerSample() & selectableConfig.getBitsPerSample()) == 0) {
            return false;
        }
        return codecConfig.getOctetsPerFrame() == 0 || codecConfig.getOctetsPerFrame() >= selectableConfig.getMinOctetsPerFrame() && codecConfig.getOctetsPerFrame() <= selectableConfig.getMaxOctetsPerFrame();
    }

    public boolean isInputCodecConfigSelectable(BluetoothLeAudioCodecConfig codecConfig) {
        if (codecConfig == null) {
            return false;
        }
        for (BluetoothLeAudioCodecConfig selectableConfig : this.mInputCodecsSelectableCapabilities) {
            if (!this.isCodecConfigSelectable(codecConfig, selectableConfig)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputCodecConfigSelectable(BluetoothLeAudioCodecConfig codecConfig) {
        if (codecConfig == null) {
            return false;
        }
        for (BluetoothLeAudioCodecConfig selectableConfig : this.mOutputCodecsSelectableCapabilities) {
            if (!this.isCodecConfigSelectable(codecConfig, selectableConfig)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mInputCodecConfig, this.mOutputCodecConfig, this.mInputCodecsLocalCapabilities, this.mOutputCodecsLocalCapabilities, this.mInputCodecsSelectableCapabilities, this.mOutputCodecsSelectableCapabilities);
    }

    public String toString() {
        return "{mInputCodecConfig:" + this.mInputCodecConfig + ",mOutputCodecConfig:" + this.mOutputCodecConfig + ",mInputCodecsLocalCapabilities:" + this.mInputCodecsLocalCapabilities + ",mOutputCodecsLocalCapabilities:" + this.mOutputCodecsLocalCapabilities + ",mInputCodecsSelectableCapabilities:" + this.mInputCodecsSelectableCapabilities + ",mOutputCodecsSelectableCapabilities:" + this.mOutputCodecsSelectableCapabilities + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedObject(this.mInputCodecConfig, flags);
        out.writeTypedObject(this.mOutputCodecConfig, flags);
        out.writeTypedList(this.mInputCodecsLocalCapabilities);
        out.writeTypedList(this.mOutputCodecsLocalCapabilities);
        out.writeTypedList(this.mInputCodecsSelectableCapabilities);
        out.writeTypedList(this.mOutputCodecsSelectableCapabilities);
    }

    public BluetoothLeAudioCodecConfig getInputCodecConfig() {
        return this.mInputCodecConfig;
    }

    public BluetoothLeAudioCodecConfig getOutputCodecConfig() {
        return this.mOutputCodecConfig;
    }

    public List<BluetoothLeAudioCodecConfig> getInputCodecLocalCapabilities() {
        return this.mInputCodecsLocalCapabilities == null ? Collections.emptyList() : this.mInputCodecsLocalCapabilities;
    }

    public List<BluetoothLeAudioCodecConfig> getOutputCodecLocalCapabilities() {
        return this.mOutputCodecsLocalCapabilities == null ? Collections.emptyList() : this.mOutputCodecsLocalCapabilities;
    }

    public List<BluetoothLeAudioCodecConfig> getInputCodecSelectableCapabilities() {
        return this.mInputCodecsSelectableCapabilities == null ? Collections.emptyList() : this.mInputCodecsSelectableCapabilities;
    }

    public List<BluetoothLeAudioCodecConfig> getOutputCodecSelectableCapabilities() {
        return this.mOutputCodecsSelectableCapabilities == null ? Collections.emptyList() : this.mOutputCodecsSelectableCapabilities;
    }
}

