/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ComponentName;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class BluetoothHeadset
implements BluetoothProfile {
    private static final String TAG = "BluetoothHeadset";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_VENDOR_SPECIFIC_HEADSET_EVENT = "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT";
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD";
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE";
    public static final int AT_CMD_TYPE_READ = 0;
    public static final int AT_CMD_TYPE_TEST = 1;
    public static final int AT_CMD_TYPE_SET = 2;
    public static final int AT_CMD_TYPE_BASIC = 3;
    public static final int AT_CMD_TYPE_ACTION = 4;
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_ARGS = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_ARGS";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_COMPANY_ID_CATEGORY = "android.bluetooth.headset.intent.category.companyid";
    public static final String VENDOR_RESULT_CODE_COMMAND_ANDROID = "+ANDROID";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_XAPL = "+XAPL";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV = "+IPHONEACCEV";
    public static final int VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV_BATTERY_LEVEL = 1;
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT = "+XEVENT";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT_BATTERY_LEVEL = "BATTERY";
    public static final int STATE_AUDIO_DISCONNECTED = 10;
    public static final int STATE_AUDIO_CONNECTING = 11;
    public static final int STATE_AUDIO_CONNECTED = 12;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_HF_INDICATORS_VALUE_CHANGED = "android.bluetooth.headset.action.HF_INDICATORS_VALUE_CHANGED";
    public static final String EXTRA_HF_INDICATORS_IND_ID = "android.bluetooth.headset.extra.HF_INDICATORS_IND_ID";
    public static final String EXTRA_HF_INDICATORS_IND_VALUE = "android.bluetooth.headset.extra.HF_INDICATORS_IND_VALUE";
    private static final int MESSAGE_HEADSET_SERVICE_CONNECTED = 100;
    private static final int MESSAGE_HEADSET_SERVICE_DISCONNECTED = 101;
    private final CloseGuard mCloseGuard = new CloseGuard();
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private volatile IBluetoothHeadset mService;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(BluetoothHeadset.TAG, "onBluetoothStateChange: up=" + up);
            if (!up) {
                BluetoothHeadset.this.doUnbind();
            } else {
                BluetoothHeadset.this.doBind();
            }
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothProfileServiceConnection mConnection = new IBluetoothProfileServiceConnection.Stub(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d(BluetoothHeadset.TAG, "Proxy object connected");
            BluetoothHeadset.this.mService = IBluetoothHeadset.Stub.asInterface(service);
            BluetoothHeadset.this.mHandler.sendMessage(BluetoothHeadset.this.mHandler.obtainMessage(100));
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Log.d(BluetoothHeadset.TAG, "Proxy object disconnected");
            BluetoothHeadset.this.doUnbind();
            BluetoothHeadset.this.mHandler.sendMessage(BluetoothHeadset.this.mHandler.obtainMessage(101));
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    if (BluetoothHeadset.this.mServiceListener == null) break;
                    BluetoothHeadset.this.mServiceListener.onServiceConnected(1, BluetoothHeadset.this);
                    break;
                }
                case 101: {
                    if (BluetoothHeadset.this.mServiceListener == null) break;
                    BluetoothHeadset.this.mServiceListener.onServiceDisconnected(1);
                }
            }
        }
    };

    BluetoothHeadset(Context context, BluetoothProfile.ServiceListener l, BluetoothAdapter adapter) {
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        if (context.getApplicationInfo().targetSdkVersion <= 30 && context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
            throw new SecurityException("Need BLUETOOTH permission");
        }
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.doBind();
        this.mCloseGuard.open("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doBind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService == null) {
                try {
                    return this.mAdapter.getBluetoothManager().bindBluetoothProfileService(1, this.mConnection);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to bind HeadsetService", e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnbind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService != null) {
                try {
                    this.mAdapter.getBluetoothManager().unbindBluetoothProfileService(1, this.mConnection);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to unbind HeadsetService", e);
                }
                finally {
                    this.mService = null;
                }
            }
        }
    }

    @UnsupportedAppUsage
    void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException re) {
                Log.e(TAG, "", re);
            }
        }
        this.mServiceListener = null;
        this.doUnbind();
        this.mCloseGuard.close();
    }

    protected void finalize() throws Throwable {
        this.mCloseGuard.warnIfOpen();
        this.close();
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE"})
    public boolean connect(BluetoothDevice device) {
        BluetoothHeadset.log("connect(" + device + ")");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connectWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disconnect(BluetoothDevice device) {
        BluetoothHeadset.log("disconnect(" + device + ")");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnectWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHeadset service = this.mService;
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevicesWithAttribution(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHeadset service = this.mService;
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionStateWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothHeadset.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isNoiseReductionSupported(BluetoothDevice device) {
        BluetoothHeadset.log("isNoiseReductionSupported()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isNoiseReductionSupported(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isVoiceRecognitionSupported(BluetoothDevice device) {
        BluetoothHeadset.log("isVoiceRecognitionSupported()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isVoiceRecognitionSupported(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE"})
    public boolean startVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("startVoiceRecognition()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.startVoiceRecognition(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean stopVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("stopVoiceRecognition()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.stopVoiceRecognition(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isAudioConnected(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isAudioConnected(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getAudioState(BluetoothDevice device) {
        Objects.requireNonNull(device);
        IBluetoothHeadset service = this.mService;
        int defaultValue = 10;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (!this.isDisabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAudioState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(10);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                throw e.rethrowFromSystemServer();
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                return 15;
            }
        }
        return 10;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setAudioRouteAllowed(boolean allowed) {
        IBluetoothHeadset service = this.mService;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
            return 9;
        }
        if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setAudioRouteAllowed(allowed, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                return 0;
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                return 15;
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                e.rethrowFromSystemServer();
            }
        }
        Log.e(TAG, "setAudioRouteAllowed: Bluetooth disabled, but profile service still bound");
        return Integer.MAX_VALUE;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getAudioRouteAllowed() {
        IBluetoothHeadset service = this.mService;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
            return 9;
        }
        if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAudioRouteAllowed(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false) != false ? 400 : 401;
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                return 15;
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                e.rethrowFromSystemServer();
            }
        }
        Log.e(TAG, "getAudioRouteAllowed: Bluetooth disabled, but profile service still bound");
        return Integer.MAX_VALUE;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setForceScoAudio(boolean forced) {
        IBluetoothHeadset service = this.mService;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setForceScoAudio(forced, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int connectAudio() {
        IBluetoothHeadset service = this.mService;
        int defaultValue = Integer.MAX_VALUE;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
            return 9;
        }
        if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connectAudio(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                throw e.rethrowFromSystemServer();
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                return 15;
            }
        }
        Log.e(TAG, "connectAudio: Bluetooth disabled, but profile service still bound");
        return Integer.MAX_VALUE;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int disconnectAudio() {
        IBluetoothHeadset service = this.mService;
        int defaultValue = Integer.MAX_VALUE;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
            return 9;
        }
        if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnectAudio(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                throw e.rethrowFromSystemServer();
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                return 15;
            }
        }
        Log.e(TAG, "disconnectAudio: Bluetooth disabled, but profile service still bound");
        return Integer.MAX_VALUE;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean startScoUsingVirtualVoiceCall() {
        BluetoothHeadset.log("startScoUsingVirtualVoiceCall()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.startScoUsingVirtualVoiceCall(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean stopScoUsingVirtualVoiceCall() {
        BluetoothHeadset.log("stopScoUsingVirtualVoiceCall()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.stopScoUsingVirtualVoiceCall(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE"})
    public void phoneStateChanged(int numActive, int numHeld, int callState, String number, int type, String name) {
        IBluetoothHeadset service = this.mService;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                service.phoneStateChanged(numActive, numHeld, callState, number, type, name, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE"})
    public void clccResponse(int index, int direction, int status, int mode, boolean mpty, String number, int type) {
        IBluetoothHeadset service = this.mService;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.clccResponse(index, direction, status, mode, mpty, number, type, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sendVendorSpecificResultCode(BluetoothDevice device, String command, String arg) {
        BluetoothHeadset.log("sendVendorSpecificResultCode()");
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.sendVendorSpecificResultCode(device, command, arg, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_PHONE_STATE"})
    @UnsupportedAppUsage(trackingBug=171933273L)
    public boolean setActiveDevice(BluetoothDevice device) {
        Log.d(TAG, "setActiveDevice: " + device);
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && (device == null || BluetoothHeadset.isValidDevice(device))) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setActiveDevice(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(trackingBug=171933273L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice getActiveDevice() {
        IBluetoothHeadset service = this.mService;
        BluetoothDevice defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActiveDevice(this.mAttributionSource, recv);
                return Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isInbandRingingEnabled() {
        BluetoothHeadset.log("isInbandRingingEnabled()");
        IBluetoothHeadset service = this.mService;
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHeadset.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isInbandRingingEnabled(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isDisabled() {
        return this.mAdapter.getState() == 10;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisconnectAudioReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectAudioReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetAudioRouteAllowedReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetAudioRouteAllowedReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetAudioStateReturnValues {
    }
}

