/*
 * Decompiled with CFR 0.152.
 */
package android.app.wallpapereffectsgeneration;

import android.annotation.SystemApi;
import android.app.wallpapereffectsgeneration.CameraAttributes;
import android.app.wallpapereffectsgeneration.TexturedMesh;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class CinematicEffectResponse
implements Parcelable {
    public static final int CINEMATIC_EFFECT_STATUS_ERROR = 0;
    public static final int CINEMATIC_EFFECT_STATUS_OK = 1;
    public static final int CINEMATIC_EFFECT_STATUS_NOT_READY = 2;
    public static final int CINEMATIC_EFFECT_STATUS_PENDING = 3;
    public static final int CINEMATIC_EFFECT_STATUS_TOO_MANY_REQUESTS = 4;
    public static final int CINEMATIC_EFFECT_STATUS_FEATURE_DISABLED = 5;
    public static final int CINEMATIC_EFFECT_STATUS_IMAGE_FORMAT_NOT_SUITABLE = 6;
    public static final int CINEMATIC_EFFECT_STATUS_CONTENT_UNSUPPORTED = 7;
    public static final int CINEMATIC_EFFECT_STATUS_CONTENT_TARGET_ERROR = 8;
    public static final int CINEMATIC_EFFECT_STATUS_CONTENT_TOO_FLAT = 9;
    public static final int CINEMATIC_EFFECT_STATUS_ANIMATION_FAILURE = 10;
    public static final int IMAGE_CONTENT_TYPE_UNKNOWN = 0;
    public static final int IMAGE_CONTENT_TYPE_PEOPLE_PORTRAIT = 1;
    public static final int IMAGE_CONTENT_TYPE_LANDSCAPE = 2;
    public static final int IMAGE_CONTENT_TYPE_OTHER = 3;
    private int mStatusCode;
    private String mTaskId;
    private int mImageContentType;
    private List<TexturedMesh> mTexturedMeshes;
    private CameraAttributes mStartKeyFrame;
    private CameraAttributes mEndKeyFrame;
    public static final Parcelable.Creator<CinematicEffectResponse> CREATOR = new Parcelable.Creator<CinematicEffectResponse>(){

        @Override
        public CinematicEffectResponse createFromParcel(Parcel in) {
            return new CinematicEffectResponse(in);
        }

        public CinematicEffectResponse[] newArray(int size) {
            return new CinematicEffectResponse[size];
        }
    };

    private CinematicEffectResponse(Parcel in) {
        this.mStatusCode = in.readInt();
        this.mTaskId = in.readString();
        this.mImageContentType = in.readInt();
        this.mTexturedMeshes = new ArrayList<TexturedMesh>();
        in.readTypedList(this.mTexturedMeshes, TexturedMesh.CREATOR);
        this.mStartKeyFrame = in.readTypedObject(CameraAttributes.CREATOR);
        this.mEndKeyFrame = in.readTypedObject(CameraAttributes.CREATOR);
    }

    private CinematicEffectResponse(int statusCode, String taskId, int imageContentType, List<TexturedMesh> texturedMeshes, CameraAttributes startKeyFrame, CameraAttributes endKeyFrame) {
        this.mStatusCode = statusCode;
        this.mTaskId = taskId;
        this.mImageContentType = imageContentType;
        this.mStartKeyFrame = startKeyFrame;
        this.mEndKeyFrame = endKeyFrame;
        this.mTexturedMeshes = texturedMeshes;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getTaskId() {
        return this.mTaskId;
    }

    public int getImageContentType() {
        return this.mImageContentType;
    }

    public List<TexturedMesh> getTexturedMeshes() {
        return this.mTexturedMeshes;
    }

    public CameraAttributes getStartKeyFrame() {
        return this.mStartKeyFrame;
    }

    public CameraAttributes getEndKeyFrame() {
        return this.mEndKeyFrame;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mTaskId);
        out.writeInt(this.mImageContentType);
        out.writeTypedList(this.mTexturedMeshes, flags);
        out.writeTypedObject(this.mStartKeyFrame, flags);
        out.writeTypedObject(this.mEndKeyFrame, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CinematicEffectResponse that = (CinematicEffectResponse)o;
        return this.mTaskId.equals(that.mTaskId);
    }

    public int hashCode() {
        return Objects.hash(this.mTaskId);
    }

    @SystemApi
    public static class Builder {
        private int mStatusCode;
        private String mTaskId;
        private int mImageContentType;
        private List<TexturedMesh> mTexturedMeshes;
        private CameraAttributes mStartKeyFrame;
        private CameraAttributes mEndKeyFrame;

        @SystemApi
        public Builder(int statusCode, String taskId) {
            this.mStatusCode = statusCode;
            this.mTaskId = taskId;
        }

        public Builder setImageContentType(int imageContentType) {
            this.mImageContentType = imageContentType;
            return this;
        }

        public Builder setTexturedMeshes(List<TexturedMesh> texturedMeshes) {
            this.mTexturedMeshes = texturedMeshes;
            return this;
        }

        public Builder setStartKeyFrame(CameraAttributes startKeyFrame) {
            this.mStartKeyFrame = startKeyFrame;
            return this;
        }

        public Builder setEndKeyFrame(CameraAttributes endKeyFrame) {
            this.mEndKeyFrame = endKeyFrame;
            return this;
        }

        public CinematicEffectResponse build() {
            if (this.mTexturedMeshes == null) {
                this.mTexturedMeshes = new ArrayList<TexturedMesh>(0);
            }
            return new CinematicEffectResponse(this.mStatusCode, this.mTaskId, this.mImageContentType, this.mTexturedMeshes, this.mStartKeyFrame, this.mEndKeyFrame);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImageContentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CinematicEffectStatusCode {
    }
}

