/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TimeConfiguration
implements Parcelable {
    public static final Parcelable.Creator<TimeConfiguration> CREATOR = new Parcelable.Creator<TimeConfiguration>(){

        @Override
        public TimeConfiguration createFromParcel(Parcel source) {
            return TimeConfiguration.readFromParcel(source);
        }

        public TimeConfiguration[] newArray(int size) {
            return new TimeConfiguration[size];
        }
    };
    private static final String SETTING_AUTO_DETECTION_ENABLED = "autoDetectionEnabled";
    private final Bundle mBundle;

    private TimeConfiguration(Builder builder) {
        this.mBundle = builder.mBundle;
    }

    public boolean isAutoDetectionEnabled() {
        return this.mBundle.getBoolean(SETTING_AUTO_DETECTION_ENABLED);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    private static TimeConfiguration readFromParcel(Parcel in) {
        return new Builder().merge(in.readBundle()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeConfiguration that = (TimeConfiguration)o;
        return this.mBundle.kindofEquals(that.mBundle);
    }

    public int hashCode() {
        return Objects.hash(this.mBundle);
    }

    public String toString() {
        return "TimeConfiguration{mBundle=" + this.mBundle + '}';
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();

        public Builder() {
        }

        public Builder(TimeConfiguration configuration) {
            this.mBundle.putAll(configuration.mBundle);
        }

        public Builder setAutoDetectionEnabled(boolean enabled) {
            this.mBundle.putBoolean(TimeConfiguration.SETTING_AUTO_DETECTION_ENABLED, enabled);
            return this;
        }

        Builder merge(Bundle bundle) {
            this.mBundle.putAll(bundle);
            return this;
        }

        public TimeConfiguration build() {
            return new TimeConfiguration(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Setting {
    }
}

