/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.app.job.JobInfo;
import android.app.job.JobWorkItem;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IJobScheduler
extends IInterface {
    public int schedule(JobInfo var1) throws RemoteException;

    public int enqueue(JobInfo var1, JobWorkItem var2) throws RemoteException;

    public int scheduleAsPackage(JobInfo var1, String var2, int var3, String var4) throws RemoteException;

    public void cancel(int var1) throws RemoteException;

    public void cancelAll() throws RemoteException;

    public ParceledListSlice getAllPendingJobs() throws RemoteException;

    public JobInfo getPendingJob(int var1) throws RemoteException;

    public List<JobInfo> getStartedJobs() throws RemoteException;

    public ParceledListSlice getAllJobSnapshots() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IJobScheduler {
        public static final String DESCRIPTOR = "android.app.job.IJobScheduler";
        static final int TRANSACTION_schedule = 1;
        static final int TRANSACTION_enqueue = 2;
        static final int TRANSACTION_scheduleAsPackage = 3;
        static final int TRANSACTION_cancel = 4;
        static final int TRANSACTION_cancelAll = 5;
        static final int TRANSACTION_getAllPendingJobs = 6;
        static final int TRANSACTION_getPendingJob = 7;
        static final int TRANSACTION_getStartedJobs = 8;
        static final int TRANSACTION_getAllJobSnapshots = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IJobScheduler asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IJobScheduler) {
                return (IJobScheduler)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "schedule";
                }
                case 2: {
                    return "enqueue";
                }
                case 3: {
                    return "scheduleAsPackage";
                }
                case 4: {
                    return "cancel";
                }
                case 5: {
                    return "cancelAll";
                }
                case 6: {
                    return "getAllPendingJobs";
                }
                case 7: {
                    return "getPendingJob";
                }
                case 8: {
                    return "getStartedJobs";
                }
                case 9: {
                    return "getAllJobSnapshots";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    JobInfo _arg0 = data.readTypedObject(JobInfo.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.schedule(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    JobInfo _arg0 = data.readTypedObject(JobInfo.CREATOR);
                    JobWorkItem _arg1 = data.readTypedObject(JobWorkItem.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.enqueue(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    JobInfo _arg0 = data.readTypedObject(JobInfo.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.scheduleAsPackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancel(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.cancelAll();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ParceledListSlice _result = this.getAllPendingJobs();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    JobInfo _result = this.getPendingJob(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    List<JobInfo> _result = this.getStartedJobs();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 9: {
                    ParceledListSlice _result = this.getAllJobSnapshots();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IJobScheduler {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int schedule(JobInfo job) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(job, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enqueue(JobInfo job, JobWorkItem work) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(job, 0);
                    _data.writeTypedObject(work, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int scheduleAsPackage(JobInfo job, String packageName, int userId, String tag) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(job, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel(int jobId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAll() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAllPendingJobs() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JobInfo getPendingJob(int jobId) throws RemoteException {
                JobInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(JobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<JobInfo> getStartedJobs() throws RemoteException {
                ArrayList<JobInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(JobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAllJobSnapshots() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IJobScheduler {
        @Override
        public int schedule(JobInfo job) throws RemoteException {
            return 0;
        }

        @Override
        public int enqueue(JobInfo job, JobWorkItem work) throws RemoteException {
            return 0;
        }

        @Override
        public int scheduleAsPackage(JobInfo job, String packageName, int userId, String tag) throws RemoteException {
            return 0;
        }

        @Override
        public void cancel(int jobId) throws RemoteException {
        }

        @Override
        public void cancelAll() throws RemoteException {
        }

        @Override
        public ParceledListSlice getAllPendingJobs() throws RemoteException {
            return null;
        }

        @Override
        public JobInfo getPendingJob(int jobId) throws RemoteException {
            return null;
        }

        @Override
        public List<JobInfo> getStartedJobs() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAllJobSnapshots() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

