/*
 * Decompiled with CFR 0.152.
 */
package android.app.contentsuggestions;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.contentsuggestions.ClassificationsRequest;
import android.app.contentsuggestions.ContentClassification;
import android.app.contentsuggestions.ContentSelection;
import android.app.contentsuggestions.IClassificationsCallback;
import android.app.contentsuggestions.IContentSuggestionsManager;
import android.app.contentsuggestions.ISelectionsCallback;
import android.app.contentsuggestions.SelectionsRequest;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.SyncResultReceiver;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public class ContentSuggestionsManager {
    public static final String EXTRA_BITMAP = "android.contentsuggestions.extra.BITMAP";
    private static final String TAG = ContentSuggestionsManager.class.getSimpleName();
    private static final int SYNC_CALLS_TIMEOUT_MS = 5000;
    private final IContentSuggestionsManager mService;
    private final int mUser;

    public ContentSuggestionsManager(int userId, IContentSuggestionsManager service) {
        this.mService = service;
        this.mUser = userId;
    }

    public void provideContextImage(Bitmap bitmap, Bundle imageContextRequestExtras) {
        if (this.mService == null) {
            Log.e(TAG, "provideContextImage called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.provideContextBitmap(this.mUser, bitmap, imageContextRequestExtras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void provideContextImage(int taskId, Bundle imageContextRequestExtras) {
        if (this.mService == null) {
            Log.e(TAG, "provideContextImage called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.provideContextImage(this.mUser, taskId, imageContextRequestExtras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void suggestContentSelections(SelectionsRequest request, Executor callbackExecutor, SelectionsCallback callback) {
        if (this.mService == null) {
            Log.e(TAG, "suggestContentSelections called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.suggestContentSelections(this.mUser, request, new SelectionsCallbackWrapper(callback, callbackExecutor));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void classifyContentSelections(ClassificationsRequest request, Executor callbackExecutor, ClassificationsCallback callback) {
        if (this.mService == null) {
            Log.e(TAG, "classifyContentSelections called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.classifyContentSelections(this.mUser, request, new ClassificationsCallbackWrapper(callback, callbackExecutor));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyInteraction(String requestId, Bundle interaction) {
        if (this.mService == null) {
            Log.e(TAG, "notifyInteraction called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.notifyInteraction(this.mUser, requestId, interaction);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isEnabled() {
        if (this.mService == null) {
            return false;
        }
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.isEnabled(this.mUser, receiver);
            return receiver.getIntResult() != 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get the enable status.");
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_SUGGESTIONS")
    public void resetTemporaryService(int userId) {
        if (this.mService == null) {
            Log.e(TAG, "resetTemporaryService called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.resetTemporaryService(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_SUGGESTIONS")
    public void setTemporaryService(int userId, String serviceName, int duration) {
        if (this.mService == null) {
            Log.e(TAG, "setTemporaryService called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.setTemporaryService(userId, serviceName, duration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_SUGGESTIONS")
    public void setDefaultServiceEnabled(int userId, boolean enabled) {
        if (this.mService == null) {
            Log.e(TAG, "setDefaultServiceEnabled called, but no ContentSuggestionsManager configured");
            return;
        }
        try {
            this.mService.setDefaultServiceEnabled(userId, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class ClassificationsCallbackWrapper
    extends IClassificationsCallback.Stub {
        private final ClassificationsCallback mCallback;
        private final Executor mExecutor;

        ClassificationsCallbackWrapper(ClassificationsCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContentClassificationsAvailable(int statusCode, List<ContentClassification> classifications) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onContentClassificationsAvailable(statusCode, classifications));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class SelectionsCallbackWrapper
    extends ISelectionsCallback.Stub {
        private final SelectionsCallback mCallback;
        private final Executor mExecutor;

        SelectionsCallbackWrapper(SelectionsCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContentSelectionsAvailable(int statusCode, List<ContentSelection> selections) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onContentSelectionsAvailable(statusCode, selections));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface ClassificationsCallback {
        public void onContentClassificationsAvailable(int var1, List<ContentClassification> var2);
    }

    public static interface SelectionsCallback {
        public void onContentSelectionsAvailable(int var1, List<ContentSelection> var2);
    }
}

