/*
 * Decompiled with CFR 0.152.
 */
package android.app.cloudsearch;

import android.annotation.SystemApi;
import android.app.cloudsearch.SearchResult;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class SearchResponse
implements Parcelable {
    public static final int SEARCH_STATUS_UNKNOWN = -1;
    public static final int SEARCH_STATUS_OK = 0;
    public static final int SEARCH_STATUS_TIME_OUT = 1;
    public static final int SEARCH_STATUS_NO_INTERNET = 2;
    private final int mStatusCode;
    private String mSource;
    private final List<SearchResult> mSearchResults;
    public static final Parcelable.Creator<SearchResponse> CREATOR = new Parcelable.Creator<SearchResponse>(){

        @Override
        public SearchResponse createFromParcel(Parcel p) {
            return new SearchResponse(p);
        }

        public SearchResponse[] newArray(int size) {
            return new SearchResponse[size];
        }
    };

    private SearchResponse(Parcel in) {
        this.mStatusCode = in.readInt();
        this.mSource = in.readString();
        this.mSearchResults = in.createTypedArrayList(SearchResult.CREATOR);
    }

    private SearchResponse(@SearchStatusCode int statusCode, String source, List<SearchResult> searchResults) {
        this.mStatusCode = statusCode;
        this.mSource = source;
        this.mSearchResults = searchResults;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getSource() {
        return this.mSource;
    }

    public List<SearchResult> getSearchResults() {
        return this.mSearchResults;
    }

    public void setSource(String source) {
        this.mSource = source;
    }

    private SearchResponse(Builder b) {
        this.mStatusCode = b.mStatusCode;
        this.mSource = Objects.requireNonNull(b.mSource);
        this.mSearchResults = Objects.requireNonNull(b.mSearchResults);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatusCode);
        dest.writeString(this.mSource);
        dest.writeTypedList(this.mSearchResults);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResponse that = (SearchResponse)obj;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mSource, that.mSource) && Objects.equals(this.mSearchResults, that.mSearchResults);
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mSource, this.mSearchResults);
    }

    @SystemApi
    public static class Builder {
        private int mStatusCode;
        private String mSource;
        private List<SearchResult> mSearchResults;

        @SystemApi
        public Builder(@SearchStatusCode int statusCode) {
            this.mStatusCode = statusCode;
            this.mSource = "DEFAULT";
            this.mSearchResults = new ArrayList<SearchResult>();
        }

        public Builder setStatusCode(@SearchStatusCode int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        public Builder setSource(String source) {
            this.mSource = source;
            return this;
        }

        public Builder setSearchResults(List<SearchResult> searchResults) {
            this.mSearchResults = searchResults;
            return this;
        }

        public SearchResponse build() {
            if (this.mStatusCode < -1 || this.mStatusCode > 2 || this.mSearchResults == null) {
                throw new IllegalStateException("Please make sure all @NonNull args are assigned.");
            }
            return new SearchResponse(this.mStatusCode, this.mSource, this.mSearchResults);
        }
    }

    public static @interface SearchStatusCode {
    }
}

