/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IBackupManager
extends IInterface {
    public void dataChangedForUser(int var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:57:1:57:25")
    public void dataChanged(String var1) throws RemoteException;

    public void clearBackupDataForUser(int var1, String var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:77:1:77:69")
    public void clearBackupData(String var1, String var2) throws RemoteException;

    public void initializeTransportsForUser(int var1, String[] var2, IBackupObserver var3) throws RemoteException;

    public void agentConnectedForUser(int var1, String var2, IBinder var3) throws RemoteException;

    public void agentConnected(String var1, IBinder var2) throws RemoteException;

    public void agentDisconnectedForUser(int var1, String var2) throws RemoteException;

    public void agentDisconnected(String var1) throws RemoteException;

    public void restoreAtInstallForUser(int var1, String var2, int var3) throws RemoteException;

    public void restoreAtInstall(String var1, int var2) throws RemoteException;

    public void setBackupEnabledForUser(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:160:1:160:69")
    public void setBackupEnabled(boolean var1) throws RemoteException;

    public void setAutoRestoreForUser(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:184:1:184:69")
    public void setAutoRestore(boolean var1) throws RemoteException;

    public boolean isBackupEnabledForUser(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:201:1:201:69")
    public boolean isBackupEnabled() throws RemoteException;

    public boolean setBackupPassword(String var1, String var2) throws RemoteException;

    public boolean hasBackupPassword() throws RemoteException;

    public void backupNowForUser(int var1) throws RemoteException;

    public void backupNow() throws RemoteException;

    public void adbBackup(int var1, ParcelFileDescriptor var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, String[] var11) throws RemoteException;

    public void fullTransportBackupForUser(int var1, String[] var2) throws RemoteException;

    public void adbRestore(int var1, ParcelFileDescriptor var2) throws RemoteException;

    public void acknowledgeFullBackupOrRestoreForUser(int var1, int var2, boolean var3, String var4, String var5, IFullBackupRestoreObserver var6) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:330:1:330:69")
    public void acknowledgeFullBackupOrRestore(int var1, boolean var2, String var3, String var4, IFullBackupRestoreObserver var5) throws RemoteException;

    public void updateTransportAttributesForUser(int var1, ComponentName var2, String var3, Intent var4, String var5, Intent var6, CharSequence var7) throws RemoteException;

    public String getCurrentTransportForUser(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:380:1:380:25")
    public String getCurrentTransport() throws RemoteException;

    public ComponentName getCurrentTransportComponentForUser(int var1) throws RemoteException;

    public String[] listAllTransportsForUser(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:407:1:407:69")
    public String[] listAllTransports() throws RemoteException;

    public ComponentName[] listAllTransportComponentsForUser(int var1) throws RemoteException;

    public String[] getTransportWhitelist() throws RemoteException;

    public String selectBackupTransportForUser(int var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:445:1:445:69")
    public String selectBackupTransport(String var1) throws RemoteException;

    public void selectBackupTransportAsyncForUser(int var1, ComponentName var2, ISelectBackupTransportCallback var3) throws RemoteException;

    public Intent getConfigurationIntentForUser(int var1, String var2) throws RemoteException;

    public Intent getConfigurationIntent(String var1) throws RemoteException;

    public String getDestinationStringForUser(int var1, String var2) throws RemoteException;

    public String getDestinationString(String var1) throws RemoteException;

    public Intent getDataManagementIntentForUser(int var1, String var2) throws RemoteException;

    public Intent getDataManagementIntent(String var1) throws RemoteException;

    public CharSequence getDataManagementLabelForUser(int var1, String var2) throws RemoteException;

    public IRestoreSession beginRestoreSessionForUser(int var1, String var2, String var3) throws RemoteException;

    public void opCompleteForUser(int var1, int var2, long var3) throws RemoteException;

    public void opComplete(int var1, long var2) throws RemoteException;

    public void setBackupServiceActive(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/backup/IBackupManager.aidl:596:1:596:69")
    public boolean isBackupServiceActive(int var1) throws RemoteException;

    public boolean isUserReadyForBackup(int var1) throws RemoteException;

    public long getAvailableRestoreTokenForUser(int var1, String var2) throws RemoteException;

    public boolean isAppEligibleForBackupForUser(int var1, String var2) throws RemoteException;

    public String[] filterAppsEligibleForBackupForUser(int var1, String[] var2) throws RemoteException;

    public int requestBackupForUser(int var1, String[] var2, IBackupObserver var3, IBackupManagerMonitor var4, int var5) throws RemoteException;

    public int requestBackup(String[] var1, IBackupObserver var2, IBackupManagerMonitor var3, int var4) throws RemoteException;

    public void cancelBackupsForUser(int var1) throws RemoteException;

    public void cancelBackups() throws RemoteException;

    public UserHandle getUserForAncestralSerialNumber(long var1) throws RemoteException;

    public void setAncestralSerialNumber(long var1) throws RemoteException;

    public void excludeKeysFromRestore(String var1, List<String> var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackupManager {
        public static final String DESCRIPTOR = "android.app.backup.IBackupManager";
        static final int TRANSACTION_dataChangedForUser = 1;
        static final int TRANSACTION_dataChanged = 2;
        static final int TRANSACTION_clearBackupDataForUser = 3;
        static final int TRANSACTION_clearBackupData = 4;
        static final int TRANSACTION_initializeTransportsForUser = 5;
        static final int TRANSACTION_agentConnectedForUser = 6;
        static final int TRANSACTION_agentConnected = 7;
        static final int TRANSACTION_agentDisconnectedForUser = 8;
        static final int TRANSACTION_agentDisconnected = 9;
        static final int TRANSACTION_restoreAtInstallForUser = 10;
        static final int TRANSACTION_restoreAtInstall = 11;
        static final int TRANSACTION_setBackupEnabledForUser = 12;
        static final int TRANSACTION_setBackupEnabled = 13;
        static final int TRANSACTION_setAutoRestoreForUser = 14;
        static final int TRANSACTION_setAutoRestore = 15;
        static final int TRANSACTION_isBackupEnabledForUser = 16;
        static final int TRANSACTION_isBackupEnabled = 17;
        static final int TRANSACTION_setBackupPassword = 18;
        static final int TRANSACTION_hasBackupPassword = 19;
        static final int TRANSACTION_backupNowForUser = 20;
        static final int TRANSACTION_backupNow = 21;
        static final int TRANSACTION_adbBackup = 22;
        static final int TRANSACTION_fullTransportBackupForUser = 23;
        static final int TRANSACTION_adbRestore = 24;
        static final int TRANSACTION_acknowledgeFullBackupOrRestoreForUser = 25;
        static final int TRANSACTION_acknowledgeFullBackupOrRestore = 26;
        static final int TRANSACTION_updateTransportAttributesForUser = 27;
        static final int TRANSACTION_getCurrentTransportForUser = 28;
        static final int TRANSACTION_getCurrentTransport = 29;
        static final int TRANSACTION_getCurrentTransportComponentForUser = 30;
        static final int TRANSACTION_listAllTransportsForUser = 31;
        static final int TRANSACTION_listAllTransports = 32;
        static final int TRANSACTION_listAllTransportComponentsForUser = 33;
        static final int TRANSACTION_getTransportWhitelist = 34;
        static final int TRANSACTION_selectBackupTransportForUser = 35;
        static final int TRANSACTION_selectBackupTransport = 36;
        static final int TRANSACTION_selectBackupTransportAsyncForUser = 37;
        static final int TRANSACTION_getConfigurationIntentForUser = 38;
        static final int TRANSACTION_getConfigurationIntent = 39;
        static final int TRANSACTION_getDestinationStringForUser = 40;
        static final int TRANSACTION_getDestinationString = 41;
        static final int TRANSACTION_getDataManagementIntentForUser = 42;
        static final int TRANSACTION_getDataManagementIntent = 43;
        static final int TRANSACTION_getDataManagementLabelForUser = 44;
        static final int TRANSACTION_beginRestoreSessionForUser = 45;
        static final int TRANSACTION_opCompleteForUser = 46;
        static final int TRANSACTION_opComplete = 47;
        static final int TRANSACTION_setBackupServiceActive = 48;
        static final int TRANSACTION_isBackupServiceActive = 49;
        static final int TRANSACTION_isUserReadyForBackup = 50;
        static final int TRANSACTION_getAvailableRestoreTokenForUser = 51;
        static final int TRANSACTION_isAppEligibleForBackupForUser = 52;
        static final int TRANSACTION_filterAppsEligibleForBackupForUser = 53;
        static final int TRANSACTION_requestBackupForUser = 54;
        static final int TRANSACTION_requestBackup = 55;
        static final int TRANSACTION_cancelBackupsForUser = 56;
        static final int TRANSACTION_cancelBackups = 57;
        static final int TRANSACTION_getUserForAncestralSerialNumber = 58;
        static final int TRANSACTION_setAncestralSerialNumber = 59;
        static final int TRANSACTION_excludeKeysFromRestore = 60;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBackupManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBackupManager) {
                return (IBackupManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dataChangedForUser";
                }
                case 2: {
                    return "dataChanged";
                }
                case 3: {
                    return "clearBackupDataForUser";
                }
                case 4: {
                    return "clearBackupData";
                }
                case 5: {
                    return "initializeTransportsForUser";
                }
                case 6: {
                    return "agentConnectedForUser";
                }
                case 7: {
                    return "agentConnected";
                }
                case 8: {
                    return "agentDisconnectedForUser";
                }
                case 9: {
                    return "agentDisconnected";
                }
                case 10: {
                    return "restoreAtInstallForUser";
                }
                case 11: {
                    return "restoreAtInstall";
                }
                case 12: {
                    return "setBackupEnabledForUser";
                }
                case 13: {
                    return "setBackupEnabled";
                }
                case 14: {
                    return "setAutoRestoreForUser";
                }
                case 15: {
                    return "setAutoRestore";
                }
                case 16: {
                    return "isBackupEnabledForUser";
                }
                case 17: {
                    return "isBackupEnabled";
                }
                case 18: {
                    return "setBackupPassword";
                }
                case 19: {
                    return "hasBackupPassword";
                }
                case 20: {
                    return "backupNowForUser";
                }
                case 21: {
                    return "backupNow";
                }
                case 22: {
                    return "adbBackup";
                }
                case 23: {
                    return "fullTransportBackupForUser";
                }
                case 24: {
                    return "adbRestore";
                }
                case 25: {
                    return "acknowledgeFullBackupOrRestoreForUser";
                }
                case 26: {
                    return "acknowledgeFullBackupOrRestore";
                }
                case 27: {
                    return "updateTransportAttributesForUser";
                }
                case 28: {
                    return "getCurrentTransportForUser";
                }
                case 29: {
                    return "getCurrentTransport";
                }
                case 30: {
                    return "getCurrentTransportComponentForUser";
                }
                case 31: {
                    return "listAllTransportsForUser";
                }
                case 32: {
                    return "listAllTransports";
                }
                case 33: {
                    return "listAllTransportComponentsForUser";
                }
                case 34: {
                    return "getTransportWhitelist";
                }
                case 35: {
                    return "selectBackupTransportForUser";
                }
                case 36: {
                    return "selectBackupTransport";
                }
                case 37: {
                    return "selectBackupTransportAsyncForUser";
                }
                case 38: {
                    return "getConfigurationIntentForUser";
                }
                case 39: {
                    return "getConfigurationIntent";
                }
                case 40: {
                    return "getDestinationStringForUser";
                }
                case 41: {
                    return "getDestinationString";
                }
                case 42: {
                    return "getDataManagementIntentForUser";
                }
                case 43: {
                    return "getDataManagementIntent";
                }
                case 44: {
                    return "getDataManagementLabelForUser";
                }
                case 45: {
                    return "beginRestoreSessionForUser";
                }
                case 46: {
                    return "opCompleteForUser";
                }
                case 47: {
                    return "opComplete";
                }
                case 48: {
                    return "setBackupServiceActive";
                }
                case 49: {
                    return "isBackupServiceActive";
                }
                case 50: {
                    return "isUserReadyForBackup";
                }
                case 51: {
                    return "getAvailableRestoreTokenForUser";
                }
                case 52: {
                    return "isAppEligibleForBackupForUser";
                }
                case 53: {
                    return "filterAppsEligibleForBackupForUser";
                }
                case 54: {
                    return "requestBackupForUser";
                }
                case 55: {
                    return "requestBackup";
                }
                case 56: {
                    return "cancelBackupsForUser";
                }
                case 57: {
                    return "cancelBackups";
                }
                case 58: {
                    return "getUserForAncestralSerialNumber";
                }
                case 59: {
                    return "setAncestralSerialNumber";
                }
                case 60: {
                    return "excludeKeysFromRestore";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.dataChangedForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.dataChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearBackupDataForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    IBackupObserver _arg2 = IBackupObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.initializeTransportsForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.agentConnectedForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.agentConnected(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.agentDisconnectedForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.agentDisconnected(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restoreAtInstallForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restoreAtInstall(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBackupEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBackupEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutoRestoreForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutoRestore(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isBackupEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    boolean _result = this.isBackupEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setBackupPassword(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    boolean _result = this.hasBackupPassword();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.backupNowForUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    this.backupNow();
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    boolean _arg6 = data.readBoolean();
                    boolean _arg7 = data.readBoolean();
                    boolean _arg8 = data.readBoolean();
                    boolean _arg9 = data.readBoolean();
                    String[] _arg10 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.adbBackup(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.fullTransportBackupForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.adbRestore(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    IFullBackupRestoreObserver _arg5 = IFullBackupRestoreObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acknowledgeFullBackupOrRestoreForUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    IFullBackupRestoreObserver _arg4 = IFullBackupRestoreObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acknowledgeFullBackupOrRestore(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    Intent _arg3 = data.readTypedObject(Intent.CREATOR);
                    String _arg4 = data.readString();
                    Intent _arg5 = data.readTypedObject(Intent.CREATOR);
                    CharSequence _arg6 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.updateTransportAttributesForUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getCurrentTransportForUser(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 29: {
                    String _result = this.getCurrentTransport();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ComponentName _result = this.getCurrentTransportComponentForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String[] _result = this.listAllTransportsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 32: {
                    String[] _result = this.listAllTransports();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.listAllTransportComponentsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 34: {
                    String[] _result = this.getTransportWhitelist();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.selectBackupTransportForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.selectBackupTransport(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    ISelectBackupTransportCallback _arg2 = ISelectBackupTransportCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.selectBackupTransportAsyncForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Intent _result = this.getConfigurationIntentForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Intent _result = this.getConfigurationIntent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getDestinationStringForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getDestinationString(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Intent _result = this.getDataManagementIntentForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Intent _result = this.getDataManagementIntent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    CharSequence _result = this.getDataManagementLabelForUser(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    IRestoreSession _result = this.beginRestoreSessionForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.opCompleteForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.opComplete(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBackupServiceActive(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isBackupServiceActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUserReadyForBackup(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getAvailableRestoreTokenForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAppEligibleForBackupForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    String[] _result = this.filterAppsEligibleForBackupForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    IBackupObserver _arg2 = IBackupObserver.Stub.asInterface(data.readStrongBinder());
                    IBackupManagerMonitor _arg3 = IBackupManagerMonitor.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestBackupForUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 55: {
                    String[] _arg0 = data.createStringArray();
                    IBackupObserver _arg1 = IBackupObserver.Stub.asInterface(data.readStrongBinder());
                    IBackupManagerMonitor _arg2 = IBackupManagerMonitor.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestBackup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelBackupsForUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    this.cancelBackups();
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    UserHandle _result = this.getUserForAncestralSerialNumber(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 59: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setAncestralSerialNumber(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.excludeKeysFromRestore(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 59;
        }

        private static class Proxy
        implements IBackupManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataChangedForUser(int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataChanged(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBackupDataForUser(int userId, String transportName, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transportName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBackupData(String transportName, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(transportName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeTransportsForUser(int userId, String[] transportNames, IBackupObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStringArray(transportNames);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void agentConnectedForUser(int userId, String packageName, IBinder agent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(agent);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void agentConnected(String packageName, IBinder agent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(agent);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void agentDisconnectedForUser(int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void agentDisconnected(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreAtInstallForUser(int userId, String packageName, int token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    _data.writeInt(token);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreAtInstall(String packageName, int token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(token);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBackupEnabledForUser(int userId, boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(isEnabled);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBackupEnabled(boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoRestoreForUser(int userId, boolean doAutoRestore) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(doAutoRestore);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoRestore(boolean doAutoRestore) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(doAutoRestore);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBackupEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBackupEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBackupPassword(String currentPw, String newPw) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(currentPw);
                    _data.writeString(newPw);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasBackupPassword() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void backupNowForUser(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void backupNow() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adbBackup(int userId, ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, boolean doKeyValue, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(fd, 0);
                    _data.writeBoolean(includeApks);
                    _data.writeBoolean(includeObbs);
                    _data.writeBoolean(includeShared);
                    _data.writeBoolean(doWidgets);
                    _data.writeBoolean(allApps);
                    _data.writeBoolean(allIncludesSystem);
                    _data.writeBoolean(doCompress);
                    _data.writeBoolean(doKeyValue);
                    _data.writeStringArray(packageNames);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fullTransportBackupForUser(int userId, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStringArray(packageNames);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adbRestore(int userId, ParcelFileDescriptor fd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(fd, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledgeFullBackupOrRestoreForUser(int userId, int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(token);
                    _data.writeBoolean(allow);
                    _data.writeString(curPassword);
                    _data.writeString(encryptionPassword);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeBoolean(allow);
                    _data.writeString(curPassword);
                    _data.writeString(encryptionPassword);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTransportAttributesForUser(int userId, ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, CharSequence dataManagementLabel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(transportComponent, 0);
                    _data.writeString(name);
                    _data.writeTypedObject(configurationIntent, 0);
                    _data.writeString(currentDestinationString);
                    _data.writeTypedObject(dataManagementIntent, 0);
                    if (dataManagementLabel != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(dataManagementLabel, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentTransportForUser(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentTransport() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getCurrentTransportComponentForUser(int userId) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listAllTransportsForUser(int userId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listAllTransports() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName[] listAllTransportComponentsForUser(int userId) throws RemoteException {
                ComponentName[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTransportWhitelist() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String selectBackupTransportForUser(int userId, String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String selectBackupTransport(String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectBackupTransportAsyncForUser(int userId, ComponentName transport, ISelectBackupTransportCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(transport, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent getConfigurationIntentForUser(int userId, String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent getConfigurationIntent(String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDestinationStringForUser(int userId, String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDestinationString(String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent getDataManagementIntentForUser(int userId, String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent getDataManagementIntent(String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getDataManagementLabelForUser(int userId, String transport) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(transport);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRestoreSession beginRestoreSessionForUser(int userId, String packageName, String transportID) throws RemoteException {
                IRestoreSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    _data.writeString(transportID);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = IRestoreSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opCompleteForUser(int userId, int token, long result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(token);
                    _data.writeLong(result);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opComplete(int token, long result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeLong(result);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBackupServiceActive(int whichUser, boolean makeActive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(whichUser);
                    _data.writeBoolean(makeActive);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBackupServiceActive(int whichUser) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(whichUser);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUserReadyForBackup(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAvailableRestoreTokenForUser(int userId, String packageName) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAppEligibleForBackupForUser(int userId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] filterAppsEligibleForBackupForUser(int userId, String[] packages) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStringArray(packages);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestBackupForUser(int userId, String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStringArray(packages);
                    _data.writeStrongInterface(observer);
                    _data.writeStrongInterface(monitor);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packages);
                    _data.writeStrongInterface(observer);
                    _data.writeStrongInterface(monitor);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelBackupsForUser(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelBackups() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserHandle getUserForAncestralSerialNumber(long ancestralSerialNumber) throws RemoteException {
                UserHandle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(ancestralSerialNumber);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UserHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAncestralSerialNumber(long ancestralSerialNumber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(ancestralSerialNumber);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void excludeKeysFromRestore(String packageName, List<String> keys) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(keys);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBackupManager {
        @Override
        public void dataChangedForUser(int userId, String packageName) throws RemoteException {
        }

        @Override
        public void dataChanged(String packageName) throws RemoteException {
        }

        @Override
        public void clearBackupDataForUser(int userId, String transportName, String packageName) throws RemoteException {
        }

        @Override
        public void clearBackupData(String transportName, String packageName) throws RemoteException {
        }

        @Override
        public void initializeTransportsForUser(int userId, String[] transportNames, IBackupObserver observer) throws RemoteException {
        }

        @Override
        public void agentConnectedForUser(int userId, String packageName, IBinder agent) throws RemoteException {
        }

        @Override
        public void agentConnected(String packageName, IBinder agent) throws RemoteException {
        }

        @Override
        public void agentDisconnectedForUser(int userId, String packageName) throws RemoteException {
        }

        @Override
        public void agentDisconnected(String packageName) throws RemoteException {
        }

        @Override
        public void restoreAtInstallForUser(int userId, String packageName, int token) throws RemoteException {
        }

        @Override
        public void restoreAtInstall(String packageName, int token) throws RemoteException {
        }

        @Override
        public void setBackupEnabledForUser(int userId, boolean isEnabled) throws RemoteException {
        }

        @Override
        public void setBackupEnabled(boolean isEnabled) throws RemoteException {
        }

        @Override
        public void setAutoRestoreForUser(int userId, boolean doAutoRestore) throws RemoteException {
        }

        @Override
        public void setAutoRestore(boolean doAutoRestore) throws RemoteException {
        }

        @Override
        public boolean isBackupEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isBackupEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean setBackupPassword(String currentPw, String newPw) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasBackupPassword() throws RemoteException {
            return false;
        }

        @Override
        public void backupNowForUser(int userId) throws RemoteException {
        }

        @Override
        public void backupNow() throws RemoteException {
        }

        @Override
        public void adbBackup(int userId, ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, boolean doKeyValue, String[] packageNames) throws RemoteException {
        }

        @Override
        public void fullTransportBackupForUser(int userId, String[] packageNames) throws RemoteException {
        }

        @Override
        public void adbRestore(int userId, ParcelFileDescriptor fd) throws RemoteException {
        }

        @Override
        public void acknowledgeFullBackupOrRestoreForUser(int userId, int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        }

        @Override
        public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        }

        @Override
        public void updateTransportAttributesForUser(int userId, ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, CharSequence dataManagementLabel) throws RemoteException {
        }

        @Override
        public String getCurrentTransportForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getCurrentTransport() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getCurrentTransportComponentForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] listAllTransportsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] listAllTransports() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName[] listAllTransportComponentsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] getTransportWhitelist() throws RemoteException {
            return null;
        }

        @Override
        public String selectBackupTransportForUser(int userId, String transport) throws RemoteException {
            return null;
        }

        @Override
        public String selectBackupTransport(String transport) throws RemoteException {
            return null;
        }

        @Override
        public void selectBackupTransportAsyncForUser(int userId, ComponentName transport, ISelectBackupTransportCallback listener) throws RemoteException {
        }

        @Override
        public Intent getConfigurationIntentForUser(int userId, String transport) throws RemoteException {
            return null;
        }

        @Override
        public Intent getConfigurationIntent(String transport) throws RemoteException {
            return null;
        }

        @Override
        public String getDestinationStringForUser(int userId, String transport) throws RemoteException {
            return null;
        }

        @Override
        public String getDestinationString(String transport) throws RemoteException {
            return null;
        }

        @Override
        public Intent getDataManagementIntentForUser(int userId, String transport) throws RemoteException {
            return null;
        }

        @Override
        public Intent getDataManagementIntent(String transport) throws RemoteException {
            return null;
        }

        @Override
        public CharSequence getDataManagementLabelForUser(int userId, String transport) throws RemoteException {
            return null;
        }

        @Override
        public IRestoreSession beginRestoreSessionForUser(int userId, String packageName, String transportID) throws RemoteException {
            return null;
        }

        @Override
        public void opCompleteForUser(int userId, int token, long result) throws RemoteException {
        }

        @Override
        public void opComplete(int token, long result) throws RemoteException {
        }

        @Override
        public void setBackupServiceActive(int whichUser, boolean makeActive) throws RemoteException {
        }

        @Override
        public boolean isBackupServiceActive(int whichUser) throws RemoteException {
            return false;
        }

        @Override
        public boolean isUserReadyForBackup(int userId) throws RemoteException {
            return false;
        }

        @Override
        public long getAvailableRestoreTokenForUser(int userId, String packageName) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean isAppEligibleForBackupForUser(int userId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public String[] filterAppsEligibleForBackupForUser(int userId, String[] packages) throws RemoteException {
            return null;
        }

        @Override
        public int requestBackupForUser(int userId, String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
            return 0;
        }

        @Override
        public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
            return 0;
        }

        @Override
        public void cancelBackupsForUser(int userId) throws RemoteException {
        }

        @Override
        public void cancelBackups() throws RemoteException {
        }

        @Override
        public UserHandle getUserForAncestralSerialNumber(long ancestralSerialNumber) throws RemoteException {
            return null;
        }

        @Override
        public void setAncestralSerialNumber(long ancestralSerialNumber) throws RemoteException {
        }

        @Override
        public void excludeKeysFromRestore(String packageName, List<String> keys) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

