/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchBatchResult;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.aidl.AppSearchBatchResultParcel;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchBatchResultCallback;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SearchSessionUtil {
    private static final String TAG = "AppSearchSessionUtil";

    private SearchSessionUtil() {
    }

    public static void sendSystemErrorToCallback(AppSearchResult<?> failedResult, BatchResultCallback<?, ?> callback) {
        Preconditions.checkArgument(!failedResult.isSuccess());
        AppSearchException throwable = new AppSearchException(failedResult.getResultCode(), failedResult.getErrorMessage());
        callback.onSystemError(throwable);
    }

    public static <T> void safeExecute(Executor executor, Consumer<AppSearchResult<T>> errorCallback, Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (Throwable t) {
            Log.e(TAG, "Failed to schedule runnable", t);
            errorCallback.accept(AppSearchResult.throwableToFailedResult(t));
        }
    }

    public static void safeExecute(Executor executor, BatchResultCallback<?, ?> errorCallback, Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (Throwable t) {
            Log.e(TAG, "Failed to schedule runnable", t);
            errorCallback.onSystemError(t);
        }
    }

    public static IAppSearchBatchResultCallback createGetDocumentCallback(final Executor executor, final BatchResultCallback<String, GenericDocument> callback) {
        return new IAppSearchBatchResultCallback.Stub(){

            @Override
            public void onResult(AppSearchBatchResultParcel resultParcel) {
                SearchSessionUtil.safeExecute(executor, callback, () -> {
                    AppSearchBatchResult result = resultParcel.getResult();
                    AppSearchBatchResult.Builder<String, GenericDocument> documentResultBuilder = new AppSearchBatchResult.Builder<String, GenericDocument>();
                    for (Map.Entry entry : result.getSuccesses().entrySet()) {
                        GenericDocument document;
                        try {
                            document = new GenericDocument((Bundle)entry.getValue());
                        }
                        catch (Throwable t) {
                            documentResultBuilder.setFailure(entry.getKey(), 2, t.getMessage());
                            continue;
                        }
                        documentResultBuilder.setSuccess(entry.getKey(), document);
                    }
                    for (Map.Entry<String, Object> entry : result.getFailures().entrySet()) {
                        documentResultBuilder.setFailure(entry.getKey(), ((AppSearchResult)entry.getValue()).getResultCode(), ((AppSearchResult)entry.getValue()).getErrorMessage());
                    }
                    callback.onResult(documentResultBuilder.build());
                });
            }

            @Override
            public void onSystemError(AppSearchResultParcel result) {
                SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(result.getResult(), callback));
            }
        };
    }
}

