/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GetByDocumentIdRequest {
    public static final String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";
    private final String mNamespace;
    private final Set<String> mIds;
    private final Map<String, List<String>> mTypePropertyPathsMap;

    GetByDocumentIdRequest(String namespace, Set<String> ids, Map<String, List<String>> typePropertyPathsMap) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mIds = Objects.requireNonNull(ids);
        this.mTypePropertyPathsMap = Objects.requireNonNull(typePropertyPathsMap);
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.mIds);
    }

    public Map<String, List<String>> getProjections() {
        ArrayMap<String, List<String>> copy = new ArrayMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.mTypePropertyPathsMap.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    public Map<String, List<String>> getProjectionsInternal() {
        return this.mTypePropertyPathsMap;
    }

    public static class Builder {
        private final String mNamespace;
        private ArraySet<String> mIds = new ArraySet();
        private ArrayMap<String, List<String>> mProjectionTypePropertyPaths = new ArrayMap();
        private boolean mBuilt = false;

        public Builder(String namespace) {
            this.mNamespace = Objects.requireNonNull(namespace);
        }

        public Builder addIds(String ... ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            return this.addIds(Arrays.asList(ids));
        }

        public Builder addIds(Collection<String> ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            this.mIds.addAll(ids);
            return this;
        }

        public Builder addProjection(String schemaType, Collection<String> propertyPaths) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsList.add(propertyPath);
            }
            this.mProjectionTypePropertyPaths.put(schemaType, propertyPathsList);
            return this;
        }

        public GetByDocumentIdRequest build() {
            this.mBuilt = true;
            return new GetByDocumentIdRequest(this.mNamespace, this.mIds, this.mProjectionTypePropertyPaths);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mIds = new ArraySet<String>(this.mIds);
                this.mProjectionTypePropertyPaths = new ArrayMap<String, List<String>>(this.mProjectionTypePropertyPaths);
                this.mBuilt = false;
            }
        }
    }
}

