/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.Map;
import java.util.Set;

public class ParcelableGranteeMap
implements Parcelable {
    private final Map<Integer, Set<String>> mPackagesByUid;
    public static final Parcelable.Creator<ParcelableGranteeMap> CREATOR = new Parcelable.Creator<ParcelableGranteeMap>(){

        @Override
        public ParcelableGranteeMap createFromParcel(Parcel source) {
            ArrayMap<Integer, Set<String>> packagesByUid = new ArrayMap<Integer, Set<String>>();
            int numUids = source.readInt();
            for (int i = 0; i < numUids; ++i) {
                int uid = source.readInt();
                String[] pkgs = source.readStringArray();
                packagesByUid.put(uid, new ArraySet<String>(pkgs));
            }
            return new ParcelableGranteeMap(packagesByUid);
        }

        public ParcelableGranteeMap[] newArray(int size) {
            return new ParcelableGranteeMap[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPackagesByUid.size());
        for (Map.Entry<Integer, Set<String>> uidEntry : this.mPackagesByUid.entrySet()) {
            dest.writeInt(uidEntry.getKey());
            dest.writeStringArray(uidEntry.getValue().toArray(new String[0]));
        }
    }

    public ParcelableGranteeMap(Map<Integer, Set<String>> packagesByUid) {
        this.mPackagesByUid = packagesByUid;
    }

    public Map<Integer, Set<String>> getPackagesByUid() {
        return this.mPackagesByUid;
    }
}

