/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.IOnProjectionStateChangedListener;
import android.app.IUiModeManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class UiModeManager {
    private static final String TAG = "UiModeManager";
    public static String ACTION_ENTER_CAR_MODE = "android.app.action.ENTER_CAR_MODE";
    @SystemApi
    public static final String ACTION_ENTER_CAR_MODE_PRIORITIZED = "android.app.action.ENTER_CAR_MODE_PRIORITIZED";
    public static String ACTION_EXIT_CAR_MODE = "android.app.action.EXIT_CAR_MODE";
    @SystemApi
    public static final String ACTION_EXIT_CAR_MODE_PRIORITIZED = "android.app.action.EXIT_CAR_MODE_PRIORITIZED";
    public static String ACTION_ENTER_DESK_MODE = "android.app.action.ENTER_DESK_MODE";
    public static String ACTION_EXIT_DESK_MODE = "android.app.action.EXIT_DESK_MODE";
    @SystemApi
    public static final String EXTRA_CALLING_PACKAGE = "android.app.extra.CALLING_PACKAGE";
    @SystemApi
    public static final String EXTRA_PRIORITY = "android.app.extra.PRIORITY";
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_CUSTOM = 3;
    public static final int MODE_NIGHT_NO = 1;
    public static final int MODE_NIGHT_YES = 2;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_UNKNOWN = -1;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_SCHEDULE = 0;
    @SystemApi
    public static final int MODE_NIGHT_CUSTOM_TYPE_BEDTIME = 1;
    private IUiModeManager mService;
    private Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<OnProjectionStateChangedListener, InnerListener> mProjectionStateListenerMap = new ArrayMap<OnProjectionStateChangedListener, InnerListener>();
    @GuardedBy(value={"mLock"})
    private final OnProjectionStateChangedListenerResourceManager mOnProjectionStateChangedListenerResourceManager = new OnProjectionStateChangedListenerResourceManager();
    public static final int ENABLE_CAR_MODE_GO_CAR_HOME = 1;
    public static final int ENABLE_CAR_MODE_ALLOW_SLEEP = 2;
    public static final int DISABLE_CAR_MODE_GO_HOME = 1;
    public static final int DISABLE_CAR_MODE_ALL_PRIORITIES = 2;
    @SystemApi
    public static final int DEFAULT_PRIORITY = 0;
    @SystemApi
    public static final int PROJECTION_TYPE_NONE = 0;
    @SystemApi
    public static final int PROJECTION_TYPE_AUTOMOTIVE = 1;
    @SystemApi
    public static final int PROJECTION_TYPE_ALL = -1;

    @UnsupportedAppUsage
    UiModeManager() throws ServiceManager.ServiceNotFoundException {
        this(null);
    }

    UiModeManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mService = IUiModeManager.Stub.asInterface(ServiceManager.getServiceOrThrow("uimode"));
        this.mContext = context;
    }

    public void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ENTER_CAR_MODE_PRIORITIZED")
    public void enableCarMode(int priority, int flags) {
        if (this.mService != null) {
            try {
                this.mService.enableCarMode(flags, priority, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void disableCarMode(int flags) {
        if (this.mService != null) {
            try {
                this.mService.disableCarModeByCallingPackage(flags, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getCurrentModeType() {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentModeType();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    public void setNightMode(int mode) {
        if (this.mService != null) {
            try {
                this.mService.setNightMode(mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public void setNightModeCustomType(int nightModeCustomType) {
        if (this.mService != null) {
            try {
                this.mService.setNightModeCustomType(nightModeCustomType);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public int getNightModeCustomType() {
        if (this.mService != null) {
            try {
                return this.mService.getNightModeCustomType();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public void setApplicationNightMode(int mode) {
        if (this.mService != null) {
            try {
                this.mService.setApplicationNightMode(mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getNightMode() {
        if (this.mService != null) {
            try {
                return this.mService.getNightMode();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public boolean isUiModeLocked() {
        if (this.mService != null) {
            try {
                return this.mService.isUiModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean isNightModeLocked() {
        if (this.mService != null) {
            try {
                return this.mService.isNightModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public boolean setNightModeActivatedForCustomMode(int nightModeCustomType, boolean active) {
        if (this.mService != null) {
            try {
                return this.mService.setNightModeActivatedForCustomMode(nightModeCustomType, active);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public boolean setNightModeActivated(boolean active) {
        if (this.mService != null) {
            try {
                return this.mService.setNightModeActivated(active);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public LocalTime getCustomNightModeStart() {
        if (this.mService != null) {
            try {
                return LocalTime.ofNanoOfDay(this.mService.getCustomNightModeStart() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeStart(LocalTime time) {
        if (this.mService != null) {
            try {
                this.mService.setCustomNightModeStart(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public LocalTime getCustomNightModeEnd() {
        if (this.mService != null) {
            try {
                return LocalTime.ofNanoOfDay(this.mService.getCustomNightModeEnd() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeEnd(LocalTime time) {
        if (this.mService != null) {
            try {
                this.mService.setCustomNightModeEnd(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TOGGLE_AUTOMOTIVE_PROJECTION", conditional=true)
    public boolean requestProjection(int projectionType) {
        if (this.mService != null) {
            try {
                return this.mService.requestProjection(new Binder(), projectionType, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TOGGLE_AUTOMOTIVE_PROJECTION", conditional=true)
    public boolean releaseProjection(int projectionType) {
        if (this.mService != null) {
            try {
                return this.mService.releaseProjection(projectionType, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public Set<String> getProjectingPackages(int projectionType) {
        if (this.mService != null) {
            try {
                return new ArraySet<String>(this.mService.getProjectingPackages(projectionType));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Set.of();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public int getActiveProjectionTypes() {
        if (this.mService != null) {
            try {
                return this.mService.getActiveProjectionTypes();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public void addOnProjectionStateChangedListener(int projectionType, Executor executor, OnProjectionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProjectionStateListenerMap.containsKey(listener)) {
                Slog.i(TAG, "Attempted to add listener that was already added.");
                return;
            }
            if (this.mService != null) {
                InnerListener innerListener = new InnerListener(executor, listener, this.mOnProjectionStateChangedListenerResourceManager);
                try {
                    this.mService.addOnProjectionStateChangedListener(innerListener, projectionType);
                    this.mProjectionStateListenerMap.put(listener, innerListener);
                }
                catch (RemoteException e) {
                    this.mOnProjectionStateChangedListenerResourceManager.remove(innerListener);
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PROJECTION_STATE")
    public void removeOnProjectionStateChangedListener(OnProjectionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            InnerListener innerListener = this.mProjectionStateListenerMap.get(listener);
            if (innerListener == null) {
                Slog.i(TAG, "Attempted to remove listener that was not added.");
                return;
            }
            if (this.mService != null) {
                try {
                    this.mService.removeOnProjectionStateChangedListener(innerListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mProjectionStateListenerMap.remove(listener);
            this.mOnProjectionStateChangedListenerResourceManager.remove(innerListener);
        }
    }

    private static class OnProjectionStateChangedListenerResourceManager {
        private final Map<InnerListener, OnProjectionStateChangedListener> mOuterListenerMap = new ArrayMap<InnerListener, OnProjectionStateChangedListener>(1);
        private final Map<InnerListener, Executor> mExecutorMap = new ArrayMap<InnerListener, Executor>(1);

        private OnProjectionStateChangedListenerResourceManager() {
        }

        void put(InnerListener innerListener, Executor executor, OnProjectionStateChangedListener outerListener) {
            this.mOuterListenerMap.put(innerListener, outerListener);
            this.mExecutorMap.put(innerListener, executor);
        }

        void remove(InnerListener innerListener) {
            this.mOuterListenerMap.remove(innerListener);
            this.mExecutorMap.remove(innerListener);
        }

        OnProjectionStateChangedListener getOuterListener(InnerListener innerListener) {
            return this.mOuterListenerMap.get(innerListener);
        }

        Executor getExecutor(InnerListener innerListener) {
            return this.mExecutorMap.get(innerListener);
        }
    }

    private static class InnerListener
    extends IOnProjectionStateChangedListener.Stub {
        private final WeakReference<OnProjectionStateChangedListenerResourceManager> mResourceManager;

        private InnerListener(Executor executor, OnProjectionStateChangedListener outerListener, OnProjectionStateChangedListenerResourceManager resourceManager) {
            resourceManager.put(this, executor, outerListener);
            this.mResourceManager = new WeakReference<OnProjectionStateChangedListenerResourceManager>(resourceManager);
        }

        @Override
        public void onProjectionStateChanged(int activeProjectionTypes, List<String> projectingPackages) {
            OnProjectionStateChangedListenerResourceManager resourceManager = (OnProjectionStateChangedListenerResourceManager)this.mResourceManager.get();
            if (resourceManager == null) {
                Slog.w(UiModeManager.TAG, "Can't execute onProjectionStateChanged, resource manager is gone.");
                return;
            }
            OnProjectionStateChangedListener outerListener = resourceManager.getOuterListener(this);
            Executor executor = resourceManager.getExecutor(this);
            if (outerListener == null || executor == null) {
                Slog.w(UiModeManager.TAG, "Can't execute onProjectionStatechanged, references are null.");
                return;
            }
            executor.execute(PooledLambda.obtainRunnable(OnProjectionStateChangedListener::onProjectionStateChanged, outerListener, activeProjectionTypes, new ArraySet<String>(projectingPackages)).recycleOnUse());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProjectionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableCarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableCarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightModeCustomReturnType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightModeCustomType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightMode {
    }

    @SystemApi
    public static interface OnProjectionStateChangedListener {
        public void onProjectionStateChanged(int var1, Set<String> var2);
    }
}

