/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityGestureEvent;
import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.MagnificationConfig;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.IUiAutomationConnection;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os._Original_Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.inputmethod.EditorInfo;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IAccessibilityInputMethodSessionCallback;
import com.android.internal.inputmethod.RemoteAccessibilityInputConnection;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

public class UiAutomation {
    private static final String LOG_TAG = UiAutomation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int CONNECTION_ID_UNDEFINED = -1;
    private static final long CONNECT_TIMEOUT_MILLIS = 5000L;
    public static final int ROTATION_UNFREEZE = -2;
    public static final int ROTATION_FREEZE_CURRENT = -1;
    public static final int ROTATION_FREEZE_0 = 0;
    public static final int ROTATION_FREEZE_90 = 1;
    public static final int ROTATION_FREEZE_180 = 2;
    public static final int ROTATION_FREEZE_270 = 3;
    public static final int FLAG_DONT_SUPPRESS_ACCESSIBILITY_SERVICES = 1;
    public static final int FLAG_DONT_USE_ACCESSIBILITY = 2;
    public static final Set<String> ALL_PERMISSIONS = Set.of("_ALL_PERMISSIONS_");
    private final Object mLock = new Object();
    private final ArrayList<AccessibilityEvent> mEventQueue = new ArrayList();
    private final Handler mLocalCallbackHandler;
    private final IUiAutomationConnection mUiAutomationConnection;
    private HandlerThread mRemoteCallbackThread;
    private IAccessibilityServiceClient mClient;
    private int mConnectionId = -1;
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private boolean mWaitingForEventDelivery;
    private long mLastEventTimeMillis;
    private int mConnectionState = 0;
    private boolean mIsDestroyed;
    private int mFlags;
    private int mGenerationId = 0;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UiAutomation(Looper looper, IUiAutomationConnection connection) {
        if (looper == null) {
            throw new IllegalArgumentException("Looper cannot be null!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        this.mLocalCallbackHandler = new Handler(looper);
        this.mUiAutomationConnection = connection;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void connect() {
        try {
            this.connectWithTimeout(0, 5000L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(int flags) {
        try {
            this.connectWithTimeout(flags, 5000L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWithTimeout(int flags, long timeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfConnectedLocked();
            if (this.mConnectionState == 1) {
                return;
            }
            this.mConnectionState = 1;
            this.mRemoteCallbackThread = new HandlerThread("UiAutomation");
            this.mRemoteCallbackThread.start();
            this.mClient = new IAccessibilityServiceClientImpl(this.mRemoteCallbackThread.getLooper(), ++this.mGenerationId);
        }
        try {
            this.mUiAutomationConnection.connect(this.mClient, flags);
            this.mFlags = flags;
            if (!this.useAccessibility()) {
                this.mConnectionState = 0;
                return;
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while connecting " + this, re);
        }
        object = this.mLock;
        synchronized (object) {
            long startTimeMillis = SystemClock.uptimeMillis();
            while (this.mConnectionState != 2) {
                long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                long remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
                if (remainingTimeMillis <= 0L) {
                    this.mConnectionState = 3;
                    throw new TimeoutException("Timeout while connecting " + this);
                }
                try {
                    this.mLock.wait(remainingTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionState == 1) {
                throw new IllegalStateException("Cannot call disconnect() while connecting " + this);
            }
            if (this.useAccessibility() && this.mConnectionState == 0) {
                return;
            }
            this.mConnectionState = 0;
            this.mConnectionId = -1;
            ++this.mGenerationId;
        }
        try {
            this.mUiAutomationConnection.disconnect();
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while disconnecting " + this, re);
        }
        finally {
            if (this.mRemoteCallbackThread != null) {
                this.mRemoteCallbackThread.quit();
                this.mRemoteCallbackThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAccessibilityEventListener(OnAccessibilityEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            this.mOnAccessibilityEventListener = listener;
        }
    }

    public void destroy() {
        this.disconnect();
        this.mIsDestroyed = true;
    }

    public void adoptShellPermissionIdentity() {
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), null);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing adopting shell permission identity!", re);
        }
    }

    public void adoptShellPermissionIdentity(String ... permissions) {
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), permissions);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing adopting shell permission identity!", re);
        }
    }

    public void dropShellPermissionIdentity() {
        try {
            this.mUiAutomationConnection.dropShellPermissionIdentity();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing dropping shell permission identity!", re);
        }
    }

    public Set<String> getAdoptedShellPermissions() {
        try {
            List<String> permissions = this.mUiAutomationConnection.getAdoptedShellPermissions();
            return permissions == null ? ALL_PERMISSIONS : new ArraySet<String>(permissions);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting adopted shell permissions", re);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGlobalAction(int action) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo findFocus(int focus) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceInfo(AccessibilityServiceInfo info) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance().clearCache(this.mConnectionId);
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                connection.setServiceInfo(info);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindows(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<List<AccessibilityWindowInfo>> getWindowsOnAllDisplays() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindowsOnAllDisplays(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getRootInActiveWindow() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId, 4);
    }

    public boolean injectInputEvent(InputEvent event, boolean sync) {
        return this.injectInputEvent(event, sync, true);
    }

    public boolean injectInputEvent(InputEvent event, boolean sync, boolean waitForAnimations) {
        try {
            return this.mUiAutomationConnection.injectInputEvent(event, sync, waitForAnimations);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event!", re);
            return false;
        }
    }

    public void setAnimationScale(float scale) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                connection.setAnimationScale(scale);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
        }
    }

    public void syncInputTransactions() {
        try {
            this.mUiAutomationConnection.syncInputTransactions(true);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while syncing input transactions!", re);
        }
    }

    public void syncInputTransactions(boolean waitForAnimations) {
        try {
            this.mUiAutomationConnection.syncInputTransactions(waitForAnimations);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while syncing input transactions!", re);
        }
    }

    public boolean setRotation(int rotation) {
        switch (rotation) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.mUiAutomationConnection.setRotation(rotation);
                    return true;
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error while setting rotation!", re);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid rotation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityEvent executeAndWaitForEvent(Runnable command, AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        block24: {
            var5_4 = this.mLock;
            synchronized (var5_4) {
                this.throwIfNotConnectedLocked();
                this.mEventQueue.clear();
                this.mWaitingForEventDelivery = true;
            }
            executionStartTimeMillis = SystemClock.uptimeMillis();
            command.run();
            receivedEvents = new ArrayList<AccessibilityEvent>();
            try {
                startTimeMillis = SystemClock.uptimeMillis();
lbl11:
                // 2 sources

                while (true) {
                    localEvents = new ArrayList<AccessibilityEvent>();
                    var11_11 = this.mLock;
                    synchronized (var11_11) {
                        localEvents.addAll(this.mEventQueue);
                        this.mEventQueue.clear();
                    }
lbl18:
                    // 3 sources

                    while (!localEvents.isEmpty()) {
                        event = (AccessibilityEvent)localEvents.remove(0);
                        if (event.getEventTime() < executionStartTimeMillis) continue;
                        if (filter.accept(event)) {
                            var12_15 = event;
                            size = receivedEvents.size();
                            i = 0;
                            break block24;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl57
                    break;
                }
            }
            catch (Throwable var18_18) {
                size = receivedEvents.size();
                i = 0;
                while (true) {
                    if (i >= size) {
                        var20_21 = this.mLock;
                        synchronized (var20_21) {
                            this.mWaitingForEventDelivery = false;
                            this.mEventQueue.clear();
                            this.mLock.notifyAll();
                            throw var18_18;
                        }
                    }
                    ((AccessibilityEvent)receivedEvents.get(i)).recycle();
                    ++i;
                }
            }
        }
        while (true) {
            if (i >= size) {
                var14_17 = this.mLock;
                synchronized (var14_17) {
                    this.mWaitingForEventDelivery = false;
                    this.mEventQueue.clear();
                    this.mLock.notifyAll();
                    return var12_15;
                }
            }
            ((AccessibilityEvent)receivedEvents.get(i)).recycle();
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            receivedEvents.add(event);
            ** GOTO lbl18
lbl57:
            // 1 sources

            elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
            remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
            if (remainingTimeMillis <= 0L) {
                throw new TimeoutException("Expected event not received within: " + timeoutMillis + " ms among: " + receivedEvents);
            }
            var15_14 = this.mLock;
            synchronized (var15_14) {
                if (this.mEventQueue.isEmpty()) {
                    try {
                        this.mLock.wait(remainingTimeMillis);
                    }
                    catch (InterruptedException var16_8) {
                        // empty catch block
                    }
                }
            }
            ** continue;
        }
    }

    public void waitForIdle(long idleTimeoutMillis, long globalTimeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long startTimeMillis = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = startTimeMillis;
            }
            while (true) {
                long currentTimeMillis;
                long elapsedGlobalTimeMillis;
                long remainingGlobalTimeMillis;
                if ((remainingGlobalTimeMillis = globalTimeoutMillis - (elapsedGlobalTimeMillis = (currentTimeMillis = SystemClock.uptimeMillis()) - startTimeMillis)) <= 0L) {
                    throw new TimeoutException("No idle state with idle timeout: " + idleTimeoutMillis + " within global timeout: " + globalTimeoutMillis);
                }
                long elapsedIdleTimeMillis = currentTimeMillis - this.mLastEventTimeMillis;
                long remainingIdleTimeMillis = idleTimeoutMillis - elapsedIdleTimeMillis;
                if (remainingIdleTimeMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainingIdleTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Bitmap takeScreenshot() {
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        int rotation = display.getRotation();
        Bitmap screenShot = null;
        try {
            screenShot = this.mUiAutomationConnection.takeScreenshot(new Rect(0, 0, displaySize.x, displaySize.y));
            if (screenShot == null) {
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screenshot!", re);
            return null;
        }
        screenShot.setHasAlpha(false);
        return screenShot;
    }

    public Bitmap takeScreenshot(Window window) {
        if (window == null) {
            return null;
        }
        View decorView = window.peekDecorView();
        if (decorView == null) {
            return null;
        }
        ViewRootImpl viewRoot = decorView.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        SurfaceControl sc = viewRoot.getSurfaceControl();
        if (!sc.isValid()) {
            return null;
        }
        new SurfaceControl.Transaction().apply(true);
        try {
            return this.mUiAutomationConnection.takeSurfaceControlScreenshot(sc);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screenshot!", re);
            return null;
        }
    }

    public void setRunAsMonkey(boolean enable) {
        try {
            ActivityManager.getService().setUserIsMonkey(enable);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowContentFrameStats getWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", re);
            return null;
        }
    }

    @Deprecated
    public void clearWindowAnimationFrameStats() {
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", re);
        }
    }

    @Deprecated
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", re);
            return null;
        }
    }

    public void grantRuntimePermission(String packageName, String permission2) {
        this.grantRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean grantRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.grantRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    public void grantRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        try {
            this.mUiAutomationConnection.grantRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    public void revokeRuntimePermission(String packageName, String permission2) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean revokeRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    public void revokeRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        try {
            this.mUiAutomationConnection.revokeRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ParcelFileDescriptor executeShellCommand(String command) {
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            source = pipe[0];
            sink = pipe[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink, null);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink);
        }
        IoUtils.closeQuietly(sink);
        return source;
    }

    @SuppressLint(value={"ArrayReturn"})
    public ParcelFileDescriptor[] executeShellCommandRw(String command) {
        return this.executeShellCommandInternal(command, false);
    }

    @SuppressLint(value={"ArrayReturn"})
    public ParcelFileDescriptor[] executeShellCommandRwe(String command) {
        return this.executeShellCommandInternal(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ParcelFileDescriptor[] executeShellCommandInternal(String command, boolean includeStderr) {
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source_read = null;
        ParcelFileDescriptor sink_read = null;
        ParcelFileDescriptor source_write = null;
        ParcelFileDescriptor sink_write = null;
        ParcelFileDescriptor stderr_source_read = null;
        ParcelFileDescriptor stderr_sink_read = null;
        try {
            ParcelFileDescriptor[] pipe_read = ParcelFileDescriptor.createPipe();
            source_read = pipe_read[0];
            sink_read = pipe_read[1];
            ParcelFileDescriptor[] pipe_write = ParcelFileDescriptor.createPipe();
            source_write = pipe_write[0];
            sink_write = pipe_write[1];
            if (includeStderr) {
                ParcelFileDescriptor[] stderr_read = ParcelFileDescriptor.createPipe();
                stderr_source_read = stderr_read[0];
                stderr_sink_read = stderr_read[1];
            }
            this.mUiAutomationConnection.executeShellCommandWithStderr(command, sink_read, source_write, stderr_sink_read);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
            IoUtils.closeQuietly(stderr_sink_read);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink_read);
                    IoUtils.closeQuietly(source_write);
                    IoUtils.closeQuietly(stderr_sink_read);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
            IoUtils.closeQuietly(stderr_sink_read);
        }
        IoUtils.closeQuietly(sink_read);
        IoUtils.closeQuietly(source_write);
        IoUtils.closeQuietly(stderr_sink_read);
        ParcelFileDescriptor[] result = new ParcelFileDescriptor[includeStderr ? 3 : 2];
        result[0] = source_read;
        result[1] = sink_write;
        if (includeStderr) {
            result[2] = stderr_source_read;
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UiAutomation@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[id=").append(this.mConnectionId);
        stringBuilder.append(", flags=").append(this.mFlags);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @GuardedBy(value={"mLock"})
    private void throwIfConnectedLocked() {
        if (this.mConnectionState == 2) {
            throw new IllegalStateException("UiAutomation connected, " + this);
        }
    }

    @GuardedBy(value={"mLock"})
    private void throwIfNotConnectedLocked() {
        if (this.mConnectionState != 2) {
            String msg = this.useAccessibility() ? "UiAutomation not connected, " : "UiAutomation not connected: Accessibility-dependent method called with FLAG_DONT_USE_ACCESSIBILITY set, ";
            throw new IllegalStateException(msg + this);
        }
    }

    private void warnIfBetterCommand(String cmd) {
        if (cmd.startsWith("pm grant ")) {
            Log.w(LOG_TAG, "UiAutomation.grantRuntimePermission() is more robust and should be used instead of 'pm grant'");
        } else if (cmd.startsWith("pm revoke ")) {
            Log.w(LOG_TAG, "UiAutomation.revokeRuntimePermission() is more robust and should be used instead of 'pm revoke'");
        }
    }

    private boolean useAccessibility() {
        return (this.mFlags & 2) == 0;
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper {
        public IAccessibilityServiceClientImpl(Looper looper, final int generationId) {
            super(null, looper, new AccessibilityService.Callbacks(){
                private final int mGenerationId;
                {
                    this.mGenerationId = generationId;
                }

                private boolean isGenerationChangedLocked() {
                    return this.mGenerationId != UiAutomation.this.mGenerationId;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init(int connectionId, IBinder windowToken) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        if (this.isGenerationChangedLocked()) {
                            return;
                        }
                        UiAutomation.this.mConnectionState = 2;
                        UiAutomation.this.mConnectionId = connectionId;
                        UiAutomation.this.mLock.notifyAll();
                    }
                    if (_Original_Build.IS_DEBUGGABLE) {
                        Log.v(LOG_TAG, "Init " + UiAutomation.this);
                    }
                }

                @Override
                public void onServiceConnected() {
                }

                @Override
                public void onInterrupt() {
                }

                @Override
                public void onSystemActionsChanged() {
                }

                @Override
                public void createImeSession(IAccessibilityInputMethodSessionCallback callback) {
                }

                @Override
                public void startInput(RemoteAccessibilityInputConnection inputConnection, EditorInfo editorInfo, boolean restarting) {
                }

                @Override
                public boolean onGesture(AccessibilityGestureEvent gestureEvent) {
                    return false;
                }

                @Override
                public void onMotionEvent(MotionEvent event) {
                }

                @Override
                public void onTouchStateChanged(int displayId, int state) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAccessibilityEvent(AccessibilityEvent event) {
                    OnAccessibilityEventListener listener;
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        if (this.isGenerationChangedLocked()) {
                            return;
                        }
                        UiAutomation.this.mLastEventTimeMillis = event.getEventTime();
                        if (UiAutomation.this.mWaitingForEventDelivery) {
                            UiAutomation.this.mEventQueue.add(AccessibilityEvent.obtain(event));
                        }
                        UiAutomation.this.mLock.notifyAll();
                        listener = UiAutomation.this.mOnAccessibilityEventListener;
                    }
                    if (listener != null) {
                        UiAutomation.this.mLocalCallbackHandler.sendMessage(PooledLambda.obtainMessage(OnAccessibilityEventListener::onAccessibilityEvent, listener, AccessibilityEvent.obtain(event)));
                    }
                }

                @Override
                public boolean onKeyEvent(KeyEvent event) {
                    return false;
                }

                @Override
                public void onMagnificationChanged(int displayId, Region region, MagnificationConfig config) {
                }

                @Override
                public void onSoftKeyboardShowModeChanged(int showMode) {
                }

                @Override
                public void onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                }

                @Override
                public void onFingerprintCapturingGesturesChanged(boolean active) {
                }

                @Override
                public void onFingerprintGesture(int gesture) {
                }

                @Override
                public void onAccessibilityButtonClicked(int displayId) {
                }

                @Override
                public void onAccessibilityButtonAvailabilityChanged(boolean available) {
                }
            });
        }
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int FAILED = 3;
    }
}

