/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.drawable.Icon;
import android.media.INearbyMediaDevicesProvider;
import android.media.INearbyMediaDevicesUpdateCallback;
import android.media.MediaRoute2Info;
import android.media.NearbyDevice;
import android.media.NearbyMediaDevicesProvider;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.statusbar.IAddTileResultCallback;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.statusbar.IUndoMediaTransferCallback;
import com.android.internal.statusbar.NotificationVisibility;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 65536;
    public static final int DISABLE_NOTIFICATION_ICONS = 131072;
    public static final int DISABLE_NOTIFICATION_ALERTS = 262144;
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int DISABLE_SYSTEM_INFO = 0x100000;
    public static final int DISABLE_HOME = 0x200000;
    public static final int DISABLE_RECENT = 0x1000000;
    public static final int DISABLE_BACK = 0x400000;
    public static final int DISABLE_CLOCK = 0x800000;
    public static final int DISABLE_SEARCH = 0x2000000;
    public static final int DISABLE_ONGOING_CALL_CHIP = 0x4000000;
    @Deprecated
    public static final int DISABLE_NAVIGATION = 0x1200000;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE_MASK = 0x7FF0000;
    public static final int DISABLE2_QUICK_SETTINGS = 1;
    public static final int DISABLE2_SYSTEM_ICONS = 2;
    public static final int DISABLE2_NOTIFICATION_SHADE = 4;
    public static final int DISABLE2_GLOBAL_ACTIONS = 8;
    public static final int DISABLE2_ROTATE_SUGGESTIONS = 16;
    public static final int DISABLE2_NONE = 0;
    public static final int DISABLE2_MASK = 31;
    public static final int DEFAULT_SETUP_DISABLE_FLAGS = 61145088;
    public static final int DEFAULT_SETUP_DISABLE2_FLAGS = 0;
    private static final int DEFAULT_SIM_LOCKED_DISABLED_FLAGS = 65536;
    public static final int NAVIGATION_HINT_BACK_ALT = 1;
    public static final int NAVIGATION_HINT_IME_SHOWN = 2;
    public static final int NAVIGATION_HINT_IME_SWITCHER_SHOWN = 4;
    public static final int WINDOW_STATUS_BAR = 1;
    public static final int WINDOW_NAVIGATION_BAR = 2;
    public static final int WINDOW_STATE_SHOWING = 0;
    public static final int WINDOW_STATE_HIDING = 1;
    public static final int WINDOW_STATE_HIDDEN = 2;
    public static final int CAMERA_LAUNCH_SOURCE_WIGGLE = 0;
    public static final int CAMERA_LAUNCH_SOURCE_POWER_DOUBLE_TAP = 1;
    public static final int CAMERA_LAUNCH_SOURCE_LIFT_TRIGGER = 2;
    public static final int SESSION_KEYGUARD = 1;
    public static final int SESSION_BIOMETRIC_PROMPT = 2;
    public static final Set<Integer> ALL_SESSIONS = Set.of(Integer.valueOf(1), Integer.valueOf(2));
    public static final int TILE_ADD_REQUEST_RESULT_TILE_NOT_ADDED = 0;
    public static final int TILE_ADD_REQUEST_RESULT_TILE_ALREADY_ADDED = 1;
    public static final int TILE_ADD_REQUEST_RESULT_TILE_ADDED = 2;
    public static final int TILE_ADD_REQUEST_RESULT_DIALOG_DISMISSED = 3;
    private static final int TILE_ADD_REQUEST_FIRST_ERROR_CODE = 1000;
    public static final int TILE_ADD_REQUEST_ERROR_MISMATCHED_PACKAGE = 1000;
    public static final int TILE_ADD_REQUEST_ERROR_REQUEST_IN_PROGRESS = 1001;
    public static final int TILE_ADD_REQUEST_ERROR_BAD_COMPONENT = 1002;
    public static final int TILE_ADD_REQUEST_ERROR_NOT_CURRENT_USER = 1003;
    public static final int TILE_ADD_REQUEST_ERROR_APP_NOT_IN_FOREGROUND = 1004;
    public static final int TILE_ADD_REQUEST_ERROR_NO_STATUS_BAR_SERVICE = 1005;
    @SystemApi
    public static final int NAV_BAR_MODE_DEFAULT = 0;
    @SystemApi
    public static final int NAV_BAR_MODE_KIDS = 1;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_ALMOST_CLOSE_TO_START_CAST = 0;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_ALMOST_CLOSE_TO_END_CAST = 1;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_RECEIVER_TRIGGERED = 2;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_THIS_DEVICE_TRIGGERED = 3;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_RECEIVER_SUCCEEDED = 4;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_THIS_DEVICE_SUCCEEDED = 5;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_RECEIVER_FAILED = 6;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_TRANSFER_TO_THIS_DEVICE_FAILED = 7;
    @SystemApi
    public static final int MEDIA_TRANSFER_SENDER_STATE_FAR_FROM_RECEIVER = 8;
    @SystemApi
    public static final int MEDIA_TRANSFER_RECEIVER_STATE_CLOSE_TO_SENDER = 0;
    @SystemApi
    public static final int MEDIA_TRANSFER_RECEIVER_STATE_FAR_FROM_SENDER = 1;
    private final Map<NearbyMediaDevicesProvider, NearbyMediaDevicesProviderWrapper> nearbyMediaDevicesProviderMap = new HashMap<NearbyMediaDevicesProvider, NearbyMediaDevicesProviderWrapper>();
    private static final long MEDIA_CONTROL_SESSION_ACTIONS = 203800354L;
    @UnsupportedAppUsage
    private Context mContext;
    private IStatusBarService mService;
    @UnsupportedAppUsage
    private IBinder mToken = new Binder();

    @UnsupportedAppUsage
    StatusBarManager(Context context) {
        this.mContext = context;
    }

    @UnsupportedAppUsage
    private synchronized IStatusBarService getService() {
        if (this.mService == null) {
            this.mService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            if (this.mService == null) {
                Slog.w("StatusBarManager", "warning: no STATUS_BAR_SERVICE");
            }
        }
        return this.mService;
    }

    @UnsupportedAppUsage
    public void disable(int what) {
        try {
            int userId = Binder.getCallingUserHandle().getIdentifier();
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.disableForUser(what, this.mToken, this.mContext.getPackageName(), userId);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void disable2(int what) {
        try {
            int userId = Binder.getCallingUserHandle().getIdentifier();
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.disable2ForUser(what, this.mToken, this.mContext.getPackageName(), userId);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void clickNotification(String key, int rank, int count, boolean visible) {
        this.clickNotificationInternal(key, rank, count, visible);
    }

    private void clickNotificationInternal(String key, int rank, int count, boolean visible) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.onNotificationClick(key, NotificationVisibility.obtain(key, rank, count, visible));
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void sendNotificationFeedback(String key, Bundle feedback) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.onNotificationFeedbackReceived(key, feedback);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void expandNotificationsPanel() {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.expandNotificationsPanel();
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.STATUS_BAR")
    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="This operation is not allowed anymore, please see {@link android.content.Intent#ACTION_CLOSE_SYSTEM_DIALOGS} for more details.")
    public void collapsePanels() {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.collapsePanels();
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.STATUS_BAR")
    public void togglePanel() {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.togglePanel();
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.STATUS_BAR")
    public void handleSystemKey(int key) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.handleSystemKey(key);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void expandSettingsPanel() {
        this.expandSettingsPanel(null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void expandSettingsPanel(String subPanel) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.expandSettingsPanel(subPanel);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setIcon(String slot, int iconId, int iconLevel, String contentDescription) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.setIcon(slot, this.mContext.getPackageName(), iconId, iconLevel, contentDescription);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void removeIcon(String slot) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.removeIcon(slot);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setIconVisibility(String slot, boolean visible) {
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.setIconVisibility(slot, visible);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR")
    public void setDisabledForSetup(boolean disabled) {
        try {
            int userId = Binder.getCallingUserHandle().getIdentifier();
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.disableForUser(disabled ? 61145088 : 0, this.mToken, this.mContext.getPackageName(), userId);
                svc.disable2ForUser(disabled ? 0 : 0, this.mToken, this.mContext.getPackageName(), userId);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.STATUS_BAR")
    public void setExpansionDisabledForSimNetworkLock(boolean disabled) {
        try {
            int userId = Binder.getCallingUserHandle().getIdentifier();
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.disableForUser(disabled ? 65536 : 0, this.mToken, this.mContext.getPackageName(), userId);
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR")
    public DisableInfo getDisableInfo() {
        try {
            int userId = Binder.getCallingUserHandle().getIdentifier();
            IStatusBarService svc = this.getService();
            int[] flags = new int[]{0, 0};
            if (svc != null) {
                flags = svc.getDisableFlags(this.mToken, userId);
            }
            return new DisableInfo(flags[0], flags[1]);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void requestTileServiceListeningState(ComponentName componentName) {
        Objects.requireNonNull(componentName);
        try {
            this.getService().requestTileServiceListeningState(componentName, this.mContext.getUserId());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void requestAddTileService(ComponentName tileServiceComponentName, CharSequence tileLabel, Icon icon, Executor resultExecutor, Consumer<Integer> resultCallback) {
        Objects.requireNonNull(tileServiceComponentName);
        Objects.requireNonNull(tileLabel);
        Objects.requireNonNull(icon);
        Objects.requireNonNull(resultExecutor);
        Objects.requireNonNull(resultCallback);
        if (!tileServiceComponentName.getPackageName().equals(this.mContext.getPackageName())) {
            resultExecutor.execute(() -> resultCallback.accept(1000));
            return;
        }
        int userId = this.mContext.getUserId();
        RequestResultCallback callbackProxy = new RequestResultCallback(resultExecutor, resultCallback);
        IStatusBarService svc = this.getService();
        try {
            svc.requestAddTile(tileServiceComponentName, tileLabel, icon, userId, callbackProxy);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }

    public void cancelRequestAddTile(String packageName) {
        Objects.requireNonNull(packageName);
        IStatusBarService svc = this.getService();
        try {
            svc.cancelRequestAddTile(packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR")
    public void setNavBarMode(int navBarMode) {
        if (navBarMode != 0 && navBarMode != 1) {
            throw new IllegalArgumentException("Supplied navBarMode not supported: " + navBarMode);
        }
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                svc.setNavBarMode(navBarMode);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR")
    public int getNavBarMode() {
        int navBarMode = 0;
        try {
            IStatusBarService svc = this.getService();
            if (svc != null) {
                navBarMode = svc.getNavBarMode();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return navBarMode;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, Executor undoExecutor, Runnable undoCallback) {
        Objects.requireNonNull(routeInfo);
        if (displayState != 4 && displayState != 5 && undoCallback != null) {
            throw new IllegalArgumentException("The undoCallback should only be provided when the state is a transfer succeeded state");
        }
        if (undoCallback != null && undoExecutor == null) {
            throw new IllegalArgumentException("You must pass an executor when you pass an undo callback");
        }
        IStatusBarService svc = this.getService();
        try {
            UndoCallback callbackProxy = null;
            if (undoExecutor != null) {
                callbackProxy = new UndoCallback(undoExecutor, undoCallback);
            }
            svc.updateMediaTapToTransferSenderDisplay(displayState, routeInfo, callbackProxy);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) {
        Objects.requireNonNull(routeInfo);
        IStatusBarService svc = this.getService();
        try {
            svc.updateMediaTapToTransferReceiverDisplay(displayState, routeInfo, appIcon, appName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void registerNearbyMediaDevicesProvider(NearbyMediaDevicesProvider provider) {
        Objects.requireNonNull(provider);
        if (this.nearbyMediaDevicesProviderMap.containsKey(provider)) {
            return;
        }
        try {
            IStatusBarService svc = this.getService();
            NearbyMediaDevicesProviderWrapper providerWrapper = new NearbyMediaDevicesProviderWrapper(provider);
            this.nearbyMediaDevicesProviderMap.put(provider, providerWrapper);
            svc.registerNearbyMediaDevicesProvider(providerWrapper);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void unregisterNearbyMediaDevicesProvider(NearbyMediaDevicesProvider provider) {
        Objects.requireNonNull(provider);
        if (!this.nearbyMediaDevicesProviderMap.containsKey(provider)) {
            return;
        }
        try {
            IStatusBarService svc = this.getService();
            NearbyMediaDevicesProviderWrapper providerWrapper = this.nearbyMediaDevicesProviderMap.get(provider);
            this.nearbyMediaDevicesProviderMap.remove(provider);
            svc.unregisterNearbyMediaDevicesProvider(providerWrapper);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.READ_COMPAT_CHANGE_CONFIG", "android.permission.LOG_COMPAT_CHANGE"})
    public static boolean useMediaSessionActionsForApp(String packageName, UserHandle user) {
        return CompatChanges.isChangeEnabled(203800354L, packageName, user);
    }

    public static String windowStateToString(int state) {
        if (state == 1) {
            return "WINDOW_STATE_HIDING";
        }
        if (state == 2) {
            return "WINDOW_STATE_HIDDEN";
        }
        if (state == 0) {
            return "WINDOW_STATE_SHOWING";
        }
        return "WINDOW_STATE_UNKNOWN";
    }

    static class NearbyMediaDevicesProviderWrapper
    extends INearbyMediaDevicesProvider.Stub {
        private final NearbyMediaDevicesProvider mProvider;
        private final Map<INearbyMediaDevicesUpdateCallback, Consumer<List<NearbyDevice>>> mRegisteredCallbacks = new HashMap<INearbyMediaDevicesUpdateCallback, Consumer<List<NearbyDevice>>>();

        NearbyMediaDevicesProviderWrapper(NearbyMediaDevicesProvider provider) {
            this.mProvider = provider;
        }

        @Override
        public void registerNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback) {
            Consumer<List<NearbyDevice>> callbackAsConsumer = nearbyDevices -> {
                try {
                    callback.onDevicesUpdated((List<NearbyDevice>)nearbyDevices);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            };
            this.mRegisteredCallbacks.put(callback, callbackAsConsumer);
            this.mProvider.registerNearbyDevicesCallback(callbackAsConsumer);
        }

        @Override
        public void unregisterNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback) {
            if (!this.mRegisteredCallbacks.containsKey(callback)) {
                return;
            }
            this.mProvider.unregisterNearbyDevicesCallback(this.mRegisteredCallbacks.get(callback));
            this.mRegisteredCallbacks.remove(callback);
        }
    }

    static class UndoCallback
    extends IUndoMediaTransferCallback.Stub {
        private final Executor mExecutor;
        private final Runnable mCallback;

        UndoCallback(Executor executor, Runnable callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onUndoTriggered() {
            long callingIdentity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(this.mCallback);
            }
            finally {
                UndoCallback.restoreCallingIdentity(callingIdentity);
            }
        }
    }

    static class RequestResultCallback
    extends IAddTileResultCallback.Stub {
        private final Executor mExecutor;
        private final Consumer<Integer> mCallback;

        RequestResultCallback(Executor executor, Consumer<Integer> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onTileRequest(int userResponse) {
            this.mExecutor.execute(() -> this.mCallback.accept(userResponse));
        }
    }

    @SystemApi
    public static class DisableInfo {
        private boolean mStatusBarExpansion;
        private boolean mNavigateHome;
        private boolean mNotificationPeeking;
        private boolean mRecents;
        private boolean mSearch;
        private boolean mSystemIcons;
        private boolean mClock;
        private boolean mNotificationIcons;
        private boolean mRotationSuggestion;

        public DisableInfo(int flags1, int flags2) {
            this.mStatusBarExpansion = (flags1 & 0x10000) != 0;
            this.mNavigateHome = (flags1 & 0x200000) != 0;
            this.mNotificationPeeking = (flags1 & 0x40000) != 0;
            this.mRecents = (flags1 & 0x1000000) != 0;
            this.mSearch = (flags1 & 0x2000000) != 0;
            this.mSystemIcons = (flags1 & 0x100000) != 0;
            this.mClock = (flags1 & 0x800000) != 0;
            this.mNotificationIcons = (flags1 & 0x20000) != 0;
            this.mRotationSuggestion = (flags2 & 0x10) != 0;
        }

        public DisableInfo() {
        }

        @SystemApi
        public boolean isStatusBarExpansionDisabled() {
            return this.mStatusBarExpansion;
        }

        public void setStatusBarExpansionDisabled(boolean disabled) {
            this.mStatusBarExpansion = disabled;
        }

        @SystemApi
        public boolean isNavigateToHomeDisabled() {
            return this.mNavigateHome;
        }

        public void setNagivationHomeDisabled(boolean disabled) {
            this.mNavigateHome = disabled;
        }

        @SystemApi
        public boolean isNotificationPeekingDisabled() {
            return this.mNotificationPeeking;
        }

        public void setNotificationPeekingDisabled(boolean disabled) {
            this.mNotificationPeeking = disabled;
        }

        @SystemApi
        public boolean isRecentsDisabled() {
            return this.mRecents;
        }

        public void setRecentsDisabled(boolean disabled) {
            this.mRecents = disabled;
        }

        @SystemApi
        public boolean isSearchDisabled() {
            return this.mSearch;
        }

        public void setSearchDisabled(boolean disabled) {
            this.mSearch = disabled;
        }

        public boolean areSystemIconsDisabled() {
            return this.mSystemIcons;
        }

        public void setSystemIconsDisabled(boolean disabled) {
            this.mSystemIcons = disabled;
        }

        public boolean isClockDisabled() {
            return this.mClock;
        }

        public void setClockDisabled(boolean disabled) {
            this.mClock = disabled;
        }

        public boolean areNotificationIconsDisabled() {
            return this.mNotificationIcons;
        }

        public void setNotificationIconsDisabled(boolean disabled) {
            this.mNotificationIcons = disabled;
        }

        public boolean isRotationSuggestionDisabled() {
            return this.mRotationSuggestion;
        }

        @SystemApi
        public boolean areAllComponentsEnabled() {
            return !this.mStatusBarExpansion && !this.mNavigateHome && !this.mNotificationPeeking && !this.mRecents && !this.mSearch && !this.mSystemIcons && !this.mClock && !this.mNotificationIcons && !this.mRotationSuggestion;
        }

        public void setEnableAll() {
            this.mStatusBarExpansion = false;
            this.mNavigateHome = false;
            this.mNotificationPeeking = false;
            this.mRecents = false;
            this.mSearch = false;
            this.mSystemIcons = false;
            this.mClock = false;
            this.mNotificationIcons = false;
            this.mRotationSuggestion = false;
        }

        public boolean areAllComponentsDisabled() {
            return this.mStatusBarExpansion && this.mNavigateHome && this.mNotificationPeeking && this.mRecents && this.mSearch && this.mSystemIcons && this.mClock && this.mNotificationIcons && this.mRotationSuggestion;
        }

        public void setDisableAll() {
            this.mStatusBarExpansion = true;
            this.mNavigateHome = true;
            this.mNotificationPeeking = true;
            this.mRecents = true;
            this.mSearch = true;
            this.mSystemIcons = true;
            this.mClock = true;
            this.mNotificationIcons = true;
            this.mRotationSuggestion = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DisableInfo: ");
            sb.append(" mStatusBarExpansion=").append(this.mStatusBarExpansion ? "disabled" : "enabled");
            sb.append(" mNavigateHome=").append(this.mNavigateHome ? "disabled" : "enabled");
            sb.append(" mNotificationPeeking=").append(this.mNotificationPeeking ? "disabled" : "enabled");
            sb.append(" mRecents=").append(this.mRecents ? "disabled" : "enabled");
            sb.append(" mSearch=").append(this.mSearch ? "disabled" : "enabled");
            sb.append(" mSystemIcons=").append(this.mSystemIcons ? "disabled" : "enabled");
            sb.append(" mClock=").append(this.mClock ? "disabled" : "enabled");
            sb.append(" mNotificationIcons=").append(this.mNotificationIcons ? "disabled" : "enabled");
            sb.append(" mRotationSuggestion=").append(this.mRotationSuggestion ? "disabled" : "enabled");
            return sb.toString();
        }

        public Pair<Integer, Integer> toFlags() {
            int disable1 = 0;
            int disable2 = 0;
            if (this.mStatusBarExpansion) {
                disable1 |= 0x10000;
            }
            if (this.mNavigateHome) {
                disable1 |= 0x200000;
            }
            if (this.mNotificationPeeking) {
                disable1 |= 0x40000;
            }
            if (this.mRecents) {
                disable1 |= 0x1000000;
            }
            if (this.mSearch) {
                disable1 |= 0x2000000;
            }
            if (this.mSystemIcons) {
                disable1 |= 0x100000;
            }
            if (this.mClock) {
                disable1 |= 0x800000;
            }
            if (this.mNotificationIcons) {
                disable1 |= 0x20000;
            }
            if (this.mRotationSuggestion) {
                disable2 |= 0x10;
            }
            return new Pair<Integer, Integer>(disable1, disable2);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaTransferReceiverState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaTransferSenderState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NavBarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WindowVisibleState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WindowType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Disable2Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableFlags {
    }
}

