/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PropertyInvalidatedCache<Query, Result> {
    public static final String MODULE_TEST = "test";
    public static final String MODULE_SYSTEM = "system_server";
    public static final String MODULE_BLUETOOTH = "bluetooth";
    public static final String MODULE_TELEPHONY = "telephony";
    private static final int NONCE_UNSET = 0;
    private static final int NONCE_DISABLED = 1;
    private static final int NONCE_CORKED = 2;
    private static final int NONCE_BYPASS = 3;
    private static final String[] sNonceName = new String[]{"unset", "disabled", "corked", "bypass"};
    private static final String TAG = "PropertyInvalidatedCache";
    private static final boolean DEBUG = false;
    private static final boolean VERIFY = false;
    @GuardedBy(value={"mLock"})
    private long mHits = 0L;
    @GuardedBy(value={"mLock"})
    private long mMisses = 0L;
    @GuardedBy(value={"mLock"})
    private long[] mSkips = new long[]{0L, 0L, 0L, 0L};
    @GuardedBy(value={"mLock"})
    private long mMissOverflow = 0L;
    @GuardedBy(value={"mLock"})
    private long mHighWaterMark = 0L;
    @GuardedBy(value={"mLock"})
    private long mClears = 0L;
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Long> sInvalidates = new HashMap();
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Long> sCorkedInvalidates = new HashMap();
    private static boolean sEnabled = true;
    private static final Object sCorkLock = new Object();
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Integer> sCorks = new HashMap();
    @GuardedBy(value={"sCorkLock"})
    private static final HashSet<String> sDisabledKeys = new HashSet();
    @GuardedBy(value={"sCorkLock"})
    private static final WeakHashMap<PropertyInvalidatedCache, Void> sCaches = new WeakHashMap();
    private final Object mLock = new Object();
    private final String mPropertyName;
    private volatile SystemProperties.Handle mPropertyHandle;
    private final String mCacheName;
    private QueryHandler<Query, Result> mComputer;
    @GuardedBy(value={"mLock"})
    private final LinkedHashMap<Query, Result> mCache;
    @GuardedBy(value={"mLock"})
    private long mLastSeenNonce = 0L;
    private boolean mDisabled = false;
    private final int mMaxEntries;
    private static volatile boolean sTesting = false;
    private static final HashMap<String, Long> sTestingPropertyMap = new HashMap();
    static final String NAME_CONTAINS = "-name-has=";
    static final String NAME_LIKE = "-name-like=";
    static final String PROPERTY_CONTAINS = "-property-has=";
    static final String PROPERTY_LIKE = "-property-like=";

    public static String createPropertyName(String module, String apiName) {
        char[] api = apiName.toCharArray();
        int upper = 0;
        for (int i = 1; i < api.length; ++i) {
            if (!Character.isUpperCase(api[i])) continue;
            ++upper;
        }
        char[] suffix = new char[api.length + upper];
        int j = 0;
        for (int i = 0; i < api.length; ++i) {
            if (Character.isJavaIdentifierPart(api[i])) {
                if (Character.isUpperCase(api[i])) {
                    if (i > 0) {
                        suffix[j++] = 95;
                    }
                    suffix[j++] = Character.toLowerCase(api[i]);
                    continue;
                }
                suffix[j++] = api[i];
                continue;
            }
            throw new IllegalArgumentException("invalid api name");
        }
        return "cache_key." + module + "." + new String(suffix);
    }

    private static boolean isReservedNonce(long n) {
        return n >= 0L && n <= 3L;
    }

    public PropertyInvalidatedCache(int maxEntries, String propertyName) {
        this(maxEntries, propertyName, propertyName);
    }

    public PropertyInvalidatedCache(int maxEntries, String propertyName, String cacheName) {
        this.mPropertyName = propertyName;
        this.mCacheName = cacheName;
        this.mMaxEntries = maxEntries;
        this.mComputer = new DefaultComputer(this);
        this.mCache = this.createMap();
        this.registerCache();
    }

    public PropertyInvalidatedCache(int maxEntries, String module, String api, String cacheName, QueryHandler<Query, Result> computer) {
        this.mPropertyName = PropertyInvalidatedCache.createPropertyName(module, api);
        this.mCacheName = cacheName;
        this.mMaxEntries = maxEntries;
        this.mComputer = computer;
        this.mCache = this.createMap();
        this.registerCache();
    }

    private LinkedHashMap<Query, Result> createMap() {
        return new LinkedHashMap<Query, Result>(2, 0.75f, true){

            @Override
            @GuardedBy(value={"mLock"})
            protected boolean removeEldestEntry(Map.Entry eldest) {
                int size = this.size();
                if ((long)size > PropertyInvalidatedCache.this.mHighWaterMark) {
                    PropertyInvalidatedCache.this.mHighWaterMark = size;
                }
                if (size > PropertyInvalidatedCache.this.mMaxEntries) {
                    ++PropertyInvalidatedCache.this.mMissOverflow;
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCache() {
        Object object = sCorkLock;
        synchronized (object) {
            sCaches.put(this, null);
            if (sDisabledKeys.contains(this.mCacheName)) {
                this.disableInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestMode(boolean mode) {
        sTesting = mode;
        HashMap<String, Long> hashMap = sTestingPropertyMap;
        synchronized (hashMap) {
            sTestingPropertyMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testPropertyName(String name) {
        HashMap<String, Long> hashMap = sTestingPropertyMap;
        synchronized (hashMap) {
            sTestingPropertyMap.put(name, 0L);
        }
    }

    public void testPropertyName() {
        PropertyInvalidatedCache.testPropertyName(this.mPropertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentNonce() {
        SystemProperties.Handle handle;
        if (sTesting) {
            HashMap<String, Long> hashMap = sTestingPropertyMap;
            synchronized (hashMap) {
                Long n = sTestingPropertyMap.get(this.mPropertyName);
                if (n != null) {
                    return n;
                }
            }
        }
        if ((handle = this.mPropertyHandle) == null) {
            handle = SystemProperties.find(this.mPropertyName);
            if (handle == null) {
                return 0L;
            }
            this.mPropertyHandle = handle;
        }
        return handle.getLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setNonce(String name, long val) {
        if (sTesting) {
            HashMap<String, Long> hashMap = sTestingPropertyMap;
            synchronized (hashMap) {
                Long n = sTestingPropertyMap.get(name);
                if (n != null) {
                    sTestingPropertyMap.put(name, val);
                    return;
                }
            }
        }
        SystemProperties.set(name, Long.toString(val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNonce(String name) {
        if (sTesting) {
            HashMap<String, Long> hashMap = sTestingPropertyMap;
            synchronized (hashMap) {
                Long n = sTestingPropertyMap.get(name);
                if (n != null) {
                    return n;
                }
            }
        }
        return SystemProperties.getLong(name, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.clear();
            ++this.mClears;
        }
    }

    public Result recompute(Query query) {
        return this.mComputer.apply(query);
    }

    public boolean bypass(Query query) {
        return this.mComputer.shouldBypassCache(query);
    }

    public boolean resultEquals(Result cachedResult, Result fetchedResult) {
        if (fetchedResult != null) {
            return Objects.equals(cachedResult, fetchedResult);
        }
        return true;
    }

    protected Result refresh(Result oldResult, Query query) {
        return oldResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableInstance() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDisabled = true;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disableLocal(String name) {
        Object object = sCorkLock;
        synchronized (object) {
            sDisabledKeys.add(name);
            for (PropertyInvalidatedCache cache : sCaches.keySet()) {
                if (!name.equals(cache.mCacheName)) continue;
                cache.disableInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetDisableLocal() {
        Object object = sCorkLock;
        synchronized (object) {
            sDisabledKeys.remove(this.mCacheName);
        }
    }

    public void disableLocal() {
        this.disableForCurrentProcess();
    }

    public void disableForCurrentProcess() {
        PropertyInvalidatedCache.disableLocal(this.mCacheName);
    }

    public static void disableForCurrentProcess(String cacheName) {
        PropertyInvalidatedCache.disableLocal(cacheName);
    }

    public boolean isDisabled() {
        return this.mDisabled || !sEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result query(Query query) {
        long currentNonce;
        block23: {
            Result cachedResult;
            block24: {
                Result refreshedResult;
                long l = currentNonce = !this.isDisabled() ? this.getCurrentNonce() : 1L;
                if (this.bypass(query)) {
                    currentNonce = 3L;
                }
                while (true) {
                    if (PropertyInvalidatedCache.isReservedNonce(currentNonce)) {
                        if (!this.mDisabled) {
                            Object object = this.mLock;
                            synchronized (object) {
                                int n = (int)currentNonce;
                                this.mSkips[n] = this.mSkips[n] + 1L;
                            }
                        }
                        return this.recompute(query);
                    }
                    Object object = this.mLock;
                    synchronized (object) {
                        if (currentNonce == this.mLastSeenNonce) {
                            cachedResult = this.mCache.get(query);
                            if (cachedResult != null) {
                                ++this.mHits;
                            }
                        } else {
                            this.clear();
                            this.mLastSeenNonce = currentNonce;
                            cachedResult = null;
                        }
                    }
                    if (cachedResult == null) break block23;
                    refreshedResult = this.refresh(cachedResult, query);
                    if (refreshedResult == cachedResult) break block24;
                    long afterRefreshNonce = this.getCurrentNonce();
                    if (currentNonce == afterRefreshNonce) break;
                    currentNonce = afterRefreshNonce;
                }
                Object object = this.mLock;
                synchronized (object) {
                    if (currentNonce == this.mLastSeenNonce) {
                        if (refreshedResult == null) {
                            this.mCache.remove(query);
                        } else {
                            this.mCache.put(query, refreshedResult);
                        }
                    }
                }
                return this.maybeCheckConsistency(query, refreshedResult);
            }
            return this.maybeCheckConsistency(query, cachedResult);
        }
        Result result = this.recompute(query);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastSeenNonce == currentNonce && result != null) {
                this.mCache.put(query, result);
            }
            ++this.mMisses;
        }
        return this.maybeCheckConsistency(query, result);
    }

    public void disableSystemWide() {
        PropertyInvalidatedCache.disableSystemWide(this.mPropertyName);
    }

    private static void disableSystemWide(String name) {
        if (!sEnabled) {
            return;
        }
        PropertyInvalidatedCache.setNonce(name, 1L);
    }

    public void invalidateCache() {
        PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
    }

    public static void invalidateCache(String module, String api) {
        PropertyInvalidatedCache.invalidateCache(PropertyInvalidatedCache.createPropertyName(module, api));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCache(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            Integer numberCorks = sCorks.get(name);
            if (numberCorks != null && numberCorks > 0) {
                long count = sCorkedInvalidates.getOrDefault(name, 0L);
                sCorkedInvalidates.put(name, count + 1L);
                return;
            }
            PropertyInvalidatedCache.invalidateCacheLocked(name);
        }
    }

    @GuardedBy(value={"sCorkLock"})
    private static void invalidateCacheLocked(String name) {
        long newValue;
        long nonce = PropertyInvalidatedCache.getNonce(name);
        if (nonce == 1L) {
            return;
        }
        while (PropertyInvalidatedCache.isReservedNonce(newValue = NoPreloadHolder.next())) {
        }
        PropertyInvalidatedCache.setNonce(name, newValue);
        long invalidateCount = sInvalidates.getOrDefault(name, 0L);
        sInvalidates.put(name, ++invalidateCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corkInvalidations(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks == 0) {
                long nonce = PropertyInvalidatedCache.getNonce(name);
                if (nonce != 0L && nonce != 1L) {
                    PropertyInvalidatedCache.setNonce(name, 2L);
                }
            } else {
                long count = sCorkedInvalidates.getOrDefault(name, 0L);
                sCorkedInvalidates.put(name, count + 1L);
            }
            sCorks.put(name, numberCorks + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncorkInvalidations(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks < 1) {
                throw new AssertionError((Object)("cork underflow: " + name));
            }
            if (numberCorks == 1) {
                sCorks.remove(name);
                PropertyInvalidatedCache.invalidateCacheLocked(name);
            } else {
                sCorks.put(name, numberCorks - 1);
            }
        }
    }

    private Result maybeCheckConsistency(Query query, Result proposedResult) {
        return proposedResult;
    }

    public String cacheName() {
        return this.mCacheName;
    }

    public String propertyName() {
        return this.mPropertyName;
    }

    protected String queryToString(Query query) {
        return Objects.toString(query);
    }

    public static void disableForTestMode() {
        Log.d(TAG, "disabling all caches in the process");
        sEnabled = false;
    }

    public boolean getDisabledState() {
        return this.isDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<PropertyInvalidatedCache> getActiveCaches() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<PropertyInvalidatedCache>(sCaches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<Map.Entry<String, Integer>> getActiveCorks() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<Map.Entry<String, Integer>>(sCorks.entrySet());
        }
    }

    private static boolean anyDetailed(String[] args) {
        for (String a : args) {
            if (!a.startsWith(NAME_CONTAINS) && !a.startsWith(NAME_LIKE) && !a.startsWith(PROPERTY_CONTAINS) && !a.startsWith(PROPERTY_LIKE)) continue;
            return true;
        }
        return false;
    }

    private static boolean chooses(String arg, String key, String reference, boolean contains) {
        if (arg.startsWith(key)) {
            String value = arg.substring(key.length());
            if (contains) {
                return reference.contains(value);
            }
            return reference.matches(value);
        }
        return false;
    }

    private boolean showDetailed(String[] args) {
        for (String a : args) {
            if (!PropertyInvalidatedCache.chooses(a, NAME_CONTAINS, this.cacheName(), true) && !PropertyInvalidatedCache.chooses(a, NAME_LIKE, this.cacheName(), false) && !PropertyInvalidatedCache.chooses(a, PROPERTY_CONTAINS, this.mPropertyName, true) && !PropertyInvalidatedCache.chooses(a, PROPERTY_LIKE, this.mPropertyName, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpContents(PrintWriter pw, boolean detailed, String[] args) {
        long corkedInvalidates;
        long invalidateCount;
        if (detailed && !this.showDetailed(args)) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            invalidateCount = sInvalidates.getOrDefault(this.mPropertyName, 0L);
            corkedInvalidates = sCorkedInvalidates.getOrDefault(this.mPropertyName, 0L);
        }
        object = this.mLock;
        synchronized (object) {
            pw.println(TextUtils.formatSimple("  Cache Name: %s", this.cacheName()));
            pw.println(TextUtils.formatSimple("    Property: %s", this.mPropertyName));
            long skips = this.mSkips[2] + this.mSkips[0] + this.mSkips[1] + this.mSkips[3];
            pw.println(TextUtils.formatSimple("    Hits: %d, Misses: %d, Skips: %d, Clears: %d", this.mHits, this.mMisses, skips, this.mClears));
            pw.println(TextUtils.formatSimple("    Skip-corked: %d, Skip-unset: %d, Skip-bypass: %d, Skip-other: %d", this.mSkips[2], this.mSkips[0], this.mSkips[3], this.mSkips[1]));
            pw.println(TextUtils.formatSimple("    Nonce: 0x%016x, Invalidates: %d, CorkedInvalidates: %d", this.mLastSeenNonce, invalidateCount, corkedInvalidates));
            pw.println(TextUtils.formatSimple("    Current Size: %d, Max Size: %d, HW Mark: %d, Overflows: %d", this.mCache.size(), this.mMaxEntries, this.mHighWaterMark, this.mMissOverflow));
            pw.println(TextUtils.formatSimple("    Enabled: %s", this.mDisabled ? "false" : "true"));
            pw.println("");
            if (!detailed) {
                return;
            }
            Set<Map.Entry<Query, Result>> cacheEntries = this.mCache.entrySet();
            if (cacheEntries.size() == 0) {
                return;
            }
            pw.println("    Contents:");
            for (Map.Entry<Query, Result> entry : cacheEntries) {
                String key = Objects.toString(entry.getKey());
                String value = Objects.toString(entry.getValue());
                pw.println(TextUtils.formatSimple("      Key: %s\n      Value: %s\n", key, value));
            }
        }
    }

    @GuardedBy(value={"sCorkLock"})
    private static void dumpCorkInfo(PrintWriter pw) {
        ArrayList<Map.Entry<String, Integer>> activeCorks = PropertyInvalidatedCache.getActiveCorks();
        if (activeCorks.size() > 0) {
            pw.println("  Corking Status:");
            for (int i = 0; i < activeCorks.size(); ++i) {
                Map.Entry<String, Integer> entry = activeCorks.get(i);
                pw.println(TextUtils.formatSimple("    Property Name: %s Count: %d", entry.getKey(), entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpCacheInfo(PrintWriter pw, String[] args) {
        ArrayList<PropertyInvalidatedCache> activeCaches;
        if (!sEnabled) {
            pw.println("  Caching is disabled in this process.");
            return;
        }
        boolean detail = PropertyInvalidatedCache.anyDetailed(args);
        Object object = sCorkLock;
        synchronized (object) {
            activeCaches = PropertyInvalidatedCache.getActiveCaches();
            if (!detail) {
                PropertyInvalidatedCache.dumpCorkInfo(pw);
            }
        }
        for (int i = 0; i < activeCaches.size(); ++i) {
            PropertyInvalidatedCache currentCache = activeCaches.get(i);
            currentCache.dumpContents(pw, detail, args);
        }
    }

    public static void dumpCacheInfo(ParcelFileDescriptor pfd, String[] args) {
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        PrintWriter bout = new PrintWriter(barray);
        PropertyInvalidatedCache.dumpCacheInfo(bout, args);
        bout.close();
        try {
            FileOutputStream out = new FileOutputStream(pfd.getFileDescriptor());
            barray.writeTo(out);
            out.close();
            barray.close();
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to dump PropertyInvalidatedCache instances");
        }
    }

    public static void onTrimMemory() {
        for (PropertyInvalidatedCache pic : PropertyInvalidatedCache.getActiveCaches()) {
            pic.clear();
        }
    }

    public static class AutoCorker {
        public static final int DEFAULT_AUTO_CORK_DELAY_MS = 50;
        private final String mPropertyName;
        private final int mAutoCorkDelayMs;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private long mUncorkDeadlineMs = -1L;
        @GuardedBy(value={"mLock"})
        private Handler mHandler;

        public AutoCorker(String propertyName) {
            this(propertyName, 50);
        }

        public AutoCorker(String propertyName, int autoCorkDelayMs) {
            this.mPropertyName = propertyName;
            this.mAutoCorkDelayMs = autoCorkDelayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autoCork() {
            if (Looper.getMainLooper() == null) {
                PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean alreadyQueued = this.mUncorkDeadlineMs >= 0L;
                this.mUncorkDeadlineMs = SystemClock.uptimeMillis() + (long)this.mAutoCorkDelayMs;
                if (!alreadyQueued) {
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    PropertyInvalidatedCache.corkInvalidations(this.mPropertyName);
                } else {
                    Object object2 = sCorkLock;
                    synchronized (object2) {
                        long count = sCorkedInvalidates.getOrDefault(this.mPropertyName, 0L);
                        sCorkedInvalidates.put(this.mPropertyName, count + 1L);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message msg) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUncorkDeadlineMs < 0L) {
                    return;
                }
                long nowMs = SystemClock.uptimeMillis();
                if (this.mUncorkDeadlineMs > nowMs) {
                    this.mUncorkDeadlineMs = nowMs + (long)this.mAutoCorkDelayMs;
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    return;
                }
                this.mUncorkDeadlineMs = -1L;
                PropertyInvalidatedCache.uncorkInvalidations(this.mPropertyName);
            }
        }

        @GuardedBy(value={"mLock"})
        private Handler getHandlerLocked() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper()){

                    @Override
                    public void handleMessage(Message msg) {
                        this.handleMessage(msg);
                    }
                };
            }
            return this.mHandler;
        }
    }

    private static class NoPreloadHolder {
        private static final AtomicLong sNextNonce = new AtomicLong(new Random().nextLong());

        private NoPreloadHolder() {
        }

        public static long next() {
            return sNextNonce.getAndIncrement();
        }
    }

    private static class DefaultComputer<Query, Result>
    extends QueryHandler<Query, Result> {
        final PropertyInvalidatedCache<Query, Result> mCache;

        DefaultComputer(PropertyInvalidatedCache<Query, Result> cache) {
            this.mCache = cache;
        }

        @Override
        public Result apply(Query query) {
            return this.mCache.recompute(query);
        }
    }

    public static abstract class QueryHandler<Q, R> {
        public abstract R apply(Q var1);

        public boolean shouldBypassCache(Q query) {
            return false;
        }
    }
}

