/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.IApplicationThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAppTask
extends IInterface {
    public void finishAndRemoveTask() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/IAppTask.aidl:27:1:27:69")
    public ActivityManager.RecentTaskInfo getTaskInfo() throws RemoteException;

    public void moveToFront(IApplicationThread var1, String var2) throws RemoteException;

    public int startActivity(IBinder var1, String var2, String var3, Intent var4, String var5, Bundle var6) throws RemoteException;

    public void setExcludeFromRecents(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppTask {
        public static final String DESCRIPTOR = "android.app.IAppTask";
        static final int TRANSACTION_finishAndRemoveTask = 1;
        static final int TRANSACTION_getTaskInfo = 2;
        static final int TRANSACTION_moveToFront = 3;
        static final int TRANSACTION_startActivity = 4;
        static final int TRANSACTION_setExcludeFromRecents = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAppTask asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAppTask) {
                return (IAppTask)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "finishAndRemoveTask";
                }
                case 2: {
                    return "getTaskInfo";
                }
                case 3: {
                    return "moveToFront";
                }
                case 4: {
                    return "startActivity";
                }
                case 5: {
                    return "setExcludeFromRecents";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.finishAndRemoveTask();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ActivityManager.RecentTaskInfo _result = this.getTaskInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    IApplicationThread _arg0 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.moveToFront(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Intent _arg3 = data.readTypedObject(Intent.CREATOR);
                    String _arg4 = data.readString();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.startActivity(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setExcludeFromRecents(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IAppTask {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishAndRemoveTask() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ActivityManager.RecentTaskInfo getTaskInfo() throws RemoteException {
                ActivityManager.RecentTaskInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ActivityManager.RecentTaskInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveToFront(IApplicationThread appThread, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(appThread);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startActivity(IBinder whoThread, String callingPackage, String callingFeatureId, Intent intent, String resolvedType, Bundle options) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(whoThread);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    _data.writeTypedObject(intent, 0);
                    _data.writeString(resolvedType);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExcludeFromRecents(boolean exclude) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(exclude);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAppTask {
        @Override
        public void finishAndRemoveTask() throws RemoteException {
        }

        @Override
        public ActivityManager.RecentTaskInfo getTaskInfo() throws RemoteException {
            return null;
        }

        @Override
        public void moveToFront(IApplicationThread appThread, String callingPackage) throws RemoteException {
        }

        @Override
        public int startActivity(IBinder whoThread, String callingPackage, String callingFeatureId, Intent intent, String resolvedType, Bundle options) throws RemoteException {
            return 0;
        }

        @Override
        public void setExcludeFromRecents(boolean exclude) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

