/*
 * Decompiled with CFR 0.152.
 */
package android.adservices;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetTopicsResponse
implements Parcelable {
    public static final int RESULT_OK = 0;
    public static final int RESULT_INTERNAL_ERROR = 1;
    public static final int RESULT_INVALID_ARGUMENT = 2;
    public static final int RESULT_IO_ERROR = 3;
    public static final int RESULT_RATE_LIMIT_REACHED = 4;
    private final int mResultCode;
    private final String mErrorMessage;
    private final List<Long> mTaxonomyVersions;
    private final List<Long> mModelVersions;
    private final List<String> mTopics;
    public static final Parcelable.Creator<GetTopicsResponse> CREATOR = new Parcelable.Creator<GetTopicsResponse>(){

        @Override
        public GetTopicsResponse createFromParcel(Parcel in) {
            return new GetTopicsResponse(in);
        }

        public GetTopicsResponse[] newArray(int size) {
            return new GetTopicsResponse[size];
        }
    };

    private GetTopicsResponse(int resultCode, String errorMessage, List<Long> taxonomyVersions, List<Long> modelVersions, List<String> topics) {
        this.mResultCode = resultCode;
        this.mErrorMessage = errorMessage;
        this.mTaxonomyVersions = taxonomyVersions;
        this.mModelVersions = modelVersions;
        this.mTopics = topics;
    }

    private GetTopicsResponse(Parcel in) {
        this.mResultCode = in.readInt();
        this.mErrorMessage = in.readString();
        this.mTaxonomyVersions = Collections.unmodifiableList(GetTopicsResponse.readLongList(in));
        this.mModelVersions = Collections.unmodifiableList(GetTopicsResponse.readLongList(in));
        ArrayList<String> topicsMutable = new ArrayList<String>();
        in.readStringList(topicsMutable);
        this.mTopics = Collections.unmodifiableList(topicsMutable);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mResultCode);
        out.writeString(this.mErrorMessage);
        GetTopicsResponse.writeLongList(out, this.mTaxonomyVersions);
        GetTopicsResponse.writeLongList(out, this.mModelVersions);
        out.writeStringList(this.mTopics);
    }

    public boolean isSuccess() {
        return this.getResultCode() == 0;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public List<Long> getTaxonomyVersions() {
        return this.mTaxonomyVersions;
    }

    public List<Long> getModelVersions() {
        return this.mModelVersions;
    }

    public List<String> getTopics() {
        return this.mTopics;
    }

    private static List<Long> readLongList(Parcel in) {
        ArrayList<Long> list = new ArrayList<Long>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readLong());
        }
        return list;
    }

    private static void writeLongList(Parcel out, List<Long> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (Long l : val) {
            out.writeLong(l);
        }
    }

    public static class Builder {
        private int mResultCode;
        private String mErrorMessage;
        private List<Long> mTaxonomyVersions = new ArrayList<Long>();
        private List<Long> mModelVersions = new ArrayList<Long>();
        private List<String> mTopics = new ArrayList<String>();

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        public Builder setTaxonomyVersions(List<Long> taxonomyVersions) {
            this.mTaxonomyVersions = taxonomyVersions;
            return this;
        }

        public Builder setModelVersions(List<Long> modelVersions) {
            this.mModelVersions = modelVersions;
            return this;
        }

        public Builder setTopics(List<String> topics) {
            this.mTopics = topics;
            return this;
        }

        public GetTopicsResponse build() {
            if (this.mTopics == null || this.mTaxonomyVersions == null || this.mModelVersions == null) {
                throw new IllegalArgumentException("Topics or TaxonomyVersion or ModelVersion is null");
            }
            if (this.mTopics.size() != this.mTaxonomyVersions.size() || this.mTopics.size() != this.mModelVersions.size()) {
                throw new IllegalArgumentException("Size mismatch in Topics");
            }
            return new GetTopicsResponse(this.mResultCode, this.mErrorMessage, this.mTaxonomyVersions, this.mModelVersions, this.mTopics);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

