/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.ibm.icu.text.MessagePattern;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NlsCapitalizationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.I18nInspection;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public class TitleCapitalizationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                UExpression uElement = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UInjectionHost.class, UCallExpression.class, UReferenceExpression.class});
                if (uElement == null) {
                    return;
                }
                Value titleValue = TitleCapitalizationInspection.getTitleValue(uElement, new HashSet());
                if (titleValue == null) {
                    return;
                }
                List<UExpression> usages = I18nInspection.findIndirectUsages(uElement, false);
                if (usages.isEmpty()) {
                    usages = Collections.singletonList(uElement);
                }
                EnumSet<Nls.Capitalization> capitalizationContexts = EnumSet.noneOf(Nls.Capitalization.class);
                for (UExpression usage : usages) {
                    capitalizationContexts.add(this.getCapitalization(usage));
                }
                capitalizationContexts.remove(Nls.Capitalization.NotSpecified);
                for (Nls.Capitalization capitalization : capitalizationContexts) {
                    String message;
                    if (titleValue.isSatisfied(capitalization)) continue;
                    TitleCapitalizationFix fix = null;
                    if (capitalizationContexts.size() > 1) {
                        message = JavaI18nBundle.message("inspection.title.capitalization.mix.description", new Object[0]);
                    } else if (titleValue instanceof DeclaredValue) {
                        message = JavaI18nBundle.message("inspection.title.capitalization.mismatch.description", titleValue, TitleCapitalizationInspection.getCapitalizationName(capitalization));
                    } else {
                        fix = titleValue.canFix() && element instanceof PsiExpression ? new TitleCapitalizationFix(titleValue, capitalization) : null;
                        message = JavaI18nBundle.message("inspection.title.capitalization.description", titleValue, TitleCapitalizationInspection.getCapitalizationName(capitalization));
                    }
                    holder.registerProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }

            private Nls.Capitalization getCapitalization(UExpression usage) {
                Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
                NlsInfo info = NlsInfo.forExpression(usage, false);
                if (info instanceof NlsInfo.Localized) {
                    capitalization = ((NlsInfo.Localized)info).getCapitalization();
                } else if (info.getNlsStatus() == ThreeState.UNSURE) {
                    PsiParameter parameter;
                    PsiMethod method;
                    UCallExpression call;
                    UElement parent = usage.getUastParent();
                    if (usage instanceof UCallExpression && parent instanceof UQualifiedReferenceExpression) {
                        parent = parent.getUastParent();
                    }
                    if ((call = (UCallExpression)ObjectUtils.tryCast((Object)parent, UCallExpression.class)) != null && (method = call.resolve()) != null && (parameter = AnnotationContext.getParameter((PsiMethod)method, (UCallExpression)call, (UExpression)usage)) != null) {
                        capitalization = TitleCapitalizationInspection.getSupplierCapitalization(parameter);
                    }
                }
                return capitalization;
            }
        };
    }

    @Nls
    private static String getCapitalizationName(Nls.Capitalization capitalization) {
        return switch (capitalization) {
            case Nls.Capitalization.Title -> JavaI18nBundle.message("capitalization.kind.title", new Object[0]);
            case Nls.Capitalization.Sentence -> JavaI18nBundle.message("capitalization.kind.sentence", new Object[0]);
            default -> throw new IllegalArgumentException();
        };
    }

    @Nullable
    private static Value getTitleValue(@Nullable UExpression arg, Set<? super UExpression> processed) {
        if (arg instanceof UInjectionHost) {
            return Value.of((UInjectionHost)arg);
        }
        if (arg instanceof UCallExpression) {
            UCallExpression call = (UCallExpression)arg;
            UExpression returnValue = StringFlowUtil.getReturnValue((UCallExpression)call);
            if (arg.equals(returnValue)) {
                return null;
            }
            if (returnValue != null && processed.add((UExpression)returnValue)) {
                return TitleCapitalizationInspection.getTitleValue(returnValue, processed);
            }
            Value fromProperty = Value.of(TitleCapitalizationInspection.getPropertyArgument(call), call.getValueArgumentCount() > 1);
            if (fromProperty != null) {
                return fromProperty;
            }
        }
        if (arg instanceof UResolvable) {
            Value value;
            PsiElement target = ((UResolvable)arg).resolve();
            if (target instanceof PsiModifierListOwner && (value = Value.of(NlsInfo.forModifierListOwner((PsiModifierListOwner)target))) != null) {
                return value;
            }
            PsiType type = arg.getExpressionType();
            if (type != null) {
                return Value.of(NlsInfo.forType(type));
            }
        }
        return null;
    }

    @Nullable
    private static Property getPropertyArgument(UCallExpression arg) {
        List args = arg.getValueArguments();
        if (!args.isEmpty()) {
            return JavaI18nUtil.resolveProperty((UExpression)args.get(0));
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Nls.Capitalization getSupplierCapitalization(PsiParameter parameter) {
        NlsInfo info;
        PsiType typeParameter;
        PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)parameter.getType(), PsiClassType.class);
        if (classType != null && classType.equalsToText("java.util.function.Supplier<java.lang.String>") && (typeParameter = (PsiType)ArrayUtil.getFirstElement((Object[])classType.getParameters())) != null && (info = NlsInfo.forType(typeParameter)) instanceof NlsInfo.Localized) {
            return ((NlsInfo.Localized)info).getCapitalization();
        }
        return Nls.Capitalization.NotSpecified;
    }

    static interface Value {
        @NotNull
        public String toString();

        public boolean isSatisfied(@NotNull Nls.Capitalization var1);

        @NotNull
        default public String fixCapitalization(@NotNull Nls.Capitalization capitalization) {
            return NlsCapitalizationUtil.fixValue((String)this.toString(), (Nls.Capitalization)capitalization);
        }

        default public boolean canFix() {
            return true;
        }

        @Contract(value="null, _ -> null")
        @Nullable
        public static Value of(@Nullable Property property, boolean useFormat) {
            if (property == null) {
                return null;
            }
            String value = property.getUnescapedValue();
            if (value == null) {
                return null;
            }
            if (useFormat) {
                try {
                    MessagePattern pattern = new MessagePattern(MessagePattern.ApostropheMode.DOUBLE_REQUIRED);
                    pattern.parse(value);
                    return new PropertyValue(value, pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new TextValue(value);
        }

        public static Value of(@NotNull UInjectionHost literal) {
            String value = literal.evaluateToString();
            return value == null ? null : new TextValue(value);
        }

        @Nullable
        public static Value of(@NotNull PsiLiteralExpression literal) {
            Object value = literal.getValue();
            return value instanceof String ? new TextValue((String)value) : null;
        }

        @Nullable
        public static Value of(NlsInfo info) {
            Nls.Capitalization capitalization;
            if (info instanceof NlsInfo.Localized && (capitalization = ((NlsInfo.Localized)info).getCapitalization()) != Nls.Capitalization.NotSpecified) {
                return new DeclaredValue(capitalization);
            }
            return null;
        }
    }

    static class PropertyValue
    implements Value {
        private final String myPresentation;
        private final MessagePattern myPattern;

        PropertyValue(String presentation, MessagePattern pattern) {
            this.myPresentation = presentation;
            this.myPattern = pattern;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myPresentation;
        }

        private int getMessagesForPart(int index) {
            MessagePattern.Part part = this.myPattern.getPart(index);
            if (part.getType() != MessagePattern.Part.Type.ARG_START) {
                return 0;
            }
            int limitPart = this.myPattern.getLimitPartIndex(index);
            int msgCount = 0;
            int nesting = -1;
            for (int i = index + 1; i < limitPart; ++i) {
                part = this.myPattern.getPart(i);
                if (part.getType() != MessagePattern.Part.Type.MSG_START) continue;
                if (nesting == -1) {
                    nesting = part.getValue();
                } else if (nesting != part.getValue()) continue;
                ++msgCount;
            }
            return msgCount;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == Nls.Capitalization.NotSpecified) {
                return true;
            }
            int parts = this.myPattern.countParts();
            int maxMsgCount = IntStreamEx.range((int)parts).map(this::getMessagesForPart).append(new int[]{1}).max().orElse(1);
            String string = this.myPattern.getPatternString();
            for (int curIndex = 0; curIndex < maxMsgCount; ++curIndex) {
                StringBuilder sample = new StringBuilder();
                int msgIndex = 0;
                int nestingLevel = 0;
                int curMsgCount = 0;
                boolean inMsg = false;
                for (int i = 1; i < parts; ++i) {
                    boolean shouldCopyPart;
                    MessagePattern.Part part = this.myPattern.getPart(i);
                    boolean bl = shouldCopyPart = nestingLevel == 0 || inMsg && msgIndex == curIndex % curMsgCount + 1;
                    if (shouldCopyPart) {
                        sample.append(string, this.myPattern.getPart(i - 1).getLimit(), this.myPattern.getPatternIndex(i));
                    }
                    if (part.getType() == MessagePattern.Part.Type.ARG_START) {
                        ++nestingLevel;
                        MessagePattern.ArgType argType = part.getArgType();
                        if ((argType == MessagePattern.ArgType.SIMPLE || argType == MessagePattern.ArgType.NONE) && shouldCopyPart) {
                            sample.append("_");
                        }
                        msgIndex = 0;
                        curMsgCount = Math.max(1, this.getMessagesForPart(i));
                        continue;
                    }
                    if (part.getType() == MessagePattern.Part.Type.MSG_START) {
                        ++msgIndex;
                        inMsg = true;
                        continue;
                    }
                    if (part.getType() == MessagePattern.Part.Type.MSG_LIMIT) {
                        inMsg = false;
                        continue;
                    }
                    if (part.getType() != MessagePattern.Part.Type.ARG_LIMIT) continue;
                    --nestingLevel;
                }
                if (NlsCapitalizationUtil.isCapitalizationSatisfied((String)sample.toString(), (Nls.Capitalization)capitalization)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canFix() {
            return IntStream.range(0, this.myPattern.countParts()).anyMatch(idx -> {
                MessagePattern.ArgType type = this.myPattern.getPart(idx).getArgType();
                return type == MessagePattern.ArgType.NONE || type == MessagePattern.ArgType.SIMPLE;
            });
        }
    }

    static class DeclaredValue
    implements Value {
        private final Nls.Capitalization myDeclared;

        DeclaredValue(Nls.Capitalization declared) {
            this.myDeclared = declared;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            return capitalization == Nls.Capitalization.NotSpecified || capitalization == this.myDeclared;
        }

        @Override
        public boolean canFix() {
            return false;
        }

        @Override
        @NotNull
        public String toString() {
            return TitleCapitalizationInspection.getCapitalizationName(this.myDeclared);
        }
    }

    static class TextValue
    implements Value {
        private final String myText;

        TextValue(String text) {
            this.myText = text;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myText;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            return NlsCapitalizationUtil.isCapitalizationSatisfied((String)StringUtil.stripHtml((String)this.myText, (boolean)true), (Nls.Capitalization)capitalization);
        }
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final Value myTitleValue;
        private final Nls.Capitalization myCapitalization;

        TitleCapitalizationFix(Value titleValue, Nls.Capitalization capitalization) {
            this.myTitleValue = titleValue;
            this.myCapitalization = capitalization;
        }

        @NotNull
        public String getName() {
            return JavaI18nBundle.message("quickfix.text.title.capitalization", this.myTitleValue);
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement problemElement = descriptor.getPsiElement();
            if (problemElement == null) {
                return;
            }
            this.doFix(project, problemElement);
        }

        @Nullable
        private static PsiLiteralExpression getTargetLiteral(@NotNull PsiElement element) {
            PsiMethodCallExpression call;
            PsiMethod method;
            PsiExpression returnValue;
            if (element instanceof PsiLiteralExpression) {
                return (PsiLiteralExpression)element;
            }
            if (element instanceof PsiMethodCallExpression && (returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)(method = (call = (PsiMethodCallExpression)element).resolveMethod()))) != null) {
                return (PsiLiteralExpression)ObjectUtils.tryCast((Object)returnValue, PsiLiteralExpression.class);
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
                if (variable == null) {
                    return null;
                }
                if (variable.hasModifierProperty("final")) {
                    return (PsiLiteralExpression)ObjectUtils.tryCast((Object)variable.getInitializer(), PsiLiteralExpression.class);
                }
            }
            return null;
        }

        protected void doFix(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiLiteralExpression literal = TitleCapitalizationFix.getTargetLiteral(element);
            if (literal != null) {
                Value value = Value.of(literal);
                if (value == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)value.fixCapitalization(this.myCapitalization)) + "\"", element);
                literal.replace((PsiElement)newExpression);
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                Property property = TitleCapitalizationFix.getPropertyArgument(call);
                Value value = Value.of(property, call.getArgumentList().getExpressionCount() > 1);
                if (value == null) {
                    return;
                }
                property.setValue(value.fixCapitalization(this.myCapitalization));
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            PsiElement element = previewDescriptor.getStartElement();
            PsiLiteralExpression literal = TitleCapitalizationFix.getTargetLiteral(element);
            if (literal != null) {
                PsiFile file = literal.getContainingFile();
                if (file == element.getContainingFile()) {
                    this.doFix(project, element);
                    return IntentionPreviewInfo.DIFF;
                }
                PsiElement parent = literal.getParent();
                Value value = Value.of(literal);
                if (value == null) {
                    return IntentionPreviewInfo.EMPTY;
                }
                Object mark = PsiTreeUtil.mark((PsiElement)literal);
                PsiElement copyParent = parent.copy();
                PsiLiteralExpression copyLiteral = (PsiLiteralExpression)Objects.requireNonNull(PsiTreeUtil.releaseMark((PsiElement)copyParent, (Object)mark));
                String newLiteral = "\"" + StringUtil.escapeStringCharacters((String)value.fixCapitalization(this.myCapitalization)) + "\"";
                copyLiteral.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newLiteral, null));
                return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, file.getName(), parent.getText(), copyParent.getText());
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                Property property = TitleCapitalizationFix.getPropertyArgument(call);
                Value value = Value.of(property, call.getArgumentList().getExpressionCount() > 1);
                if (value == null) {
                    return IntentionPreviewInfo.EMPTY;
                }
                Property copy = (Property)property.copy();
                copy.setValue(value.fixCapitalization(this.myCapitalization));
                return new IntentionPreviewInfo.CustomDiff((FileType)PropertiesFileType.INSTANCE, property.getContainingFile().getName(), property.getText(), copy.getText());
            }
            return IntentionPreviewInfo.EMPTY;
        }

        @Nullable
        private static Property getPropertyArgument(PsiMethodCallExpression arg) {
            PsiExpression[] args = arg.getArgumentList().getExpressions();
            if (args.length > 0) {
                return JavaI18nUtil.resolveProperty((PsiElement)args[0]);
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            return JavaI18nBundle.message("quickfix.family.title.capitalization.fix", new Object[0]);
        }
    }
}

