/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public class I18nizeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(I18nizeAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean active;
        boolean bl = active = I18nizeAction.getHandler(e) != null;
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(active);
        } else {
            e.getPresentation().setEnabled(active);
        }
    }

    @Nullable
    public static I18nQuickFixHandler<?> getHandler(AnActionEvent e) {
        Editor editor = I18nizeAction.getEditor(e);
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        return I18nizeAction.getHandler(editor, psiFile);
    }

    @Nullable
    public static I18nQuickFixHandler<?> getHandler(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement element;
        NlsInfo info;
        TextRange range = JavaI18nUtil.getSelectedRange(editor, psiFile);
        if (range == null) {
            return null;
        }
        UInjectionHost literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        NlsInfo.Localized localized = NlsInfo.localized();
        if (literalExpression != null && (info = NlsInfo.forExpression((UExpression)literalExpression)) instanceof NlsInfo.Localized) {
            localized = (NlsInfo.Localized)info;
        }
        if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(element = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            return new I18nizeConcatenationQuickFix(localized);
        }
        if (Optional.ofNullable(literalExpression).map(UastUtils::getTextRange).map(it -> it.contains(range)).orElse(false).booleanValue()) {
            return new I18nizeQuickFix(localized);
        }
        for (I18nizeHandlerProvider handlerProvider : (I18nizeHandlerProvider[])I18nizeHandlerProvider.EP_NAME.getExtensions()) {
            I18nQuickFixHandler<?> handler = handlerProvider.getHandler(psiFile, editor, range);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    public static UInjectionHost getEnclosingStringLiteral(PsiFile psiFile, Editor editor) {
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        return I18nizeAction.getEnclosingStringLiteral(psiElement);
    }

    @Nullable
    public static UInjectionHost getEnclosingStringLiteral(PsiElement psiElement) {
        while (psiElement != null) {
            UInjectionHost uastStringLiteral = (UInjectionHost)UastContextKt.toUElement((PsiElement)psiElement, UInjectionHost.class);
            if (uastStringLiteral != null && uastStringLiteral.isString()) {
                return uastStringLiteral;
            }
            psiElement = psiElement.getParent();
        }
        return null;
    }

    private static Editor getEditor(AnActionEvent e) {
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    public static <T extends UExpression> void doI18nSelectedString(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull I18nQuickFixHandler<T> handler) {
        try {
            handler.checkApplicability(psiFile, editor);
        }
        catch (IncorrectOperationException ex) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)ex.getMessage(), (String)JavaI18nBundle.message("i18nize.error.title", new Object[0]), null);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JavaI18nizeQuickFixDialog.isAvailable(psiFile);
        }
        try {
            ResourceBundleManager.getManager(psiFile);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            return;
        }
        JavaI18nizeQuickFixDialog dialog = handler.createDialog(project, editor, psiFile);
        if (dialog == null) {
            return;
        }
        if (!dialog.showAndGet()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        Collection propertiesFiles = dialog.getAllPropertiesFiles();
        for (PropertiesFile file : propertiesFiles) {
            if (FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) continue;
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            try {
                handler.performI18nization(psiFile, editor, dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), StringUtil.unescapeStringCharacters((String)dialog.getValue()), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }, PropertiesBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = I18nizeAction.getEditor(e);
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        I18nQuickFixHandler<?> handler = I18nizeAction.getHandler(e);
        if (handler == null) {
            return;
        }
        I18nizeAction.doI18nSelectedString(project, editor, psiFile, handler);
    }
}

