/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.io.CancellableFileIo;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.sdklib.util.CommandLineParser;
import com.android.utils.ILogger;
import com.android.utils.IReaderLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class AvdManagerCli
extends CommandLineParser {
    private static final String VERB_LIST = "list";
    private static final String VERB_CREATE = "create";
    private static final String VERB_MOVE = "move";
    private static final String VERB_DELETE = "delete";
    private static final String OBJECT_AVDS = "avds";
    private static final String OBJECT_AVD = "avd";
    private static final String OBJECT_TARGET = "target";
    private static final String OBJECT_TARGETS = "targets";
    private static final String OBJECT_DEVICE = "device";
    private static final String OBJECT_DEVICES = "devices";
    private static final String KEY_IMAGE_PACKAGE = "package";
    private static final String KEY_NAME = "name";
    private static final String KEY_PATH = "path";
    private static final String KEY_SDCARD = "sdcard";
    private static final String KEY_FORCE = "force";
    private static final String KEY_RENAME = "rename";
    private static final String KEY_COMPACT = "compact";
    private static final String KEY_EOL_NULL = "null";
    private static final String KEY_TAG = "tag";
    private static final String KEY_SKIN = "skin";
    private static final String KEY_ABI = "abi";
    private static final String KEY_CLEAR_CACHE = "clear-cache";
    private static final String KEY_DEVICE = "device";
    private static final String TOOLSDIR = "com.android.sdkmanager.toolsdir";
    private static final String WORKDIR = "com.android.sdkmanager.workdir";
    private static final String[] BOOLEAN_YES_REPLIES = new String[]{"yes", "y"};
    private static final String[] BOOLEAN_NO_REPLIES = new String[]{"no", "n"};
    private static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    private static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    private InputStream mInput;
    private String mOsSdkFolder;
    private final ILogger mSdkLog;
    private AndroidSdkHandler mSdkHandler;
    private AvdManager mAvdManager;
    private Path mAvdFolder;
    private static final String[][] ACTIONS = new String[][]{{"list", "", "Lists existing targets or virtual devices."}, {"list", "avd", "Lists existing Android Virtual Devices.", "avds"}, {"list", "target", "Lists existing targets.", "targets"}, {"list", "device", "Lists existing devices.", "devices"}, {"create", "avd", "Creates a new Android Virtual Device."}, {"move", "avd", "Moves or renames an Android Virtual Device."}, {"delete", "avd", "Deletes an Android Virtual Device."}};

    public static void main(String[] args) {
        try {
            AtomicReference<AvdManagerCli> reference = new AtomicReference<AvdManagerCli>();
            ILogger logger = AvdManagerCli.createLogger(reference);
            AvdManagerCli instance = new AvdManagerCli(logger);
            reference.set(instance);
            instance.run(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    @VisibleForTesting
    void run(String[] args) {
        this.init();
        this.parseArgs(args);
        if (this.mSdkHandler == null) {
            this.mSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, Paths.get(this.mOsSdkFolder, new String[0]));
        }
        this.doAction();
    }

    private static ILogger createLogger(final AtomicReference<AvdManagerCli> cli) {
        return new IReaderLogger(){

            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    System.err.printf("Error: " + errorFormat, args);
                    if (!errorFormat.endsWith("\n")) {
                        System.err.printf("\n", new Object[0]);
                    }
                }
                if (t != null) {
                    System.err.printf("Error: %s\n", t.getMessage());
                }
            }

            public void warning(String warningFormat, Object ... args) {
                if (((AvdManagerCli)cli.get()).isVerbose()) {
                    System.out.printf("Warning: " + warningFormat, args);
                    if (!warningFormat.endsWith("\n")) {
                        System.out.printf("\n", new Object[0]);
                    }
                }
            }

            public void info(String msgFormat, Object ... args) {
                if (!((AvdManagerCli)cli.get()).isSilent()) {
                    System.out.printf(msgFormat, args);
                }
            }

            public void verbose(String msgFormat, Object ... args) {
                if (((AvdManagerCli)cli.get()).isVerbose()) {
                    System.out.printf(msgFormat, args);
                }
            }

            public int readLine(byte[] inputBuffer) throws IOException {
                return System.in.read(inputBuffer);
            }
        };
    }

    private void init() {
        String workDirProp;
        if (this.mAvdFolder == null) {
            try {
                this.mAvdFolder = AndroidLocationsSingleton.INSTANCE.getAvdLocation();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.mOsSdkFolder == null) {
            String toolsDirProp = System.getProperty(TOOLSDIR);
            if (toolsDirProp == null) {
                toolsDirProp = System.getenv(TOOLSDIR);
            }
            if (toolsDirProp != null) {
                File tools;
                if (!toolsDirProp.isEmpty()) {
                    try {
                        tools = new File(toolsDirProp).getCanonicalFile();
                        if (tools.getParent() != null) {
                            this.mOsSdkFolder = tools.getParentFile().getParent();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.mOsSdkFolder == null) {
                    try {
                        tools = new File(".").getCanonicalFile();
                        this.mOsSdkFolder = tools.getParent();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (this.mOsSdkFolder == null) {
                String cmdName = "avdmanager" + (FileOpUtils.isWindows() ? ".bat" : "");
                this.errorAndExit("The tools directory property is not set, please make sure you are executing %1$s", cmdName);
            }
        }
        if (this.mInput == null) {
            this.mInput = System.in;
        }
        if ((workDirProp = System.getProperty(WORKDIR)) == null) {
            workDirProp = System.getenv(WORKDIR);
        }
        if (workDirProp != null) {
            File workDir = new File(workDirProp);
            try {
                workDir = workDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                workDir = null;
            }
            if (workDir == null || !workDir.isDirectory()) {
                this.errorAndExit("The working directory does not seem to be valid: '%1$s", workDirProp);
            }
        }
    }

    private AvdManager getAvdManager() throws AndroidLocationsException {
        if (this.mAvdManager == null) {
            this.mAvdManager = AvdManager.createInstance(this.mSdkHandler, this.mAvdFolder, DeviceManager.createInstance(this.mSdkHandler, this.mSdkLog), this.mSdkLog);
        }
        return this.mAvdManager;
    }

    private void doAction() {
        String verb = this.getVerb();
        String directObject = this.getDirectObject();
        if (VERB_LIST.equals(verb)) {
            if (OBJECT_AVD.equals(directObject)) {
                this.displayAvdList();
            } else if ("device".equals(directObject)) {
                this.displayDeviceList();
            } else if (OBJECT_TARGET.equals(directObject)) {
                this.displayTargetList();
            } else {
                this.displayAvdList();
                this.displayDeviceList();
                this.displayTargetList();
            }
        } else if (VERB_CREATE.equals(verb)) {
            if (OBJECT_AVD.equals(directObject)) {
                this.createAvd();
            }
        } else if (VERB_DELETE.equals(verb) && OBJECT_AVD.equals(directObject)) {
            this.deleteAvd();
        } else if (VERB_MOVE.equals(verb) && OBJECT_AVD.equals(directObject)) {
            this.moveAvd();
        } else {
            this.printHelpAndExit(null, new Object[0]);
        }
    }

    private void displayTagAbiList(Collection<? extends ISystemImage> systemImages, String message) {
        this.mSdkLog.info(message, new Object[0]);
        if (!systemImages.isEmpty()) {
            boolean first = true;
            for (ISystemImage iSystemImage : systemImages) {
                if (!first) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    first = false;
                }
                this.mSdkLog.info("%s/%s", new Object[]{iSystemImage.getTag().getId(), iSystemImage.getAbiType()});
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no ABIs.\n", new Object[0]);
        }
    }

    private void displayAvdList(AvdManager avdManager) {
        ArrayList<AvdInfo> avds = new ArrayList<AvdInfo>((Collection<AvdInfo>)avdManager.getValidAvds());
        avds.sort((a1, a2) -> a1.getName().compareToIgnoreCase(a2.getName()));
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (AvdInfo info : avds) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{info.getName(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available Android Virtual Devices:\n", new Object[0]);
        for (int index = 0; index < avds.size(); ++index) {
            String snapshot;
            String sdcard;
            AvdInfo info = (AvdInfo)avds.get(index);
            if (index > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{info.getName()});
            String deviceName = info.getProperties().get("hw.device.name");
            String deviceMfctr = info.getProperties().get("hw.device.manufacturer");
            if (deviceName != null) {
                this.mSdkLog.info("  Device: %s", new Object[]{deviceName});
                if (deviceMfctr != null) {
                    this.mSdkLog.info(" (%s)", new Object[]{deviceMfctr});
                }
                this.mSdkLog.info("\n", new Object[0]);
            }
            this.mSdkLog.info("    Path: %s\n", new Object[]{info.getDataFolderPath()});
            SystemImage img = (SystemImage)info.getSystemImage();
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)img.getPackage().getTypeDetails();
            String versionWithCodename = AndroidVersionUtils.getFullReleaseName(details.getAndroidVersion(), false, true);
            if (details instanceof DetailsTypes.PlatformDetailsType) {
                this.mSdkLog.info("  API: %s", new Object[]{versionWithCodename});
            } else if (details instanceof DetailsTypes.SysImgDetailsType) {
                IdDisplay vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
                String vendorStr = "";
                if (vendor != null) {
                    vendorStr = " (" + vendor.getDisplay() + ")";
                }
                this.mSdkLog.info("  Target: %s%s\n", new Object[]{img.getTag().getDisplay(), vendorStr});
                this.mSdkLog.info("          Based on: %s", new Object[]{versionWithCodename});
            } else if (details instanceof DetailsTypes.AddonDetailsType) {
                this.mSdkLog.info("  Target: %s (%s)\n", new Object[]{img.getPackage().getDisplayName(), ((DetailsTypes.AddonDetailsType)details).getVendor().getDisplay()});
                this.mSdkLog.info("          Based on: %s\n", new Object[]{versionWithCodename});
            }
            this.mSdkLog.info(" Tag/ABI: %s/%s\n", new Object[]{info.getTag().getId(), info.getAbiType()});
            Map<String, String> properties = info.getProperties();
            String skin = properties.get("skin.name");
            if (skin != null) {
                this.mSdkLog.info("    Skin: %s\n", new Object[]{skin});
            }
            if ((sdcard = properties.get("sdcard.size")) == null) {
                sdcard = properties.get("sdcard.path");
            }
            if (sdcard != null) {
                this.mSdkLog.info("  Sdcard: %s\n", new Object[]{sdcard});
            }
            if ((snapshot = properties.get("snapshot.present")) == null) continue;
            this.mSdkLog.info("Snapshot: %s\n", new Object[]{snapshot});
        }
        List badAvds = Arrays.asList(avdManager.getAllAvds()).stream().filter(avd -> avd.getStatus() != AvdInfo.AvdStatus.OK).collect(Collectors.toList());
        if (badAvds.isEmpty()) {
            return;
        }
        this.mSdkLog.info("\nThe following Android Virtual Devices could not be loaded:\n", new Object[0]);
        boolean needSeparator = false;
        for (AvdInfo info : badAvds) {
            if (needSeparator) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{info.getName()});
            this.mSdkLog.info("    Path: %s\n", new Object[]{info.getDataFolderPath()});
            String error = info.getErrorMessage();
            this.mSdkLog.info("   Error: %s\n", new Object[]{error == null ? "Uknown error" : error});
            needSeparator = true;
        }
    }

    private void displayAvdList() {
        try {
            AvdManager avdManager = this.getAvdManager();
            this.displayAvdList(avdManager);
        }
        catch (AndroidLocationsException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    void displayTargetList() {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator(){

            public void logVerbose(String s) {
            }
        };
        Collection<IAndroidTarget> targets = this.mSdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (IAndroidTarget target : targets) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{target.hashString(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available Android targets:\n", new Object[0]);
        int index = 1;
        for (IAndroidTarget target : targets) {
            this.mSdkLog.info("----------\n", new Object[0]);
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{index, target.hashString()});
            this.mSdkLog.info("     Name: %s\n", new Object[]{target.getName()});
            if (target.isPlatform()) {
                this.mSdkLog.info("     Type: Platform\n", new Object[0]);
                this.mSdkLog.info("     API level: %s\n", new Object[]{target.getVersion().getApiString()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{target.getRevision()});
            } else {
                this.mSdkLog.info("     Type: Add-On\n", new Object[0]);
                this.mSdkLog.info("     Vendor: %s\n", new Object[]{target.getVendor()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{target.getRevision()});
                this.mSdkLog.info("     Based on Android %s (API level %s)\n", new Object[]{target.getVersionName(), target.getVersion().getApiString()});
                List<OptionalLibrary> libraries = target.getAdditionalLibraries();
                if (!libraries.isEmpty()) {
                    this.mSdkLog.info("     Libraries:\n", new Object[0]);
                    for (OptionalLibrary library : libraries) {
                        this.mSdkLog.info("      * %1$s (%2$s)\n", new Object[]{library.getName(), library.getJar().getFileName().toString()});
                        this.mSdkLog.info("          %1$s\n", new Object[]{library.getDescription()});
                    }
                }
            }
            Path targetLocation = this.mSdkHandler.toCompatiblePath(target.getLocation());
            ISystemImage image = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(targetLocation);
            if (image != null) {
                this.displayTagAbiList((Collection<? extends ISystemImage>)ImmutableList.of((Object)image), " Tag/ABIs : ");
            }
            ++index;
        }
    }

    private void displayDeviceList() {
        ArrayList<Device> devices = new ArrayList<Device>(this.createDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
        Collections.sort(devices, Device.getDisplayComparator());
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (Device device : devices) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{device.getId(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available devices definitions:\n", new Object[0]);
        for (int index = 0; index < devices.size(); ++index) {
            Device device = (Device)devices.get(index);
            if (index > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{index, device.getId()});
            this.mSdkLog.info("    Name: %s\n", new Object[]{device.getDisplayName()});
            this.mSdkLog.info("    OEM : %s\n", new Object[]{device.getManufacturer()});
            String tag = device.getTagId();
            if (tag == null) continue;
            this.mSdkLog.info("    Tag : %s\n", new Object[]{tag});
        }
    }

    private DeviceManager createDeviceManager() {
        try {
            File androidFolder = AndroidLocationsSingleton.INSTANCE.getPrefsLocation().toFile();
        }
        catch (Throwable e) {
            this.mSdkLog.warning(e.getMessage(), new Object[0]);
            Object androidFolder = null;
        }
        return DeviceManager.createInstance(this.mSdkHandler, this.mSdkLog);
    }

    private String getValidImagePaths() {
        return this.mSdkHandler.getSystemImageManager((ProgressIndicator)new ProgressIndicatorAdapter(){}).getImages().stream().map(image -> image.getPackage().getPath()).collect(Collectors.joining("\n"));
    }

    private ProgressIndicator createProgressIndicator() {
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (this.isSilent()) {
            NullOutputStream nullStream = new NullOutputStream();
            out = new PrintStream(nullStream);
        }
        return new ConsoleProgressIndicator(out, err){

            public void logVerbose(String s) {
            }
        };
    }

    private void createAvd() {
        LocalPackage imagePkg;
        ProgressIndicator progress = this.createProgressIndicator();
        String packagePath = this.getParamPkgPath();
        if (packagePath == null) {
            this.errorAndExit("Package path (-k) not specified. Valid system image paths are:\n" + this.getValidImagePaths(), new Object[0]);
        }
        if ((imagePkg = this.mSdkHandler.getLocalPackage(packagePath, progress)) == null) {
            this.errorAndExit("Package path is not valid. Valid system image paths are:\n" + this.getValidImagePaths(), new Object[0]);
        }
        assert (imagePkg != null);
        Collection sysImgs = this.mSdkHandler.getSystemImageManager(progress).getImageMap().get((Object)imagePkg);
        if (sysImgs.isEmpty()) {
            this.errorAndExit("Package %1$s (%2$s) contains no system images. Valid system image paths are:\n%3$s", imagePkg.getDisplayName(), imagePkg.getPath(), this.getValidImagePaths());
        }
        try {
            AvdInfo newAvdInfo;
            String paramFolderPath;
            boolean removePrevious = this.getFlagForce();
            AvdManager avdManager = this.getAvdManager();
            String avdName = this.getParamName();
            if (!RE_AVD_NAME.matcher(avdName).matches()) {
                this.errorAndExit("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, CHARS_AVD_NAME);
                return;
            }
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info != null) {
                if (removePrevious) {
                    this.mSdkLog.warning("Android Virtual Device '%s' already exists and will be replaced.", new Object[]{avdName});
                } else {
                    this.errorAndExit("Android Virtual Device '%s' already exists.\nUse --force if you want to replace it.", avdName);
                    return;
                }
            }
            Path avdFolder = (paramFolderPath = this.getParamLocationPath()) != null ? this.mSdkHandler.toCompatiblePath(paramFolderPath) : AvdInfo.getDefaultAvdFolder(avdManager, avdName, false);
            IdDisplay tag = SystemImage.DEFAULT_TAG;
            String abiType = this.getParamAbi();
            String cmdTag = this.getParamTag();
            if (cmdTag == null) {
                DetailsTypes.SysImgDetailsType details = (DetailsTypes.SysImgDetailsType)imagePkg.getTypeDetails();
                List<IdDisplay> tags = details.getTags();
                IdDisplay idDisplay = tag = tags.isEmpty() ? null : tags.get(0);
            }
            if (abiType != null && abiType.indexOf(47) != -1) {
                String[] segments = abiType.split("/");
                if (segments.length == 2) {
                    if (cmdTag == null) {
                        cmdTag = segments[0];
                    } else if (!cmdTag.equals(segments[0])) {
                        this.errorAndExit("--%1$s %2$s conflicts with --%3$s %4$s.", KEY_TAG, cmdTag, KEY_ABI, abiType);
                    }
                    abiType = segments[1];
                } else {
                    this.errorAndExit("Invalid --%1$s %2$s: expected format 'abi' or 'tag/abi'.", KEY_ABI, abiType);
                }
            }
            if (cmdTag == null || cmdTag.isEmpty()) {
                cmdTag = tag.getId();
            }
            HashSet<String> tags = new HashSet<String>();
            for (Object systemImage : sysImgs) {
                tags.add(systemImage.getTag().getId());
            }
            if (!tags.contains(cmdTag)) {
                this.errorAndExit("Invalid --%1$s %2$s for the selected package. Valid tags are:\n%3$s", KEY_TAG, cmdTag, Joiner.on((String)"\n").join(tags));
            }
            SystemImage img = null;
            if (abiType == null || abiType.isEmpty()) {
                if (sysImgs.size() == 1) {
                    abiType = ((SystemImage)sysImgs.iterator().next()).getAbiType();
                    img = (SystemImage)sysImgs.iterator().next();
                    this.mSdkLog.info("Auto-selecting single ABI %1$s\n", new Object[]{abiType});
                } else {
                    this.displayTagAbiList(sysImgs, "Valid ABIs: ");
                    this.errorAndExit("This package has more than one ABI. Please specify one using --%1$s.", KEY_ABI);
                }
            } else {
                for (SystemImage systemImage : sysImgs) {
                    if (!systemImage.getAbiType().equals(abiType)) continue;
                    img = systemImage;
                    break;
                }
                if (img == null) {
                    this.displayTagAbiList(sysImgs, "Valid ABIs: ");
                    this.errorAndExit("Invalid --%1$s %2$s for the selected package.", KEY_ABI, abiType);
                }
            }
            assert (img != null);
            Device device = null;
            String deviceParam = this.getParamDevice();
            if (deviceParam != null) {
                ArrayList<Device> devices = new ArrayList<Device>(this.createDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
                Collections.sort(devices, Device.getDisplayComparator());
                int index = -1;
                try {
                    index = Integer.parseInt(deviceParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (index >= 0 && index < devices.size()) {
                    device = (Device)devices.get(index);
                } else {
                    for (Device d : devices) {
                        if (!deviceParam.equals(d.getId())) continue;
                        device = d;
                        break;
                    }
                }
                if (device == null) {
                    this.errorAndExit("No device found matching --%1$s %2$s.", "device", deviceParam);
                }
            }
            TreeMap<String, String> hardwareConfig = new TreeMap();
            if (device != null) {
                hardwareConfig = this.defaultHardwareConfig();
                hardwareConfig.putAll(DeviceManager.getHardwareProperties(device));
                EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
            } else {
                try {
                    hardwareConfig = this.promptForHardware();
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                }
            }
            if (this.getParamSdCard() != null) {
                hardwareConfig.put("hw.sdCard", "yes");
            }
            AvdManagerCli.updateUninitializedDynamicParameters(hardwareConfig);
            String skinName = this.getParamSkin();
            Path skinPath = null;
            if (skinName != null && Files.notExists(skinPath = this.mSdkHandler.getLocation().resolve("skins").resolve(skinName), new LinkOption[0])) {
                this.errorAndExit("Skin " + skinName + " not found at " + skinPath, new Object[0]);
            }
            if ((newAvdInfo = avdManager.createAvd(avdFolder, avdName, img, skinPath, skinName, this.getParamSdCard(), hardwareConfig, device == null ? null : device.getBootProps(), true, removePrevious, false)) == null) {
                this.errorAndExit("AVD not created.", new Object[0]);
            }
        }
        catch (AndroidLocationsException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private static Map<String, String> defaultEmulatorPropertiesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hw.camera.back", AvdCamera.EMULATED.getAsParameter());
        map.put("hw.cpu.ncore", String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES));
        map.put("showDeviceFrame", "yes");
        map.put("hw.camera.front", AvdCamera.EMULATED.getAsParameter());
        map.put("hw.keyboard", "yes");
        map.put("hw.gpu.mode", GpuMode.AUTO.getGpuSetting());
        map.put("hw.initialOrientation", "Portrait");
        map.put("disk.dataPartition.size", EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString());
        map.put("runtime.network.latency", AvdNetworkLatency.NONE.getAsParameter());
        map.put("runtime.network.speed", AvdNetworkSpeed.FULL.getAsParameter());
        map.put("sdcard.size", EmulatedProperties.DEFAULT_SDCARD_SIZE.toString());
        map.put("fastboot.forceChosenSnapshotBoot", "no");
        map.put("fastboot.forceColdBoot", "no");
        map.put("fastboot.forceFastBoot", "yes");
        map.put("hw.gpu.enabled", "yes");
        map.put("vm.heapSize", EmulatedProperties.DEFAULT_HEAP.toString());
        return map;
    }

    private void deleteAvd() {
        try {
            String avdName = this.getParamName();
            AvdManager avdManager = this.getAvdManager();
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info == null) {
                this.errorAndExit("There is no Android Virtual Device named '%s'.", avdName);
                return;
            }
            avdManager.deleteAvd(info);
        }
        catch (AndroidLocationsException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void moveAvd() {
        try {
            Path originalFolder;
            String paramFolderLocation;
            Path paramFolderPath;
            String avdName = this.getParamName();
            AvdManager avdManager = this.getAvdManager();
            AvdInfo info = avdManager.getAvd(avdName, true);
            if (info == null) {
                this.errorAndExit("There is no valid Android Virtual Device named '%s'.", avdName);
                return;
            }
            String newName = this.getParamMoveNewName();
            if (newName != null && newName.equals(info.getName())) {
                newName = null;
            }
            Path path = paramFolderPath = (paramFolderLocation = this.getParamLocationPath()) == null ? null : this.mSdkHandler.toCompatiblePath(paramFolderLocation);
            if (paramFolderPath != null) {
                try {
                    Path f2 = info.getDataFolderPath();
                    if (CancellableFileIo.isSameFile((Path)paramFolderPath, (Path)f2)) {
                        paramFolderPath = null;
                    }
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                    return;
                }
            }
            if (newName == null && paramFolderPath == null) {
                this.mSdkLog.warning("Move operation aborted: same AVD name, same canonical data path", new Object[0]);
                return;
            }
            if (newName != null && paramFolderPath == null && (originalFolder = AndroidLocationsSingleton.INSTANCE.getAvdLocation().resolve(info.getName() + ".avd")).equals(info.getDataFolderPath())) {
                try {
                    paramFolderPath = AndroidLocationsSingleton.INSTANCE.getAvdLocation().resolve(newName + ".avd");
                }
                catch (Throwable e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                }
            }
            if (newName != null) {
                if (avdManager.getAvd(newName, false) != null) {
                    this.errorAndExit("There is already an AVD named '%s'.", newName);
                    return;
                }
                Path ini = info.getIniFile();
                if (ini.equals(AvdInfo.getDefaultIniFile(avdManager, newName))) {
                    this.errorAndExit("The AVD file '%s' is in the way.", ini.toRealPath(new LinkOption[0]));
                    return;
                }
            }
            if (paramFolderPath != null && CancellableFileIo.exists((Path)paramFolderPath, (LinkOption[])new LinkOption[0])) {
                this.errorAndExit("There is already a file or directory at '%s'.\nUse --path to specify a different data folder.", paramFolderPath);
            }
            if (newName != null) {
                HashMap<String, String> properties = new HashMap<String, String>(info.getProperties());
                properties.put("avd.ini.displayname", newName);
                avdManager.updateAvd(info, properties);
            }
            avdManager.moveAvd(info, newName, paramFolderPath);
        }
        catch (AndroidLocationsException | IOException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private Map<String, String> defaultHardwareConfig() {
        HardwareProperties.HardwareProperty[] hwProperties;
        LocalPackage emulatorPackage = this.mSdkHandler.getLocalPackage("emulator", (ProgressIndicator)new ProgressIndicatorAdapter(){});
        if (emulatorPackage == null) {
            this.errorAndExit("\"emulator\" package must be installed!", new Object[0]);
        }
        Path libDir = emulatorPackage.getLocation().resolve("lib");
        Path hardwareDefs = libDir.resolve("hardware-properties.ini");
        Map<String, HardwareProperties.HardwareProperty> hwMap = HardwareProperties.parseHardwareDefinitions(new PathFileWrapper(hardwareDefs), this.mSdkLog);
        Map<String, String> hwConfigMap = AvdManagerCli.defaultEmulatorPropertiesMap();
        for (HardwareProperties.HardwareProperty property : hwProperties = hwMap.values().toArray(new HardwareProperties.HardwareProperty[0])) {
            String defaultValue = property.getDefault();
            if (defaultValue == null || defaultValue.isEmpty()) continue;
            hwConfigMap.put(property.getName(), defaultValue);
        }
        return hwConfigMap;
    }

    private Map<String, String> promptForHardware() throws IOException {
        String defaultAnswer;
        byte[] readLineBuffer = new byte[256];
        String result = defaultAnswer = "no";
        this.mSdkLog.info("Do you wish to create a custom hardware profile? [%s] ", new Object[]{defaultAnswer});
        if (!this.isSilent()) {
            result = this.readLine(readLineBuffer).trim();
        }
        if (result.isEmpty()) {
            result = defaultAnswer;
        }
        if (!AvdManagerCli.getBooleanReply(result)) {
            Map<String, String> defaultConfig = this.defaultHardwareConfig();
            AvdManagerCli.updateUninitializedDynamicParameters(defaultConfig);
            return defaultConfig;
        }
        this.mSdkLog.info("\n", new Object[0]);
        LocalPackage emulatorPackage = this.mSdkHandler.getLocalPackage("emulator", (ProgressIndicator)new ProgressIndicatorAdapter(){});
        if (emulatorPackage == null) {
            this.errorAndExit("\"emulator\" package must be installed!", new Object[0]);
        }
        Path libDir = emulatorPackage.getLocation().resolve("lib");
        Path hardwareDefs = libDir.resolve("hardware-properties.ini");
        Map<String, HardwareProperties.HardwareProperty> hwMap = HardwareProperties.parseHardwareDefinitions(new PathFileWrapper(hardwareDefs), this.mSdkLog);
        HashMap<String, String> map = new HashMap<String, String>();
        HardwareProperties.HardwareProperty[] hwProperties = hwMap.values().toArray(new HardwareProperties.HardwareProperty[0]);
        int i = 0;
        while (i < hwProperties.length) {
            HardwareProperties.HardwareProperty property = hwProperties[i];
            String description = property.getDescription();
            if (description != null) {
                this.mSdkLog.info("%2d: %s: %s\n", new Object[]{i, property.getAbstract(), description});
            } else {
                this.mSdkLog.info("%2d: %s\n", new Object[]{i, property.getAbstract()});
            }
            String defaultValue = property.getDefault();
            if (defaultValue != null) {
                this.mSdkLog.info("%s [%s]:", new Object[]{property.getName(), defaultValue});
            } else {
                this.mSdkLog.info("%s (%s):", new Object[]{property.getName(), property.getType()});
            }
            result = this.readLine(readLineBuffer);
            if (result.isEmpty()) {
                if (defaultValue == null) continue;
                this.mSdkLog.info("\n", new Object[0]);
                if (!defaultValue.isEmpty()) {
                    map.put(property.getName(), defaultValue);
                }
                ++i;
                continue;
            }
            String validResponse = AvdManagerCli.validateResponse(result, property, this.mSdkLog);
            if (validResponse != null) {
                map.put(property.getName(), validResponse);
                ++i;
            }
            this.mSdkLog.info("\n", new Object[0]);
        }
        return map;
    }

    @VisibleForTesting
    public static String validateResponse(String userInput, HardwareProperties.HardwareProperty property, ILogger logger) {
        switch (property.getType()) {
            case BOOLEAN: {
                try {
                    return AvdManagerCli.getBooleanReply(userInput) ? "yes" : "no";
                }
                catch (IOException e) {
                    logger.info("\n%s\n", new Object[]{e.getMessage()});
                    return null;
                }
            }
            case INTEGER: {
                try {
                    Integer.parseInt(userInput);
                    return userInput;
                }
                catch (NumberFormatException e) {
                    logger.info("\nInvalid integer input: %s\n", new Object[]{e.getMessage()});
                    return null;
                }
            }
            case STRING: {
                return userInput;
            }
            case DISKSIZE: {
                return userInput;
            }
            case INTEGER_ENUM: {
                for (String enumString : property.getEnum()) {
                    if (!userInput.equals(enumString)) continue;
                    return userInput;
                }
                logger.info("\nInvalid entry. Allowed values are:", new Object[0]);
                for (String enumString : property.getEnum()) {
                    logger.info(" \"%s\"", new Object[]{enumString});
                }
                logger.info("\n", new Object[0]);
                return null;
            }
            case STRING_ENUM: {
                String priorEnumString = "";
                for (String enumString : property.getEnum()) {
                    if ("...".equals(enumString)) {
                        if (priorEnumString.endsWith("0") && userInput.startsWith(priorEnumString.substring(0, priorEnumString.length() - 1))) {
                            try {
                                Integer.parseInt(userInput.substring(priorEnumString.length() - 1));
                                return userInput;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (userInput.equals(enumString)) {
                        return userInput;
                    }
                    priorEnumString = enumString;
                }
                logger.info("\nInvalid entry. Allowed values are:", new Object[0]);
                for (String enumString : property.getEnum()) {
                    logger.info(" \"%s\"", new Object[]{enumString});
                }
                logger.info("\n", new Object[0]);
                return null;
            }
        }
        return null;
    }

    private static void updateUninitializedDynamicParameters(Map<String, String> hwConfig) {
        Storage ramSize;
        boolean updateRamSize = true;
        String ramSizeString = hwConfig.get("hw.ramSize");
        if (ramSizeString != null) {
            ramSize = Storage.getStorageFromString(ramSizeString);
            boolean bl = updateRamSize = ramSize == null || ramSize.getSize() == 0L;
        }
        if (updateRamSize) {
            int numPixels;
            String lcdWidthString = hwConfig.get("hw.lcd.width");
            String lcdHeightString = hwConfig.get("hw.lcd.height");
            try {
                numPixels = Integer.parseInt(lcdWidthString) * Integer.parseInt(lcdHeightString);
            }
            catch (Exception unused) {
                numPixels = 2073600;
            }
            ramSize = EmulatedProperties.defaultRamStorage(numPixels);
            hwConfig.put("hw.ramSize", ramSize.toIniString());
        }
        boolean updateInternalStorage = true;
        String internalStorageString = hwConfig.get("disk.dataPartition.size");
        if (internalStorageString != null) {
            Storage internalStorageSize = Storage.getStorageFromString(internalStorageString);
            boolean bl = updateInternalStorage = internalStorageSize == null || internalStorageSize.getSize() == 0L;
        }
        if (updateInternalStorage) {
            hwConfig.put("disk.dataPartition.size", EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toIniString());
        }
        boolean updateHeapSize = true;
        try {
            String heapSizeString = hwConfig.get("vm.heapSize");
            updateHeapSize = heapSizeString == null || Integer.parseInt(heapSizeString) == 0;
        }
        catch (Exception heapSizeString) {
            // empty catch block
        }
        if (updateHeapSize) {
            Density density = null;
            String densityString = hwConfig.get("hw.lcd.density");
            if (densityString != null && !densityString.isEmpty()) {
                if (!densityString.endsWith("dpi")) {
                    densityString = densityString + "dpi";
                }
                density = Density.getEnum((String)densityString);
            }
            if (density == null) {
                density = Density.DPI_420;
            }
            int screenWidth = 1080;
            try {
                screenWidth = Integer.parseInt(hwConfig.get("hw.lcd.width"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int screenHeight = 1920;
            try {
                screenHeight = Integer.parseInt(hwConfig.get("hw.lcd.height"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double screenDiagonalInches = Math.sqrt(screenHeight * screenHeight + screenWidth * screenWidth) / (double)density.getDpiValue();
            ScreenSize screenSize = ScreenSize.getScreenSize((Double)screenDiagonalInches);
            boolean isWear = screenDiagonalInches <= 2.5;
            Storage heapSize = EmulatedProperties.calculateDefaultVmHeapSize(screenSize, density, isWear);
            hwConfig.put("vm.heapSize", heapSize.toIniString());
        }
        boolean updateNumCores = true;
        try {
            String numCoresString = hwConfig.get("hw.cpu.ncore");
            updateNumCores = numCoresString == null || Integer.parseInt(numCoresString) == 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (updateNumCores) {
            hwConfig.put("hw.cpu.ncore", Integer.toString(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES));
        }
    }

    private String readLine(byte[] buffer) throws IOException {
        int count = this.mInput.read(buffer);
        if (count == buffer.length && buffer[count - 1] != 10) {
            byte[] tempBuffer = new byte[256];
            String secondHalf = this.readLine(tempBuffer);
            return new String(buffer, 0, count) + secondHalf;
        }
        while (count > 0 && (buffer[count - 1] == 13 || buffer[count - 1] == 10)) {
            --count;
        }
        return new String(buffer, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptPassword(String prompt) throws IOException {
        AtomicBoolean keepErasing = new AtomicBoolean(true);
        Thread eraser = new Thread(() -> {
            while (keepErasing.get()) {
                System.err.print("\b ");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }, "eraser");
        try {
            System.err.print(prompt);
            eraser.start();
            byte[] buffer = new byte[256];
            String string = this.readLine(buffer);
            return string;
        }
        finally {
            keepErasing.set(false);
            try {
                eraser.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean getBooleanReply(String reply) throws IOException {
        for (String valid : BOOLEAN_YES_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return true;
        }
        for (String valid : BOOLEAN_NO_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return false;
        }
        throw new IOException(String.format("%s is not a valid reply", reply));
    }

    private void errorAndExit(String format, Object ... args) {
        this.mSdkLog.error(null, format, args);
        throw new RuntimeException();
    }

    @VisibleForTesting
    AvdManagerCli(ILogger logger, AndroidSdkHandler sdkHandler, AvdManager avdManager, String sdkRoot, String avdRoot, InputStream input) {
        this(logger);
        this.mSdkHandler = sdkHandler;
        this.mAvdManager = avdManager;
        this.mOsSdkFolder = sdkRoot;
        this.mInput = input;
        this.mAvdFolder = sdkHandler.toCompatiblePath(avdRoot);
    }

    private AvdManagerCli(ILogger logger) {
        super(logger, ACTIONS);
        this.mSdkLog = logger;
        this.define(CommandLineParser.Mode.BOOLEAN, false, "@@internal@@", "", "", KEY_CLEAR_CACHE, "Clear the SDK Manager repository manifest cache.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_AVD, "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_AVD, "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0). Only used by --compact.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_TARGET, "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_TARGET, "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0) Only used by --compact.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "device", "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "device", "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0) Only used by --compact.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "p", KEY_PATH, "Directory where the new AVD will be created.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_AVD, "n", KEY_NAME, "Name of the new AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "k", KEY_IMAGE_PACKAGE, "Package path of the system image for this AVD (e.g. 'system-images;android-19;google_apis;x86').", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "c", KEY_SDCARD, "Path to a shared SD card image, or size of a new sdcard for the new AVD.", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_CREATE, OBJECT_AVD, "f", KEY_FORCE, "Forces creation (overwrites an existing AVD)", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "b", KEY_ABI, "The ABI to use for the AVD. The default is to auto-select the ABI if the platform has only one ABI for its system images.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "g", KEY_TAG, "The sys-img tag to use for the AVD. The default is to auto-select if the platform has only one tag for its system images.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "d", "device", "The optional device definition to use. Can be a device index or id.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "", KEY_SKIN, "The optional name of a skin to use with this device.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_DELETE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to delete.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_MOVE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to move or rename.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "r", KEY_RENAME, "New name of the AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "p", KEY_PATH, "Path to the AVD's new directory.", null);
    }

    @Override
    public boolean acceptLackOfVerb() {
        return true;
    }

    private String getParamLocationPath() {
        return (String)this.getValue(null, null, KEY_PATH);
    }

    private String getParamPkgPath() {
        return (String)this.getValue(null, null, KEY_IMAGE_PACKAGE);
    }

    private String getParamName() {
        return (String)this.getValue(null, null, KEY_NAME);
    }

    private String getParamSdCard() {
        return (String)this.getValue(null, null, KEY_SDCARD);
    }

    private boolean getFlagForce() {
        return (Boolean)this.getValue(null, null, KEY_FORCE);
    }

    private String getParamMoveNewName() {
        return (String)this.getValue(VERB_MOVE, null, KEY_RENAME);
    }

    private String getParamAbi() {
        return (String)this.getValue(null, null, KEY_ABI);
    }

    private String getParamTag() {
        return (String)this.getValue(null, null, KEY_TAG);
    }

    private String getParamSkin() {
        return (String)this.getValue(null, null, KEY_SKIN);
    }

    private String getParamDevice() {
        return (String)this.getValue(null, null, "device");
    }

    private boolean getFlagCompact() {
        return (Boolean)this.getValue(null, null, KEY_COMPACT);
    }

    private boolean getFlagEolNull() {
        return (Boolean)this.getValue(null, null, KEY_EOL_NULL);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

