/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.repository.Revision;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeArtifact;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeFile;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeSettings;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeToolchain;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.model.V1NdkModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.android.tools.ndk.sync.NativeWorkspace;
import com.android.tools.ndk.sync.NativeWorkspaceModifier;
import com.android.tools.ndk.sync.V1NdkModelBasedNativeWorkspaceModifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/ndk/sync/V1NdkModelBasedNativeWorkspaceModifier;", "Lcom/android/tools/ndk/sync/NativeWorkspaceModifier;", "ndkModuleModel", "Lcom/android/tools/idea/gradle/project/model/NdkModuleModel;", "v1NdkModel", "Lcom/android/tools/idea/gradle/project/model/V1NdkModel;", "variantAbisToSync", "", "Lcom/android/tools/idea/gradle/project/model/VariantAbi;", "(Lcom/android/tools/idea/gradle/project/model/NdkModuleModel;Lcom/android/tools/idea/gradle/project/model/V1NdkModel;Ljava/util/Collection;)V", "module", "", "getModule", "()Ljava/lang/String;", "modify", "", "nativeWorkspace", "Lcom/android/tools/ndk/sync/NativeWorkspace;", "android-ndk"})
public final class V1NdkModelBasedNativeWorkspaceModifier
implements NativeWorkspaceModifier {
    @NotNull
    private final NdkModuleModel ndkModuleModel;
    @NotNull
    private final V1NdkModel v1NdkModel;
    @NotNull
    private final Collection<VariantAbi> variantAbisToSync;

    public V1NdkModelBasedNativeWorkspaceModifier(@NotNull NdkModuleModel ndkModuleModel, @NotNull V1NdkModel v1NdkModel, @NotNull Collection<VariantAbi> variantAbisToSync) {
        Intrinsics.checkNotNullParameter((Object)ndkModuleModel, (String)"ndkModuleModel");
        Intrinsics.checkNotNullParameter((Object)v1NdkModel, (String)"v1NdkModel");
        Intrinsics.checkNotNullParameter(variantAbisToSync, (String)"variantAbisToSync");
        this.ndkModuleModel = ndkModuleModel;
        this.v1NdkModel = v1NdkModel;
        this.variantAbisToSync = variantAbisToSync;
    }

    @Override
    @NotNull
    public String getModule() {
        return this.ndkModuleModel.getModuleName();
    }

    @Override
    public void modify(@NotNull NativeWorkspace nativeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)nativeWorkspace, (String)"nativeWorkspace");
        nativeWorkspace.clearConfig((Function1<? super VariantAbi, Boolean>)((Function1)modify.1.INSTANCE));
        Map internSwitches = new LinkedHashMap();
        nativeWorkspace.addBuildFiles(this.v1NdkModel.getBuildFiles());
        Object[] objectArray = new File[]{FilesKt.resolve((File)this.ndkModuleModel.getRootDirPath(), (String)".cxx"), FilesKt.resolve((File)this.ndkModuleModel.getRootDirPath(), (String)".externalNativeBuild")};
        nativeWorkspace.addExcludeDirs(CollectionsKt.listOf((Object[])objectArray));
        File ndkFolder = null;
        for (VariantAbi variantAbi : this.variantAbisToSync) {
            NdkVariant selectedVariant;
            if (this.v1NdkModel.getNdkVariant(variantAbi) == null) continue;
            for (IdeNativeArtifact artifact : selectedVariant.getArtifacts()) {
                if (this.v1NdkModel.findToolchain(artifact.getToolChain()) == null) {
                    throw new RuntimeException("Could not find toolchain");
                }
                for (IdeNativeFile file : artifact.getSourceFiles()) {
                    CidrCompilerSwitches switches2;
                    File compilerExecutable;
                    IdeNativeToolchain toolchain;
                    CLanguageKind lang = CxxSyncUtilsKt.cxxLanguageKindFromFile(file.getFilePath());
                    if (CxxSyncUtilsKt.compilerExecutable((OCLanguageKind)lang, toolchain) == null) continue;
                    if (ndkFolder == null) {
                        Pair<File, Revision> pair = CxxSyncUtilsKt.findNdkFolderFromFileInNdk(compilerExecutable);
                        File file2 = ndkFolder = pair != null ? (File)pair.getFirst() : null;
                    }
                    if (VfsUtil.findFileByIoFile((File)file.getFilePath(), (boolean)false) == null) continue;
                    if ((CidrCompilerSwitches)internSwitches.computeIfAbsent(file.getSettingsName(), new Function(this){
                        final /* synthetic */ V1NdkModelBasedNativeWorkspaceModifier this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        @Nullable
                        public final CidrCompilerSwitches apply(@NotNull String settingsName) {
                            Intrinsics.checkNotNullParameter((Object)settingsName, (String)"settingsName");
                            IdeNativeSettings ideNativeSettings = V1NdkModelBasedNativeWorkspaceModifier.access$getV1NdkModel$p(this.this$0).findSettings(settingsName);
                            List<E> flags = ideNativeSettings != null ? ideNativeSettings.getCompilerFlags() : null;
                            return flags == null ? null : new CidrCompilerSwitches(CollectionsKt.toList((Iterable)flags));
                        }
                    }) == null) {
                        throw new RuntimeException("Settings '" + file.getSettingsName() + "' not present in module");
                    }
                    File workingDirectory = CxxSyncUtilsKt.workingDirectory(this.ndkModuleModel, file);
                    nativeWorkspace.addSource(variantAbi, file.getFilePath(), compilerExecutable, workingDirectory, switches2);
                }
            }
        }
        if (ndkFolder != null) {
            nativeWorkspace.addExcludeDirs(CollectionsKt.listOf(ndkFolder));
        }
    }

    public static final /* synthetic */ V1NdkModel access$getV1NdkModel$p(V1NdkModelBasedNativeWorkspaceModifier $this) {
        return $this.v1NdkModel;
    }
}

