/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.idea.ndk.NativeHeaderDir;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.android.tools.ndk.sync.NativeHeaderDirCache;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eH\u0007J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/android/tools/ndk/sync/NativeHeaderDirCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "headerDirFiles", "Ljava/util/TreeSet;", "Ljava/nio/file/Path;", "headerDirsByModule", "", "Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "", "Lcom/android/tools/idea/ndk/NativeHeaderDir;", "jniHeaderFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "add", "", "moduleVariantAbi", "nativeHeaderDir", "addJniHeader", "virtualFile", "getJniHeaders", "", "getNativeHeaderDirs", "module", "", "isUnderSomeNativeHeaderDir", "", "file", "Ljava/io/File;", "refresh", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nNativeHeaderDirCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeHeaderDirCache.kt\ncom/android/tools/ndk/sync/NativeHeaderDirCache\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,96:1\n3792#2:97\n4307#2,2:98\n1851#3,2:100\n465#4,7:102\n*S KotlinDebug\n*F\n+ 1 NativeHeaderDirCache.kt\ncom/android/tools/ndk/sync/NativeHeaderDirCache\n*L\n68#1:97\n68#1:98,2\n69#1:100,2\n81#1:102,7\n*E\n"})
public final class NativeHeaderDirCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ModuleVariantAbi, Set<NativeHeaderDir>> headerDirsByModule;
    @NotNull
    private final TreeSet<Path> headerDirFiles;
    @NotNull
    private final Set<VirtualFile> jniHeaderFiles;

    public NativeHeaderDirCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.headerDirsByModule = new LinkedHashMap();
        this.headerDirFiles = SetsKt.sortedSetOf((Object[])new Path[0]);
        this.jniHeaderFiles = new LinkedHashSet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void refresh() {
        this.headerDirsByModule.clear();
        this.headerDirFiles.clear();
        this.jniHeaderFiles.clear();
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(project)");
        OCWorkspace ocWorkspace = oCWorkspace;
        for (OCResolveConfiguration configuration : ocWorkspace.getConfigurations()) {
            ModuleVariantAbi moduleVariantAbi;
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            if (CxxSyncUtilsKt.getModuleVariantAbi(configuration) == null) continue;
            configuration.getAllCompilerSettings().flatMap(refresh.1.INSTANCE).map(refresh.2.INSTANCE).forEach(new Consumer(this, moduleVariantAbi){
                final /* synthetic */ NativeHeaderDirCache this$0;
                final /* synthetic */ ModuleVariantAbi $moduleVariantAbi;
                {
                    this.this$0 = $receiver;
                    this.$moduleVariantAbi = $moduleVariantAbi;
                }

                public final void accept(NativeHeaderDir it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.this$0.add(this.$moduleVariantAbi, it);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void add(@NotNull ModuleVariantAbi moduleVariantAbi, @NotNull NativeHeaderDir nativeHeaderDir) {
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter((Object)moduleVariantAbi, (String)"moduleVariantAbi");
        Intrinsics.checkNotNullParameter((Object)nativeHeaderDir, (String)"nativeHeaderDir");
        Set<NativeHeaderDir> set = this.headerDirsByModule.computeIfAbsent(moduleVariantAbi, add.nativeHeaderDirs.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(set, (String)"headerDirsByModule.compu\u2026ntAbi) { mutableSetOf() }");
        Set<NativeHeaderDir> nativeHeaderDirs2 = set;
        nativeHeaderDirs2.add(nativeHeaderDir);
        File headerDir = nativeHeaderDir.getDir().getAbsoluteFile();
        this.headerDirFiles.add(headerDir.toPath());
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(headerDir.toPath());
        if (virtualFile != null && (virtualFileArray = virtualFile.getChildren()) != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"jni.h")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile p0 = (VirtualFile)element$iv;
                boolean bl = false;
                this.addJniHeader(p0);
            }
        }
    }

    @VisibleForTesting
    public final void addJniHeader(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ((Collection)this.jniHeaderFiles).add(virtualFile);
    }

    @NotNull
    public final Set<NativeHeaderDir> getNativeHeaderDirs(@NotNull ModuleVariantAbi moduleVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)moduleVariantAbi, (String)"moduleVariantAbi");
        Set set = this.headerDirsByModule.get(moduleVariantAbi);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<NativeHeaderDir> getNativeHeaderDirs(@NotNull String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<ModuleVariantAbi, Set<NativeHeaderDir>> $this$filterKeys$iv = this.headerDirsByModule;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ModuleVariantAbi, Set<NativeHeaderDir>> result$iv = new LinkedHashMap<ModuleVariantAbi, Set<NativeHeaderDir>>();
        for (Map.Entry<ModuleVariantAbi, Set<NativeHeaderDir>> entry$iv : $this$filterKeys$iv.entrySet()) {
            ModuleVariantAbi moduleVariantAbi = entry$iv.getKey();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)moduleVariantAbi.getModuleName(), (Object)module)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((Map)result$iv).values()));
    }

    @NotNull
    public final Set<VirtualFile> getJniHeaders() {
        return this.jniHeaderFiles;
    }

    public final boolean isUnderSomeNativeHeaderDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.getAbsoluteFile().toPath();
        Path path2 = this.headerDirFiles.floor(path);
        if (path2 == null) {
            return false;
        }
        Path prefix = path2;
        return Intrinsics.areEqual((Object)path, (Object)prefix) || path.startsWith(prefix);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/ndk/sync/NativeHeaderDirCache$Companion;", "", "()V", "getInstance", "Lcom/android/tools/ndk/sync/NativeHeaderDirCache;", "project", "Lcom/intellij/openapi/project/Project;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeHeaderDirCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(NativeHeaderDirCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Nativ\u2026aderDirCache::class.java)");
            return (NativeHeaderDirCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

