/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.ndk.DeviceHelper;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.LaunchNativeDebuggerNotifier;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import com.google.wireless.android.sdk.stats.LldbPercentileEstimator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.ProtocolResponses;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final int CONNECT_PLATFORM_NUM_ATTEMPTS = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final Collection<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private boolean myCrashed = false;
    private final Project myProject;
    private final boolean myDeviceSupportsReadOnlyWatchpoints;
    private final boolean myClientSupportsJumpToLine;
    private final boolean myClientSupportsJobjectPrettyPrinters;
    private static final Set<Abi> READONLY_WATCHPOINT_SUPPORTED_ABIS = ImmutableSet.of((Object)Abi.ARM64_V8A, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARMEABI);
    private boolean myReportedWatchpointsUsage = false;
    private final Stopwatch attachStopwatch = Stopwatch.createStarted();
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration, @NotNull ArchitectureType architectureType) throws ExecutionException {
        super(handler, (LLDBDriverConfiguration)configuration, architectureType);
        this.getProcessHandler().addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
            }

            public void processTerminated(@NotNull ProcessEvent event) {
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text = event.getText();
                if (text == null) {
                    return;
                }
                if (ProcessOutputType.isStderr((Key)outputType) && (SystemInfo.isLinux && text.contains("error while loading shared libraries") || SystemInfo.isMac && text.contains("dyld: Library not loaded"))) {
                    LOG.warn(text.trim());
                }
            }
        });
        IDevice device = configuration.getDevice();
        this.mySessionStarter = configuration.getSessionStarter();
        this.myStartupCommands = configuration.getStartupCommands();
        this.myPostAttachCommands = configuration.getPostAttachCommands();
        this.mySymDirs = AndroidNativeAppDebugProcess.getSymbolsDir(facet, debuggerState, configuration.getClientABIs());
        this.myProject = facet.getModule().getProject();
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(this.myProject, "Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsReadOnlyWatchpoints = AndroidLLDBDriver.deviceSupportsReadOnlyWatchpoints(device);
        this.myClientSupportsJumpToLine = this.clientSupportsJumpToLine(configuration.getClientABIs());
        this.myClientSupportsJobjectPrettyPrinters = this.clientSupportsJobjectPrettyPrinters(configuration.getClientABIs());
    }

    private static boolean deviceSupportsReadOnlyWatchpoints(@NotNull IDevice device) {
        Abi abi;
        if (!device.getAbis().isEmpty() && (abi = Abi.getEnum((String)((String)device.getAbis().get(0)))) != null) {
            return READONLY_WATCHPOINT_SUPPORTED_ABIS.contains(abi);
        }
        return false;
    }

    private boolean clientSupportsJumpToLine(@NotNull List<Abi> clientAbis) {
        return !clientAbis.contains(Abi.X86) || clientAbis.contains(Abi.X86_64);
    }

    private boolean clientSupportsJobjectPrettyPrinters(@NotNull List<Abi> clientAbis) {
        return !clientAbis.contains(Abi.X86) || clientAbis.contains(Abi.X86_64);
    }

    public void commonLoad() throws ExecutionException {
        LOG.info("Loading driver");
        LOG.debug("Load startup scripts");
        this.executeInterpreterCommand("settings set target.process.thread.step-out-avoid-nodebug false");
        this.loadJObjectPrettyPrinterScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        LOG.debug("connectPlatform");
        int attempts = 0;
        while (true) {
            ++attempts;
            try {
                this.connectPlatform();
                break;
            }
            catch (LLDBDriverException e) {
                if (attempts >= 10) {
                    LOG.warn("Giving up making LLDB connection after 10 attempts");
                    throw e;
                }
                LOG.warn("Failed to connect platform (attempt " + attempts + " of 10) - retrying.  Error was: " + e.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionException("Interrupted");
                }
            }
        }
    }

    private void setSymbols() throws ExecutionException {
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath().replace("\\", "\\\\") + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Append target.exec-search-paths: " + searchPathsStr);
            this.executeInterpreterCommand("settings append target.exec-search-paths " + searchPathsStr);
        }
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        if (!createTargetRequest.getCreateTarget().getExePath().isEmpty()) {
            throw new IllegalStateException("Creating a target based on an executable path is not supported on Android");
        }
        super.sendCreateTargetRequest(createTargetRequest);
    }

    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architectureId) {
        throw new IllegalStateException("loadForLaunch is not supported on Android");
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttach(int pid, final @NotNull ThrowableRunnable<ExecutionException> preAttach, final @NotNull ThrowableRunnable<ExecutionException> postAttach) throws ExecutionException {
        final DebuggerDriver.Inferior delegate = super.loadForAttach(pid);
        this.commonLoad();
        this.setSymbols();
        return new DebuggerDriver.Inferior(0){

            protected long startImpl() throws ExecutionException {
                preAttach.run();
                long ret = delegate.start();
                AndroidLLDBDriver.this.runPostAttachCommands();
                postAttach.run();
                return ret;
            }

            protected void detachImpl() throws ExecutionException {
                delegate.detach();
            }

            protected boolean destroyImpl() throws ExecutionException {
                return delegate.destroy();
            }
        };
    }

    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        super.setValuesFilteringEnabled(true);
    }

    private void runCommands(@NotNull String name, @NotNull List<String> commands) throws ExecutionException {
        for (String cmd : commands) {
            String trimmed_cmd = cmd.trim();
            if (trimmed_cmd.isEmpty()) continue;
            LOG.info(String.format("%s command: \"%s\"", name, trimmed_cmd));
            this.executeInterpreterCommand(trimmed_cmd);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        this.runCommands("Startup", this.myStartupCommands);
    }

    private void runPostAttachCommands() throws ExecutionException {
        this.runCommands("Post attach", this.myPostAttachCommands);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeInterpreterCommand(envCommand);
            ++i;
        }
    }

    private void loadJObjectPrettyPrinterScripts() throws ExecutionException {
        int deviceApiLevel = this.mySessionStarter.getDevice().getVersion().getApiLevel();
        String isDalvik = DeviceHelper.RuntimeVersion.DALVIK.equals((Object)DeviceHelper.getRuntime(this.mySessionStarter.getDevice())) ? "True" : "False";
        File scriptPath = new File(ModulePathManager.getRepoLLDBPrettyPrinterScriptsFolder(), "jstring_reader.py");
        LOG.info("Loading startup script: " + scriptPath);
        this.executeInterpreterCommand("command script import \"" + scriptPath + "\"");
        this.executeInterpreterCommand(String.format("script jstring_reader.register(%d, %s)", deviceApiLevel, isDalvik));
        if (!this.myClientSupportsJobjectPrettyPrinters) {
            this.executeInterpreterCommand("type category disable \"JNI types\"");
        }
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((Message)connectPlatformReq, ProtocolResponses.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public boolean isCrashed() {
        return this.getProcessHandler().isProcessTerminated() && this.getProcessHandler().getProcess().exitValue() != 0;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        if (accessType == LLWatchpoint.AccessType.READ && !this.myDeviceSupportsReadOnlyWatchpoints) {
            AndroidNotification.getInstance((Project)this.myProject).showBalloon("Read watchpoint not supported", "The target device does not support read watchpoints. The watchpoint will be treated as ANY.", NotificationType.WARNING);
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.sessionUsedWatchpoints();
        }
        return super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
    }

    protected void handleExited(int code) {
        super.handleExited(code);
        LLDBUsageTracker.frontendExited(code);
    }

    protected void handleAttached(int pid) {
        if (this.attachStopwatch.isRunning()) {
            this.attachStopwatch.stop();
            LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ATTACH_TIME_MICROS, this.attachStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        super.handleAttached(pid);
    }

    @NotNull
    public DebuggerDriver.AddBreakpointResult addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.AddBreakpointResult ret = super.addBreakpoint(path, line, condition);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        LLSymbolicBreakpoint ret = super.addSymbolicBreakpoint(symBreakpoint);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_SYMBOLIC_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getFrames(thread, from, count, untilFirstLineWithCode);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_FRAMES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.getVariables(threadId, frameIndex);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getVariableChildren(value, from, count);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLE_CHILDREN_RANGE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public void stepOver(boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOver(stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepInto(forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepOut(boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOut(stopInFramesWithNoDebugInfo);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public boolean resume() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        boolean ret = super.resume();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public Pair<String, Boolean> executeInterpreterCommandWithOutput(long threadId, int frameIndex, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand((long)threadId, (int)frameIndex, (String)command);
        Ref result = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((Message)request, ProtocolResponses.HandleConsoleCommand_Res.class, res -> {
            if (res.hasOut()) {
                result.set((Object)Pair.create((Object)res.getOut(), (Object)true));
            }
            if (res.hasErr()) {
                result.set((Object)Pair.create((Object)res.getErr(), (Object)false));
            }
        });
        return (Pair)result.get();
    }

    public boolean supportsJumpToLine() {
        return this.myClientSupportsJumpToLine && super.supportsJumpToLine();
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }
}

