/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.OCDebuggerLanguageSupport;
import com.jetbrains.cidr.execution.debugger.OCDebuggerTypesHelper;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageSupport
extends OCDebuggerLanguageSupport {
    @Nullable
    public XDebuggerEditorsProvider createEditor(RunProfile profile) {
        if (profile instanceof AndroidRunConfigurationBase && ((AndroidRunConfigurationBase)profile).isNativeLaunch() || profile == null) {
            return new DebuggerEditorsProvider();
        }
        return null;
    }

    private class DebuggerEditorsProvider
    extends XDebuggerEditorsProvider {
        private DebuggerEditorsProvider() {
        }

        @NotNull
        public FileType getFileType() {
            return OCFileType.INSTANCE;
        }

        @NotNull
        public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
            PsiElement context = OCDebuggerTypesHelper.getContextElement((XSourcePosition)sourcePosition, (Project)project);
            if (context != null && context.getLanguage() == OCLanguage.getInstance()) {
                return (Document)WriteAction.compute(() -> {
                    OCCodeFragment fragment = mode == EvaluationMode.EXPRESSION ? OCElementFactory.expressionCodeFragment((String)text, (Project)project, (PsiElement)context, (boolean)true, (boolean)false) : OCElementFactory.expressionOrStatementsCodeFragment((String)text, (Project)project, (PsiElement)context, (boolean)true, (boolean)false);
                    return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
                });
            }
            LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (CharSequence)text);
            return FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
        }
    }
}

