/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0001\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0003\u00a8\u0006\u000b"}, d2={"parseUnicodeHexCodePoint", "", "s", "", "codePointStartingIndex", "", "bisectAtLast", "Lkotlin/Pair;", "c", "escape", "unescape", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniMangleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniMangleUtils.kt\ncom/android/tools/ndk/jni/utils/JniMangleUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class JniMangleUtilsKt {
    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        Intrinsics.checkNotNullParameter((Object)$this$escape, (String)"<this>");
        StringBuilder result = new StringBuilder($this$escape.length() * 2);
        int n = $this$escape.length();
        for (int i = 0; i < n; ++i) {
            String string;
            char c = $this$escape.charAt(i);
            char c2 = c;
            if (c2 == '/' ? true : c2 == '.') {
                string = "_";
            } else if (c2 == '_') {
                string = "_1";
            } else if (c2 == ';') {
                string = "_2";
            } else if (c2 == '[') {
                string = "_3";
            } else {
                boolean bl = (('a' <= c2 ? c2 < '{' : false) ? true : ('A' <= c2 ? c2 < '[' : false)) ? true : ('0' <= c2 ? c2 < ':' : false);
                if (bl) {
                    string = String.valueOf(c);
                } else {
                    String string2 = "_0%04x";
                    Object[] objectArray = new Object[]{(int)c};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                }
            }
            result.append(string);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        Intrinsics.checkNotNullParameter((Object)$this$unescape, (String)"<this>");
        StringBuilder result = new StringBuilder($this$unescape.length());
        int i = 0;
        while (i < $this$unescape.length()) {
            int n;
            char c = $this$unescape.charAt(i);
            Character n2 = StringsKt.getOrNull((CharSequence)$this$unescape, (int)(i + 1));
            StringBuilder stringBuilder = result;
            if (c == '_') {
                if (n2 == null || !Character.isDigit(n2.charValue())) {
                    n = 47;
                } else {
                    int n3;
                    StringBuilder stringBuilder2;
                    int n4;
                    int n5 = n2.charValue();
                    if (n5 == 48) {
                        int n6 = n4 = JniMangleUtilsKt.parseUnicodeHexCodePoint($this$unescape, i + 2);
                        stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        i += 4;
                        stringBuilder = stringBuilder2;
                        n3 = n4;
                    } else if (n5 == 49) {
                        n3 = 95;
                    } else if (n5 == 50) {
                        n3 = 59;
                    } else if (n5 == 51) {
                        n3 = 91;
                    } else {
                        throw new IllegalArgumentException("illegal mangled string " + $this$unescape + " at position " + i);
                    }
                    n4 = n5 = n3;
                    stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    n = n5;
                }
            } else {
                n = $this$unescape.charAt(i);
            }
            stringBuilder.append((char)n);
            int n7 = ++i;
            i = n7 + 1;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private static final char parseUnicodeHexCodePoint(String s, int codePointStartingIndex) {
        if (codePointStartingIndex + 4 > s.length()) {
            throw new IllegalArgumentException("illegal mangled string " + s + " at position " + codePointStartingIndex);
        }
        String string = s.substring(codePointStartingIndex, codePointStartingIndex + 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return (char)Integer.valueOf(string, 16).intValue();
    }

    @NotNull
    public static final Pair<String, String> bisectAtLast(@NotNull String $this$bisectAtLast, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$bisectAtLast, (String)"<this>");
        if (!StringsKt.contains$default((CharSequence)$this$bisectAtLast, (char)c, (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "Cannot bisect string because delimiter '" + c + "' is missing from string \"" + $this$bisectAtLast + "\".";
            throw new IllegalArgumentException(string.toString());
        }
        int firstPartEnd = StringsKt.lastIndexOf$default((CharSequence)$this$bisectAtLast, (char)c, (int)0, (boolean)false, (int)6, null);
        String string = $this$bisectAtLast.substring(0, firstPartEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = $this$bisectAtLast.substring(firstPartEnd + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string2);
    }
}

