/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.JvmFieldId;
import com.android.tools.ndk.jni.model.JvmFieldInfo;
import com.android.tools.ndk.jni.reference.JniReferenceContributorKt;
import com.android.tools.ndk.jni.reference.JvmReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmFieldReference;", "Lcom/android/tools/ndk/jni/reference/JvmReference;", "jvmFieldId", "Lcom/android/tools/ndk/jni/model/JvmFieldId;", "element", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "(Lcom/android/tools/ndk/jni/model/JvmFieldId;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)V", "getJvmFieldId", "()Lcom/android/tools/ndk/jni/model/JvmFieldId;", "isReferenceTo", "", "Lcom/intellij/psi/PsiElement;", "resolve", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmFieldReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class JvmFieldReference
extends JvmReference {
    @NotNull
    private final JvmFieldId jvmFieldId;

    public JvmFieldReference(@NotNull JvmFieldId jvmFieldId, @NotNull OCLiteralExpression element) {
        Intrinsics.checkNotNullParameter((Object)jvmFieldId, (String)"jvmFieldId");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange textRange = JniReferenceContributorKt.access$getContentTextRange(element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.contentTextRange");
        super(element, textRange, null);
        this.jvmFieldId = jvmFieldId;
    }

    @NotNull
    public final JvmFieldId getJvmFieldId() {
        return this.jvmFieldId;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)((OCLiteralExpression)this.getElement()).getProject()).findClass(this.jvmFieldId.getClassName().getJava(), GlobalSearchScope.allScope((Project)((OCLiteralExpression)this.getElement()).getProject()));
        return (PsiElement)(psiClass != null ? psiClass.findFieldByName(this.jvmFieldId.getFieldName(), true) : null);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        JvmFieldId jvmFieldId;
        PsiField psiField;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiField psiField2 = psiField = element instanceof PsiField ? (PsiField)element : null;
        if (psiField != null) {
            PsiField it = psiField;
            boolean bl = false;
            JvmFieldInfo jvmFieldInfo = JvmFieldInfo.Companion.fromPsiField(it);
            jvmFieldId = jvmFieldInfo != null ? jvmFieldInfo.toJvmFieldId() : null;
        } else {
            jvmFieldId = null;
        }
        return Intrinsics.areEqual(jvmFieldId, (Object)this.jvmFieldId);
    }
}

