/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.reference.JniReferenceContributorKt;
import com.android.tools.ndk.jni.reference.JvmMethodReference;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.service.RegisteredNativesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmClassReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmClassReferenceProvider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n26#2:229\n26#2:234\n57#3,2:230\n288#4,2:232\n*S KotlinDebug\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmClassReferenceProvider\n*L\n83#1:229\n92#1:234\n84#1:230,2\n91#1:232,2\n*E\n"})
public final class JvmClassReferenceProvider
extends PsiReferenceProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        JniCall jniCall;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OCLiteralExpression oCLiteralExpression = element instanceof OCLiteralExpression ? (OCLiteralExpression)element : null;
        if (oCLiteralExpression == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        OCLiteralExpression literal = oCLiteralExpression;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)literal;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType = false;
        OCCallExpression oCCallExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, OCCallExpression.class, (boolean)true);
        JniCall jniCall2 = jniCall = oCCallExpression != null ? JniCallKt.toJniCall(oCCallExpression) : null;
        if (jniCall instanceof FindClassCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromFindClassCall((FindClassCall)jniCall, literal);
        } else if (jniCall instanceof GetMethodIdCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromGetMethodIdCall((GetMethodIdCall)jniCall, literal);
        } else if (jniCall instanceof GetFieldIdCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromGetFieldIdCall((GetFieldIdCall)jniCall, literal);
        } else {
            Object v7;
            block9: {
                void $this$firstOrNull$iv;
                Project project = literal.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"literal.project");
                Iterable withSelf$iv2 = JniMethodResolver.Companion.getInstance(project).processAllRegisterNatives();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RegisteredNativesBundle it = (RegisteredNativesBundle)element$iv;
                    boolean bl = false;
                    Collection collection = it.getMethodNameStringLiteralToBindingInitializer().get((Object)literal);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.methodNameStringLiter\u2026ndingInitializer[literal]");
                    boolean bl2 = !collection.isEmpty();
                    if (!bl2) continue;
                    v7 = element$iv;
                    break block9;
                }
                v7 = null;
            }
            RegisteredNativesBundle registeredNativesBundle = v7;
            if (registeredNativesBundle == null) {
                boolean $i$f$emptyArray = false;
                return new PsiReference[0];
            }
            RegisteredNativesBundle matchedBundle = registeredNativesBundle;
            BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bidirectionalMultiMap = matchedBundle.getBindingToInitializer();
            Collection collection = matchedBundle.getMethodNameStringLiteralToBindingInitializer().get((Object)literal);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"matchedBundle.methodName\u2026ndingInitializer[literal]");
            Set set = bidirectionalMultiMap.getKeys(CollectionsKt.first((Iterable)collection));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"matchedBundle.bindingToI\u2026ializer[literal].first())");
            JvmMethodId jvmMethodId = (JvmMethodId)((Pair)CollectionsKt.first((Iterable)set)).component1();
            PsiReference[] psiReferenceArray2 = new PsiReference[]{new JvmMethodReference(jvmMethodId, literal)};
            psiReferenceArray = psiReferenceArray2;
        }
        return psiReferenceArray;
    }
}

