/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.idea.kotlin.AndroidKtPsiUtilsKt;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmFieldInfo;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.reference.JniReferencesSearchKt;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/ndk/jni/reference/JniReferencesSearch;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferencesSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferencesSearch.kt\ncom/android/tools/ndk/jni/reference/JniReferencesSearch\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,233:1\n1282#2,2:234\n*S KotlinDebug\n*F\n+ 1 JniReferencesSearch.kt\ncom/android/tools/ndk/jni/reference/JniReferencesSearch\n*L\n119#1:234,2\n*E\n"})
public final class JniReferencesSearch
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public JniReferencesSearch() {
        super(true);
    }

    /*
     * WARNING - void declaration
     */
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        block18: {
            PsiField psiField;
            Object[] objectArray;
            PsiElement element;
            SearchScope augmentedScope;
            block24: {
                block23: {
                    block16: {
                        PsiField psiField2;
                        void $this$firstOrNull$iv;
                        PsiElement psiElement;
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block17: {
                                            Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
                                            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                                            if (!Registry.is((String)"com.android.tools.ndk.jni.enableJniReferenceSearch")) {
                                                return;
                                            }
                                            if (ApplicationManager.getApplication().isDispatchThread() && !Registry.is((String)"com.android.tools.ndk.jni.allowJniReferenceSearchOnEdt")) {
                                                return;
                                            }
                                            Object object = OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)queryParameters.getProject(), (Object)true);
                                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LANGUAGE_SUPPORT_DISABLE\u2026Parameters.project, true)");
                                            if (((Boolean)object).booleanValue()) {
                                                return;
                                            }
                                            Project project = queryParameters.getProject();
                                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"queryParameters.project");
                                            SearchScope searchScope = queryParameters.getEffectiveSearchScope();
                                            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"queryParameters.effectiveSearchScope");
                                            augmentedScope = JniReferencesSearchKt.access$augmentScopeForSearch(project, searchScope);
                                            PsiElement psiElement2 = queryParameters.getElementToSearch();
                                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"queryParameters.elementToSearch");
                                            psiElement = element = psiElement2;
                                            if (!(psiElement instanceof KtClassOrObject)) break block17;
                                            Object object2 = JniUtilsKt.getJvmClass((KtClassOrObject)element);
                                            if (object2 == null || (object2 = ((FullyQualifiedClassName)object2).getJava()) == null) {
                                                return;
                                            }
                                            Object className = object2;
                                            PsiClass psiClass = JavaPsiFacade.getInstance((Project)((KtClassOrObject)element).getProject()).findClass((String)className, GlobalSearchScope.projectScope((Project)((KtClassOrObject)element).getProject()));
                                            if (psiClass == null) {
                                                return;
                                            }
                                            PsiClass psiClass2 = psiClass;
                                            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass(psiClass2);
                                            if (fullyQualifiedClassName == null) {
                                                return;
                                            }
                                            FullyQualifiedClassName fullyQualifiedName = fullyQualifiedClassName;
                                            PsiElement psiElement3 = (PsiElement)psiClass2;
                                            Project project2 = ((KtClassOrObject)element).getProject();
                                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
                                            JniReferencesSearchKt.access$searchReferencesInFindClassCalls(psiElement3, consumer, JniUtilsKt.narrowDown$default(augmentedScope, project2, null, CollectionsKt.listOf((Object)fullyQualifiedName.getJvm()), 2, null));
                                            break block18;
                                        }
                                        if (!(psiElement instanceof PsiClass)) break block19;
                                        FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass((PsiClass)element);
                                        if (fullyQualifiedClassName == null) {
                                            return;
                                        }
                                        FullyQualifiedClassName fullyQualifiedName = fullyQualifiedClassName;
                                        Project project = ((PsiClass)element).getProject();
                                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                                        JniReferencesSearchKt.access$searchReferencesInFindClassCalls(element, consumer, JniUtilsKt.narrowDown$default(augmentedScope, project, null, CollectionsKt.listOf((Object)fullyQualifiedName.getJvm()), 2, null));
                                        break block18;
                                    }
                                    if (!(psiElement instanceof PsiPackage)) break block20;
                                    Project project = ((PsiPackage)element).getProject();
                                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                                    String string = ((PsiPackage)element).getQualifiedName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.qualifiedName");
                                    JniReferencesSearchKt.access$searchReferencesInFindClassCalls(element, consumer, JniUtilsKt.narrowDown$default(augmentedScope, project, null, CollectionsKt.listOf((Object)StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)), 2, null));
                                    break block18;
                                }
                                if (!(psiElement instanceof PsiMethod)) break block21;
                                Object[] fullyQualifiedName = MethodInfo.Companion.fromPsiElement(element, false);
                                JvmMethodInfo jvmMethodInfo = fullyQualifiedName instanceof JvmMethodInfo ? (JvmMethodInfo)fullyQualifiedName : null;
                                if (jvmMethodInfo == null) {
                                    return;
                                }
                                JvmMethodInfo methodInfo = jvmMethodInfo;
                                Project project = ((PsiMethod)element).getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                                fullyQualifiedName = new String[]{methodInfo.getMethodName(), methodInfo.getMethodType()};
                                SearchScope narrowedScope = JniUtilsKt.narrowDown$default(augmentedScope, project, null, CollectionsKt.listOf((Object[])fullyQualifiedName), 2, null);
                                JniReferencesSearchKt.access$searchReferencesInGetMethodIdCalls((PsiMethod)element, consumer, narrowedScope);
                                JniReferencesSearchKt.access$searchReferencesInRegisterNativesCalls((PsiMethod)element, consumer, narrowedScope);
                                break block18;
                            }
                            if (!(psiElement instanceof PsiField)) break block22;
                            JvmFieldInfo jvmFieldInfo = JvmFieldInfo.Companion.fromPsiField((PsiField)element);
                            if (jvmFieldInfo == null) {
                                return;
                            }
                            JvmFieldInfo fieldInfo = jvmFieldInfo;
                            PsiField psiField3 = (PsiField)element;
                            Project project = ((PsiField)element).getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                            Object[] narrowedScope = new String[]{fieldInfo.getFieldName(), fieldInfo.getFieldType().toJvmType()};
                            JniReferencesSearchKt.access$searchReferencesInGetFieldIdCalls(psiField3, consumer, JniUtilsKt.narrowDown$default(augmentedScope, project, null, CollectionsKt.listOf((Object[])narrowedScope), 2, null));
                            break block18;
                        }
                        if (!(psiElement instanceof KtProperty)) break block18;
                        if (!AndroidKtPsiUtilsKt.hasBackingField$default((KtProperty)((KtProperty)element), null, (int)1, null)) {
                            return;
                        }
                        Object object = JniUtilsKt.getContainingJvmClass((KtDeclaration)element);
                        if (object == null || (object = ((FullyQualifiedClassName)object).getJava()) == null) {
                            return;
                        }
                        Object containingClassName = object;
                        PsiClass fullyQualifiedName = JavaPsiFacade.getInstance((Project)((KtProperty)element).getProject()).findClass((String)containingClassName, GlobalSearchScope.projectScope((Project)((KtProperty)element).getProject()));
                        if (fullyQualifiedName == null || (objectArray = fullyQualifiedName.getFields()) == null) break block23;
                        PsiField[] psiFieldArray = objectArray;
                        boolean $i$f$firstOrNull = false;
                        int n = ((void)$this$firstOrNull$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv;
                            void it = element$iv = $this$firstOrNull$iv[i];
                            boolean bl = false;
                            KtLightField ktLightField = it instanceof KtLightField ? (KtLightField)it : null;
                            if (!Intrinsics.areEqual((Object)(ktLightField != null ? (KtDeclaration)ktLightField.getKotlinOrigin() : null), (Object)element)) continue;
                            psiField2 = element$iv;
                            break block16;
                        }
                        psiField2 = psiField = null;
                    }
                    if (psiField != null) break block24;
                }
                return;
            }
            PsiField psiField4 = psiField;
            JvmFieldInfo jvmFieldInfo = JvmFieldInfo.Companion.fromPsiField(psiField4);
            if (jvmFieldInfo == null) {
                return;
            }
            JvmFieldInfo fieldInfo = jvmFieldInfo;
            Project project = ((KtProperty)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
            objectArray = new String[]{fieldInfo.getFieldName(), fieldInfo.getFieldType().toJvmType()};
            JniReferencesSearchKt.access$searchReferencesInGetFieldIdCalls(psiField4, consumer, JniUtilsKt.narrowDown$default(augmentedScope, project, null, CollectionsKt.listOf((Object[])objectArray), 2, null));
        }
    }
}

