/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.NameGenerator;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeToken;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKindProviderKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CBW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010(\u001a\u00020\u0004H\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\u001b\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\bH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\t\u0010-\u001a\u00020\rH\u00c6\u0003J\t\u0010.\u001a\u00020\rH\u00c6\u0003J\t\u0010/\u001a\u00020\u0011H\u00c6\u0003Jk\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u00101\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\u001a\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\r2\b\b\u0002\u00106\u001a\u00020\rH\u0007J\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\bJ\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\b\u0010:\u001a\u0004\u0018\u00010\u0006J\b\u0010;\u001a\u00020!H\u0016J\t\u0010<\u001a\u00020=H\u00d6\u0001J\u0012\u0010>\u001a\u00020?2\b\b\u0002\u00106\u001a\u00020\rH\u0007J\u0006\u0010@\u001a\u00020AJ\t\u0010B\u001a\u00020\u0006H\u00d6\u0001R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006D"}, d2={"Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "Lcom/android/tools/ndk/jni/model/MethodInfo;", "Lcom/intellij/openapi/util/ModificationTracker;", "className", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "methodName", "", "args", "", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/model/JvmType;", "returnType", "isStatic", "", "isNative", "isConstructor", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Ljava/lang/String;Ljava/util/List;Lcom/android/tools/ndk/jni/model/JvmType;ZZZLcom/intellij/psi/PsiElement;)V", "getArgs", "()Ljava/util/List;", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "description", "getDescription", "()Ljava/lang/String;", "()Z", "isKotlin", "isOverloadedNativeMethod", "getMethodName", "methodType", "getMethodType", "modificationStamp", "", "nameIdentifier", "getNameIdentifier", "()Lcom/intellij/psi/PsiElement;", "getPsiElement", "getReturnType", "()Lcom/android/tools/ndk/jni/model/JvmType;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "generateNativeMethod", "cpp", "eraseArgs", "generateNativeParameterDeclarations", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "getHumanReadableParameterTypes", "getHumanReadableReturnType", "getModificationCount", "hashCode", "", "toJniNativeMethodId", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "toJvmMethodId", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "toString", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nMethodInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodInfo.kt\ncom/android/tools/ndk/jni/model/JvmMethodInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,345:1\n1851#2,2:346\n1549#2:350\n1620#2,3:351\n1549#2:354\n1620#2,3:355\n1549#2:358\n1620#2,3:359\n13543#3,2:348\n*S KotlinDebug\n*F\n+ 1 MethodInfo.kt\ncom/android/tools/ndk/jni/model/JvmMethodInfo\n*L\n169#1:346,2\n275#1:350\n275#1:351,3\n314#1:354\n314#1:355,3\n315#1:358\n315#1:359,3\n172#1:348,2\n*E\n"})
public final class JvmMethodInfo
extends MethodInfo
implements ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String methodName;
    @NotNull
    private final List<Pair<String, JvmType>> args;
    @NotNull
    private final JvmType returnType;
    private final boolean isStatic;
    private final boolean isNative;
    private final boolean isConstructor;
    @NotNull
    private final PsiElement psiElement;
    private final long modificationStamp;
    @NotNull
    public static final String RECEIVER_PARAMETER_NAME = "_receiver";

    public JvmMethodInfo(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isNative, boolean isConstructor, @NotNull PsiElement psiElement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(null);
        this.className = className;
        this.methodName = methodName;
        this.args = args;
        this.returnType = returnType;
        this.isStatic = isStatic;
        this.isNative = isNative;
        this.isConstructor = isConstructor;
        this.psiElement = psiElement;
        this.modificationStamp = this.getPsiElement().getContainingFile().getModificationStamp();
        boolean bl2 = bl = this.getPsiElement() instanceof PsiMethod || this.getPsiElement() instanceof KtFunction || this.getPsiElement() instanceof PsiClass;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "JvmMethodInfo must be created from a valid PsiMethod, PsiClass, or KtFunction";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> getArgs() {
        return this.args;
    }

    @NotNull
    public final JvmType getReturnType() {
        return this.returnType;
    }

    public final boolean isStatic() {
        return this.isStatic;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        return this.psiElement;
    }

    public long getModificationCount() {
        return this.getPsiElement().isValid() ? this.getPsiElement().getContainingFile().getModificationStamp() : this.modificationStamp + 1L;
    }

    public final boolean isOverloadedNativeMethod() {
        if (!this.getPsiElement().isValid()) {
            return false;
        }
        Project project = this.getPsiElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        return JniMethodResolver.Companion.getInstance(project).isOverloaded(this.className, this.methodName);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifier() {
        PsiElement psiElement;
        PsiElement psiElement2 = this.getPsiElement();
        if (psiElement2 instanceof PsiMethod) {
            PsiIdentifier psiIdentifier = ((PsiMethod)this.getPsiElement()).getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiIdentifier);
            psiElement = (PsiElement)psiIdentifier;
        } else if (psiElement2 instanceof KtFunction) {
            PsiElement psiElement3;
            if (this.getPsiElement() instanceof KtNamedFunction) {
                PsiElement psiElement4 = ((KtNamedFunction)this.getPsiElement()).getNameIdentifier();
                psiElement3 = psiElement4;
                Intrinsics.checkNotNull((Object)psiElement4);
            } else {
                psiElement3 = this.getPsiElement();
            }
            PsiElement psiElement5 = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"when (psiElement) {\n    \u2026lse -> psiElement\n      }");
            psiElement = psiElement5;
        } else if (psiElement2 instanceof PsiClass) {
            PsiIdentifier psiIdentifier = ((PsiClass)this.getPsiElement()).getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiIdentifier);
            psiElement = (PsiElement)psiIdentifier;
        } else {
            throw new AssertionError((Object)"impossible by constructor check");
        }
        return psiElement;
    }

    @NotNull
    public final JvmMethodId toJvmMethodId() {
        return new JvmMethodId(this.className, this.methodName, this.getMethodType());
    }

    @NotNull
    public final List<String> getHumanReadableParameterTypes() {
        List result;
        block6: {
            PsiElement psiElement;
            block5: {
                if (!this.getPsiElement().isValid()) {
                    return kotlin.collections.CollectionsKt.emptyList();
                }
                result = new ArrayList();
                psiElement = this.getPsiElement();
                if (!(psiElement instanceof KtFunction)) break block5;
                if (KotlinPluginKindProviderKt.isK2Plugin()) {
                    throw new IllegalStateException("K2 not supported in Android Studio Flamingo".toString());
                }
                DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)this.getPsiElement()));
                FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                if (functionDescriptor == null) {
                    return result;
                }
                FunctionDescriptor descriptor = functionDescriptor;
                ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
                CollectionsKt.addIfNotNull((Collection)result, receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? receiverParameterDescriptor.toString() : null);
                List list = descriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.valueParameters");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl = false;
                    result.add(it.getType().toString());
                }
                break block6;
            }
            if (!(psiElement instanceof PsiMethod)) break block6;
            PsiParameter[] psiParameterArray = ((PsiMethod)this.getPsiElement()).getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"psiElement.parameterList.parameters");
            Object[] $this$forEach$iv = psiParameterArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiParameter it = (PsiParameter)element$iv;
                boolean bl = false;
                String string = it.getType().getPresentableText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type.presentableText");
                result.add(string);
            }
        }
        return result;
    }

    @Nullable
    public final String getHumanReadableReturnType() {
        String string;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof KtFunction) {
            if (KotlinPluginKindProviderKt.isK2Plugin()) {
                throw new IllegalStateException("K2 not supported in Android Studio Flamingo".toString());
            }
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)this.getPsiElement()));
            FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
            string = functionDescriptor != null && (functionDescriptor = functionDescriptor.getReturnType()) != null ? functionDescriptor.toString() : null;
        } else if (psiElement instanceof PsiMethod) {
            PsiType psiType = ((PsiMethod)this.getPsiElement()).getReturnType();
            string = psiType != null ? psiType.getPresentableText() : null;
        } else {
            string = psiElement instanceof PsiClass ? "void" : null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final JniNativeMethodId toJniNativeMethodId(boolean eraseArgs) {
        JniNativeMethodId jniNativeMethodId;
        if (eraseArgs) {
            jniNativeMethodId = new JniNativeMethodId(this.className, this.methodName, null);
        } else {
            Collection<JvmType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.args;
            String string = this.methodName;
            FullyQualifiedClassName fullyQualifiedClassName = this.className;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((JvmType)it.getSecond());
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            String string2 = string;
            FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
            jniNativeMethodId = new JniNativeMethodId(fullyQualifiedClassName2, string2, list);
        }
        return jniNativeMethodId;
    }

    public static /* synthetic */ JniNativeMethodId toJniNativeMethodId$default(JvmMethodInfo jvmMethodInfo, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = !jvmMethodInfo.isOverloadedNativeMethod();
        }
        return jvmMethodInfo.toJniNativeMethodId(bl);
    }

    @NotNull
    public final String getMethodType() {
        return "(" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.args, (CharSequence)"", null, null, (int)0, null, (Function1)methodType.1.INSTANCE, (int)30, null) + ")" + this.returnType.toJvmType();
    }

    public final boolean isKotlin() {
        return this.getPsiElement() instanceof KtElement;
    }

    @NotNull
    public final String getDescription() {
        return this.methodName + "(" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.args, null, null, null, (int)0, null, (Function1)description.1.INSTANCE, (int)31, null) + ")";
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp, boolean eraseArgs) {
        String externDeclaration = cpp ? "extern \"C\"\n" : "";
        List<SimpleParameterDeclaration> otherArgs = this.generateNativeParameterDeclarations();
        return externDeclaration + StringsKt.trimIndent((String)("\n        JNIEXPORT " + this.returnType.toJniType() + " JNICALL\n        " + this.toJniNativeMethodId(eraseArgs).getFunctionName() + "(" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)otherArgs, null, null, null, (int)0, null, null, (int)63, null) + ") {\n            // TODO: implement " + this.methodName + "()\n        }\n      "));
    }

    public static /* synthetic */ String generateNativeMethod$default(JvmMethodInfo jvmMethodInfo, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = !jvmMethodInfo.isOverloadedNativeMethod();
        }
        return jvmMethodInfo.generateNativeMethod(bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SimpleParameterDeclaration> generateNativeParameterDeclarations() {
        Pair pair;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object = new String[]{"env", this.isStatic ? "clazz" : "thiz"};
        NameGenerator nameGenerator = new NameGenerator((String[])object);
        object = new Pair[]{TuplesKt.to((Object)"JNIEnv *", (Object)"env"), this.isStatic ? TuplesKt.to((Object)"jclass", (Object)"clazz") : TuplesKt.to((Object)"jobject", (Object)"thiz")};
        Collection collection = kotlin.collections.CollectionsKt.listOf((Object[])object);
        object = this.args;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            JvmType type = (JvmType)pair.component2();
            String string = type.toJniType();
            String string2 = SdkVersionInfo.camelCaseToUnderlines((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"camelCaseToUnderlines(name)");
            collection3.add(TuplesKt.to((Object)string, (Object)nameGenerator.generateUniqueName(string2)));
        }
        $this$map$iv = kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pair = (Pair)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SimpleParameterDeclaration((Pair<String, String>)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> component3() {
        return this.args;
    }

    @NotNull
    public final JvmType component4() {
        return this.returnType;
    }

    public final boolean component5() {
        return this.isStatic;
    }

    public final boolean component6() {
        return this.isNative;
    }

    public final boolean component7() {
        return this.isConstructor;
    }

    @NotNull
    public final PsiElement component8() {
        return this.psiElement;
    }

    @NotNull
    public final JvmMethodInfo copy(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isNative, boolean isConstructor, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return new JvmMethodInfo(className, methodName, args, returnType, isStatic, isNative, isConstructor, psiElement);
    }

    public static /* synthetic */ JvmMethodInfo copy$default(JvmMethodInfo jvmMethodInfo, FullyQualifiedClassName fullyQualifiedClassName, String string, List list, JvmType jvmType, boolean bl, boolean bl2, boolean bl3, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jvmMethodInfo.className;
        }
        if ((n & 2) != 0) {
            string = jvmMethodInfo.methodName;
        }
        if ((n & 4) != 0) {
            list = jvmMethodInfo.args;
        }
        if ((n & 8) != 0) {
            jvmType = jvmMethodInfo.returnType;
        }
        if ((n & 0x10) != 0) {
            bl = jvmMethodInfo.isStatic;
        }
        if ((n & 0x20) != 0) {
            bl2 = jvmMethodInfo.isNative;
        }
        if ((n & 0x40) != 0) {
            bl3 = jvmMethodInfo.isConstructor;
        }
        if ((n & 0x80) != 0) {
            psiElement = jvmMethodInfo.psiElement;
        }
        return jvmMethodInfo.copy(fullyQualifiedClassName, string, list, jvmType, bl, bl2, bl3, psiElement);
    }

    @NotNull
    public String toString() {
        return "JvmMethodInfo(className=" + this.className + ", methodName=" + this.methodName + ", args=" + this.args + ", returnType=" + this.returnType + ", isStatic=" + this.isStatic + ", isNative=" + this.isNative + ", isConstructor=" + this.isConstructor + ", psiElement=" + this.psiElement + ")";
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = result * 31 + this.methodName.hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        result = result * 31 + this.returnType.hashCode();
        int n = this.isStatic ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.isNative ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        int n3 = this.isConstructor ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result = result * 31 + n3;
        result = result * 31 + this.psiElement.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmMethodInfo)) {
            return false;
        }
        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)jvmMethodInfo.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)jvmMethodInfo.methodName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.args, jvmMethodInfo.args)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.returnType, (Object)jvmMethodInfo.returnType)) {
            return false;
        }
        if (this.isStatic != jvmMethodInfo.isStatic) {
            return false;
        }
        if (this.isNative != jvmMethodInfo.isNative) {
            return false;
        }
        if (this.isConstructor != jvmMethodInfo.isConstructor) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.psiElement, (Object)jvmMethodInfo.psiElement);
    }

    @JvmOverloads
    @NotNull
    public final JniNativeMethodId toJniNativeMethodId() {
        return JvmMethodInfo.toJniNativeMethodId$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp) {
        return JvmMethodInfo.generateNativeMethod$default(this, cpp, false, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
        return Companion.fromJavaMethod(method);
    }

    @JvmStatic
    @Nullable
    public static final JvmMethodInfo fromKotlinFunction(@NotNull KtFunction function) {
        return Companion.fromKotlinFunction(function);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\r\u001a\u0004\u0018\u00010\u0006*\u00020\u000b2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/ndk/jni/model/JvmMethodInfo$Companion;", "", "()V", "RECEIVER_PARAMETER_NAME", "", "fromJavaMethod", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "method", "Lcom/intellij/psi/PsiMethod;", "fromKotlinFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "fromKotlinFunctionByDescriptors", "buildMethodInfo", "args", "", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/model/JvmType;", "returnType", "fromKotlinFunctionByAnalysisApi", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "android-ndk"})
    @SourceDebugExtension(value={"SMAP\nMethodInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodInfo.kt\ncom/android/tools/ndk/jni/model/JvmMethodInfo$Companion\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n21#2:346\n21#2:347\n1#3:348\n1549#4:349\n1620#4,3:350\n*S KotlinDebug\n*F\n+ 1 MethodInfo.kt\ncom/android/tools/ndk/jni/model/JvmMethodInfo$Companion\n*L\n196#1:346\n225#1:347\n247#1:349\n247#1:350,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            boolean $i$f$runReadAction = false;
            return (JvmMethodInfo)ApplicationManager.getApplication().runReadAction(new Computable(method){
                final /* synthetic */ PsiMethod $method$inlined;
                {
                    this.$method$inlined = psiMethod;
                }

                /*
                 * WARNING - void declaration
                 */
                public final T compute() {
                    JvmMethodInfo jvmMethodInfo;
                    block13: {
                        boolean bl = false;
                        PsiClass psiClass = this.$method$inlined.getContainingClass();
                        if (psiClass == null) {
                            JvmMethodInfo jvmMethodInfo2;
                            jvmMethodInfo = jvmMethodInfo2 = null;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"method.containingClass ?\u2026return@runReadAction null");
                            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass(psiClass);
                            if (fullyQualifiedClassName == null) {
                                jvmMethodInfo = null;
                            } else {
                                void $this$mapTo$iv$iv;
                                FullyQualifiedClassName className = fullyQualifiedClassName;
                                PsiParameter[] psiParameterArray = this.$method$inlined.getParameterList().getParameters();
                                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
                                Object[] $this$map$iv = psiParameterArray;
                                boolean $i$f$map = false;
                                Object[] objectArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                for (void item$iv$iv : $this$mapTo$iv$iv) {
                                    JvmType jvmType;
                                    String string;
                                    void it;
                                    PsiParameter psiParameter = (PsiParameter)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    if (it.getName() == null) {
                                        jvmMethodInfo = null;
                                        break block13;
                                    }
                                    PsiType psiType = it.getType();
                                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"it.type");
                                    if (JvmType.Companion.fromJavaType(psiType) == null) {
                                        Object var2_3 = null;
                                        jvmMethodInfo = var2_3;
                                        break block13;
                                    }
                                    collection.add(new Pair((Object)string, (Object)jvmType));
                                }
                                List args = (List)destination$iv$iv;
                                if (this.$method$inlined.isConstructor()) {
                                    jvmMethodInfo = new JvmMethodInfo(className, "<init>", args, JvmTypeKt.getVOID_TYPE(), false, false, true, (PsiElement)this.$method$inlined);
                                } else {
                                    String string = this.$method$inlined.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
                                    PsiType psiType = this.$method$inlined.getReturnType();
                                    if (psiType == null) {
                                        Object var2_4 = null;
                                        jvmMethodInfo = var2_4;
                                    } else {
                                        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"method.returnType ?: return@runReadAction null");
                                        JvmType jvmType = JvmType.Companion.fromJavaType(psiType);
                                        if (jvmType == null) {
                                            Object var2_5 = null;
                                            jvmMethodInfo = var2_5;
                                        } else {
                                            PsiElement psiElement = (PsiElement)this.$method$inlined;
                                            boolean bl3 = false;
                                            boolean bl4 = JniUtilsKt.isNative((JvmMethod)this.$method$inlined);
                                            boolean bl5 = JniUtilsKt.isStatic((JvmModifiersOwner)this.$method$inlined);
                                            JvmType jvmType2 = jvmType;
                                            List list = args;
                                            String string2 = string;
                                            FullyQualifiedClassName fullyQualifiedClassName2 = className;
                                            jvmMethodInfo = new JvmMethodInfo(fullyQualifiedClassName2, string2, list, jvmType2, bl5, bl4, bl3, psiElement);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    return (T)jvmMethodInfo;
                }
            });
        }

        @JvmStatic
        @Nullable
        public final JvmMethodInfo fromKotlinFunction(@NotNull KtFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            boolean $i$f$runReadAction = false;
            return (JvmMethodInfo)ApplicationManager.getApplication().runReadAction(new Computable(function){
                final /* synthetic */ KtFunction $function$inlined;
                {
                    this.$function$inlined = ktFunction;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final T compute() {
                    JvmMethodInfo jvmMethodInfo;
                    boolean bl = false;
                    if (KotlinPluginKindProviderKt.isK2Plugin()) {
                        boolean $i$f$allowAnalysisOnEdt = false;
                        T t = KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"KtReadActionConfinementL\u2026imeToken.allowOnEdt.get()");
                        if (((Boolean)t).booleanValue()) {
                            JvmMethodInfo jvmMethodInfo2;
                            void this_$iv$iv$iv;
                            void this_$iv$iv;
                            boolean bl2 = false;
                            Object nonDefaultLifetimeTokenFactory$iv = null;
                            boolean $i$f$analyze = false;
                            Project project = ((KtElement)this.$function$inlined).getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
                            KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
                            boolean $i$f$analyse = false;
                            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
                            void var9_15 = this_$iv$iv;
                            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)this.$function$inlined, factory$iv$iv);
                            boolean $i$f$analyse2 = false;
                            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                            try {
                                KtAnalysisSession $this$fromKotlinFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv$iv;
                                boolean bl3 = false;
                                jvmMethodInfo2 = com.android.tools.ndk.jni.model.JvmMethodInfo$Companion.access$fromKotlinFunctionByAnalysisApi(JvmMethodInfo.Companion, $this$fromKotlinFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242, this.$function$inlined);
                            }
                            finally {
                                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                            }
                            jvmMethodInfo = jvmMethodInfo2;
                            return (T)jvmMethodInfo;
                        }
                        KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(true);
                        try {
                            JvmMethodInfo jvmMethodInfo3;
                            boolean bl4 = false;
                            Object nonDefaultLifetimeTokenFactory$iv = null;
                            boolean $i$f$analyze = false;
                            Project project = ((KtElement)this.$function$inlined).getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
                            KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project);
                            boolean $i$f$analyse = false;
                            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
                            KtAnalysisSessionProvider this_$iv$iv$iv = this_$iv$iv;
                            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)this.$function$inlined, factory$iv$iv);
                            boolean $i$f$analyse3 = false;
                            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                            try {
                                KtAnalysisSession $this$fromKotlinFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv$iv;
                                boolean bl5 = false;
                                jvmMethodInfo3 = com.android.tools.ndk.jni.model.JvmMethodInfo$Companion.access$fromKotlinFunctionByAnalysisApi(JvmMethodInfo.Companion, $this$fromKotlinFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242, this.$function$inlined);
                            }
                            finally {
                                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                            }
                            JvmMethodInfo jvmMethodInfo4 = jvmMethodInfo3;
                            jvmMethodInfo = jvmMethodInfo4;
                            return (T)jvmMethodInfo;
                        }
                        finally {
                            KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(false);
                        }
                    }
                    jvmMethodInfo = com.android.tools.ndk.jni.model.JvmMethodInfo$Companion.access$fromKotlinFunctionByDescriptors(JvmMethodInfo.Companion, this.$function$inlined);
                    return (T)jvmMethodInfo;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final JvmMethodInfo fromKotlinFunctionByDescriptors(KtFunction function) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Pair pair;
            ReceiverParameterDescriptor it;
            Object object = SearchHelpersKt.getDescriptor((KtDeclaration)((KtDeclaration)function));
            FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
            if (functionDescriptor == null) {
                return null;
            }
            FunctionDescriptor descriptor = functionDescriptor;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor != null) {
                it = receiverParameterDescriptor;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                JvmType jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, kotlinType, false, false, 6, null);
                if (jvmType == null) {
                    return null;
                }
                pair = TuplesKt.to((Object)JvmMethodInfo.RECEIVER_PARAMETER_NAME, (Object)jvmType);
            } else {
                pair = null;
            }
            Collection collection = kotlin.collections.CollectionsKt.listOfNotNull(pair);
            List list = descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.valueParameters");
            object = list;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                String string = it2.getName().asString();
                KotlinType kotlinType = it2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                JvmType jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, kotlinType, false, false, 6, null);
                if (jvmType == null) {
                    return null;
                }
                collection3.add(TuplesKt.to((Object)string, (Object)jvmType));
            }
            List args = kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            KotlinType kotlinType = descriptor.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            JvmType jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, kotlinType, true, false, 4, null);
            if (jvmType == null) {
                return null;
            }
            JvmType returnType = jvmType;
            return this.buildMethodInfo(function, args, returnType);
        }

        private final JvmMethodInfo fromKotlinFunctionByAnalysisApi(KtAnalysisSession $this$fromKotlinFunctionByAnalysisApi, KtFunction function) {
            throw new IllegalStateException("K2 not supported in Android Studio Flamingo".toString());
        }

        private final JvmMethodInfo buildMethodInfo(KtFunction $this$buildMethodInfo, List<? extends Pair<String, ? extends JvmType>> args, JvmType returnType) {
            FullyQualifiedClassName fullyQualifiedClassName = JniUtilsKt.getContainingJvmClass((KtDeclaration)$this$buildMethodInfo);
            if (fullyQualifiedClassName == null) {
                return null;
            }
            String string = JniUtilsKt.getJvmName($this$buildMethodInfo);
            if (string == null) {
                return null;
            }
            return new JvmMethodInfo(fullyQualifiedClassName, string, args, returnType, JniUtilsKt.isStatic((KtDeclaration)$this$buildMethodInfo), JniUtilsKt.isNative($this$buildMethodInfo), false, (PsiElement)$this$buildMethodInfo);
        }

        public static final /* synthetic */ JvmMethodInfo access$fromKotlinFunctionByAnalysisApi(Companion $this, KtAnalysisSession $receiver, KtFunction function) {
            return $this.fromKotlinFunctionByAnalysisApi($receiver, function);
        }

        public static final /* synthetic */ JvmMethodInfo access$fromKotlinFunctionByDescriptors(Companion $this, KtFunction function) {
            return $this.fromKotlinFunctionByDescriptors(function);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

