/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniOnloadInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectDeclaration", "", "declarator", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "returnTypeName", "", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniOnloadInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniOnloadInspection.kt\ncom/android/tools/ndk/jni/inspections/JniOnloadInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 3 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n*L\n1#1,138:1\n62#2,4:139\n66#2:147\n67#2:157\n503#3,4:143\n509#3,9:148\n*S KotlinDebug\n*F\n+ 1 JniOnloadInspection.kt\ncom/android/tools/ndk/jni/inspections/JniOnloadInspection\n*L\n49#1:139,4\n49#1:147\n49#1:157\n49#1:143,4\n49#1:148,9\n*E\n"})
public final class JniOnloadInspection
extends JniInspectionTool {
    public JniOnloadInspection() {
        super(JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ JniOnloadInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(@NotNull PsiElement element) {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    OCFunctionDeclaration oCFunctionDeclaration = element instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)element : null;
                    if (oCFunctionDeclaration == null) {
                        return;
                    }
                    OCFunctionDeclaration declarator = oCFunctionDeclaration;
                    String string = declarator.getName();
                    if (string == null) break block11;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1749321345: {
                            if (string.equals("JNI_OnLoad")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1508519592: {
                            if (string.equals("JNI_OnUnload")) {
                                n = 2;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "jint");
                            break;
                        }
                        case 2: {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "void");
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void inspectDeclaration(OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        void inspectionType$iv$iv;
        void $this$reportJniPerf$iv$iv;
        JniInspectionTool this_$iv = this;
        boolean $i$f$reportPerf$android_ndk = false;
        Project project = ((PsiElement)declarator).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
        int n = 100;
        boolean $i$f$reportJniPerf = false;
        JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
        Instant startTime$iv$iv = Instant.now();
        try {
            Integer n2;
            LocalQuickFix[] localQuickFixArray;
            JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            if (!declarator.getReturnType().equalsAfterResolving(returnTypeName, OCResolveContext.forPsi((PsiElement)((PsiElement)declarator)))) {
                OCElement oCElement;
                if (localQuickFixArray == null) {
                    oCElement = (OCElement)declarator;
                } else {
                    localQuickFixArray = declarator.getReturnTypeElement();
                    Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"declarator.returnTypeElement ?: declarator");
                    oCElement = (OCElement)localQuickFixArray;
                }
                OCElement elementToShow = oCElement;
                localQuickFixArray = new LocalQuickFix[]{this.quickFix("Fix type", "Change return type to '" + returnTypeName + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(declarator, returnTypeName){
                    final /* synthetic */ OCFunctionDeclaration $declarator;
                    final /* synthetic */ String $returnTypeName;
                    {
                        this.$declarator = $declarator;
                        this.$returnTypeName = $returnTypeName;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this.$declarator, project, this.$returnTypeName){
                            final /* synthetic */ OCFunctionDeclaration $declarator;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ String $returnTypeName;
                            {
                                this.$declarator = $declarator;
                                this.$project = $project;
                                this.$returnTypeName = $returnTypeName;
                            }

                            public final void run() {
                                OCTypeElement oCTypeElement = this.$declarator.getReturnTypeElement();
                                if (oCTypeElement == null) {
                                    return;
                                }
                                OCTypeElement elementToChange = oCTypeElement;
                                OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$declarator.getContainingFile(), (int)elementToChange.getTextOffset(), (int)elementToChange.getTextLength(), (String)this.$returnTypeName, (boolean)true);
                            }
                        });
                        return true;
                    }
                }))};
                holder.registerProblem((PsiElement)elementToShow, "Wrong type", ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            }
            List list = declarator.getParameters();
            Integer n3 = n2 = list != null ? Integer.valueOf(list.size()) : null;
            if (n3 != null && n3 == 0) {
                localQuickFixArray = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Add parameters", null, (Function2)new Function2<Project, ProblemDescriptor, Boolean>(declarator){
                    final /* synthetic */ OCFunctionDeclaration $declarator;
                    {
                        this.$declarator = $declarator;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this.$declarator, project){
                            final /* synthetic */ OCFunctionDeclaration $declarator;
                            final /* synthetic */ Project $project;
                            {
                                this.$declarator = $declarator;
                                this.$project = $project;
                            }

                            public final void run() {
                                OCParameterList oCParameterList = this.$declarator.getParameterList();
                                if (oCParameterList == null) {
                                    return;
                                }
                                int textOffset = oCParameterList.getTextOffset();
                                OCParameterList oCParameterList2 = this.$declarator.getParameterList();
                                if (oCParameterList2 == null) {
                                    return;
                                }
                                int textLength = oCParameterList2.getTextLength();
                                OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)"(JavaVM* vm, void* unused)", (boolean)true);
                            }
                        });
                        return true;
                    }
                }, 2, null)};
                holder.registerProblem((PsiElement)declarator, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            } else {
                Integer n4 = n2;
                int n5 = 1;
                if (n4 != null && n4 == n5) {
                    OCParameterList oCParameterList = declarator.getParameterList();
                    if (oCParameterList == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)oCParameterList, (String)"declarator.parameterList ?: return");
                    OCParameterList parameterList = oCParameterList;
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Add parameters", null, (Function2)new Function2<Project, ProblemDescriptor, Boolean>(parameterList, declarator){
                        final /* synthetic */ OCParameterList $parameterList;
                        final /* synthetic */ OCFunctionDeclaration $declarator;
                        {
                            this.$parameterList = $parameterList;
                            this.$declarator = $declarator;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            ApplicationManager.getApplication().runWriteAction(new Runnable(this.$parameterList, this.$declarator, project){
                                final /* synthetic */ OCParameterList $parameterList;
                                final /* synthetic */ OCFunctionDeclaration $declarator;
                                final /* synthetic */ Project $project;
                                {
                                    this.$parameterList = $parameterList;
                                    this.$declarator = $declarator;
                                    this.$project = $project;
                                }

                                public final void run() {
                                    int textOffset = this.$parameterList.getTextOffset();
                                    int textLength = this.$parameterList.getTextLength();
                                    Object object = this.$declarator.getParameters();
                                    if (object == null || (object = (OCDeclarator)object.get(0)) == null || (object = object.getName()) == null) {
                                        object = "vm";
                                    }
                                    Object parameterName = object;
                                    OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM * " + (String)parameterName + ", void* unused)"), (boolean)true);
                                }
                            });
                            return true;
                        }
                    }, 2, null)};
                    holder.registerProblem((PsiElement)parameterList, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, localQuickFixArray2);
                } else {
                    Integer n6 = n2;
                    int parameterList = 2;
                    if (n6 != null && n6 == parameterList) {
                        List list2;
                        OCDeclarator oCDeclarator;
                        List list3 = declarator.getParameters();
                        boolean bl3 = list3 != null && (list3 = (OCDeclarator)list3.get(0)) != null && (list3 = list3.getType()) != null ? !list3.equalsAfterResolving("JavaVM *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator))) : false;
                        if (bl3) {
                            List list4 = declarator.getParameters();
                            if (oCDeclarator == null) {
                                return;
                            }
                            oCDeclarator = list4 != null ? (OCDeclarator)list4.get(0) : null;
                            Intrinsics.checkNotNullExpressionValue((Object)oCDeclarator, (String)"declarator.parameters?.get(0) ?: return");
                            OCDeclarator typeNameElement = oCDeclarator;
                            oCDeclarator = new LocalQuickFix[]{this.quickFix("Change type", "Change type to JavaVM *", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(typeNameElement){
                                final /* synthetic */ OCDeclarator $typeNameElement;
                                {
                                    this.$typeNameElement = $typeNameElement;
                                    super(2);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(this.$typeNameElement, project){
                                        final /* synthetic */ OCDeclarator $typeNameElement;
                                        final /* synthetic */ Project $project;
                                        {
                                            this.$typeNameElement = $typeNameElement;
                                            this.$project = $project;
                                        }

                                        public final void run() {
                                            String string = this.$typeNameElement.getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeNameElement.name");
                                            String varName = string;
                                            OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$typeNameElement.getContainingFile(), (int)this.$typeNameElement.getParent().getTextOffset(), (int)this.$typeNameElement.getParent().getTextLength(), (String)("JavaVM *" + varName), (boolean)true);
                                        }
                                    });
                                    return true;
                                }
                            }))};
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, (LocalQuickFix[])oCDeclarator);
                        }
                        boolean bl4 = (list2 = declarator.getParameters()) != null && (list2 = (OCDeclarator)list2.get(1)) != null && (list2 = list2.getType()) != null ? !list2.equalsAfterResolving("void *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator))) : false;
                        if (bl4) {
                            List list5 = declarator.getParameters();
                            OCDeclarator oCDeclarator2 = list5 != null ? (OCDeclarator)list5.get(1) : null;
                            if (oCDeclarator == null) {
                                return;
                            }
                            oCDeclarator = oCDeclarator2;
                            Intrinsics.checkNotNullExpressionValue((Object)oCDeclarator, (String)"declarator.parameters?.get(1) ?: return");
                            OCDeclarator typeNameElement = oCDeclarator;
                            oCDeclarator = new LocalQuickFix[]{this.quickFix("Change type", "Change type to void *", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(typeNameElement){
                                final /* synthetic */ OCDeclarator $typeNameElement;
                                {
                                    this.$typeNameElement = $typeNameElement;
                                    super(2);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(this.$typeNameElement, project){
                                        final /* synthetic */ OCDeclarator $typeNameElement;
                                        final /* synthetic */ Project $project;
                                        {
                                            this.$typeNameElement = $typeNameElement;
                                            this.$project = $project;
                                        }

                                        public final void run() {
                                            String string = this.$typeNameElement.getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeNameElement.name");
                                            String varName = string;
                                            OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$typeNameElement.getContainingFile(), (int)this.$typeNameElement.getParent().getTextOffset(), (int)this.$typeNameElement.getParent().getTextLength(), (String)("void *" + varName), (boolean)true);
                                        }
                                    });
                                    return true;
                                }
                            }))};
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, (LocalQuickFix[])oCDeclarator);
                        }
                    } else if (n2 != null) {
                        Object object = declarator.getParameters();
                        if (object == null || (object = (OCDeclarator)object.get(0)) == null || (object = object.getName()) == null) {
                            object = "vm";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"declarator.parameters?.get(0)?.name ?: \"vm\"");
                        Object parameter1Name = object;
                        Object object2 = declarator.getParameters();
                        if (object2 == null || (object2 = (OCDeclarator)object2.get(1)) == null || (object2 = object2.getName()) == null) {
                            object2 = "unused";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"declarator.parameters?.get(1)?.name ?: \"unused\"");
                        Object parameter2Name = object2;
                        OCParameterList oCParameterList = declarator.getParameterList();
                        if (oCParameterList == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)oCParameterList, (String)"declarator.parameterList ?: return");
                        OCParameterList parameterList2 = oCParameterList;
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Reduce parameter list length", null, (Function2)new Function2<Project, ProblemDescriptor, Boolean>(parameterList2, declarator, (String)parameter1Name, (String)parameter2Name){
                            final /* synthetic */ OCParameterList $parameterList;
                            final /* synthetic */ OCFunctionDeclaration $declarator;
                            final /* synthetic */ String $parameter1Name;
                            final /* synthetic */ String $parameter2Name;
                            {
                                this.$parameterList = $parameterList;
                                this.$declarator = $declarator;
                                this.$parameter1Name = $parameter1Name;
                                this.$parameter2Name = $parameter2Name;
                                super(2);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                ApplicationManager.getApplication().runWriteAction(new Runnable(this.$parameterList, project, this.$declarator, this.$parameter1Name, this.$parameter2Name){
                                    final /* synthetic */ OCParameterList $parameterList;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ OCFunctionDeclaration $declarator;
                                    final /* synthetic */ String $parameter1Name;
                                    final /* synthetic */ String $parameter2Name;
                                    {
                                        this.$parameterList = $parameterList;
                                        this.$project = $project;
                                        this.$declarator = $declarator;
                                        this.$parameter1Name = $parameter1Name;
                                        this.$parameter2Name = $parameter2Name;
                                    }

                                    public final void run() {
                                        int textOffset = this.$parameterList.getTextOffset();
                                        int textLength = this.$parameterList.getTextLength();
                                        OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM* " + this.$parameter1Name + ", void *" + this.$parameter2Name + ")"), (boolean)true);
                                    }
                                });
                                return true;
                            }
                        }, 2, null)};
                        holder.registerProblem(parameterList2.getNavigationElement(), "Too many parameters", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, localQuickFixArray3);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            void inverseSampleRate$iv$iv;
            if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                Instant bl = Instant.now();
                JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl).toMillis())));
            }
        }
    }

    public static final /* synthetic */ void access$inspectDeclaration(JniOnloadInspection $this, OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        $this.inspectDeclaration(declarator, holder, returnTypeName);
    }
}

