/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.editors;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCppSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.ndk.editors.newCppSource");
    @NotNull
    private final Project myProject;

    public NewCppSourceNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (!GradleProjectInfo.getInstance((Project)this.myProject).isBuildWithGradle()) {
            return null;
        }
        if (OCWorkspace.getInstance((Project)this.myProject).getConfigurations().isEmpty()) {
            return null;
        }
        if (file.getFileType() != OCFileType.INSTANCE) {
            return null;
        }
        if (OCFileTypeHelpers.isHeaderFile((String)file.getName())) {
            return null;
        }
        if (ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject) == null) {
            return null;
        }
        if (OCWorkspace.getInstance((Project)this.myProject).getConfigurationsForFile(file).isEmpty()) {
            return new StaleCppProjectNotificationPanel("This file is not part of the project. Please include it in the appropriate build file (build.gradle, CMakeLists.txt or Android.mk etc.) and sync the project.");
        }
        return null;
    }

    private class StaleCppProjectNotificationPanel
    extends EditorNotificationPanel {
        StaleCppProjectNotificationPanel(String message) {
            this.setText(message);
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(NewCppSourceNotificationProvider.this.myProject, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_CPP_EXTERNAL_PROJECT_LINKED), null));
        }
    }
}

