/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

abstract class AbstractSisuIndex {
    static final String INDEX_FOLDER = "META-INF/sisu/";
    static final String QUALIFIER = "javax.inject.Qualifier";
    static final String NAMED = "javax.inject.Named";
    private final Map<Object, Set<String>> index = new LinkedHashMap<Object, Set<String>>();

    AbstractSisuIndex() {
    }

    protected final synchronized void addClassToIndex(Object anno, Object clazz) {
        Set<String> table2 = this.index.get(anno);
        if (table2 == null) {
            table2 = this.readTable(anno);
            this.index.put(anno, table2);
        }
        table2.add(String.valueOf(clazz));
    }

    protected final synchronized void flushIndex() {
        for (Map.Entry<Object, Set<String>> entry : this.index.entrySet()) {
            this.writeTable(entry.getKey(), entry.getValue());
        }
    }

    protected abstract void info(String var1);

    protected abstract void warn(String var1);

    protected abstract Reader getReader(String var1) throws IOException;

    protected abstract Writer getWriter(String var1) throws IOException;

    private Set<String> readTable(Object name) {
        TreeSet<String> table2 = new TreeSet<String>();
        try {
            BufferedReader reader = new BufferedReader(this.getReader(INDEX_FOLDER + name));
            try {
                String line = reader.readLine();
                while (line != null) {
                    table2.add(line);
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return table2;
    }

    private void writeTable(Object name, Set<String> table2) {
        try {
            BufferedWriter writer = new BufferedWriter(this.getWriter(INDEX_FOLDER + name));
            try {
                for (String line : table2) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.warn(e.toString());
        }
    }
}

